/*
 * Decompiled with CFR 0.152.
 */
package ajuda.visao.navegador;

import ajuda.evento.NavigatorPanelEvent;
import ajuda.evento.NavigatorPanelListener;
import ajuda.modelo.ListaTextoAjuda;
import ajuda.modelo.TextoAjuda;
import base.EsquemaVisual;
import java.awt.Graphics;
import java.awt.Panel;
import java.io.Serializable;
import java.util.Vector;

public abstract class NavigatorPanel
extends Panel
implements NavigatorPanelListener,
EsquemaVisual {
    Vector listaDeOuvintes = new Vector();
    TextoAjuda ca;
    int textIndex = 0;

    public NavigatorPanel() {
        this.setBackground(EsquemaVisual.corAreaDesenho);
    }

    protected void setConteudoAjuda(int n) {
        this.textIndex = n;
        if (this.textIndex < 0) {
            this.textIndex = 0;
        }
        if (this.textIndex > ListaTextoAjuda.numTopicos - 1) {
            this.textIndex = ListaTextoAjuda.numTopicos - 1;
        }
        this.disparaEventoMudouItemSelecionado();
    }

    public TextoAjuda getConteudoSelecionado() {
        return ListaTextoAjuda.getTexto(this.textIndex);
    }

    public int getTextIndex() {
        return this.textIndex;
    }

    public synchronized void addNavigatorPanelListener(NavigatorPanelListener navigatorPanelListener) {
        this.listaDeOuvintes.addElement(navigatorPanelListener);
    }

    public synchronized void removeNavigatorPanelListener(NavigatorPanelListener navigatorPanelListener) {
        this.listaDeOuvintes.removeElement(navigatorPanelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disparaEventoMudouItemSelecionado() {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.listaDeOuvintes.clone();
        }
        serializable = new NavigatorPanelEvent(this);
        for (int i = 0; i < vector.size(); ++i) {
            NavigatorPanelListener navigatorPanelListener = (NavigatorPanelListener)vector.elementAt(i);
            navigatorPanelListener.mudouItemSelecionado((NavigatorPanelEvent)serializable);
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public abstract /* synthetic */ void mudouItemSelecionado(NavigatorPanelEvent var1);
}

