/*
 * Decompiled with CFR 0.152.
 */
package ajuda.visao.navegador;

import ajuda.evento.NavigatorPanelEvent;
import ajuda.modelo.ListaTextoAjuda;
import ajuda.modelo.TextoAjuda;
import ajuda.visao.navegador.HelpButton;
import ajuda.visao.navegador.NavigatorPanel;
import icomb.util.I18n;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LinearNavigator
extends NavigatorPanel
implements ActionListener {
    HelpButton voltar;
    HelpButton avancar;
    HelpButton inicial;
    HelpButton imprimir;

    public LinearNavigator() {
        this.setLayout(new FlowLayout(0));
        this.voltar = new HelpButton(I18n.getString("helpButtonBack"));
        this.avancar = new HelpButton(I18n.getString("helpButtonGo"));
        this.inicial = new HelpButton(I18n.getString("helpButtonStart"));
        this.imprimir = new HelpButton(I18n.getString("helpButtonPrint"));
        this.voltar.addActionListener(this);
        this.avancar.addActionListener(this);
        this.inicial.addActionListener(this);
        this.imprimir.addActionListener(this);
        this.voltar.setEnabled(false);
        this.inicial.setEnabled(false);
        this.add(this.voltar);
        this.add(this.avancar);
        this.add(this.inicial);
        this.add(this.imprimir);
        this.setConteudoAjuda(0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 60);
    }

    private void disableApropriatedButton(int n) {
        if (n == 0) {
            this.voltar.setEnabled(false);
            this.inicial.setEnabled(false);
            this.avancar.setEnabled(true);
        } else if (n == ListaTextoAjuda.numTopicos - 1) {
            this.avancar.setEnabled(false);
            this.voltar.setEnabled(true);
            this.inicial.setEnabled(true);
        } else {
            this.voltar.setEnabled(true);
            this.inicial.setEnabled(true);
            this.avancar.setEnabled(true);
        }
    }

    private void imprimir() {
        Frame frame = new Frame();
        TextoAjuda textoAjuda = this.getConteudoSelecionado();
        PrintJob printJob = this.getToolkit().getPrintJob(frame, textoAjuda.toString(), null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                textoAjuda.printAll(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(I18n.getString("helpButtonBack"))) {
            this.setConteudoAjuda(--this.textIndex);
        }
        if (string.equals(I18n.getString("helpButtonGo"))) {
            this.setConteudoAjuda(++this.textIndex);
        }
        if (string.equals(I18n.getString("helpButtonStart"))) {
            this.textIndex = 0;
            this.setConteudoAjuda(0);
        }
        if (string.equals(I18n.getString("helpButtonPrint"))) {
            this.imprimir();
        }
        this.disableApropriatedButton(this.textIndex);
    }

    public void mudouItemSelecionado(NavigatorPanelEvent navigatorPanelEvent) {
        this.textIndex = navigatorPanelEvent.getSelectedTextIndex();
        this.disableApropriatedButton(this.textIndex);
    }
}

