/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.Calculos;
import control.Evento;
import control.EventoOperacao;
import control.EventoSelecao;
import control.Impressao;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import model.Arco;
import model.Compasso;
import model.Constantes;
import model.Esquadro;
import model.Folha;
import model.FormaLivre;
import model.Instrumento;
import model.Lapis;
import model.LapisCores;
import model.Lupa;
import model.Ponto;
import model.Posicao;
import model.Reta;
import model.Texto;

public class Tela
extends Panel
implements Constantes {
    private static final long serialVersionUID = 8090311464992645970L;
    private Image dbImage;
    private Graphics dbg;
    public double unidade = 29.4;
    public int fundo = 1;
    public Instrumento instInicial;
    public Instrumento instrumentoAtual;
    public Instrumento temp;
    public Folha folha;
    public LapisCores caixaLapis;
    public Esquadro esquadro45;
    public Esquadro esquadro60;
    public Compasso compasso;
    public Lapis lapis;
    public Lupa lupa;
    public Ponto listaPontos;
    public Arco listaArcos;
    public Reta listaRetas;
    public Texto listaTextos;
    public FormaLivre listaFormas;
    public Cursor cursor;
    public int tipoLinha = 0;
    public float espessuraLinha = 1.0f;
    public String diretorio;
    public File arquivo;
    public String codigo;
    public int contObjetos;
    Posicao cliqueAnt;
    Posicao cliqueAtual;

    public Tela() {
        this.setSize(800, 600);
        this.diretorio = ".";
        this.folha = new Folha(this);
        this.cursor = new Cursor(12);
        this.setCursor(this.cursor);
        this.cliqueAnt = new Posicao(0.0, 0.0);
        this.cliqueAtual = new Posicao(0.0, 0.0);
        this.contObjetos = -1;
        this.listaPontos = new Ponto(this.folha);
        this.listaArcos = new Arco(this.folha);
        this.listaRetas = new Reta(this.folha);
        this.listaTextos = new Texto(new Posicao(0.0, 0.0), this.folha);
        this.listaFormas = new FormaLivre(this.folha);
        this.caixaLapis = new LapisCores(new Posicao(10.0, 50.0), this);
        this.esquadro45 = new Esquadro(new Posicao(120.0, 90.0), 200.0, 45, this);
        this.esquadro60 = new Esquadro(new Posicao(120.0, 320.0), 200.0, 60, this);
        this.compasso = new Compasso(new Posicao(615.0, 240.0), 120, this);
        this.lapis = new Lapis(new Posicao(590.0, 490.0), 120, 12, 45, this.tipoLinha, this.espessuraLinha, this);
        this.lupa = new Lupa(new Posicao(645.0, 310.0), this);
        this.esquadro45.defOutroEsq(this.esquadro60);
        this.esquadro60.defOutroEsq(this.esquadro45);
        this.instInicial = this.caixaLapis;
        this.caixaLapis.proximo = this.lupa;
        this.lupa.proximo = this.lapis;
        this.lapis.proximo = this.compasso;
        this.compasso.proximo = this.esquadro45;
        this.esquadro45.proximo = this.esquadro60;
        this.instrumentoAtual = null;
        this.codigo = "";
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Posicao pos = new Posicao(event.getX(), event.getY());
                pos = Tela.this.folha.posSemPan(pos);
                Tela.this.temp = Tela.this.instInicial;
                while (Tela.this.temp != null && !Tela.this.temp.posicaoDentro(pos)) {
                    Tela.this.temp = Tela.this.temp.proximo;
                }
                if (Tela.this.temp != null) {
                    Tela.this.instrumentoAtual = Tela.this.temp;
                    Tela.this.instrumentoAtual.seleciona(new EventoSelecao(pos.x, pos.y));
                } else {
                    Tela.this.cursor = new Cursor(13);
                    Tela.this.setCursor(Tela.this.cursor);
                    Tela.this.cliqueAnt.defPosicao((double)event.getX(), (double)event.getY());
                    Tela.this.instrumentoAtual = null;
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                Posicao pos = new Posicao(event.getX(), event.getY());
                pos = Tela.this.folha.posSemPan(pos);
                if (Tela.this.instrumentoAtual != null) {
                    Tela.this.instrumentoAtual.libera(new Evento(pos.x, pos.y));
                } else {
                    Tela.this.cursor = new Cursor(12);
                    Tela.this.setCursor(Tela.this.cursor);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Posicao pos = new Posicao(event.getX(), event.getY());
                pos = Tela.this.folha.posSemPan(pos);
                Instrumento temp = Tela.this.instInicial;
                while (temp != null) {
                    temp.destaca(pos);
                    temp = temp.proximo;
                }
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                Posicao pos = new Posicao(event.getX(), event.getY());
                pos = Tela.this.folha.posSemPan(pos);
                if (Tela.this.instrumentoAtual != null) {
                    Tela.this.instrumentoAtual.opera(new EventoOperacao(pos.x, pos.y));
                } else {
                    Tela.this.cliqueAtual.defPosicao((double)event.getX(), (double)event.getY());
                    Tela.this.folha.atualizaPan(Tela.this.cliqueAnt, Tela.this.cliqueAtual);
                    Tela.this.cliqueAnt.defPosicao(Tela.this.cliqueAtual);
                    Tela.this.repaint();
                }
            }
        });
        this.setVisible(true);
    }

    public boolean salva() {
        JFileChooser escolha = new JFileChooser();
        escolha.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Risko Files (.rsk)", "rsk");
        escolha.setFileFilter(filter);
        escolha.setCurrentDirectory(new File(this.diretorio));
        if (this.isBranco().booleanValue()) {
            JOptionPane.showMessageDialog(this, "Arquivo est\u00e1 em branco !", "Aviso", 1, null);
            return false;
        }
        if (escolha.showSaveDialog(this) == 1) {
            return false;
        }
        this.arquivo = !escolha.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".rsk") ? new File(escolha.getSelectedFile() + ".rsk") : escolha.getSelectedFile();
        try {
            FileOutputStream saidaBaixa = new FileOutputStream(this.arquivo);
            DataOutputStream saidaAlta = new DataOutputStream(saidaBaixa);
            this.gerarCodigo(saidaAlta);
            ((OutputStream)saidaBaixa).close();
            this.diretorio = this.arquivo.getPath();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Arquivo n\u00e3o encontrado.(" + e.getMessage() + ")", "Erro", 0, null);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Erro ao gravar arquivo.(" + e.getMessage() + ")", "Erro", 0, null);
        }
        return true;
    }

    public String gerarCodigo(DataOutputStream saidaAlta) {
        String saida = "# RISKO V 2.0 !\n";
        int cont = 0;
        try {
            Ponto ponto = this.listaPontos;
            Reta reta = this.listaRetas;
            Arco arco = this.listaArcos;
            Texto texto = this.listaTextos;
            FormaLivre forma = this.listaFormas;
            cont = this.contObjetos;
            String[] linhas = new String[cont];
            while (cont >= 0) {
                if (reta.proximo != null && reta.proximo.serialUID == cont) {
                    reta = reta.proximo;
                    linhas[cont] = reta.salva();
                }
                if (arco.proximo != null && arco.proximo.serialUID == cont) {
                    arco = arco.proximo;
                    linhas[cont] = arco.salva();
                }
                if (texto.proximo != null && texto.proximo.serialUID == cont) {
                    texto = texto.proximo;
                    linhas[cont] = texto.salva();
                }
                if (forma.proximo != null && forma.proximo.serialUID == cont) {
                    forma = forma.proximo;
                    linhas[cont] = forma.salva();
                }
                --cont;
            }
            while (ponto.proximo != null) {
                ponto = ponto.proximo;
                if (ponto.serialUID == -1) continue;
                linhas[ponto.serialUID] = ponto.salva();
            }
            saida = String.valueOf(saida) + Calculos.joinStr(linhas);
            if (saidaAlta != null) {
                saidaAlta.writeBytes(saida);
            }
            this.codigo = saida;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Erro ao gravar arquivo.(" + e.getMessage() + ")", "Erro", 0, null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Erro: " + e.getMessage() + " [" + e.toString() + "]", "Erro", 0, null);
        }
        return saida;
    }

    public void abre() {
        JFileChooser escolha = new JFileChooser();
        escolha.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Risko Files (.rsk)", "rsk");
        escolha.setFileFilter(filter);
        escolha.setCurrentDirectory(new File(this.diretorio));
        if (escolha.showOpenDialog(this) == 1) {
            return;
        }
        this.arquivo = escolha.getSelectedFile();
        this.diretorio = this.arquivo.getPath();
        try {
            String linha;
            this.codigo = "";
            FileInputStream entradaBaixa = new FileInputStream(this.arquivo);
            BufferedReader entradaAlta = new BufferedReader(new InputStreamReader(entradaBaixa));
            while ((linha = entradaAlta.readLine()) != null) {
                if (!linha.endsWith("!")) {
                    linha = String.valueOf(linha) + "!";
                }
                this.codigo = String.valueOf(this.codigo) + linha;
            }
            this.lerCodigo(this.codigo);
            ((InputStream)entradaBaixa).close();
            this.repaint();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Arquivo n\u00e3o encontrado.(" + e.getMessage() + ")", "Erro", 0, null);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Erro ao ler arquivo.(" + e.getMessage() + ")", "Erro", 0, null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Erro: " + e.getMessage() + "[" + e.toString() + "]", "Erro", 0, null);
        }
    }

    public void lerCodigo(String conteudo) {
        JOptionPane alertaVersao = new JOptionPane("Este formato do arquivo \u00e9 de uma vers\u00e3o antiga do Risko, atualize o desenho nesta vers\u00e3o ou superior !", 1);
        JDialog dialogVersao = alertaVersao.createDialog(this, "Aviso");
        this.listaPontos.proximo = null;
        this.listaRetas.proximo = null;
        this.listaArcos.proximo = null;
        this.listaTextos.proximo = null;
        this.listaFormas.proximo = null;
        this.compasso.defNovoArco();
        Ponto ponto = this.listaPontos;
        Reta reta = this.listaRetas;
        Arco arco = this.listaArcos;
        Texto texto = this.listaTextos;
        FormaLivre forma = this.listaFormas;
        this.codigo = conteudo;
        if (!this.codigo.isEmpty()) {
            String[] linhas = this.codigo.split("!");
            int i = linhas.length - 1;
            while (i >= 0) {
                int m;
                double y;
                double x;
                StringTokenizer token = new StringTokenizer(linhas[i]);
                String simbolo = token.nextToken();
                if (i == 0) {
                    if (simbolo.equals("#")) {
                        simbolo = token.nextToken();
                        if (simbolo.equals("RISKO") && token.nextToken().equals("V") && (double)Float.parseFloat(token.nextToken()) > 2.0) {
                            dialogVersao.setVisible(true);
                        }
                    } else {
                        dialogVersao.setVisible(true);
                    }
                } else if (simbolo.equals("P")) {
                    x = Double.parseDouble(token.nextToken());
                    y = Double.parseDouble(token.nextToken());
                    ponto.proximo = new Ponto(x, y, this.folha);
                    ponto.proximo.serialUID = i - 1;
                    if (token.hasMoreTokens() && (simbolo = token.nextToken()).equals("CP")) {
                        ponto.proximo.corPonto = new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
                    }
                    ponto = ponto.proximo;
                } else if (simbolo.equals("R")) {
                    x = Double.parseDouble(token.nextToken());
                    y = Double.parseDouble(token.nextToken());
                    double x2 = Double.parseDouble(token.nextToken());
                    double y2 = Double.parseDouble(token.nextToken());
                    reta.proximo = new Reta(x, y, x2, y2, this.folha);
                    reta.proximo.serialUID = i - 1;
                    if (token.hasMoreTokens()) {
                        simbolo = token.nextToken();
                        if (simbolo.equals("CL")) {
                            reta.proximo.corLinha = new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
                        }
                        if ((simbolo = token.nextToken()).equals("TL")) {
                            reta.proximo.tipoLinha = Integer.parseInt(token.nextToken());
                        }
                        if ((simbolo = token.nextToken()).equals("EL")) {
                            reta.proximo.espessuraLinha = Float.parseFloat(token.nextToken());
                        }
                    }
                    reta = reta.proximo;
                } else if (simbolo.equals("A")) {
                    x = Double.parseDouble(token.nextToken());
                    y = Double.parseDouble(token.nextToken());
                    double raio = Double.parseDouble(token.nextToken());
                    double angInicial = Double.parseDouble(token.nextToken());
                    double angVarredura = Double.parseDouble(token.nextToken());
                    arco.proximo = new Arco(x, y, raio, angInicial, angVarredura, this.folha);
                    arco.proximo.serialUID = i - 1;
                    if (token.hasMoreTokens()) {
                        simbolo = token.nextToken();
                        if (simbolo.equals("CL")) {
                            arco.proximo.corLinha = new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
                        }
                        if ((simbolo = token.nextToken()).equals("TL")) {
                            arco.proximo.tipoLinha = Integer.parseInt(token.nextToken());
                        }
                        if ((simbolo = token.nextToken()).equals("EL")) {
                            arco.proximo.espessuraLinha = Float.parseFloat(token.nextToken());
                        }
                    }
                    arco = arco.proximo;
                } else if (simbolo.equals("T")) {
                    x = Double.parseDouble(token.nextToken());
                    y = Double.parseDouble(token.nextToken());
                    texto.proximo = new Texto(x, y, this.folha);
                    texto.proximo.serialUID = i - 1;
                    texto = texto.proximo;
                    simbolo = token.nextToken();
                    do {
                        texto.insereTexto(" " + simbolo);
                        simbolo = token.nextToken();
                    } while (token.hasMoreTokens() && !simbolo.equals("CT"));
                    if (token.hasMoreTokens() && simbolo.equals("CT")) {
                        texto.corTexto = new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
                    }
                } else if (simbolo.equals("X") && (m = Integer.parseInt(token.nextToken())) > 0) {
                    forma.proximo = new FormaLivre(this.folha);
                    forma.proximo.serialUID = i - 1;
                    forma = forma.proximo;
                    int n = 0;
                    while (n < m) {
                        x = Double.parseDouble(token.nextToken());
                        y = Double.parseDouble(token.nextToken());
                        forma.adicVertice(x, y);
                        ++n;
                    }
                    if (token.hasMoreTokens()) {
                        simbolo = token.nextToken();
                        if (simbolo.equals("CL")) {
                            forma.corLinha = new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
                        }
                        if ((simbolo = token.nextToken()).equals("TL")) {
                            forma.tipoLinha = Integer.parseInt(token.nextToken());
                        }
                        if ((simbolo = token.nextToken()).equals("EL")) {
                            forma.espessuraLinha = Float.parseFloat(token.nextToken());
                        }
                    }
                }
                --i;
            }
            this.contObjetos = linhas.length - 1;
        }
    }

    public void novo() {
        if (!this.isBranco().booleanValue()) {
            int resp = JOptionPane.showConfirmDialog(this, "Deseja salvar o arquivo atual ?", "Salvar", 1, 3, null);
            switch (resp) {
                case 0: {
                    if (this.salva()) break;
                    return;
                }
                case 2: {
                    return;
                }
            }
            this.listaPontos.proximo = null;
            this.listaRetas.proximo = null;
            this.listaArcos.proximo = null;
            this.listaTextos.proximo = null;
            this.listaFormas.proximo = null;
            this.compasso.defNovoArco();
            this.contObjetos = -1;
            this.repaint();
        }
    }

    public void iniciaImpressao() {
        if (this.isBranco().booleanValue()) {
            JOptionPane.showMessageDialog(this, "Arquivo est\u00e1 em branco !", "Aviso", 1, null);
            return;
        }
        int resp = JOptionPane.showConfirmDialog(this, "Deseja imprimir o desenho atual ?", "Imprirmir", 0, 3, null);
        if (resp == 1) {
            return;
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Impressao impressao = new Impressao(this);
        PageFormat page = new PageFormat();
        Paper paper = new Paper();
        double largura = 595.275590551181;
        double altura = 841.8897637795275;
        paper.setSize(largura, altura);
        paper.setImageableArea(0.0, 0.0, largura, altura);
        page.setPaper(paper);
        page = printJob.validatePage(page);
        printJob.setJobName("Risko File Print: " + (this.arquivo != null ? this.arquivo.getAbsolutePath() : ""));
        printJob.setPrintable(impressao, page);
        try {
            boolean doPrint = printJob.printDialog();
            if (doPrint) {
                printJob.print();
            }
        }
        catch (PrinterException e) {
            JOptionPane.showMessageDialog(this, "Erro de Impress\u00e3o.(" + e.getMessage() + ")", "Erro", 0, null);
        }
    }

    public void imprime(Graphics g, Impressao impressao) {
        int cont = 0;
        Arco arco = this.listaArcos;
        Reta reta = this.listaRetas;
        Ponto ponto = this.listaPontos;
        Texto texto = this.listaTextos;
        FormaLivre forma = this.listaFormas;
        cont = this.contObjetos;
        while (cont >= 0) {
            if (arco.proximo != null && arco.proximo.serialUID == cont) {
                arco = arco.proximo;
                arco.imprime(g, impressao);
            }
            if (reta.proximo != null && reta.proximo.serialUID == cont) {
                reta = reta.proximo;
                reta.imprime(g, impressao);
            }
            if (ponto.proximo != null && ponto.proximo.serialUID == cont) {
                ponto = ponto.proximo;
                ponto.imprime(g, impressao);
            }
            if (texto.proximo != null && texto.proximo.serialUID == cont) {
                texto = texto.proximo;
                texto.imprime(g, impressao);
            }
            if (forma.proximo != null && forma.proximo.serialUID == cont) {
                forma = forma.proximo;
                forma.imprime(g, impressao);
            }
            --cont;
        }
    }

    private Boolean isBranco() {
        Boolean result = true;
        result = result & this.listaPontos.proximo == null;
        result = result & this.listaRetas.proximo == null;
        result = result & this.listaArcos.proximo == null;
        result = result & this.listaTextos.proximo == null;
        result = result & this.listaFormas.proximo == null;
        return result;
    }

    @Override
    public void update(Graphics g) {
        if (this.dbImage == null || this.dbImage.getWidth(this) != this.getSize().width || this.dbImage.getHeight(this) != this.getSize().height) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbg = this.dbImage.getGraphics();
        }
        this.dbg.setColor(this.getForeground());
        this.paint(this.dbg);
        g.drawImage(this.dbImage, 0, 0, this);
    }

    @Override
    public void paint(Graphics g) {
        this.folha.desenha(g);
        Instrumento[] lista = new Instrumento[6];
        Instrumento temp = this.instInicial;
        int i = 0;
        while (temp != null && i < 6) {
            lista[6 - i - 1] = temp;
            temp = temp.proximo;
            ++i;
        }
        i = 0;
        while (i < 6) {
            lista[i].desenha(g);
            ++i;
        }
        Arco arco = this.listaArcos;
        while (arco.proximo != null) {
            arco = arco.proximo;
            if (arco.serialUID == -1) {
                ++this.contObjetos;
                arco.serialUID = arco.serialUID;
            }
            arco.desenha(g);
        }
        Reta reta = this.listaRetas;
        while (reta.proximo != null) {
            reta = reta.proximo;
            if (reta.serialUID == -1) {
                ++this.contObjetos;
                reta.serialUID = reta.serialUID;
            }
            reta.desenha(g);
        }
        Ponto ponto = this.listaPontos;
        while (ponto.proximo != null) {
            ponto = ponto.proximo;
            if (ponto.serialUID == -1) {
                ++this.contObjetos;
                ponto.serialUID = ponto.serialUID;
            }
            ponto.desenha(g);
        }
        Texto texto = this.listaTextos;
        while (texto.proximo != null) {
            texto = texto.proximo;
            if (texto.serialUID == -1) {
                ++this.contObjetos;
                texto.serialUID = texto.serialUID;
            }
            texto.desenha(g);
        }
        FormaLivre forma = this.listaFormas;
        while (forma.proximo != null) {
            forma = forma.proximo;
            if (forma.serialUID == -1 && !forma.vazia()) {
                ++this.contObjetos;
                forma.serialUID = forma.serialUID;
            }
            forma.desenha(g);
        }
    }
}

