/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import model.Posicao;

public class Vetor {
    public double x;
    public double y;

    public Vetor(double x, double y) {
        this.defCoords(x, y);
    }

    public Vetor(Posicao posIni, Posicao posFim) {
        this.defCoords(posFim.x - posIni.x, posFim.y - posIni.y);
    }

    public Vetor(double x1, double y1, double x2, double y2) {
        this.defCoords(x2 - x1, y2 - y1);
    }

    public void defCoords(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double prodEscalar(Vetor vet) {
        return this.x * vet.x + this.y * vet.y;
    }

    public double norma() {
        return Calculos.raiz(this.x * this.x + this.y * this.y);
    }

    public double normaProj(Vetor vet) {
        return Calculos.divisao(this.prodEscalar(vet), vet.norma());
    }

    public Vetor proj(Vetor vet) {
        double norma = Calculos.divisao(this.prodEscalar(vet), vet.prodEscalar(vet));
        return new Vetor(norma * vet.x, norma * vet.y);
    }

    public double distPos(Posicao origem, Posicao pos) {
        Vetor vet = new Vetor(origem, pos);
        return Calculos.divisao(this.x * vet.y - this.y * vet.x, this.norma());
    }

    public Vetor vetorNormal(double norma) {
        double nx = Calculos.divisao(this.y * norma, this.norma());
        double ny = Calculos.divisao(-this.x * norma, this.norma());
        return new Vetor(nx, ny);
    }

    public Vetor vetorPar(double norma) {
        return new Vetor(norma * Calculos.divisao(this.x, this.norma()), norma * Calculos.divisao(this.y, this.norma()));
    }

    public Vetor soma(Vetor vet) {
        return new Vetor(this.x + vet.x, this.y + vet.y);
    }

    public Vetor invert() {
        return new Vetor(-this.x, -this.y);
    }

    public Vetor gira(double angulo) {
        double s = Math.sin(angulo);
        double c = Math.cos(angulo);
        double xtemp = this.x * c - this.y * s;
        double ytemp = this.x * s + this.y * c;
        return new Vetor(xtemp, ytemp);
    }

    int intX() {
        return (int)Math.round(this.x);
    }

    int intY() {
        return (int)Math.round(this.y);
    }
}

