/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Impressao;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Posicao;
import model.Reta;
import model.Vetor;

public class Texto
implements Constantes {
    public int serialUID;
    public Folha folha;
    public Posicao posicao;
    public String texto;
    public Texto proximo;
    public Color corTexto;
    Font fonte = new Font("Serif", 1, 14);
    FontMetrics medidas;

    public Texto(double x, double y, String texto, Folha folha) {
        this.posicao = new Posicao(x, y);
        this.texto = texto;
        this.folha = folha;
        this.serialUID = -1;
        this.proximo = null;
        this.corTexto = Cor.txtNormal;
    }

    public Texto(Posicao pos, String texto, Folha folha) {
        this(pos.x, pos.y, texto, folha);
    }

    public Texto(double x, double y, Folha folha) {
        this(x, y, "", folha);
    }

    public Texto(Posicao pos, Folha folha) {
        this(pos.x, pos.y, "", folha);
    }

    public void insereTexto(char c) {
        this.texto = String.valueOf(this.texto) + c;
    }

    public void insereTexto(String s) {
        this.texto = String.valueOf(this.texto) + s;
    }

    public void apagaUltCar() {
        if (this.tamanho() > 0) {
            this.texto = this.texto.substring(0, this.tamanho() - 1);
        }
    }

    public int tamanho() {
        return this.texto.length();
    }

    public Posicao posFim() {
        double altura;
        double largura;
        if (this.texto == "") {
            largura = 2.0 * this.folha.zoom();
            altura = 10.0 * this.folha.zoom();
        } else {
            largura = this.medidas.stringWidth(this.texto) + this.medidas.charWidth('m');
            altura = this.medidas.getAscent();
        }
        Vetor vet = new Vetor(0.0, -1.0);
        Vetor vet2 = new Vetor(1.0, 0.0);
        Posicao inicio = this.folha.posRelativa(this.posicao);
        inicio = inicio.soma(vet.vetorPar(altura));
        Posicao fim = inicio.soma(vet2.vetorPar(largura));
        return fim;
    }

    public boolean contemPosicao(Posicao pos) {
        Posicao fim;
        int largura = this.medidas.stringWidth(this.texto);
        int altura = this.medidas.getAscent();
        Vetor vet = new Vetor(0.0, -1.0);
        Vetor vet2 = new Vetor(1.0, 0.0);
        Posicao inicio = this.posicao.soma(vet.vetorPar(0.5 * (double)altura));
        Reta reta = new Reta(inicio, fim = inicio.soma(vet2.vetorPar(1.0 * (double)largura)), null);
        return reta.distanciaPos(pos) <= 0.5 * (double)altura + 6.0 && reta.dentroLimites(pos);
    }

    public boolean contPosRel(Posicao pos) {
        Posicao fim;
        Posicao ref = new Posicao(this.folha.posComZoom(this.posicao));
        int largura = this.medidas.stringWidth(this.texto);
        int altura = this.medidas.getAscent();
        Vetor vet = new Vetor(0.0, -1.0);
        Vetor vet2 = new Vetor(1.0, 0.0);
        Posicao inicio = ref.soma(vet.vetorPar(0.5 * (double)altura));
        Reta reta = new Reta(inicio, fim = inicio.soma(vet2.vetorPar(1.0 * (double)largura)), null);
        return reta.distanciaPos(pos) <= 0.5 * (double)altura + 6.0 && reta.dentroLimites(pos);
    }

    public void desenha(Graphics g) {
        Posicao local = this.folha.posRelativa(this.posicao);
        Color cor = g.getColor();
        g.setColor(this.corTexto);
        Font fonteRel = this.fonte.deriveFont((float)((double)this.fonte.getSize2D() * this.folha.zoom()));
        g.setFont(fonteRel);
        this.medidas = g.getFontMetrics();
        g.drawString(this.texto, local.intX(), local.intY());
        g.setColor(cor);
    }

    public void imprime(Graphics g, Impressao impressao) {
        Posicao local = impressao.posRelativa(this.posicao);
        Color cor = g.getColor();
        g.setColor(this.corTexto);
        Font fonteRel = this.fonte.deriveFont((float)((double)this.fonte.getSize2D() * this.folha.zoom()));
        g.setFont(fonteRel);
        this.medidas = g.getFontMetrics();
        g.drawString(this.texto, local.intX(), local.intY());
        g.setColor(cor);
    }

    public String salva() {
        String result = "T " + this.posicao.x + " " + this.posicao.y + " " + this.texto;
        result = String.valueOf(result) + " CT " + this.corTexto.getRed() + " " + this.corTexto.getGreen() + " " + this.corTexto.getBlue();
        result = String.valueOf(result) + " !\n";
        return result;
    }
}

