/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Impressao;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Posicao;
import model.Vetor;

public class Reta
implements Constantes {
    public int serialUID;
    public Folha folha;
    public int tolerancia;
    public Posicao inicio;
    public Posicao fim;
    public Reta proximo;
    public double angBordaEsq;
    public boolean destaque;
    public int tipoLinha;
    public float espessuraLinha;
    public Color corLinha;

    public Reta(double x1, double y1, double x2, double y2, Folha folha) {
        this.folha = folha;
        this.serialUID = -1;
        this.inicio = new Posicao(x1, y1);
        this.fim = new Posicao(x2, y2);
        this.proximo = null;
        this.tolerancia = 4;
        this.angBordaEsq = 0.0;
        this.destaque = false;
        this.tipoLinha = Cor.tipoLinha;
        this.espessuraLinha = Cor.espessuraLinha;
        this.corLinha = Cor.retNormal;
    }

    public Reta(Posicao inicio, Posicao fim, Folha folha) {
        this(inicio.x, inicio.y, fim.x, fim.y, folha);
    }

    public Reta(Folha folha) {
        this(0.0, 0.0, 0.0, 0.0, folha);
    }

    public Reta retaRelativa() {
        return new Reta(this.folha.posComZoom(this.inicio), this.folha.posComZoom(this.fim), this.folha);
    }

    public int inicioInteiroX() {
        return (int)Math.round(this.inicio.x);
    }

    public int inicioInteiroY() {
        return (int)Math.round(this.inicio.y);
    }

    public int fimInteiroX() {
        return (int)Math.round(this.fim.x);
    }

    public int fimInteiroY() {
        return (int)Math.round(this.fim.y);
    }

    public void defInicio(Posicao pos) {
        this.inicio = new Posicao(pos);
    }

    public void defFim(Posicao pos) {
        this.fim = new Posicao(pos);
    }

    public double distanciaPos(Posicao pos) {
        return Calculos.distanciaPontoReta(pos, this.inicio, this.fim);
    }

    public double distanciaPosSinal(Posicao pos) {
        return Calculos.distanciaPontoRetaSinal(pos, this.inicio, this.fim);
    }

    public double distPosRel(Posicao pos) {
        return Calculos.distanciaPontoReta(pos, this.folha.posComZoom(this.inicio), this.folha.posComZoom(this.fim));
    }

    public boolean dentroLimites(Posicao pos) {
        double a = this.fim.x - this.inicio.x;
        double x = pos.x - this.inicio.x;
        double b = this.fim.y - this.inicio.y;
        double y = pos.y - this.inicio.y;
        double proj = (a * x + b * y) / Math.sqrt(a * a + b * b);
        return !(proj > Math.sqrt(a * a + b * b)) && !(proj < 0.0);
    }

    public boolean dentroLimitesRel(Posicao pos) {
        double a = this.fimRel().x - this.inicioRel().x;
        double x = pos.x - this.inicioRel().x;
        double b = this.fimRel().y - this.inicioRel().y;
        double y = pos.y - this.inicioRel().y;
        double proj = (a * x + b * y) / Math.sqrt(a * a + b * b);
        return !(proj > Math.sqrt(a * a + b * b)) && !(proj < 0.0);
    }

    public double coeficienteAngular() {
        return Calculos.divisao(this.fim.y - this.inicio.y, this.fim.x - this.inicio.x);
    }

    public double coeficienteLinear() {
        return Calculos.divisao(this.inicio.x * this.fim.y - this.inicio.y * this.fim.x, this.inicio.x - this.fim.x);
    }

    public boolean dentroRegiao(Posicao pos) {
        Posicao vertSupEsq = new Posicao(this.inicio);
        Posicao vertInfDir = new Posicao(this.inicio);
        vertSupEsq.x = Math.min(this.inicio.x, this.fim.x) - (double)this.tolerancia;
        vertSupEsq.y = Math.min(this.inicio.y, this.fim.y) - (double)this.tolerancia;
        vertInfDir.x = Math.max(this.inicio.x, this.fim.x) + (double)this.tolerancia;
        vertInfDir.y = Math.max(this.inicio.y, this.fim.y) + (double)this.tolerancia;
        return pos.x >= vertSupEsq.x && pos.y >= vertSupEsq.y && pos.x <= vertInfDir.x && pos.y <= vertInfDir.y;
    }

    public boolean dentroRegiaoRel(Posicao pos) {
        Posicao vertSupEsq = new Posicao(this.inicioRel());
        Posicao vertInfDir = new Posicao(this.inicioRel());
        vertSupEsq.x = Math.min(this.inicioRel().x, this.fimRel().x) - (double)this.tolerancia;
        vertSupEsq.y = Math.min(this.inicioRel().y, this.fimRel().y) - (double)this.tolerancia;
        vertInfDir.x = Math.max(this.inicioRel().x, this.fimRel().x) + (double)this.tolerancia;
        vertInfDir.y = Math.max(this.inicioRel().y, this.fimRel().y) + (double)this.tolerancia;
        return pos.x >= vertSupEsq.x && pos.y >= vertSupEsq.y && pos.x <= vertInfDir.x && pos.y <= vertInfDir.y;
    }

    public Posicao inicioRel() {
        return this.folha.posComZoom(this.inicio);
    }

    public Posicao fimRel() {
        return this.folha.posComZoom(this.fim);
    }

    public Reta quebra(Posicao pos) {
        Reta reta = new Reta(pos, this.fim, this.folha);
        this.fim = new Posicao(pos);
        return reta;
    }

    public Vetor vetorDiretor() {
        return new Vetor(this.inicio, this.fim);
    }

    public void desenha(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f));
        } else if (this.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (this.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (this.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        Posicao inicioRel = this.folha.posRelativa(this.inicio);
        Posicao fimRel = this.folha.posRelativa(this.fim);
        Color cor = g2d.getColor();
        if (this.destaque) {
            g2d.setColor(Cor.retDest);
        } else {
            g2d.setColor(this.corLinha);
        }
        g2d.drawLine(inicioRel.intX(), inicioRel.intY(), fimRel.intX(), fimRel.intY());
        g2d.setColor(cor);
    }

    public void imprime(Graphics g, Impressao impressao) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f));
        } else if (this.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (this.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (this.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        Posicao inicioRel = impressao.posRelativa(this.inicio);
        Posicao fimRel = impressao.posRelativa(this.fim);
        Color cor = g2d.getColor();
        g2d.setColor(this.corLinha);
        g2d.drawLine(inicioRel.intX(), inicioRel.intY(), fimRel.intX(), fimRel.intY());
        g2d.setColor(cor);
    }

    public String salva() {
        String result = "R " + this.inicio.x + " " + this.inicio.y + " " + this.fim.x + " " + this.fim.y;
        result = String.valueOf(result) + " CL " + this.corLinha.getRed() + " " + this.corLinha.getGreen() + " " + this.corLinha.getBlue();
        result = String.valueOf(result) + " TL " + this.tipoLinha;
        result = String.valueOf(result) + " EL " + this.espessuraLinha;
        result = String.valueOf(result) + " !\n";
        return result;
    }
}

