/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Impressao;
import java.awt.Color;
import java.awt.Graphics;
import model.Constantes;
import model.Cor;
import model.Esquadro;
import model.Folha;
import model.Posicao;
import model.Vetor;

public class Ponto
extends Posicao
implements Constantes {
    public int serialUID;
    private Folha folha;
    public Ponto proximo = null;
    public Esquadro esqVinc;
    public Ponto proxVinc;
    public Vetor vetAjEsq;
    public int estado;
    public int bordaEsq;
    public int areaComp;
    public double distEsq;
    public float espessuraPonto;
    public Color corPonto;

    public Ponto(double x, double y, Folha folha) {
        super(x, y);
        this.folha = folha;
        this.serialUID = -1;
        this.esqVinc = null;
        this.proxVinc = null;
        this.vetAjEsq = null;
        this.distEsq = 0.0;
        this.bordaEsq = 0;
        this.areaComp = 0;
        this.estado = 0;
        this.corPonto = Cor.ptoNormal;
        this.espessuraPonto = Cor.espessuraLinha;
    }

    public Ponto(Posicao pos, Folha folha) {
        this(pos.x, pos.y, folha);
    }

    public Ponto(Folha folha) {
        this(0.0, 0.0, folha);
    }

    public Ponto pontoRel() {
        Ponto ponto = new Ponto(this.folha.posComZoom(this.x, this.y), this.folha);
        ponto.distEsq = this.distEsq;
        ponto.bordaEsq = this.bordaEsq;
        return ponto;
    }

    public boolean igualRel(Posicao pos) {
        return Calculos.distancia(this.folha.posComZoom(this.x, this.y), pos) <= 1.0E-6;
    }

    public void desenha(Graphics g) {
        Color cor = g.getColor();
        switch (this.estado) {
            case 0: {
                g.setColor(this.corPonto);
                break;
            }
            case 1: {
                g.setColor(Cor.ptoDest);
                break;
            }
            case 2: {
                g.setColor(Cor.ptoVinc);
            }
        }
        Posicao local = this.folha.posRelativa(this.x, this.y);
        g.fillOval(local.intX() - 2, local.intY() - 2, 4, 4);
        g.setColor(cor);
    }

    public void imprime(Graphics g, Impressao impressao) {
        Posicao local = impressao.posRelativa(this.x, this.y);
        Color cor = g.getColor();
        g.setColor(this.corPonto);
        g.fillOval(local.intX() - 2, local.intY() - 2, 4, 4);
        g.setColor(cor);
    }

    public String salva() {
        String result = "P " + this.x + " " + this.y;
        result = String.valueOf(result) + " CP " + this.corPonto.getRed() + " " + this.corPonto.getGreen() + " " + this.corPonto.getBlue();
        result = String.valueOf(result) + " !\n";
        return result;
    }
}

