/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Evento;
import control.EventoOperacao;
import control.EventoSelecao;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Instrumento;
import model.Posicao;
import model.Reta;
import model.Vetor;
import view.Tela;

public class Lupa
extends Instrumento
implements Constantes {
    private Folha folha;
    public Posicao pontaCabo;
    public Posicao centroLente;
    private int tamCabo = 30;
    private int largura = 4;
    private int raioLente = 17;
    private int regiao = -1;
    private double zoomIni;
    Posicao cliqueIni;
    Posicao cliqueAnt;

    public Lupa(Posicao posicao, Tela sistema) {
        this.centroLente = new Posicao(posicao);
        this.pontaCabo = this.centroLente.soma(new Vetor(32.0, 32.0));
        this.proximo = null;
        this.sistema = sistema;
        this.folha = sistema.folha;
    }

    @Override
    public boolean posicaoDentro(Posicao clique) {
        this.regiao = this.regiaoAtiva(clique);
        return this.regiao != -1;
    }

    public int regiaoAtiva(Posicao posCursor) {
        int regiao = -1;
        if (Calculos.distancia(this.centroLente, posCursor) <= (double)this.raioLente) {
            regiao = 2;
        } else {
            Reta cabo = new Reta(this.pontaCabo, this.centroLente, null);
            if (cabo.distanciaPos(posCursor) <= (double)this.largura && cabo.dentroLimites(posCursor)) {
                regiao = 1;
            }
        }
        return regiao;
    }

    @Override
    public void seleciona(EventoSelecao evento) {
        this.zoomIni = this.folha.zoom();
        this.cliqueIni = new Posicao(evento.coordenadas());
        this.cliqueIni = this.folha.posPan(this.cliqueIni);
        this.sistema.compasso.calcRaio();
        this.cliqueAnt = new Posicao(this.cliqueIni);
        if (this.regiao == 2) {
            Cursor cursor = new Cursor(9);
            this.sistema.setCursor(cursor);
            if (this.folha.posSemZoom(this.centroLente) != this.folha.focoAtual()) {
                Vetor mov = new Vetor(this.folha.posSemZoom(this.centroLente), this.centroLente);
                this.folha.atualizaPanSimples(mov);
                this.folha.alteraFoco(this.folha.posSemZoom(this.centroLente));
                this.moveLupa(mov.invert());
                this.sistema.esquadro45.movEsqDir(mov.invert());
                this.sistema.esquadro60.movEsqDir(mov.invert());
                this.sistema.lapis.moveLapis(mov.invert());
                this.sistema.compasso.moveCompasso(mov.invert());
            }
            this.sistema.repaint();
        }
    }

    @Override
    public void opera(EventoOperacao evento) {
        Posicao cliqueAtual = new Posicao(evento.coordenadas());
        cliqueAtual = this.folha.posPan(cliqueAtual);
        Vetor mov = new Vetor(this.cliqueAnt, cliqueAtual);
        switch (this.regiao) {
            case 2: {
                double fator = 1.0 + (this.cliqueIni.y - cliqueAtual.y) / 100.0;
                this.folha.alteraZoom(fator * this.zoomIni);
                this.sistema.compasso.defNovoArco();
                this.sistema.compasso.abertura(fator * this.zoomIni, fator);
                this.sistema.esquadro45.desfazVincs();
                this.sistema.esquadro60.desfazVincs();
                this.sistema.esquadro45.limpaEscala();
                this.sistema.esquadro60.limpaEscala();
                this.sistema.repaint();
                break;
            }
            case 1: {
                this.moveLupa(mov);
                this.sistema.repaint();
            }
        }
        this.cliqueAnt.defPosicao(cliqueAtual);
    }

    @Override
    public void libera(Evento evento) {
        Cursor cursor = new Cursor(12);
        this.sistema.setCursor(cursor);
        this.regiao = -1;
    }

    private void moveLupa(Vetor mov) {
        this.pontaCabo = this.pontaCabo.soma(mov);
        this.centroLente = this.centroLente.soma(mov);
    }

    @Override
    public boolean destaca(Posicao posCursor) {
        int regAnt = this.regiao;
        this.regiao = this.regiaoAtiva(posCursor);
        if (this.regiao != regAnt) {
            this.sistema.repaint();
        }
        return this.regiao != -1;
    }

    @Override
    public void desenha(Graphics g) {
        int[] X = new int[4];
        int[] Y = new int[4];
        double a = this.largura;
        double b = this.tamCabo;
        Vetor vet1 = new Vetor(this.pontaCabo, this.centroLente);
        vet1 = vet1.vetorPar(b);
        Vetor vet2 = vet1.vetorNormal(a);
        Posicao pos = this.pontaCabo.soma(vet2);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = this.pontaCabo.soma(vet1).soma(vet2);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = this.pontaCabo.soma(vet1).soma(vet2.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = this.pontaCabo.soma(vet2.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon cabo = this.sistema.folha.poligono(X, Y, 4);
        Color cor = g.getColor();
        if (this.regiao == 1) {
            g.setColor(Cor.lupCaboDest);
        } else {
            g.setColor(Cor.lupCabo);
        }
        g.fillPolygon(cabo);
        g.setColor(Cor.lupContorno);
        g.drawPolygon(cabo);
        pos = this.sistema.folha.posPan(this.centroLente);
        g.setColor(Cor.lupAro);
        g.fillOval(pos.intX() - this.raioLente, pos.intY() - this.raioLente, 2 * this.raioLente, 2 * this.raioLente);
        if (this.regiao == 2) {
            g.setColor(Cor.lupLenteDest);
        } else {
            g.setColor(Cor.lupLente);
        }
        g.fillOval(pos.intX() - this.raioLente + 3, pos.intY() - this.raioLente + 3, 2 * this.raioLente - 6, 2 * this.raioLente - 6);
        g.setColor(Cor.lupReflexo);
        g.fillOval(pos.intX() - this.raioLente + 5, pos.intY() - this.raioLente + 5, 2 * this.raioLente - 10, 2 * this.raioLente - 10);
        if (this.regiao == 2) {
            g.setColor(Cor.lupLenteDest);
        } else {
            g.setColor(Cor.lupLente);
        }
        g.fillOval(pos.intX() - this.raioLente + 5, pos.intY() - this.raioLente + 4, 2 * this.raioLente - 13, 2 * this.raioLente - 8);
        g.setColor(cor);
    }
}

