/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Evento;
import control.EventoOperacao;
import control.EventoSelecao;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Instrumento;
import model.Posicao;
import model.Vetor;
import view.Tela;

public class LapisCores
extends Instrumento
implements Constantes {
    private int altura = 60;
    private int largura = 66;
    private int regiao;
    private int tam01;
    private int tam02;
    private int tam03;
    public double[] vertX = new double[4];
    public double[] vertY = new double[4];
    Folha folha;
    public Posicao posicaoCaixa;
    public Image logo_image;
    public URL logo_file;
    private boolean possuiFoco;
    Posicao cliqueIni;
    Posicao cliqueAnt;

    public LapisCores(Posicao posicao, Tela sistema) {
        this.sistema = sistema;
        this.folha = sistema.folha;
        this.possuiFoco = false;
        this.tam01 = 80;
        this.tam02 = 60;
        this.tam03 = 40;
        this.posicaoCaixa = new Posicao(posicao);
        try {
            this.logo_file = this.getClass().getResource("/assets/logo.png");
            if (this.logo_file != null) {
                this.logo_image = ImageIO.read(this.logo_file);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(e.toString()) + ": " + e.getMessage());
        }
    }

    @Override
    public boolean posicaoDentro(Posicao clique) {
        double x = clique.x;
        double y = clique.y;
        this.regiao = -1;
        this.possuiFoco = false;
        if (x >= this.vertX[0] && x <= this.vertX[1] && y >= this.vertY[2] && y <= this.vertY[1]) {
            this.regiao = 0;
            return true;
        }
        if (x >= this.vertX[0] && x < this.vertX[0] + 11.0 && y >= this.vertY[0] && y <= this.vertY[0] + (double)this.tam03) {
            this.regiao = CAIXALAPIS[12];
            return true;
        }
        if (x >= this.vertX[0] + 11.0 && x < this.vertX[0] + 22.0 && y >= this.vertY[0] && y <= this.vertY[0] + (double)this.tam03) {
            this.regiao = CAIXALAPIS[13];
            return true;
        }
        if (x >= this.vertX[0] + 22.0 && x < this.vertX[0] + 33.0 && y >= this.vertY[0] && y <= this.vertY[0] + (double)this.tam03) {
            this.regiao = CAIXALAPIS[14];
            return true;
        }
        if (x >= this.vertX[0] + 33.0 && x < this.vertX[0] + 44.0 && y >= this.vertY[0] && y <= this.vertY[0] + (double)this.tam03) {
            this.regiao = CAIXALAPIS[15];
            return true;
        }
        if (x >= this.vertX[0] + 44.0 && x < this.vertX[0] + 55.0 && y >= this.vertY[0] && y <= this.vertY[0] + (double)this.tam03) {
            this.regiao = CAIXALAPIS[16];
            return true;
        }
        if (x >= this.vertX[0] + 55.0 && x < this.vertX[0] + 66.0 && y >= this.vertY[0] && y <= this.vertY[0] + (double)this.tam03) {
            this.regiao = CAIXALAPIS[17];
            return true;
        }
        if (x >= this.vertX[0] && x < this.vertX[0] + 11.0 && y >= this.vertY[0] + (double)this.tam03 && y <= this.vertY[0] + (double)this.tam02) {
            this.regiao = CAIXALAPIS[6];
            return true;
        }
        if (x >= this.vertX[0] + 11.0 && x < this.vertX[0] + 22.0 && y >= this.vertY[0] + (double)this.tam03 && y <= this.vertY[0] + (double)this.tam02) {
            this.regiao = CAIXALAPIS[7];
            return true;
        }
        if (x >= this.vertX[0] + 21.0 && x < this.vertX[0] + 33.0 && y >= this.vertY[0] + (double)this.tam03 && y <= this.vertY[0] + (double)this.tam02) {
            this.regiao = CAIXALAPIS[8];
            return true;
        }
        if (x >= this.vertX[0] + 31.0 && x < this.vertX[0] + 44.0 && y >= this.vertY[0] + (double)this.tam03 && y <= this.vertY[0] + (double)this.tam02) {
            this.regiao = CAIXALAPIS[9];
            return true;
        }
        if (x >= this.vertX[0] + 41.0 && x < this.vertX[0] + 55.0 && y >= this.vertY[0] + (double)this.tam03 && y <= this.vertY[0] + (double)this.tam02) {
            this.regiao = CAIXALAPIS[10];
            return true;
        }
        if (x >= this.vertX[0] + 51.0 && x < this.vertX[0] + 66.0 && y >= this.vertY[0] + (double)this.tam03 && y <= this.vertY[0] + (double)this.tam02) {
            this.regiao = CAIXALAPIS[11];
            return true;
        }
        if (x >= this.vertX[0] && x < this.vertX[0] + 11.0 && y >= this.vertY[0] + (double)this.tam02 && y <= this.vertY[0] + (double)this.tam01) {
            this.regiao = CAIXALAPIS[0];
            return true;
        }
        if (x >= this.vertX[0] + 11.0 && x < this.vertX[0] + 22.0 && y >= this.vertY[0] + (double)this.tam02 && y <= this.vertY[0] + (double)this.tam01) {
            this.regiao = CAIXALAPIS[1];
            return true;
        }
        if (x >= this.vertX[0] + 21.0 && x < this.vertX[0] + 33.0 && y >= this.vertY[0] + (double)this.tam02 && y <= this.vertY[0] + (double)this.tam01) {
            this.regiao = CAIXALAPIS[2];
            return true;
        }
        if (x >= this.vertX[0] + 31.0 && x < this.vertX[0] + 44.0 && y >= this.vertY[0] + (double)this.tam02 && y <= this.vertY[0] + (double)this.tam01) {
            this.regiao = CAIXALAPIS[3];
            return true;
        }
        if (x >= this.vertX[0] + 41.0 && x < this.vertX[0] + 55.0 && y >= this.vertY[0] + (double)this.tam02 && y <= this.vertY[0] + (double)this.tam01) {
            this.regiao = CAIXALAPIS[4];
            return true;
        }
        if (x >= this.vertX[0] + 51.0 && x < this.vertX[0] + 66.0 && y >= this.vertY[0] + (double)this.tam02 && y <= this.vertY[0] + (double)this.tam01) {
            this.regiao = CAIXALAPIS[5];
            return true;
        }
        return false;
    }

    @Override
    public void seleciona(EventoSelecao evento) {
        Posicao cliqueAtual = new Posicao(evento.coordenadas());
        this.cliqueIni = new Posicao(evento.coordenadas());
        this.cliqueAnt = new Posicao(this.cliqueIni);
        if (this.posicaoDentro(cliqueAtual)) {
            if (this.regiao == CAIXALAPIS[0] || this.regiao == CAIXALAPIS[6] || this.regiao == CAIXALAPIS[12]) {
                Cor.ptoNormal = Cor.caixaLapisCor1;
                Cor.retNormal = Cor.caixaLapisCor1;
                Cor.arcNormal = Cor.caixaLapisCor1;
                Cor.traNormal = Cor.caixaLapisCor1;
                Cor.txtNormal = Cor.caixaLapisCor1;
                Cor.lapGraf = Cor.caixaLapisCor1;
                Cor.lapCorpo = Cor.caixaLapisCor1;
                Cor.compGraf = Cor.caixaLapisCor1;
                Cor.lapGrafDest = Cor.caixaLapisDest;
                Cor.lapCorpoDest = Cor.caixaLapisDest;
                Cor.compGrafDest = Cor.caixaLapisDest;
            } else if (this.regiao == CAIXALAPIS[1] || this.regiao == CAIXALAPIS[7] || this.regiao == CAIXALAPIS[13]) {
                Cor.ptoNormal = Cor.caixaLapisCor2;
                Cor.retNormal = Cor.caixaLapisCor2;
                Cor.arcNormal = Cor.caixaLapisCor2;
                Cor.traNormal = Cor.caixaLapisCor2;
                Cor.txtNormal = Cor.caixaLapisCor2;
                Cor.lapGraf = Cor.caixaLapisCor2;
                Cor.lapCorpo = Cor.caixaLapisCor2;
                Cor.compGraf = Cor.caixaLapisCor2;
                Cor.lapGrafDest = Cor.lapGraf.darker();
                Cor.lapCorpoDest = Cor.lapCorpo.darker();
                Cor.compGrafDest = Cor.compGraf.darker();
            } else if (this.regiao == CAIXALAPIS[2] || this.regiao == CAIXALAPIS[8] || this.regiao == CAIXALAPIS[14]) {
                Cor.ptoNormal = Cor.caixaLapisCor3;
                Cor.retNormal = Cor.caixaLapisCor3;
                Cor.arcNormal = Cor.caixaLapisCor3;
                Cor.traNormal = Cor.caixaLapisCor3;
                Cor.txtNormal = Cor.caixaLapisCor3;
                Cor.lapGraf = Cor.caixaLapisCor3;
                Cor.lapCorpo = Cor.caixaLapisCor3;
                Cor.compGraf = Cor.caixaLapisCor3;
                Cor.lapGrafDest = Cor.lapGraf.darker();
                Cor.lapCorpoDest = Cor.lapCorpo.darker();
                Cor.compGrafDest = Cor.compGraf.darker();
            } else if (this.regiao == CAIXALAPIS[3] || this.regiao == CAIXALAPIS[9] || this.regiao == CAIXALAPIS[15]) {
                Cor.ptoNormal = Cor.caixaLapisCor4;
                Cor.retNormal = Cor.caixaLapisCor4;
                Cor.arcNormal = Cor.caixaLapisCor4;
                Cor.traNormal = Cor.caixaLapisCor4;
                Cor.txtNormal = Cor.caixaLapisCor4;
                Cor.lapGraf = Cor.caixaLapisCor4;
                Cor.lapCorpo = Cor.caixaLapisCor4;
                Cor.compGraf = Cor.caixaLapisCor4;
                Cor.lapGrafDest = Cor.lapGraf.darker();
                Cor.lapCorpoDest = Cor.lapCorpo.darker();
                Cor.compGrafDest = Cor.compGraf.darker();
            } else if (this.regiao == CAIXALAPIS[4] || this.regiao == CAIXALAPIS[10] || this.regiao == CAIXALAPIS[16]) {
                Cor.ptoNormal = Cor.caixaLapisCor5;
                Cor.retNormal = Cor.caixaLapisCor5;
                Cor.arcNormal = Cor.caixaLapisCor5;
                Cor.traNormal = Cor.caixaLapisCor5;
                Cor.txtNormal = Cor.caixaLapisCor5;
                Cor.lapGraf = Cor.caixaLapisCor5;
                Cor.lapCorpo = Cor.caixaLapisCor5;
                Cor.compGraf = Cor.caixaLapisCor5;
                Cor.lapGrafDest = Cor.lapGraf.darker();
                Cor.lapCorpoDest = Cor.lapCorpo.darker();
                Cor.compGrafDest = Cor.compGraf.darker();
            } else if (this.regiao == CAIXALAPIS[5] || this.regiao == CAIXALAPIS[11] || this.regiao == CAIXALAPIS[17]) {
                Cor.ptoNormal = Cor.caixaLapisCor6;
                Cor.retNormal = Cor.caixaLapisCor6;
                Cor.arcNormal = Cor.caixaLapisCor6;
                Cor.traNormal = Cor.caixaLapisCor6;
                Cor.txtNormal = Cor.caixaLapisCor6;
                Cor.lapGraf = Cor.caixaLapisCor6;
                Cor.lapCorpo = Cor.caixaLapisCor6;
                Cor.compGraf = Cor.caixaLapisCor6;
                Cor.lapGrafDest = Cor.lapGraf.darker();
                Cor.lapCorpoDest = Cor.lapCorpo.darker();
                Cor.compGrafDest = Cor.compGraf.darker();
            }
            if (this.regiao == CAIXALAPIS[0] || this.regiao == CAIXALAPIS[1] || this.regiao == CAIXALAPIS[2] || this.regiao == CAIXALAPIS[3] || this.regiao == CAIXALAPIS[4] || this.regiao == CAIXALAPIS[5]) {
                Cor.espessuraLinha = 1.0f;
            } else if (this.regiao == CAIXALAPIS[6] || this.regiao == CAIXALAPIS[7] || this.regiao == CAIXALAPIS[8] || this.regiao == CAIXALAPIS[9] || this.regiao == CAIXALAPIS[10] || this.regiao == CAIXALAPIS[11]) {
                Cor.espessuraLinha = 2.0f;
            } else if (this.regiao == CAIXALAPIS[12] || this.regiao == CAIXALAPIS[13] || this.regiao == CAIXALAPIS[14] || this.regiao == CAIXALAPIS[15] || this.regiao == CAIXALAPIS[16] || this.regiao == CAIXALAPIS[17]) {
                Cor.espessuraLinha = 3.0f;
            }
            this.sistema.repaint();
        }
    }

    @Override
    public void opera(EventoOperacao evento) {
        Posicao cliqueAtual = new Posicao(evento.coordenadas());
        Vetor vetMov = new Vetor(this.cliqueAnt, cliqueAtual);
        if (this.regiao == 0) {
            this.moveLapisCores(vetMov);
        }
        this.cliqueAnt.defPosicao(cliqueAtual);
    }

    public void moveLapisCores(Vetor desloca) {
        this.posicaoCaixa = this.posicaoCaixa.soma(desloca);
        this.sistema.repaint();
    }

    @Override
    public void libera(Evento evento) {
    }

    @Override
    public boolean destaca(Posicao posCursor) {
        int estAnt = this.regiao;
        this.possuiFoco = this.posicaoDentro(posCursor);
        if (this.regiao != estAnt) {
            this.sistema.repaint();
        }
        return this.possuiFoco;
    }

    @Override
    public void desenha(Graphics g) {
        Posicao posgraf;
        int[] X = new int[4];
        int[] Y = new int[4];
        Polygon[] lapis = new Polygon[18];
        Polygon[] pgraf = new Polygon[18];
        Polygon[] graf = new Polygon[18];
        Color[] corLapis = new Color[6];
        this.vertX[0] = this.posicaoCaixa.x;
        this.vertY[0] = this.posicaoCaixa.y + (double)this.altura;
        this.vertX[1] = this.posicaoCaixa.x + (double)this.largura;
        this.vertY[1] = this.posicaoCaixa.y + (double)this.altura;
        this.vertX[2] = this.posicaoCaixa.x + (double)this.largura;
        this.vertY[2] = this.posicaoCaixa.y;
        this.vertX[3] = this.posicaoCaixa.x;
        this.vertY[3] = this.posicaoCaixa.y;
        corLapis[0] = Cor.caixaLapisCor1;
        corLapis[1] = Cor.caixaLapisCor2;
        corLapis[2] = Cor.caixaLapisCor3;
        corLapis[3] = Cor.caixaLapisCor4;
        corLapis[4] = Cor.caixaLapisCor5;
        corLapis[5] = Cor.caixaLapisCor6;
        Color lapPontaGraf = Cor.lapPontaGraf;
        Posicao pos = new Posicao(this.vertX[0] - 11.0, this.vertY[1]);
        int i = 0;
        while (i < 6) {
            pos = new Posicao(pos.x + 11.0, pos.y);
            X[0] = pos.intX();
            Y[0] = pos.intY() + this.tam01;
            X[1] = pos.intX() + 10;
            Y[1] = pos.intY() + this.tam01;
            X[2] = pos.intX() + 10;
            Y[2] = pos.intY();
            X[3] = pos.intX();
            Y[3] = pos.intY();
            lapis[i] = this.folha.poligono(X, Y, 4);
            if (this.regiao == CAIXALAPIS[i] && this.possuiFoco) {
                g.setColor(Cor.caixaLapisDest);
            } else {
                g.setColor(corLapis[i]);
            }
            g.fillPolygon(lapis[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(lapis[i]);
            posgraf = new Posicao(pos.x, pos.y + (double)this.tam01);
            X[0] = posgraf.intX();
            Y[0] = posgraf.intY();
            X[1] = posgraf.intX() + 5;
            Y[1] = posgraf.intY() + 10;
            X[2] = posgraf.intX() + 10;
            Y[2] = posgraf.intY();
            pgraf[i] = this.folha.poligono(X, Y, 3);
            g.setColor(lapPontaGraf);
            g.fillPolygon(pgraf[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(pgraf[i]);
            posgraf = new Posicao(pos.x, pos.y + (double)this.tam01);
            X[0] = posgraf.intX() + 4;
            Y[0] = posgraf.intY() + 7;
            X[1] = posgraf.intX() + 6;
            Y[1] = posgraf.intY() + 7;
            X[2] = posgraf.intX() + 5;
            Y[2] = posgraf.intY() + 10;
            graf[i] = this.folha.poligono(X, Y, 3);
            g.setColor(corLapis[i]);
            g.fillPolygon(graf[i]);
            g.setColor(corLapis[i]);
            g.drawPolygon(graf[i]);
            ++i;
        }
        pos = new Posicao(this.vertX[0] - 11.0, this.vertY[1]);
        i = 6;
        while (i < 12) {
            pos = new Posicao(pos.x + 11.0, pos.y);
            X[0] = pos.intX();
            Y[0] = pos.intY() + this.tam02;
            X[1] = pos.intX() + 10;
            Y[1] = pos.intY() + this.tam02;
            X[2] = pos.intX() + 10;
            Y[2] = pos.intY();
            X[3] = pos.intX();
            Y[3] = pos.intY();
            lapis[i] = this.folha.poligono(X, Y, 4);
            if (this.regiao == CAIXALAPIS[i] && this.possuiFoco) {
                g.setColor(Cor.caixaLapisDest);
            } else {
                g.setColor(corLapis[i - 6]);
            }
            g.fillPolygon(lapis[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(lapis[i]);
            posgraf = new Posicao(pos.x, pos.y + (double)this.tam02);
            X[0] = posgraf.intX();
            Y[0] = posgraf.intY();
            X[1] = posgraf.intX() + 5;
            Y[1] = posgraf.intY() + 10;
            X[2] = posgraf.intX() + 10;
            Y[2] = posgraf.intY();
            pgraf[i] = this.folha.poligono(X, Y, 3);
            g.setColor(lapPontaGraf);
            g.fillPolygon(pgraf[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(pgraf[i]);
            posgraf = new Posicao(pos.x, pos.y + (double)this.tam02);
            X[0] = posgraf.intX() + 3;
            Y[0] = posgraf.intY() + 5;
            X[1] = posgraf.intX() + 7;
            Y[1] = posgraf.intY() + 5;
            X[2] = posgraf.intX() + 5;
            Y[2] = posgraf.intY() + 10;
            graf[i] = this.folha.poligono(X, Y, 3);
            g.setColor(corLapis[i - 6]);
            g.fillPolygon(graf[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(graf[i]);
            ++i;
        }
        pos = new Posicao(this.vertX[0] - 11.0, this.vertY[1]);
        i = 12;
        while (i < 18) {
            pos = new Posicao(pos.x + 11.0, pos.y);
            X[0] = pos.intX();
            Y[0] = pos.intY() + this.tam03;
            X[1] = pos.intX() + 10;
            Y[1] = pos.intY() + this.tam03;
            X[2] = pos.intX() + 10;
            Y[2] = pos.intY();
            X[3] = pos.intX();
            Y[3] = pos.intY();
            lapis[i] = this.folha.poligono(X, Y, 4);
            if (this.regiao == CAIXALAPIS[i] && this.possuiFoco) {
                g.setColor(Cor.caixaLapisDest);
            } else {
                g.setColor(corLapis[i - 12]);
            }
            g.fillPolygon(lapis[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(lapis[i]);
            posgraf = new Posicao(pos.x, pos.y + (double)this.tam03);
            X[0] = posgraf.intX();
            Y[0] = posgraf.intY();
            X[1] = posgraf.intX() + 5;
            Y[1] = posgraf.intY() + 10;
            X[2] = posgraf.intX() + 10;
            Y[2] = posgraf.intY();
            pgraf[i] = this.folha.poligono(X, Y, 3);
            g.setColor(lapPontaGraf);
            g.fillPolygon(pgraf[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(pgraf[i]);
            posgraf = new Posicao(pos.x, pos.y + (double)this.tam03);
            X[0] = posgraf.intX() + 2;
            Y[0] = posgraf.intY() + 3;
            X[1] = posgraf.intX() + 8;
            Y[1] = posgraf.intY() + 3;
            X[2] = posgraf.intX() + 5;
            Y[2] = posgraf.intY() + 10;
            graf[i] = this.folha.poligono(X, Y, 3);
            g.setColor(corLapis[i - 12]);
            g.fillPolygon(graf[i]);
            g.setColor(Cor.lapContorno);
            g.drawPolygon(graf[i]);
            ++i;
        }
        Posicao pExt0 = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pExt1 = new Posicao(this.vertX[1], this.vertY[1]);
        Posicao pExt2 = new Posicao(this.vertX[2], this.vertY[2]);
        Posicao pExt3 = new Posicao(this.vertX[3], this.vertY[3]);
        X[0] = pExt0.intX();
        Y[0] = pExt0.intY();
        X[1] = pExt1.intX();
        Y[1] = pExt1.intY();
        X[2] = pExt2.intX();
        Y[2] = pExt2.intY();
        X[3] = pExt3.intX();
        Y[3] = pExt3.intY();
        Polygon caixa = this.folha.poligono(X, Y, 4);
        Color cor = g.getColor();
        g.setColor(Cor.caixaLapis);
        if (this.regiao == 0 && this.possuiFoco) {
            g.setColor(Cor.caixaLapis);
        } else {
            g.setColor(Cor.caixaLapis);
        }
        g.fillPolygon(caixa);
        try {
            if (this.logo_file != null) {
                g.drawImage(this.logo_image, caixa.xpoints[0] + 3, caixa.ypoints[2], null);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(e.toString()) + ": " + e.getMessage());
        }
        g.setColor(Cor.caixaLapisContorno);
        g.drawPolygon(caixa);
        g.setColor(cor);
    }
}

