/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Evento;
import control.EventoOperacao;
import control.EventoSelecao;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import model.Arco;
import model.Constantes;
import model.Cor;
import model.Esquadro;
import model.Folha;
import model.FormaLivre;
import model.Instrumento;
import model.Ponto;
import model.Posicao;
import model.Reta;
import model.Texto;
import model.Vetor;
import view.Tela;

public class Lapis
extends Instrumento
implements Constantes {
    public Posicao pontaGraf;
    public Posicao pontaBorr;
    public Posicao pontaGrafRel;
    public Posicao PontaBorrRel;
    public Posicao pontaGrafAnt;
    private int largura;
    private int regiao;
    private int borda;
    Vetor vetDir;
    Esquadro esquadro1;
    Esquadro esquadro2;
    Esquadro esquadro;
    Posicao cliqueInicial;
    Posicao cliqueAnt;
    Ponto apontaPontos;
    Reta apontaRetas;
    Reta retaAtual;
    Arco apontaArcos;
    Texto apontaTextos;
    FormaLivre apontaFormas;
    FormaLivre forma;
    Folha folha;
    TrataTexto tTexto;
    public int tipoLinha;

    public Lapis(Posicao posicao, int tamanho, int largura, int inclinacao, int tipoLinha, float espessuraLinha, Tela sistema) {
        this.largura = largura;
        this.cliqueInicial = new Posicao(0.0, 0.0);
        this.cliqueAnt = new Posicao(0.0, 0.0);
        this.pontaGraf = new Posicao(0.0, 0.0);
        this.pontaBorr = new Posicao(0.0, 0.0);
        this.regiao = -1;
        this.constLapis(posicao, tamanho, inclinacao);
        this.proximo = null;
        this.sistema = sistema;
        this.esquadro1 = sistema.esquadro45;
        this.esquadro2 = sistema.esquadro60;
        this.apontaPontos = sistema.listaPontos;
        this.apontaRetas = sistema.listaRetas;
        this.apontaArcos = sistema.listaArcos;
        this.apontaTextos = sistema.listaTextos;
        this.apontaFormas = sistema.listaFormas;
        this.tipoLinha = Cor.tipoLinha;
        this.folha = sistema.folha;
        this.tTexto = new TrataTexto();
        sistema.addKeyListener(this.tTexto);
    }

    @Override
    public boolean posicaoDentro(Posicao clique) {
        boolean valido = true;
        double a = this.pontaBorr.x - this.pontaGraf.x;
        double x = clique.x - this.pontaGraf.x;
        double b = this.pontaBorr.y - this.pontaGraf.y;
        double y = clique.y - this.pontaGraf.y;
        double projecao = Calculos.divisao(a * x + b * y, Calculos.raiz(a * a + b * b));
        valido = !(projecao > Calculos.raiz(a * a + b * b) + (double)(this.largura / 2)) && !(projecao < 0.0);
        double distancia = Calculos.divisao(Math.abs(a * y - b * x), Calculos.raiz(a * a + b * b));
        return distancia <= (double)(this.largura / 2) && valido;
    }

    @Override
    public void seleciona(EventoSelecao evento) {
        this.borda = 0;
        this.esquadro = null;
        this.vetDir = new Vetor(0.0, 0.0);
        this.cliqueInicial.defPosicao(evento.coordenadas());
        this.cliqueAnt.defPosicao(evento.coordenadas());
        this.regiao = this.regiaoAtiva(this.cliqueInicial);
        if (this.regiao == 1) {
            if (this.apontaFormas.proximo == null || !this.apontaFormas.proximo.vazia()) {
                this.forma = new FormaLivre(this.folha);
                this.forma.proximo = this.apontaFormas.proximo;
                this.apontaFormas.proximo = this.forma;
            }
            this.forma = this.apontaFormas.proximo;
        } else if (this.regiao == 4) {
            this.pontaGrafAnt = this.pontaGraf;
            this.sistema.repaint();
        } else if (this.regiao == 5) {
            if (Cor.tipoLinha == 0) {
                Cor.tipoLinha = 1;
            } else if (Cor.tipoLinha == 1) {
                Cor.tipoLinha = 2;
            } else if (Cor.tipoLinha == 2) {
                Cor.tipoLinha = 3;
            } else if (Cor.tipoLinha == 3) {
                Cor.tipoLinha = 0;
            }
            this.sistema.repaint();
        }
    }

    public int regiaoAtiva(Posicao posCursor) {
        double distGraf;
        int regiao = -1;
        double distBor = Calculos.distancia(posCursor, this.pontaBorr);
        regiao = distBor <= 0.5 * (double)this.largura ? 3 : (distBor > 0.5 * (double)this.largura && distBor < 1.3 * (double)this.largura ? 4 : ((distGraf = Calculos.distancia(posCursor, this.pontaGraf)) <= (double)(2 * this.largura) ? 1 : (distGraf <= 33.0 ? 5 : 2)));
        return regiao;
    }

    @Override
    public void opera(EventoOperacao evento) {
        Posicao cliqueAtual = new Posicao(evento.coordenadas());
        Vetor vetMov = new Vetor(this.cliqueAnt, cliqueAtual);
        switch (this.regiao) {
            case 3: {
                this.moveLapis(vetMov);
                if (!(this.apagaFormaParcial(this.pontaBorr) || this.apagaTexto(this.pontaBorr) || this.apagaPonto(this.pontaBorr) || this.apagaArcoParcial(this.pontaBorr))) {
                    this.apagaRetaParcial(this.pontaBorr);
                }
                this.sistema.repaint();
                break;
            }
            case 4: {
                Vetor vet1 = new Vetor(this.pontaGraf, cliqueAtual);
                Vetor vet2 = new Vetor(this.pontaGraf, this.cliqueAnt);
                double angulo = Calculos.anguloVetores(vet1, vet2);
                this.giraLapis(angulo);
                this.sistema.repaint();
                break;
            }
            case 2: {
                this.moveLapis(vetMov);
                this.destElementos();
                this.sistema.repaint();
                break;
            }
            case 1: {
                if (!this.folha.posicaoDentro(this.folha.posPan(this.pontaGraf))) break;
                int borda1 = this.esquadro1.intercepta(this.pontaGraf);
                int borda2 = this.esquadro2.intercepta(this.pontaGraf);
                if (!(this.esquadro == this.esquadro1 && this.borda == borda1 || this.esquadro == this.esquadro2 && this.borda == borda2)) {
                    if (borda1 == 0 && borda2 == 0) {
                        this.esquadro = null;
                        this.borda = 0;
                        this.vetDir = null;
                    } else if (borda1 != 0 && borda2 == 0) {
                        this.esquadro = this.esquadro1;
                        this.borda = borda1;
                        this.vetDir = this.esquadro1.vetBorda(borda1);
                    } else if (borda1 == 0 && borda2 != 0) {
                        this.esquadro = this.esquadro2;
                        this.borda = borda2;
                        this.vetDir = this.esquadro2.vetBorda(borda2);
                    } else if (borda1 != 0 && borda2 != 0) {
                        if (this.esquadro1.distLapis <= this.esquadro2.distLapis) {
                            this.esquadro = this.esquadro1;
                            this.borda = borda1;
                            this.vetDir = this.esquadro1.vetBorda(borda1);
                        } else {
                            this.esquadro = this.esquadro2;
                            this.borda = borda2;
                            this.vetDir = this.esquadro2.vetBorda(borda2);
                        }
                    }
                    if (this.borda != 0) {
                        if (!this.apoiado(this.esquadro, this.borda, vetMov)) {
                            this.borda = 0;
                        } else {
                            this.ajusteLapisBorda(this.esquadro, this.borda);
                            this.retaAtual = new Reta(this.folha);
                            this.retaAtual.defInicio(this.folha.posSemZoom(this.pontaGraf));
                            this.insereReta(this.retaAtual);
                        }
                    }
                }
                if (this.borda == 0) {
                    this.moveLapis(vetMov);
                    this.forma.adicVertice(this.folha.posSemZoom(this.pontaGraf));
                } else if (!this.apoiado(this.esquadro, this.borda, vetMov)) {
                    this.borda = 0;
                    this.moveLapis(vetMov);
                } else {
                    if (!this.apontaFormas.proximo.vazia()) {
                        this.forma = new FormaLivre(this.folha);
                        this.forma.proximo = this.apontaFormas.proximo;
                        this.apontaFormas.proximo = this.forma;
                    }
                    this.moveLapisDirecao(this.vetDir, vetMov);
                    this.esquadro.destEsc(this.borda, this.pontaGraf);
                    this.pontaGrafRel = new Posicao(this.pontaGraf);
                    if (this.esquadro.bordaEsc == this.borda) {
                        this.pontaGrafRel = this.pontaGrafRel.soma(this.esquadro.vetAjEsc(this.pontaGrafRel));
                    }
                    this.pontaGrafRel = this.folha.posSemZoom(this.pontaGrafRel);
                    if (this.retaAtual.fim.x == 0.0 && this.retaAtual.fim.y == 0.0) {
                        if (Calculos.distIgual(this.pontaGrafRel.x, this.retaAtual.inicio.x)) {
                            if (this.pontaGrafRel.y < this.retaAtual.inicio.y) {
                                this.retaAtual.defFim(this.retaAtual.inicio);
                                this.retaAtual.defInicio(this.pontaGrafRel);
                            } else {
                                this.retaAtual.defFim(this.pontaGrafRel);
                            }
                        } else if (this.pontaGrafRel.x < this.retaAtual.inicio.x) {
                            this.retaAtual.defFim(this.retaAtual.inicio);
                            this.retaAtual.defInicio(this.pontaGrafRel);
                        } else {
                            this.retaAtual.defFim(this.pontaGrafRel);
                        }
                    } else if (Calculos.distIgual(this.pontaGrafRel.x, this.retaAtual.inicio.x) && Calculos.distIgual(this.pontaGrafRel.x, this.retaAtual.fim.x)) {
                        if (this.pontaGrafRel.y < this.retaAtual.inicio.y) {
                            this.retaAtual.defInicio(this.pontaGrafRel);
                        } else if (this.pontaGrafRel.y > this.retaAtual.fim.y) {
                            this.retaAtual.defFim(this.pontaGrafRel);
                        }
                    } else if (this.pontaGrafRel.x < this.retaAtual.inicio.x) {
                        this.retaAtual.defInicio(this.pontaGrafRel);
                    } else if (this.pontaGrafRel.x > this.retaAtual.fim.x) {
                        this.retaAtual.defFim(this.pontaGrafRel);
                    }
                }
                this.sistema.repaint();
            }
        }
        this.cliqueAnt.defPosicao(cliqueAtual);
    }

    @Override
    public void libera(Evento evento) {
        Posicao cliqueAtual = new Posicao(evento.coordenadas());
        int borda1 = this.esquadro1.intercepta(this.pontaGraf);
        int borda2 = this.esquadro2.intercepta(this.pontaGraf);
        if (borda1 != 0 || borda2 != 0) {
            if (this.esquadro1.distLapis <= this.esquadro2.distLapis) {
                this.ajusteLapisBorda(this.esquadro1, borda1);
                this.ajusteLapisEsc(this.esquadro1, borda1);
            } else {
                this.ajusteLapisBorda(this.esquadro2, borda2);
                this.ajusteLapisEsc(this.esquadro2, borda2);
            }
            this.sistema.repaint();
        }
        if (this.borda != 0) {
            Ponto ponto;
            this.apontaRetas.proximo = this.retaAtual.proximo;
            this.retaAtual.proximo = null;
            Reta auxiliar = this.apontaRetas;
            while (auxiliar.proximo != null) {
                auxiliar = auxiliar.proximo;
                double angulo = Calculos.anguloRetas(this.retaAtual.fim.x - this.retaAtual.inicio.x, this.retaAtual.fim.y - this.retaAtual.inicio.y, auxiliar.fim.x - auxiliar.inicio.x, auxiliar.fim.y - auxiliar.inicio.y);
                double distancia = Calculos.distanciaPontoReta(this.retaAtual.inicio, auxiliar.inicio, auxiliar.fim);
                if (!(angulo <= 1.0E-6) || !(distancia <= 1.0E-6)) continue;
                if (this.retaAtual.inicio.x > auxiliar.inicio.x + 1.0E-6 && this.retaAtual.inicio.x < auxiliar.fim.x - 1.0E-6) {
                    this.retaAtual.inicio.x = auxiliar.inicio.x;
                    this.retaAtual.inicio.y = auxiliar.inicio.y;
                    if (auxiliar.fim.x > this.retaAtual.fim.x) {
                        this.retaAtual.fim.x = auxiliar.fim.x;
                        this.retaAtual.fim.y = auxiliar.fim.y;
                    }
                    this.removeReta(auxiliar);
                    continue;
                }
                if (this.retaAtual.fim.x > auxiliar.inicio.x + 1.0E-6 && this.retaAtual.fim.x < auxiliar.fim.x - 1.0E-6) {
                    this.retaAtual.fim.x = auxiliar.fim.x;
                    this.retaAtual.fim.y = auxiliar.fim.y;
                    if (auxiliar.inicio.x < this.retaAtual.inicio.x) {
                        this.retaAtual.inicio.x = auxiliar.inicio.x;
                        this.retaAtual.inicio.y = auxiliar.inicio.y;
                    }
                    this.removeReta(auxiliar);
                    continue;
                }
                if (this.retaAtual.inicio.x < auxiliar.inicio.x - 1.0E-6 && this.retaAtual.fim.x > auxiliar.fim.x + 1.0E-6) {
                    this.removeReta(auxiliar);
                    continue;
                }
                if (this.retaAtual.inicio.y > auxiliar.inicio.y + 1.0E-6 && this.retaAtual.inicio.y < auxiliar.fim.y - 1.0E-6) {
                    this.retaAtual.inicio.x = auxiliar.inicio.x;
                    this.retaAtual.inicio.y = auxiliar.inicio.y;
                    if (auxiliar.fim.y > this.retaAtual.fim.y) {
                        this.retaAtual.fim.x = auxiliar.fim.x;
                        this.retaAtual.fim.y = auxiliar.fim.y;
                    }
                    this.removeReta(auxiliar);
                    continue;
                }
                if (this.retaAtual.fim.y > auxiliar.inicio.y + 1.0E-6 && this.retaAtual.fim.y < auxiliar.fim.y - 1.0E-6) {
                    this.retaAtual.fim.x = auxiliar.fim.x;
                    this.retaAtual.fim.y = auxiliar.fim.y;
                    if (auxiliar.inicio.y < this.retaAtual.inicio.y) {
                        this.retaAtual.inicio.x = auxiliar.inicio.x;
                        this.retaAtual.inicio.y = auxiliar.inicio.y;
                    }
                    this.removeReta(auxiliar);
                    continue;
                }
                if (!(this.retaAtual.inicio.y < auxiliar.inicio.y - 1.0E-6) || !(this.retaAtual.fim.y > auxiliar.fim.y + 1.0E-6)) continue;
                this.removeReta(auxiliar);
            }
            this.insereReta(this.retaAtual);
            Posicao[] intersecao = new Posicao[]{new Posicao(0.0, 0.0), new Posicao(0.0, 0.0)};
            Reta reta = this.apontaRetas;
            while (reta.proximo != null) {
                Posicao pos;
                reta = reta.proximo;
                if (reta == this.retaAtual || (pos = Calculos.intersecaoRetas(this.retaAtual, reta)) == null) continue;
                ponto = this.apontaPontos.proximo;
                while (ponto != null && !ponto.igual(pos)) {
                    ponto = ponto.proximo;
                }
                if (ponto != null) continue;
                ponto = new Ponto(pos, this.folha);
                ponto.proximo = this.apontaPontos.proximo;
                this.apontaPontos.proximo = ponto;
                this.sistema.repaint();
            }
            Arco arco = this.apontaArcos;
            while (arco.proximo != null) {
                arco = arco.proximo;
                int n = Calculos.intersecaoRetaArco(this.retaAtual, arco, intersecao);
                int i = 1;
                while (i <= n) {
                    ponto = this.apontaPontos.proximo;
                    while (ponto != null && !ponto.igual(intersecao[i - 1])) {
                        ponto = ponto.proximo;
                    }
                    if (ponto == null) {
                        ponto = new Ponto(intersecao[i - 1], this.folha);
                        ponto.proximo = this.apontaPontos.proximo;
                        this.apontaPontos.proximo = ponto;
                        this.sistema.repaint();
                    }
                    ++i;
                }
            }
        } else if (this.regiao == 1 && Calculos.distancia(this.cliqueInicial, cliqueAtual) <= 2.0) {
            Ponto ponto = this.apontaPontos.proximo;
            while (ponto != null && !ponto.igualRel(this.folha.posSemZoom(this.pontaGraf))) {
                ponto = ponto.proximo;
            }
            if (ponto == null) {
                double d;
                double dmin = 4.0;
                Posicao pos = this.pontaGraf;
                Reta retaPerto = null;
                Reta reta = this.apontaRetas;
                while (reta.proximo != null) {
                    reta = reta.proximo;
                    reta.destaque = false;
                    Reta retaRel = reta.retaRelativa();
                    d = retaRel.distanciaPosSinal(pos);
                    if (!(d * d <= dmin * dmin) || !retaRel.dentroLimites(pos)) continue;
                    dmin = d;
                    retaPerto = retaRel;
                }
                Arco arcoPerto = null;
                Arco arco = this.apontaArcos;
                while (arco.proximo != null) {
                    arco = arco.proximo;
                    arco.destaque = false;
                    Arco arcoRel = arco.arcoRel();
                    d = arcoRel.raio - Calculos.distancia(pos, arcoRel.centro);
                    if (!(d * d <= dmin * dmin) || !arcoRel.interceptaPosicao(pos)) continue;
                    dmin = d;
                    arcoPerto = arcoRel;
                }
                if (arcoPerto != null) {
                    Vetor vet = new Vetor(arcoPerto.centro, pos);
                    vet = vet.vetorPar(arcoPerto.raio);
                    pos = arcoPerto.centro.soma(vet);
                } else if (retaPerto != null) {
                    Vetor vet = retaPerto.vetorDiretor();
                    vet = vet.vetorNormal(dmin);
                    pos = pos.soma(vet.invert());
                }
                ponto = new Ponto(this.folha.posSemZoom(pos), this.folha);
                ponto.proximo = this.apontaPontos.proximo;
                this.apontaPontos.proximo = ponto;
                this.sistema.repaint();
            }
        } else if (this.regiao == 3 && Calculos.distancia(this.cliqueInicial, cliqueAtual) <= 2.0) {
            this.apaga();
            this.sistema.repaint();
        }
        this.regiao = -1;
    }

    public void insereReta(Reta retaAtual) {
        retaAtual.proximo = this.apontaRetas.proximo;
        this.apontaRetas.proximo = retaAtual;
    }

    public void removeReta(Reta retaAtual) {
        Reta r = this.apontaRetas;
        while (r.proximo != null && r.proximo != retaAtual) {
            r = r.proximo;
        }
        if (r.proximo == retaAtual) {
            r.proximo = retaAtual.proximo;
        }
    }

    public void destElementos() {
        double d;
        double dmin = 4.0;
        Posicao pos = this.pontaGraf;
        Reta retaPerto = null;
        Reta reta = this.apontaRetas;
        while (reta.proximo != null) {
            reta = reta.proximo;
            reta.destaque = false;
            Reta retaRel = reta.retaRelativa();
            d = retaRel.distanciaPosSinal(pos);
            if (!(d * d <= dmin * dmin) || !retaRel.dentroLimites(pos)) continue;
            dmin = d;
            retaPerto = reta;
        }
        Arco arcoPerto = null;
        Arco arco = this.apontaArcos;
        while (arco.proximo != null) {
            arco = arco.proximo;
            arco.destaque = false;
            Arco arcoRel = arco.arcoRel();
            d = arcoRel.raio - Calculos.distancia(pos, arcoRel.centro);
            if (!(d * d <= dmin * dmin) || !arcoRel.interceptaPosicao(pos)) continue;
            dmin = d;
            arcoPerto = arco;
        }
        if (arcoPerto != null) {
            arcoPerto.destaque = true;
        } else if (retaPerto != null) {
            retaPerto.destaque = true;
        }
    }

    private void constLapis(Posicao posicao, int tamanho, int inclinacao) {
        this.pontaGraf.x = posicao.x;
        this.pontaGraf.y = posicao.y;
        this.pontaBorr.x = this.pontaGraf.x + (double)tamanho * Math.cos((double)inclinacao * (Math.PI / 180));
        this.pontaBorr.y = this.pontaGraf.y - (double)tamanho * Math.sin((double)inclinacao * (Math.PI / 180));
    }

    public void moveLapis(Vetor desloca) {
        this.pontaBorr = this.pontaBorr.soma(desloca);
        this.pontaGraf = this.pontaGraf.soma(desloca);
    }

    private void giraLapis(double angulo) {
        Vetor vetor = new Vetor(this.pontaGraf, this.pontaBorr);
        this.pontaBorr = this.pontaGraf.soma(vetor.gira(angulo));
    }

    private void moveLapisDirecao(Vetor vetDir, Vetor vetMov) {
        Vetor vetProj = vetMov.proj(vetDir);
        this.moveLapis(vetProj);
    }

    private void ajusteLapisBorda(Esquadro esquadro, int borda) {
        Vetor vetBorda = esquadro.vetBorda(borda);
        Vetor vetMov = vetBorda.vetorNormal(-esquadro.distLapis);
        this.moveLapis(vetMov);
    }

    private void ajusteLapisEsc(Esquadro esq, int borda) {
        Reta retaBorda;
        if (esq.bordaEsc == borda && (retaBorda = esq.retaBordaEsc()).dentroLimites(this.pontaGraf)) {
            esq.subUnidDest = esq.subUnid(this.pontaGraf);
            Vetor vetAj = esq.vetAjEsc(this.pontaGraf);
            this.moveLapis(vetAj);
        }
    }

    public boolean apoiado(Esquadro esq, int borda, Vetor vetMov) {
        if (vetMov.norma() <= 4.0) {
            return true;
        }
        Vetor vetBorda = esq.vetBorda(borda);
        Vetor vetPerp = vetBorda.vetorNormal(1.0);
        double ang = Calculos.anguloVetores(vetPerp, vetMov);
        return !((ang = Math.abs(ang * 57.29577951308232)) <= 20.0);
    }

    private void apaga() {
        if (!(this.apagaTexto(this.pontaBorr) || this.apagaPonto(this.pontaBorr) || this.apagaForma(this.pontaBorr) || this.apagaArco(this.pontaBorr))) {
            this.apagaReta(this.pontaBorr);
        }
    }

    private boolean apagaPonto(Posicao pos) {
        double dmin = this.largura / 2;
        boolean ret = false;
        Ponto anterior = this.apontaPontos;
        Ponto ponto = anterior.proximo;
        while (ponto != null) {
            double d = Calculos.distancia(pos, this.folha.posComZoom(ponto));
            if (d <= dmin) {
                ret = true;
                Esquadro esquadro = ponto.esqVinc;
                if (esquadro != null) {
                    esquadro.desfazVincs(ponto);
                }
                anterior.proximo = ponto = ponto.proximo;
                continue;
            }
            anterior = ponto;
            ponto = ponto.proximo;
        }
        return ret;
    }

    private boolean apagaReta(Posicao pos) {
        double dmin = this.largura / 2;
        boolean ret = false;
        Reta anterior = this.apontaRetas;
        Reta retaAtual = anterior.proximo;
        while (retaAtual != null) {
            if (retaAtual.distPosRel(pos) <= dmin && retaAtual.dentroLimitesRel(pos)) {
                ret = true;
                anterior.proximo = retaAtual = retaAtual.proximo;
                continue;
            }
            anterior = retaAtual;
            retaAtual = retaAtual.proximo;
        }
        return ret;
    }

    private boolean apagaArco(Posicao pos) {
        double raioBorr = this.largura / 2;
        boolean ret = false;
        Arco arcoAnt = this.apontaArcos;
        Arco arcoAtual = arcoAnt.proximo;
        while (arcoAtual != null) {
            Arco arcoRel = arcoAtual.arcoRel();
            if (arcoRel.interceptaPosicao(pos)) {
                ret = true;
                arcoAnt.proximo = arcoAtual = arcoAtual.proximo;
                this.sistema.compasso.defNovoArco();
                continue;
            }
            double dist1 = Calculos.distancia(pos, arcoRel.posicaoInicio());
            double dist2 = Calculos.distancia(pos, arcoRel.posicaoFim());
            if (dist1 <= raioBorr && dist2 <= raioBorr) {
                ret = true;
                arcoAnt.proximo = arcoAtual = arcoAtual.proximo;
                this.sistema.compasso.defNovoArco();
                continue;
            }
            arcoAnt = arcoAtual;
            arcoAtual = arcoAtual.proximo;
        }
        return ret;
    }

    private boolean apagaTexto(Posicao pos) {
        boolean ret = false;
        Texto anterior = this.apontaTextos;
        Texto texto = anterior.proximo;
        while (texto != null) {
            if (texto.contPosRel(pos)) {
                if (this.tTexto.ultimo == texto) {
                    this.tTexto.ultimo = null;
                }
                anterior.proximo = texto = texto.proximo;
                ret = true;
                continue;
            }
            anterior = texto;
            texto = texto.proximo;
        }
        return ret;
    }

    private boolean apagaForma(Posicao pos) {
        boolean ret = false;
        boolean exclui = false;
        double raioBorr = this.largura / 2;
        FormaLivre formaAnt = this.apontaFormas;
        FormaLivre formaAtual = formaAnt.proximo;
        while (formaAtual != null) {
            if (formaAtual.dentroRegiaoRel(pos)) {
                formaAtual.reset();
                Posicao vertAnt = null;
                Posicao vertAtual = formaAtual.proxVertice();
                while (vertAtual != null) {
                    Posicao vertRel1 = vertAtual.posRel(this.folha);
                    double dist = Calculos.distancia(vertRel1, pos);
                    if (dist <= raioBorr + 1.0E-6) {
                        exclui = true;
                        break;
                    }
                    if (vertAnt != null) {
                        Posicao vertRel2 = vertAnt.posRel(this.folha);
                        Reta reta = new Reta(vertRel2, vertRel1, this.folha);
                        if (reta.dentroLimites(pos) && reta.distanciaPos(pos) <= raioBorr + 1.0E-6) {
                            exclui = true;
                            break;
                        }
                        vertAnt = vertAtual;
                        vertAtual = formaAtual.proxVertice();
                        continue;
                    }
                    vertAnt = vertAtual;
                    vertAtual = formaAtual.proxVertice();
                }
            }
            if (exclui) {
                ret = true;
                exclui = false;
                formaAnt.proximo = formaAtual = formaAtual.proximo;
                continue;
            }
            formaAnt = formaAtual;
            formaAtual = formaAtual.proximo;
        }
        return ret;
    }

    private boolean apagaFormaParcial(Posicao pos) {
        boolean ret = false;
        double raioBorr = this.largura / 2;
        Posicao[] intersecao = new Posicao[]{new Posicao(0.0, 0.0), new Posicao(0.0, 0.0)};
        Arco arcoBorr = new Arco(pos, raioBorr, 0.0, 360.0, this.folha);
        FormaLivre formaAnt = this.apontaFormas;
        FormaLivre formaAtual = formaAnt.proximo;
        while (formaAtual != null) {
            if (formaAtual.dentroRegiaoRel(pos)) {
                formaAtual.reset();
                Posicao vertAtual = formaAtual.proxVertice();
                Posicao vertProx = formaAtual.proxVerticeRef();
                while (vertAtual != null) {
                    FormaLivre formaNova;
                    int n;
                    Reta retaRel;
                    vertAtual = vertAtual.posRel(this.folha);
                    double dist1 = Calculos.distancia(vertAtual, pos);
                    if (vertProx == null) {
                        if (dist1 <= raioBorr + 1.0E-6) {
                            formaAtual.removeVerticeAtual();
                            vertAtual = formaAtual.vertAtual();
                            ret = true;
                            continue;
                        }
                        vertAtual = formaAtual.proxVertice();
                        vertProx = formaAtual.proxVerticeRef();
                        continue;
                    }
                    vertProx = vertProx.posRel(this.folha);
                    double dist2 = Calculos.distancia(vertProx, pos);
                    if (dist1 <= raioBorr && dist2 <= raioBorr) {
                        formaAtual.removeVerticeAtual();
                        vertAtual = formaAtual.vertAtual();
                        vertProx = formaAtual.proxVerticeRef();
                        ret = true;
                        continue;
                    }
                    if (dist1 < raioBorr - 1.0E-6 && dist2 > raioBorr) {
                        retaRel = new Reta(vertAtual, vertProx, this.folha);
                        n = Calculos.intersecaoRetaArco(retaRel, arcoBorr, intersecao);
                        if (n == 1) {
                            formaAtual.adicVerticeLocal(this.folha.posSemZoom(intersecao[0]));
                            formaAtual.removeVerticeAtual();
                            vertAtual = formaAtual.vertAtual();
                            ret = true;
                            continue;
                        }
                        vertAtual = formaAtual.proxVertice();
                        vertProx = formaAtual.proxVerticeRef();
                        continue;
                    }
                    if (dist1 > raioBorr && dist2 <= raioBorr + 1.0E-6) {
                        if (Calculos.distIgual(dist2, raioBorr)) {
                            vertAtual = formaAtual.proxVertice();
                            formaNova = formaAtual.quebra();
                            formaNova.corLinha = formaAtual.corLinha;
                            formaNova.tipoLinha = formaAtual.tipoLinha;
                            formaNova.espessuraLinha = formaAtual.espessuraLinha;
                            formaNova.proximo = formaAtual.proximo;
                            formaAtual.proximo = formaNova;
                            ret = true;
                            break;
                        }
                        retaRel = new Reta(vertAtual, vertProx, this.folha);
                        n = Calculos.intersecaoRetaArco(retaRel, arcoBorr, intersecao);
                        if (n == 1) {
                            formaAtual.adicVerticeLocal(this.folha.posSemZoom(intersecao[0]));
                            vertAtual = formaAtual.proxVertice();
                            formaNova = formaAtual.quebra();
                            formaNova.corLinha = formaAtual.corLinha;
                            formaNova.tipoLinha = formaAtual.tipoLinha;
                            formaNova.espessuraLinha = formaAtual.espessuraLinha;
                            formaNova.proximo = formaAtual.proximo;
                            formaAtual.proximo = formaNova;
                            ret = true;
                            break;
                        }
                        vertAtual = formaAtual.proxVertice();
                        vertProx = formaAtual.proxVerticeRef();
                        continue;
                    }
                    if (dist1 > raioBorr + 1.0E-6 && dist2 > raioBorr + 1.0E-6) {
                        retaRel = new Reta(vertAtual, vertProx, this.folha);
                        n = Calculos.intersecaoRetaArco(retaRel, arcoBorr, intersecao);
                        if (n == 2) {
                            double dist4;
                            double dist3 = Calculos.distancia(vertAtual, intersecao[0]);
                            if (dist3 < (dist4 = Calculos.distancia(vertAtual, intersecao[1]))) {
                                formaAtual.adicVerticeLocal(this.folha.posSemZoom(intersecao[0]));
                                vertAtual = formaAtual.proxVertice();
                                formaAtual.adicVerticeLocal(this.folha.posSemZoom(intersecao[1]));
                            } else {
                                formaAtual.adicVerticeLocal(this.folha.posSemZoom(intersecao[1]));
                                vertAtual = formaAtual.proxVertice();
                                formaAtual.adicVerticeLocal(this.folha.posSemZoom(intersecao[0]));
                            }
                            formaNova = formaAtual.quebra();
                            formaNova.corLinha = formaAtual.corLinha;
                            formaNova.tipoLinha = formaAtual.tipoLinha;
                            formaNova.espessuraLinha = formaAtual.espessuraLinha;
                            formaNova.proximo = formaAtual.proximo;
                            formaAtual.proximo = formaNova;
                            ret = true;
                            break;
                        }
                        vertAtual = formaAtual.proxVertice();
                        vertProx = formaAtual.proxVerticeRef();
                        continue;
                    }
                    vertAtual = formaAtual.proxVertice();
                    vertProx = formaAtual.proxVerticeRef();
                }
            }
            if (formaAtual.vazia() || formaAtual.numElementos() == 1) {
                formaAnt.proximo = formaAtual = formaAtual.proximo;
                continue;
            }
            formaAtual.atualiza();
            formaAnt = formaAtual;
            formaAtual = formaAtual.proximo;
        }
        return ret;
    }

    public boolean apagaRetaParcial(Posicao pos) {
        boolean ret = false;
        double dmin = this.largura / 2;
        Arco borracha = new Arco(pos, dmin, 0.0, 360.0, this.folha);
        Posicao[] intersecao = new Posicao[]{new Posicao(0.0, 0.0)};
        Reta retaAnt = this.apontaRetas;
        Reta retaAtual = retaAnt.proximo;
        while (retaAtual != null) {
            int i;
            Reta retaRel = retaAtual.retaRelativa();
            if (!retaRel.dentroRegiao(pos)) {
                retaAnt = retaAtual;
                retaAtual = retaAtual.proximo;
                continue;
            }
            double dist1 = Calculos.distancia(pos, retaRel.inicio);
            double dist2 = Calculos.distancia(pos, retaRel.fim);
            if (dist1 <= dmin && dist2 <= dmin) {
                ret = true;
                retaAnt.proximo = retaAtual = retaAtual.proximo;
                continue;
            }
            if (dist1 <= dmin) {
                i = Calculos.intersecaoRetaArco(retaRel, borracha, intersecao);
                if (i == 1) {
                    ret = true;
                    retaAtual.inicio = new Posicao(this.folha.posSemZoom(intersecao[0]));
                }
                retaAnt = retaAtual;
                retaAtual = retaAtual.proximo;
                continue;
            }
            if (dist2 <= dmin) {
                i = Calculos.intersecaoRetaArco(retaRel, borracha, intersecao);
                if (i == 1) {
                    ret = true;
                    retaAtual.fim = new Posicao(this.folha.posSemZoom(intersecao[0]));
                }
                retaAnt = retaAtual;
                retaAtual = retaAtual.proximo;
                continue;
            }
            double dist3 = retaRel.distanciaPosSinal(pos);
            if (Math.abs(dist3) <= dmin && retaRel.dentroLimites(pos)) {
                ret = true;
                Vetor vet1 = new Vetor(retaRel.inicio, retaRel.fim);
                Vetor vet2 = vet1.vetorNormal(dist3).invert();
                Posicao local = pos.soma(vet2);
                Reta retaNova = retaAtual.quebra(this.folha.posSemZoom(local));
                retaNova.corLinha = retaAtual.corLinha;
                retaNova.tipoLinha = retaAtual.tipoLinha;
                retaNova.espessuraLinha = retaAtual.espessuraLinha;
                retaNova.proximo = retaAtual.proximo;
                retaAtual.proximo = retaNova;
                continue;
            }
            retaAnt = retaAtual;
            retaAtual = retaAtual.proximo;
        }
        return ret;
    }

    private boolean apagaArcoParcial(Posicao pos) {
        double raioBorr = this.largura / 2;
        boolean ret = false;
        Posicao[] intersecao = new Posicao[]{new Posicao(0.0, 0.0), new Posicao(0.0, 0.0)};
        Arco arcoBorr = new Arco(pos, raioBorr, 0.0, 360.0, this.folha);
        Arco arcoAnt = this.apontaArcos;
        Arco arcoAtual = arcoAnt.proximo;
        while (arcoAtual != null) {
            Vetor vetAng2;
            Vetor vetAng1;
            Vetor vetBorr;
            Vetor vetCorda;
            double ang2;
            double ang1;
            double ang;
            Vetor vet2;
            Vetor vet1;
            double dist2;
            double dist1;
            double dist;
            Arco arcoRel = arcoAtual.arcoRel();
            if (!arcoRel.dentroRegiao(pos)) {
                arcoAnt = arcoAtual;
                arcoAtual = arcoAtual.proximo;
                continue;
            }
            int n = Calculos.intersecaoArcos(arcoBorr, arcoRel, intersecao);
            if (n == 0) {
                dist = Calculos.distancia(pos, arcoRel.centro);
                if (dist < raioBorr - arcoRel.raio) {
                    ret = true;
                    arcoAnt.proximo = arcoAtual = arcoAtual.proximo;
                    this.sistema.compasso.defNovoArco();
                    continue;
                }
                dist1 = Calculos.distancia(pos, arcoRel.posicaoInicio());
                dist2 = Calculos.distancia(pos, arcoRel.posicaoFim());
                if (dist1 <= raioBorr && dist2 <= raioBorr) {
                    ret = true;
                    arcoAnt.proximo = arcoAtual = arcoAtual.proximo;
                    this.sistema.compasso.defNovoArco();
                    continue;
                }
                arcoAnt = arcoAtual;
                arcoAtual = arcoAtual.proximo;
                continue;
            }
            if (n == 1) {
                dist = Calculos.distancia(pos, arcoRel.centro);
                if (dist < raioBorr + arcoRel.raio - 1.0E-6) {
                    dist1 = Calculos.distancia(pos, arcoRel.posicaoInicio());
                    dist2 = Calculos.distancia(pos, arcoRel.posicaoFim());
                    if (dist1 <= raioBorr) {
                        vet1 = new Vetor(arcoRel.centro, arcoRel.posicaoInicio());
                        vet2 = new Vetor(arcoRel.centro, intersecao[0]);
                        ang = Calculos.anguloVetores360(vet1, vet2);
                        ang1 = arcoAtual.anguloInicial() + ang;
                        if (ang1 >= 360.0) {
                            ang1 -= 360.0;
                        }
                        ang2 = arcoAtual.anguloVarredura() - ang;
                        arcoAtual.defAnguloInicial(ang1);
                        arcoAtual.defAnguloVarredura(ang2);
                    } else if (dist2 <= raioBorr) {
                        vet1 = new Vetor(arcoRel.centro, arcoRel.posicaoFim());
                        vet2 = new Vetor(arcoRel.centro, intersecao[0]);
                        ang = Calculos.anguloVetores360(vet2, vet1);
                        ang2 = arcoAtual.anguloVarredura() - ang;
                        arcoAtual.defAnguloVarredura(ang2);
                    }
                    ret = true;
                }
                arcoAnt = arcoAtual;
                arcoAtual = arcoAtual.proximo;
                continue;
            }
            if (n != 2) continue;
            vet1 = new Vetor(arcoRel.centro, intersecao[0]);
            vet2 = new Vetor(arcoRel.centro, intersecao[1]);
            ang1 = Calculos.anguloVetores360(new Vetor(1.0, 0.0), vet1);
            if (ang1 > (ang2 = Calculos.anguloVetores360(new Vetor(1.0, 0.0), vet2))) {
                if (ang1 - ang2 > 180.0) {
                    ang2 += 360.0;
                    vetCorda = new Vetor(intersecao[0], intersecao[1]);
                    vetBorr = new Vetor(intersecao[0], arcoBorr.centro);
                    vetAng1 = new Vetor(arcoRel.centro, intersecao[0]);
                    vetAng2 = new Vetor(arcoRel.centro, intersecao[1]);
                } else {
                    ang = ang1;
                    ang1 = ang2;
                    ang2 = ang;
                    vetCorda = new Vetor(intersecao[1], intersecao[0]);
                    vetBorr = new Vetor(intersecao[1], arcoBorr.centro);
                    vetAng1 = new Vetor(arcoRel.centro, intersecao[1]);
                    vetAng2 = new Vetor(arcoRel.centro, intersecao[0]);
                }
            } else if (ang2 - ang1 > 180.0) {
                ang = ang2;
                ang2 = ang1;
                ang1 = ang;
                ang2 += 360.0;
                vetCorda = new Vetor(intersecao[1], intersecao[0]);
                vetBorr = new Vetor(intersecao[1], arcoBorr.centro);
                vetAng1 = new Vetor(arcoRel.centro, intersecao[1]);
                vetAng2 = new Vetor(arcoRel.centro, intersecao[0]);
            } else {
                vetCorda = new Vetor(intersecao[0], intersecao[1]);
                vetBorr = new Vetor(intersecao[0], arcoBorr.centro);
                vetAng1 = new Vetor(arcoRel.centro, intersecao[0]);
                vetAng2 = new Vetor(arcoRel.centro, intersecao[1]);
            }
            if (arcoRel.fechado()) {
                if (arcoRel.raio < arcoBorr.raio) {
                    if (Calculos.prodVetSaindo(vetCorda, vetBorr)) {
                        arcoAtual.defAnguloInicial(ang1);
                        arcoAtual.defAnguloVarredura(ang2 - ang1);
                    } else {
                        ang = ang2 >= 360.0 ? ang2 - 360.0 : ang2;
                        arcoAtual.defAnguloInicial(ang);
                        arcoAtual.defAnguloVarredura(360.0 - (ang2 - ang1));
                    }
                } else {
                    ang = ang2 >= 360.0 ? ang2 - 360.0 : ang2;
                    arcoAtual.defAnguloInicial(ang);
                    arcoAtual.defAnguloVarredura(360.0 - (ang2 - ang1));
                }
            } else {
                Arco arcoNovo;
                Vetor vetFim;
                Vetor vetIni;
                dist1 = Calculos.distancia(pos, arcoRel.posicaoInicio());
                dist2 = Calculos.distancia(pos, arcoRel.posicaoFim());
                if (dist1 <= raioBorr && dist2 <= raioBorr) {
                    if (arcoRel.raio < arcoBorr.raio) {
                        if (Calculos.prodVetSaindo(vetCorda, vetBorr)) {
                            arcoAtual.defAnguloInicial(ang1);
                            arcoAtual.defAnguloVarredura(ang2 - ang1);
                        } else {
                            ang = ang2 >= 360.0 ? ang2 - 360.0 : ang2;
                            arcoAtual.defAnguloInicial(ang);
                            arcoAtual.defAnguloVarredura(360.0 - (ang2 - ang1));
                        }
                    } else {
                        ang = ang2 >= 360.0 ? ang2 - 360.0 : ang2;
                        arcoAtual.defAnguloInicial(ang);
                        arcoAtual.defAnguloVarredura(360.0 - (ang2 - ang1));
                    }
                } else if (arcoRel.raio < arcoBorr.raio) {
                    if (Calculos.prodVetSaindo(vetCorda, vetBorr)) {
                        vetIni = new Vetor(arcoRel.centro, arcoRel.posicaoInicio());
                        ang = Calculos.anguloVetores360(vetIni, vetAng2);
                        arcoAtual.defAnguloVarredura(ang);
                        vetFim = new Vetor(arcoRel.centro, arcoRel.posicaoFim());
                        ang = Calculos.anguloVetores360(vetAng1, vetFim);
                        arcoNovo = new Arco(arcoAtual.centro, arcoAtual.raio, ang1, ang, this.folha);
                        arcoNovo.corLinha = arcoAtual.corLinha;
                        arcoNovo.tipoLinha = arcoAtual.tipoLinha;
                        arcoNovo.espessuraLinha = arcoAtual.espessuraLinha;
                        arcoNovo.proximo = arcoAtual;
                        arcoAnt.proximo = arcoNovo;
                        arcoAnt = arcoNovo;
                    } else {
                        ang = ang2 >= 360.0 ? ang2 - 360.0 : ang2;
                        vetIni = new Vetor(arcoRel.centro, arcoRel.posicaoInicio());
                        ang = Calculos.anguloVetores360(vetIni, vetAng1);
                        arcoAtual.defAnguloVarredura(ang);
                        vetFim = new Vetor(arcoRel.centro, arcoRel.posicaoFim());
                        ang = Calculos.anguloVetores360(vetAng2, vetFim);
                        arcoNovo = new Arco(arcoAtual.centro, arcoAtual.raio, ang2, ang, this.folha);
                        arcoNovo.corLinha = arcoAtual.corLinha;
                        arcoNovo.tipoLinha = arcoAtual.tipoLinha;
                        arcoNovo.espessuraLinha = arcoAtual.espessuraLinha;
                        arcoNovo.proximo = arcoAtual;
                        arcoAnt.proximo = arcoNovo;
                        arcoAnt = arcoNovo;
                    }
                } else {
                    ang = ang2 >= 360.0 ? ang2 - 360.0 : ang2;
                    vetIni = new Vetor(arcoRel.centro, arcoRel.posicaoInicio());
                    ang = Calculos.anguloVetores360(vetIni, vetAng1);
                    arcoAtual.defAnguloVarredura(ang);
                    vetFim = new Vetor(arcoRel.centro, arcoRel.posicaoFim());
                    ang = Calculos.anguloVetores360(vetAng2, vetFim);
                    arcoNovo = new Arco(arcoAtual.centro, arcoAtual.raio, ang2, ang, this.folha);
                    arcoNovo.corLinha = arcoAtual.corLinha;
                    arcoNovo.tipoLinha = arcoAtual.tipoLinha;
                    arcoNovo.espessuraLinha = arcoAtual.espessuraLinha;
                    arcoNovo.proximo = arcoAtual;
                    arcoAnt.proximo = arcoNovo;
                    arcoAnt = arcoNovo;
                }
            }
            ret = true;
            arcoAnt = arcoAtual;
            arcoAtual = arcoAtual.proximo;
        }
        return ret;
    }

    @Override
    public boolean destaca(Posicao posCursor) {
        int regAnt = this.regiao;
        this.regiao = this.posicaoDentro(posCursor) ? this.regiaoAtiva(posCursor) : -1;
        if (this.regiao != regAnt) {
            this.sistema.repaint();
        }
        return this.regiao != -1;
    }

    @Override
    public void desenha(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int[] X = new int[4];
        int[] Y = new int[4];
        double a = this.largura;
        Posicao pontaGrafI = new Posicao(this.pontaGraf.intX(), this.pontaGraf.intY());
        Posicao pontaBorrI = new Posicao(this.pontaBorr.intX(), this.pontaBorr.intY());
        Vetor vet1 = new Vetor(pontaGrafI, pontaBorrI);
        Vetor vet2 = vet1.vetorPar(0.8 * a);
        Vetor vet3 = vet1.vetorNormal(0.2 * a);
        Posicao pos = new Posicao(pontaGrafI);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pontaGrafI.soma(vet2).soma(vet3);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pontaGrafI.soma(vet2).soma(vet3.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        Polygon graf = this.folha.poligono(X, Y, 3);
        Vetor vet4 = vet1.vetorPar(2.0 * a);
        Vetor vet5 = vet1.vetorNormal(0.5 * a);
        pos = pontaGrafI.soma(vet2).soma(vet3);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pontaGrafI.soma(vet4).soma(vet5);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pontaGrafI.soma(vet4).soma(vet5.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pontaGrafI.soma(vet2).soma(vet3.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon pgraf = this.folha.poligono(X, Y, 4);
        Vetor vet6 = vet4.vetorPar(2.8 * a);
        pos = pontaGrafI.soma(vet4).soma(vet5);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pontaGrafI.soma(vet6).soma(vet5);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pontaGrafI.soma(vet6).soma(vet5.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pontaGrafI.soma(vet4).soma(vet5.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon troca_linha = this.folha.poligono(X, Y, 4);
        pos = pontaGrafI.soma(vet6).soma(vet5);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pontaBorrI.soma(vet5);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pontaBorrI.soma(vet5.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pontaGrafI.soma(vet6).soma(vet5.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon corpo = this.folha.poligono(X, Y, 4);
        vet3 = vet1.vetorPar(0.5 * a).invert();
        pos = pontaBorrI.soma(vet5);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pontaBorrI.soma(vet5).soma(vet3);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pontaBorrI.soma(vet5.invert()).soma(vet3);
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pontaBorrI.soma(vet5.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon borracha = this.folha.poligono(X, Y, 4);
        vet4 = vet1.vetorPar(0.8 * a).invert();
        pos = pontaBorrI.soma(vet5).soma(vet3).soma(vet4);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pontaBorrI.soma(vet5).soma(vet3);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pontaBorrI.soma(vet5.invert()).soma(vet3);
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pontaBorrI.soma(vet5.invert()).soma(vet3).soma(vet4);
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon anel = this.folha.poligono(X, Y, 4);
        Color cor = g.getColor();
        pos = this.folha.posPan(pontaBorrI);
        if (this.regiao == 1) {
            g.setColor(Cor.lapGrafDest);
        } else {
            g.setColor(Cor.lapGraf);
        }
        g.fillPolygon(graf);
        if (this.regiao == 1) {
            g.setColor(Cor.lapPontaGrafDest);
        } else {
            g.setColor(Cor.lapPontaGraf);
        }
        g.fillPolygon(pgraf);
        if (this.regiao == 2) {
            g.setColor(Cor.lapCorpoDest);
        } else {
            g.setColor(Cor.lapCorpo);
        }
        g.fillPolygon(corpo);
        g.setColor(Cor.lapContorno);
        g.drawPolygon(graf);
        g.drawPolygon(pgraf);
        if (Cor.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f));
        } else if (Cor.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (Cor.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (Cor.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        cor = g2d.getColor();
        g2d.drawPolygon(corpo);
        if (this.regiao == 3) {
            g.setColor(Cor.lapBorrDest);
        } else {
            g.setColor(Cor.lapBorr);
        }
        g.fillOval(pos.intX() - this.largura / 2, pos.intY() - this.largura / 2, this.largura, this.largura);
        g.setColor(Cor.lapBorr);
        g.drawOval(pos.intX() - this.largura / 2 + 1, pos.intY() - this.largura / 2 + 1, this.largura - 2, this.largura - 2);
        g.setColor(Cor.lapBorrSombra);
        g.drawOval(pos.intX() - this.largura / 2, pos.intY() - this.largura / 2, this.largura, this.largura);
        if (this.regiao == 3) {
            g.setColor(Cor.lapBorrDest);
        } else {
            g.setColor(Cor.lapBorr);
        }
        g.fillPolygon(borracha);
        g.setColor(Cor.lapBorrContorno);
        g.drawPolyline(borracha.xpoints, borracha.ypoints, borracha.npoints);
        if (this.regiao == 4) {
            g.setColor(Cor.lapAnelDest);
        } else {
            g.setColor(Cor.lapAnel);
        }
        g.fillPolygon(anel);
        g.setColor(Cor.lapContorno);
        g.drawPolygon(anel);
        if (this.regiao == 5) {
            g.setColor(Cor.lapTrocaLapisDest);
        } else {
            g.setColor(Cor.lapTrocaLapis);
        }
        g.fillPolygon(troca_linha);
        g.setColor(Cor.lapContorno);
        g.drawPolygon(troca_linha);
        g.setColor(cor);
    }

    private class TrataTexto
    implements KeyListener {
        Texto ultimo = null;
        private int cod = 0;
        private Boolean ctrl;

        @Override
        public void keyPressed(KeyEvent event) {
            this.cod = event.getKeyCode();
            this.ctrl = event.isControlDown();
            switch (this.cod) {
                case 113: {
                    Lapis.this.sistema.fundo = (Lapis.this.sistema.fundo + 1) % 4;
                    Lapis.this.sistema.repaint();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (Lapis.this.folha.posicaoDentro(Lapis.this.folha.posPan(Lapis.this.pontaGraf)) && !this.ctrl.booleanValue()) {
                Posicao pos;
                Posicao pg = Lapis.this.folha.posSemZoom(Lapis.this.pontaGraf);
                if (this.ultimo == null || !pg.igual(this.ultimo.posicao)) {
                    this.ultimo = new Texto(pg, Lapis.this.folha);
                    this.ultimo.proximo = Lapis.this.apontaTextos.proximo;
                    Lapis.this.apontaTextos.proximo = this.ultimo;
                }
                if (this.cod == 8) {
                    this.ultimo.apagaUltCar();
                    if (this.ultimo.tamanho() == 0) {
                        Lapis.this.apontaTextos.proximo = this.ultimo.proximo;
                        this.ultimo = null;
                    }
                } else if (this.cod != 10 && this.cod != 27 && Lapis.this.folha.posicaoDentro(pos = this.ultimo.posFim())) {
                    this.ultimo.insereTexto(event.getKeyChar());
                }
                Lapis.this.sistema.repaint();
            }
        }
    }
}

