/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Impressao;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Posicao;

public class FormaLivre
implements Constantes {
    public int serialUID;
    public Posicao vertices = new Posicao(0.0, 0.0);
    public Posicao ant;
    public Posicao atual;
    public Posicao vertSupEsq = new Posicao(0.0, 0.0);
    public Posicao vertInfDir = new Posicao(0.0, 0.0);
    public int numElementos;
    public FormaLivre proximo;
    public Folha folha;
    public int tolerancia = 6;
    public int tipoLinha;
    public float espessuraLinha;
    public Color corLinha;

    public FormaLivre(Folha folha) {
        this.folha = folha;
        this.serialUID = -1;
        this.tipoLinha = Cor.tipoLinha;
        this.espessuraLinha = Cor.espessuraLinha;
        this.ant = this.vertices;
        this.atual = null;
        this.proximo = null;
        this.numElementos = 0;
        this.corLinha = Cor.traNormal;
    }

    public void adicVertice(double x, double y) {
        Posicao pos = new Posicao(x, y);
        pos.proximo = this.vertices.proximo;
        this.vertices.proximo = pos;
        ++this.numElementos;
        if (this.numElementos == 1) {
            this.vertSupEsq.defPosicao(x, y);
            this.vertInfDir.defPosicao(x, y);
        } else {
            if (pos.x < this.vertSupEsq.x) {
                this.vertSupEsq.x = pos.x;
            }
            if (pos.y < this.vertSupEsq.y) {
                this.vertSupEsq.y = pos.y;
            }
            if (pos.x > this.vertInfDir.x) {
                this.vertInfDir.x = pos.x;
            }
            if (pos.y > this.vertInfDir.y) {
                this.vertInfDir.y = pos.y;
            }
        }
    }

    public void adicVerticeLocal(double x, double y) {
        Posicao pos = new Posicao(x, y);
        pos.proximo = this.atual.proximo;
        this.atual.proximo = pos;
        ++this.numElementos;
        if (this.numElementos == 1) {
            this.vertSupEsq.defPosicao(x, y);
            this.vertInfDir.defPosicao(x, y);
        } else {
            if (pos.x < this.vertSupEsq.x) {
                this.vertSupEsq.x = pos.x;
            }
            if (pos.y < this.vertSupEsq.y) {
                this.vertSupEsq.y = pos.y;
            }
            if (pos.x > this.vertInfDir.x) {
                this.vertInfDir.x = pos.x;
            }
            if (pos.y > this.vertInfDir.y) {
                this.vertInfDir.y = pos.y;
            }
        }
    }

    public void adicVertice(Posicao pos) {
        this.adicVertice(pos.x, pos.y);
    }

    public void adicVerticeLocal(Posicao pos) {
        this.adicVerticeLocal(pos.x, pos.y);
    }

    public FormaLivre quebra() {
        if (this.atual != null) {
            FormaLivre forma = new FormaLivre(this.folha);
            forma.novosVertices(this.atual.proximo);
            this.atual.proximo = null;
            this.atualiza();
            return forma;
        }
        return null;
    }

    private void novosVertices(Posicao inicioLista) {
        this.vertices.proximo = inicioLista;
        this.atualiza();
    }

    public boolean dentroRegiao(Posicao pos) {
        return pos.x >= this.vertSupEsq.x - (double)this.tolerancia && pos.y >= this.vertSupEsq.y - (double)this.tolerancia && pos.x <= this.vertInfDir.x + (double)this.tolerancia && pos.y <= this.vertInfDir.y + (double)this.tolerancia;
    }

    public void atualiza() {
        this.vertSupEsq.defPosicao(0, 0);
        this.vertInfDir.defPosicao(0, 0);
        int n = 0;
        this.reset();
        while (this.temMaisVertice()) {
            Posicao pos = this.proxVertice();
            if (++n == 1) {
                this.vertSupEsq.defPosicao(pos);
                this.vertInfDir.defPosicao(pos);
                continue;
            }
            if (pos.x < this.vertSupEsq.x) {
                this.vertSupEsq.x = pos.x;
            }
            if (pos.y < this.vertSupEsq.y) {
                this.vertSupEsq.y = pos.y;
            }
            if (pos.x > this.vertInfDir.x) {
                this.vertInfDir.x = pos.x;
            }
            if (!(pos.y > this.vertInfDir.y)) continue;
            this.vertInfDir.y = pos.y;
        }
        this.numElementos = n;
    }

    public boolean dentroRegiaoRel(Posicao pos) {
        Posicao pos1 = this.vertSupEsq.posRel(this.folha);
        Posicao pos2 = this.vertInfDir.posRel(this.folha);
        return pos.x >= pos1.x - (double)this.tolerancia && pos.y >= pos1.y - (double)this.tolerancia && pos.x <= pos2.x + (double)this.tolerancia && pos.y <= pos2.y + (double)this.tolerancia;
    }

    public void removeVerticeAtual() {
        if (this.atual != null) {
            this.ant.proximo = this.atual = this.atual.proximo;
            --this.numElementos;
        }
    }

    public boolean vazia() {
        return this.numElementos == 0;
    }

    public int numElementos() {
        return this.numElementos;
    }

    public void reset() {
        this.ant = null;
        this.atual = this.vertices;
    }

    public Posicao vertAtual() {
        return this.atual;
    }

    public Posicao proxVertice() {
        this.ant = this.atual;
        this.atual = this.atual.proximo;
        return this.atual;
    }

    public Posicao proxVerticeRef() {
        if (this.atual != null) {
            return this.atual.proximo;
        }
        return null;
    }

    public boolean temMaisVertice() {
        if (this.atual != null) {
            return this.atual.proximo != null;
        }
        return false;
    }

    public void desenha(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        this.reset();
        int[] x = new int[this.numElementos];
        int[] y = new int[this.numElementos];
        int i = 0;
        while (i < this.numElementos) {
            Posicao pos = this.folha.posRelativa(this.proxVertice());
            x[i] = pos.intX();
            y[i] = pos.intY();
            ++i;
        }
        if (this.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f));
        } else if (this.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (this.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (this.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        Color cor = g2d.getColor();
        g2d.setColor(this.corLinha);
        g2d.drawPolyline(x, y, this.numElementos);
        g2d.setColor(cor);
    }

    public void imprime(Graphics g, Impressao impressao) {
        Graphics2D g2d = (Graphics2D)g.create();
        this.reset();
        int[] x = new int[this.numElementos];
        int[] y = new int[this.numElementos];
        int i = 0;
        while (i < this.numElementos) {
            Posicao pos = impressao.posRelativa(this.proxVertice());
            x[i] = pos.intX();
            y[i] = pos.intY();
            ++i;
        }
        if (this.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f));
        } else if (this.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (this.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (this.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        Color cor = g2d.getColor();
        g2d.setColor(this.corLinha);
        g2d.drawPolyline(x, y, this.numElementos);
        g2d.setColor(cor);
    }

    public String salva() {
        String linha = "X " + this.numElementos;
        this.reset();
        Posicao pos = this.proxVertice();
        while (pos != null) {
            linha = String.valueOf(linha) + " " + pos.x + " " + pos.y;
            pos = this.proxVertice();
        }
        linha = String.valueOf(linha) + " CL " + this.corLinha.getRed() + " " + this.corLinha.getGreen() + " " + this.corLinha.getBlue();
        linha = String.valueOf(linha) + " TL " + this.tipoLinha;
        linha = String.valueOf(linha) + " EL " + this.espessuraLinha;
        linha = String.valueOf(linha) + " !\n";
        return linha;
    }
}

