/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Evento;
import control.EventoOperacao;
import control.EventoSelecao;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Instrumento;
import model.Ponto;
import model.Posicao;
import model.Reta;
import model.Vetor;
import view.Tela;

public class Esquadro
extends Instrumento
implements Constantes {
    public double[] vertX = new double[3];
    public double[] vertY = new double[3];
    double tipoGraus;
    double altura;
    double comprimento;
    double distCentVert;
    double distInterna;
    double altInterna;
    double compInterno;
    double distLapis;
    double distCompasso;
    Folha folha;
    Posicao cliqueAnt;
    Posicao cliqueAtual;
    Ponto apontaPontos;
    Reta apontaRetas;
    Font fonte;
    public int subUnidDest;
    public int bordaEsc;
    public int bordaCompasso;
    private int numVincs;
    private Ponto pontosVincs;
    private Ponto pontoDest;
    private Ponto pontoAj3Dest;
    private boolean possuiFoco;
    public static int numColisoes = 0;
    public static int bordaContato;
    public static int bordaContato2;
    public static int vertContato;
    public static double angBordas;
    public static double distBorda;
    public static Esquadro esqBorda;
    public static Esquadro esqVert;
    Esquadro outroEsq;

    public Esquadro(Posicao posicao, double altura, int tipoGraus, Tela sistema) {
        double angRad = (double)tipoGraus * (Math.PI / 180);
        this.tipoGraus = tipoGraus;
        this.altura = altura;
        this.comprimento = this.comprimento(altura, tipoGraus);
        this.altInterna = 0.4 * altura;
        this.distInterna = Calculos.divisao(altura - this.altInterna, 1.0 + Calculos.divisao(1.0, Math.sin(angRad)) + Calculos.divisao(1.0, Math.tan(angRad)));
        this.compInterno = this.comprimento(this.altInterna, tipoGraus);
        this.numVincs = 0;
        this.subUnidDest = -1;
        this.pontosVincs = new Ponto(this.folha);
        this.pontoDest = null;
        this.pontoAj3Dest = null;
        this.fonte = new Font("Serif", 0, 8);
        this.bordaEsc = 3;
        this.vertX[0] = posicao.x;
        this.vertY[0] = posicao.y + altura;
        this.vertX[1] = posicao.x;
        this.vertY[1] = posicao.y;
        this.vertX[2] = this.vertX[0] + this.comprimento;
        this.vertY[2] = this.vertY[0];
        this.distCentVert = Calculos.distancia(this.centro(), new Posicao(this.vertX[2], this.vertY[2]));
        this.possuiFoco = false;
        this.cliqueAnt = new Posicao(0.0, 0.0);
        this.apontaPontos = sistema.listaPontos;
        this.apontaRetas = sistema.listaRetas;
        this.proximo = null;
        this.sistema = sistema;
        this.folha = sistema.folha;
    }

    @Override
    public void seleciona(EventoSelecao evento) {
        this.cliqueAnt.defPosicao(evento.coordenadas());
        this.liberaEscala();
    }

    @Override
    public void opera(EventoOperacao evento) {
        int borda;
        Ponto pontoAj3 = null;
        this.cliqueAtual = new Posicao(evento.coordenadas());
        Vetor vetMov = new Vetor(this.cliqueAnt, this.cliqueAtual);
        this.move(this.cliqueAtual, vetMov);
        switch (numColisoes) {
            case 0: {
                if (!this.esqPerto()) break;
                if (this.vertColide()) {
                    ++numColisoes;
                    esqVert = this;
                    esqBorda = this.outroEsq;
                    this.ajusteVertBorda(vertContato, bordaContato);
                    break;
                }
                if (!this.bordaColide()) break;
                ++numColisoes;
                esqBorda = this;
                esqVert = this.outroEsq;
                this.ajusteBordaVert(bordaContato, vertContato);
                break;
            }
            case 1: {
                if (this.colisaoValida()) {
                    if (!this.contatoBordas()) break;
                    ++numColisoes;
                    this.ajusteBordas();
                    break;
                }
                --numColisoes;
                break;
            }
            case 2: {
                if (!this.colisoesValidas()) {
                    numColisoes = 0;
                    this.outroEsq.subUnidDest = -1;
                    break;
                }
                this.outroEsq.subUnidDest = this.subUnidDest();
                if (this.outroEsq.subUnidDest != -1) break;
                borda = esqBorda == this ? bordaContato : bordaContato2;
                pontoAj3 = this.ajustePonto3(borda);
            }
        }
        if (numColisoes > 0) {
            this.desfazVincs();
            if (this.pontoDest != null) {
                this.pontoDest.estado = 0;
                this.pontoDest.esqVinc = null;
                this.pontoDest = null;
            }
        } else {
            Ponto ponto = null;
            switch (this.numVincs) {
                case 0: {
                    ponto = this.pontoAVincular();
                    break;
                }
                case 1: {
                    Ponto pontoVinc = this.pontosVincs.proxVinc;
                    if (this.vinculoValido(pontoVinc, this.cliqueAnt, this.cliqueAtual)) {
                        ponto = this.pontoAVincular(pontoVinc.bordaEsq);
                        if (ponto != null) break;
                        this.destEsc(pontoVinc.bordaEsq, pontoVinc.pontoRel());
                        break;
                    }
                    pontoVinc.estado = 0;
                    pontoVinc.esqVinc = null;
                    this.pontosVincs.proxVinc = null;
                    --this.numVincs;
                    this.liberaEscala();
                    break;
                }
                case 2: {
                    Ponto pontoVinc = this.pontosVincs.proxVinc;
                    if (!this.vinculoValido(pontoVinc)) {
                        pontoVinc.estado = 0;
                        pontoVinc.esqVinc = null;
                        this.pontosVincs.proxVinc = pontoVinc.proxVinc;
                        pontoVinc.proxVinc = null;
                        --this.numVincs;
                        break;
                    }
                    if (!this.vinculoValido(pontoVinc.proxVinc)) {
                        pontoVinc.proxVinc.estado = 0;
                        pontoVinc.proxVinc.esqVinc = null;
                        pontoVinc.proxVinc = null;
                        --this.numVincs;
                        break;
                    }
                    if (!this.vinculoValido(pontoVinc, pontoVinc.proxVinc, vetMov)) {
                        this.desfazVincs();
                        break;
                    }
                    borda = this.pontosVincs.proxVinc.bordaEsq;
                    pontoAj3 = this.ajustePonto3(borda);
                }
            }
            if (this.pontoDest == null) {
                if (ponto != null) {
                    this.pontoDest = ponto;
                    ponto.estado = 1;
                }
            } else if (ponto != null) {
                if (ponto != this.pontoDest) {
                    this.pontoDest.estado = 0;
                }
                this.pontoDest = ponto;
                ponto.estado = 1;
            } else {
                this.pontoDest.estado = 0;
                this.pontoDest = null;
            }
        }
        if (this.pontoAj3Dest == null) {
            if (pontoAj3 != null) {
                this.pontoAj3Dest = pontoAj3;
                pontoAj3.estado = 1;
            }
        } else if (pontoAj3 != null) {
            if (pontoAj3 != this.pontoAj3Dest) {
                this.pontoAj3Dest.estado = 0;
            }
            this.pontoAj3Dest = pontoAj3;
            pontoAj3.estado = 1;
        } else {
            this.pontoAj3Dest.estado = 0;
            this.pontoAj3Dest = null;
        }
        this.cliqueAnt.defPosicao(this.cliqueAtual.x, this.cliqueAtual.y);
        this.sistema.repaint();
    }

    @Override
    public void libera(Evento evento) {
        if (numColisoes == 0) {
            switch (this.numVincs) {
                case 0: {
                    if (this.pontoDest != null) {
                        ++this.numVincs;
                        Ponto pontoRel = this.pontoDest.pontoRel();
                        this.pontoDest.estado = 2;
                        this.pontoDest.esqVinc = this;
                        this.pontoDest.proxVinc = this.pontosVincs.proxVinc;
                        this.pontosVincs.proxVinc = this.pontoDest;
                        this.ajusteComPonto(pontoRel);
                        this.ajusteEscPos(this.pontoDest.bordaEsq, pontoRel);
                        this.destEsc(this.pontoDest.bordaEsq, pontoRel);
                        this.ajusteHor(this.pontoDest.bordaEsq, pontoRel);
                        this.pontoDest = null;
                    } else if (!this.ajusteBordaReta() && !this.ajusteComFolha()) {
                        this.ajusteHor(this.centro());
                    }
                    this.sistema.repaint();
                    break;
                }
                case 1: {
                    if (this.pontoDest != null) {
                        ++this.numVincs;
                        Ponto pontoRel1 = this.pontosVincs.proxVinc.pontoRel();
                        Ponto pontoRel2 = this.pontoDest.pontoRel();
                        this.pontoDest.estado = 2;
                        this.pontoDest.esqVinc = this;
                        this.pontoDest.proxVinc = this.pontosVincs.proxVinc;
                        this.pontosVincs.proxVinc = this.pontoDest;
                        this.ajusteComPontos(pontoRel1, pontoRel2);
                        this.pontoDest = null;
                    } else {
                        Ponto ponto = this.pontosVincs.proxVinc;
                        Ponto pontoRel = ponto.pontoRel();
                        this.ajusteEscPos(ponto.bordaEsq, pontoRel);
                        Reta reta = this.retaAVincular(ponto);
                        if (reta == null) {
                            this.ajusteHor(ponto.bordaEsq, pontoRel);
                        } else {
                            this.ajusteComReta(reta, pontoRel);
                        }
                    }
                    this.sistema.repaint();
                }
            }
        }
        if (this.pontoAj3Dest != null) {
            this.movEsqDir(this.pontoAj3Dest.vetAjEsq);
            this.pontoAj3Dest.estado = 0;
            this.pontoAj3Dest = null;
            this.sistema.repaint();
        } else if (numColisoes == 2) {
            this.ajusteEscala();
            this.sistema.repaint();
        }
    }

    public void defOutroEsq(Esquadro esquadro) {
        this.outroEsq = esquadro;
    }

    public void limpaEscala() {
        this.subUnidDest = -1;
    }

    public boolean esqPerto() {
        double dist = Calculos.distancia(this.outroEsq.centro(), this.centro());
        return dist <= this.distCentVert + this.outroEsq.distCentVert;
    }

    public boolean posPerto(Posicao pos) {
        double dist = Calculos.distancia(this.centro(), pos);
        return dist <= this.distCentVert + 20.0;
    }

    public boolean ladoDeDentro(int borda, double x, double y) {
        double a = x - this.vertX[borda - 1];
        double n = this.vertY[borda % 3] - this.vertY[borda - 1];
        double b = y - this.vertY[borda - 1];
        double m = this.vertX[borda % 3] - this.vertX[borda - 1];
        return a * n - b * m < -1.0E-6;
    }

    public boolean ladoDeDentro(int borda, Posicao posicao) {
        return this.ladoDeDentro(borda, posicao.x, posicao.y);
    }

    public boolean vertColide() {
        boolean resp = false;
        double dmin = 2.0;
        int v = 0;
        while (v <= 2) {
            int b = 1;
            while (b <= 3) {
                double dist;
                Posicao pVert;
                Reta retaBorda;
                if (this.colisaoPermitida(v, b) && (retaBorda = this.outroEsq.retaBorda(b)).dentroLimites(pVert = this.posVert(v)) && (dist = retaBorda.distanciaPosSinal(pVert)) >= -40.0 * Math.abs(dmin) && dist <= Math.abs(dmin)) {
                    dmin = dist;
                    distBorda = dist;
                    bordaContato = b;
                    vertContato = v;
                    resp = true;
                }
                ++b;
            }
            ++v;
        }
        return resp;
    }

    private boolean bordaColide() {
        return this.outroEsq.vertColide();
    }

    private boolean colisaoPermitida(int vert, int borda) {
        Posicao pVert1 = this.posVert(vert + 1);
        Posicao pVert2 = this.posVert(vert + 2);
        if (this.outroEsq.ladoDeDentro(borda, pVert1)) {
            return false;
        }
        return !this.outroEsq.ladoDeDentro(borda, pVert2);
    }

    private boolean colisaoValida() {
        double angTol = 20.0;
        Vetor vetMov = new Vetor(this.cliqueAnt, this.cliqueAtual);
        Esquadro esqBorda = Esquadro.esqBorda;
        Esquadro esqVert = Esquadro.esqVert;
        int borda = bordaContato;
        int vert = vertContato;
        Posicao pos = esqVert.posVert(vert);
        Reta retaBorda = esqBorda.retaBorda(borda);
        Vetor vetRadial = new Vetor(pos, this.cliqueAnt);
        if (!retaBorda.dentroLimites(pos)) {
            return false;
        }
        double ang = Calculos.anguloVetores(vetRadial, vetMov);
        if ((ang *= 57.29577951308232) * ang <= angTol * angTol) {
            return false;
        }
        Posicao pVert1 = esqVert.posVert(vert + 1);
        Posicao pVert2 = esqVert.posVert(vert + 2);
        if (!esqBorda.ladoDeDentro(borda, pVert1)) {
            return true;
        }
        return !esqBorda.ladoDeDentro(borda, pVert2);
    }

    private boolean colisoesValidas() {
        double angTol = 20.0;
        int borda1 = bordaContato;
        int borda2 = bordaContato2;
        Esquadro esq1 = esqBorda;
        Esquadro esq2 = esqVert;
        Vetor vetMov = new Vetor(this.cliqueAnt, this.cliqueAtual);
        Vetor vetBorda = esq1.vetBorda(borda1);
        Vetor vetNormal = esqBorda == this ? vetBorda.vetorNormal(-10.0) : vetBorda.vetorNormal(10.0);
        double ang = Calculos.anguloVetores(vetNormal, vetMov);
        if ((ang *= 57.29577951308232) * ang <= angTol * angTol) {
            return false;
        }
        Reta retaBorda1 = esq1.retaBorda(borda1);
        Reta retaBorda2 = esq2.retaBorda(borda2);
        if (retaBorda1.dentroLimites(retaBorda2.inicio)) {
            return true;
        }
        if (retaBorda1.dentroLimites(retaBorda2.fim)) {
            return true;
        }
        if (retaBorda2.dentroLimites(retaBorda1.inicio)) {
            return true;
        }
        return retaBorda2.dentroLimites(retaBorda1.fim);
    }

    private boolean contatoBordas() {
        int bordaCont;
        double ang;
        double angS;
        int borda2;
        int borda1;
        boolean resp = false;
        int borda = bordaContato;
        int vert = vertContato;
        Esquadro esqBorda = Esquadro.esqBorda;
        Esquadro esqVert = Esquadro.esqVert;
        Vetor vetBorda = esqBorda.vetBorda(borda);
        if (vert == 0) {
            borda1 = 1;
            borda2 = 3;
        } else {
            borda1 = vert + 1;
            borda2 = vert;
        }
        Vetor vet1 = esqVert.vetBorda(borda1);
        Vetor vet2 = esqVert.vetBorda(borda2).invert();
        double ang1 = Calculos.anguloVetores(vetBorda, vet1);
        double ang2 = Calculos.anguloVetores(vetBorda, vet2);
        double angS1 = Calculos.ang90radSinal(ang1);
        double angS2 = Calculos.ang90radSinal(ang2);
        ang1 = Calculos.ang90rad(ang1);
        ang2 = Calculos.ang90rad(ang2);
        if (angS1 <= angS2) {
            angS = angS1;
            ang = ang1;
            bordaCont = borda1;
        } else {
            angS = angS2;
            ang = ang2;
            bordaCont = borda2;
        }
        double angGraus = angS * 57.29577951308232;
        if (angGraus >= -80.0 && angGraus <= 2.0) {
            resp = true;
            angBordas = ang;
            bordaContato2 = bordaCont;
        }
        return resp;
    }

    private Ponto pontoAVincular() {
        Ponto pontoVinc = null;
        double dmin = 4.0;
        Ponto pontoAtual = this.apontaPontos;
        while (pontoAtual.proximo != null) {
            pontoAtual = pontoAtual.proximo;
            if (pontoAtual.estado == 2) continue;
            Ponto pontoRel = pontoAtual.pontoRel();
            int n = 1;
            while (n <= 3) {
                double dist;
                Reta retaBorda = this.retaBorda(n);
                if (retaBorda.dentroLimites(pontoRel) && (dist = retaBorda.distanciaPosSinal(pontoRel)) * dist < dmin * dmin) {
                    dmin = dist;
                    pontoAtual.distEsq = dist;
                    pontoAtual.bordaEsq = n;
                    pontoVinc = pontoAtual;
                }
                ++n;
            }
        }
        return pontoVinc;
    }

    private Ponto pontoAVincular(int borda) {
        int n = borda;
        Ponto pontoVinc = null;
        double dmin = 4.0;
        Ponto pontoAtual = this.apontaPontos;
        while (pontoAtual.proximo != null) {
            double dist2;
            double dist;
            pontoAtual = pontoAtual.proximo;
            if (pontoAtual.estado == 2) continue;
            Ponto pontoRel = pontoAtual.pontoRel();
            Reta retaBorda = this.retaBorda(n);
            if (!retaBorda.dentroLimites(pontoRel) || !((dist = retaBorda.distanciaPos(pontoRel)) < dmin)) continue;
            if (this.numVincs == 0) {
                dmin = dist;
                pontoAtual.distEsq = dist;
                pontoAtual.bordaEsq = n;
                pontoVinc = pontoAtual;
                continue;
            }
            if (this.numVincs != 1 || !((dist2 = Calculos.distancia(this.pontosVincs.proxVinc.pontoRel(), pontoRel)) > 10.0)) continue;
            dmin = dist;
            pontoAtual.distEsq = dist;
            pontoAtual.bordaEsq = n;
            pontoVinc = pontoAtual;
        }
        return pontoVinc;
    }

    private Reta retaAVincular(Ponto ponto) {
        Reta retaVinc = null;
        double angMin = 5.0;
        Vetor vetBorda = this.vetBorda(ponto.bordaEsq);
        Ponto pontoAtual = this.apontaPontos;
        while (pontoAtual.proximo != null) {
            pontoAtual = pontoAtual.proximo;
            Reta retaAtual = this.apontaRetas;
            while (retaAtual.proximo != null) {
                double dist;
                retaAtual = retaAtual.proximo;
                if (!retaAtual.dentroRegiao(pontoAtual) || !((dist = retaAtual.distanciaPos(pontoAtual)) <= 1.0E-6) || !retaAtual.dentroLimites(pontoAtual)) continue;
                Vetor vetReta = retaAtual.vetorDiretor();
                double angRad = Calculos.anguloVetores(vetReta, vetBorda);
                double angGraus = (angRad = Calculos.ang90rad(angRad)) * 57.29577951308232;
                if (!(angGraus * angGraus < angMin * angMin)) continue;
                angMin = angGraus;
                retaAtual.angBordaEsq = angRad;
                retaVinc = retaAtual;
            }
        }
        return retaVinc;
    }

    private boolean vinculoValido(Ponto ponto, Posicao clkAnt, Posicao clkAtual) {
        if (numColisoes > 0) {
            return false;
        }
        Ponto pontoRel = ponto.pontoRel();
        Reta reta = this.retaBorda(ponto.bordaEsq);
        if (!reta.dentroLimites(pontoRel)) {
            return false;
        }
        Vetor vetBorda = this.vetBorda(ponto.bordaEsq);
        Vetor vetPerp = vetBorda.vetorNormal(1.0);
        Vetor vetRadial = new Vetor(pontoRel, clkAnt);
        Vetor vetMov = new Vetor(clkAnt, clkAtual);
        if (vetMov.norma() <= 2.0) {
            return true;
        }
        double angRad1 = Calculos.anguloVetores(vetPerp, vetMov);
        angRad1 = Calculos.ang90rad(angRad1);
        double angGraus1 = angRad1 * 57.29577951308232;
        double angRad2 = Calculos.anguloVetores(vetRadial, vetMov);
        angRad2 = Calculos.ang90rad(angRad2);
        double angGraus2 = angRad2 * 57.29577951308232;
        return !(Math.abs(angGraus1) <= 20.0) || !(Math.abs(angGraus2) <= 20.0);
    }

    private boolean vinculoValido(Ponto ponto) {
        if (numColisoes > 0) {
            return false;
        }
        Ponto pontoRel = ponto.pontoRel();
        Reta reta = this.retaBorda(ponto.bordaEsq);
        return reta.dentroLimites(pontoRel);
    }

    private boolean vinculoValido(Ponto ponto1, Ponto ponto2, Vetor vetMov) {
        if (vetMov.norma() <= 2.0) {
            return true;
        }
        Vetor vetBorda = this.vetBorda(ponto2.bordaEsq);
        Vetor vetPerp = vetBorda.vetorNormal(1.0);
        double ang = Calculos.anguloVetores(vetPerp, vetMov);
        if ((ang *= 57.29577951308232) > 90.0) {
            ang -= 180.0;
        } else if (ang < -90.0) {
            ang += 180.0;
        }
        return !(Math.abs(ang) <= 40.0);
    }

    public void desfazVincs() {
        Ponto ponto = this.pontosVincs.proxVinc;
        if (this.numVincs == 1) {
            ponto.estado = 0;
            this.pontosVincs.proxVinc = null;
        } else if (this.numVincs == 2) {
            ponto.estado = 0;
            ponto = ponto.proxVinc;
            ponto.estado = 0;
            this.pontosVincs.proxVinc = null;
        }
        this.numVincs = 0;
    }

    public void desfazVincs(Ponto pontoVinc) {
        Ponto ponto = this.pontosVincs.proxVinc;
        if (this.numVincs == 1) {
            if (ponto == pontoVinc) {
                ponto.estado = 0;
                ponto.esqVinc = null;
                this.pontosVincs.proxVinc = null;
                this.numVincs = 0;
            }
        } else if (this.numVincs == 2) {
            if (ponto == pontoVinc) {
                ponto.estado = 0;
                ponto.esqVinc = null;
                this.pontosVincs.proxVinc = ponto.proxVinc;
                ponto.proxVinc = null;
                --this.numVincs;
            } else if (ponto.proxVinc == pontoVinc) {
                ponto.proxVinc.estado = 0;
                ponto.proxVinc.esqVinc = null;
                ponto.proxVinc = null;
                --this.numVincs;
            }
        }
    }

    private void ajusteHor(Posicao centroRot) {
        Vetor vetHor = new Vetor(1.0, 0.0);
        int n = 0;
        while (n <= 2) {
            Vetor vetBorda = this.vetBorda(n + 1);
            double angRad = Calculos.anguloVetores(vetHor, vetBorda);
            double angGraus = (angRad = Calculos.ang90rad(angRad)) * 57.29577951308232;
            if (Math.abs(angGraus) <= 2.0) {
                this.rodaEsquadro(angRad, centroRot);
                break;
            }
            ++n;
        }
    }

    private void ajusteHor(int borda, Posicao centroRot) {
        Vetor vetHor = new Vetor(1.0, 0.0);
        Vetor vetBorda = this.vetBorda(borda);
        double angRad = Calculos.anguloVetores(vetHor, vetBorda);
        double angGraus = (angRad = Calculos.ang90rad(angRad)) * 57.29577951308232;
        if (Math.abs(angGraus) <= 2.0) {
            this.rodaEsquadro(angRad, centroRot);
        }
    }

    private void ajusteComReta(Reta reta, Posicao centroRot) {
        this.rodaEsquadro(reta.angBordaEsq, centroRot);
    }

    private void move(Posicao cliqueAtual, Vetor movCursor) {
        if (numColisoes == 1) {
            if (esqBorda == this) {
                Posicao centroRot = new Posicao(this.outroEsq.posVert(vertContato));
                Vetor vetIni = new Vetor(centroRot, this.cliqueAnt);
                Vetor vetFim = new Vetor(centroRot, cliqueAtual);
                double ang = Calculos.anguloVetores(vetIni, vetFim);
                Vetor vetDesloc = vetFim.vetorPar(vetFim.norma() - vetIni.norma());
                this.rodaEsquadro(-ang, centroRot);
                int borda = bordaContato;
                Vetor vetDir = this.vetBorda(borda);
                vetDesloc = vetDesloc.proj(vetDir).vetorPar(vetDesloc.norma());
                this.movEsqDir(vetDesloc);
                Posicao pos = this.cliqueAnt.soma(vetDesloc);
                Vetor vetIni2 = new Vetor(centroRot, pos);
                vetIni2.gira(-ang);
                ang = Calculos.anguloVetores(vetIni, vetIni2);
                this.rodaEsquadro(ang, centroRot);
            } else {
                Posicao centroRot = new Posicao(this.posVert(vertContato));
                Vetor vetIni = new Vetor(centroRot, this.cliqueAnt);
                Vetor vetFim = new Vetor(centroRot, cliqueAtual);
                double ang = Calculos.anguloVetores(vetIni, vetFim);
                Vetor vetDesloc = vetFim.vetorPar(vetFim.norma() - vetIni.norma());
                this.rodaEsquadro(-ang, centroRot);
                int borda = bordaContato;
                Vetor vetDir = this.outroEsq.vetBorda(borda);
                vetDesloc = vetDesloc.proj(vetDir);
                this.movEsqDir(vetDesloc);
                Posicao pos = this.cliqueAnt.soma(vetDesloc);
                Vetor vetIni2 = new Vetor(centroRot, pos);
                vetIni2.gira(-ang);
                centroRot = new Posicao(this.posVert(vertContato));
                ang = Calculos.anguloVetores(vetIni, vetIni2);
                this.rodaEsquadro(ang, centroRot);
            }
        } else if (numColisoes == 2) {
            Vetor vetDir = esqBorda.vetBorda(bordaContato);
            this.movEsqDir(movCursor.proj(vetDir));
        } else if (this.numVincs == 1) {
            Posicao centroRot = new Posicao(this.pontosVincs.proxVinc.pontoRel());
            Vetor vetIni = new Vetor(centroRot, this.cliqueAnt);
            Vetor vetFim = new Vetor(centroRot, cliqueAtual);
            double ang = Calculos.anguloVetores(vetIni, vetFim);
            Vetor vetDesloc = vetFim.vetorPar(vetFim.norma() - vetIni.norma());
            this.rodaEsquadro(-ang, centroRot);
            int borda = this.pontosVincs.proxVinc.bordaEsq;
            Vetor vetDir = this.vetBorda(borda);
            vetDesloc = vetDesloc.proj(vetDir).vetorPar(vetDesloc.norma());
            this.movEsqDir(vetDesloc);
            Posicao pos = this.cliqueAnt.soma(vetDesloc);
            Vetor vetIni2 = new Vetor(centroRot, pos);
            vetIni2.gira(-ang);
            ang = Calculos.anguloVetores(vetIni, vetIni2);
            this.rodaEsquadro(ang, centroRot);
        } else if (this.numVincs == 2) {
            Ponto ponto1 = this.pontosVincs.proxVinc.pontoRel();
            Ponto ponto2 = this.pontosVincs.proxVinc.proxVinc.pontoRel();
            Vetor vetDir = new Vetor(ponto1, ponto2);
            this.movEsqDir(movCursor.proj(vetDir));
        } else {
            Posicao centroEsq = this.centro();
            Vetor vetIni = new Vetor(centroEsq, this.cliqueAnt);
            Vetor vetFim = new Vetor(centroEsq, cliqueAtual);
            double ang = Calculos.anguloVetores(vetIni, vetFim);
            this.rodaEsquadro(-ang);
            Vetor vetDesloc = vetFim.vetorPar(vetFim.norma() - vetIni.norma());
            this.movEsqDir(vetDesloc);
        }
    }

    private Posicao centro() {
        double x = this.vertX[0] + 0.3333333333333333 * (this.vertX[2] - this.vertX[0]) + 0.3333333333333333 * (this.vertX[1] - this.vertX[0]);
        double y = this.vertY[0] + 0.3333333333333333 * (this.vertY[2] - this.vertY[0]) + 0.3333333333333333 * (this.vertY[1] - this.vertY[0]);
        return new Posicao(x, y);
    }

    public void movEsqDir(Vetor vetMov) {
        int n = 0;
        while (n <= 2) {
            Posicao vertice = new Posicao(this.vertX[n], this.vertY[n]);
            vertice = vertice.soma(vetMov);
            this.vertX[n] = vertice.x;
            this.vertY[n] = vertice.y;
            ++n;
        }
    }

    private void rodaEsquadro(double angulo) {
        this.rodaEsquadro(angulo, this.centro());
    }

    private void rodaEsquadro(double angulo, Posicao centro) {
        double seno = Math.sin(angulo);
        double cosseno = Math.cos(angulo);
        int n = 0;
        while (n <= 2) {
            double x = this.vertX[n] - centro.x;
            double y = this.vertY[n] - centro.y;
            double xtemp = x * cosseno - y * seno;
            double ytemp = x * seno + y * cosseno;
            x = xtemp;
            y = ytemp;
            this.vertX[n] = x + centro.x;
            this.vertY[n] = y + centro.y;
            ++n;
        }
    }

    public void ajusteVertBorda(int vert, int borda) {
        Vetor vetBorda = this.outroEsq.vetBorda(borda);
        this.movEsqDir(vetBorda.vetorNormal(-distBorda));
    }

    public void ajusteBordaVert(int borda, int vert) {
        Vetor vetBorda = this.vetBorda(borda);
        this.movEsqDir(vetBorda.vetorNormal(distBorda));
    }

    public void ajusteBordas() {
        double ang = angBordas;
        Posicao pos = esqVert.posVert(vertContato);
        if (esqBorda == this) {
            ang = -ang;
        }
        this.rodaEsquadro(ang, pos);
    }

    private Ponto ajustePonto3(int borda) {
        double dmin;
        double distA = dmin = 4.0;
        double distB = dmin;
        Ponto pontoAj = null;
        Vetor vetAj = null;
        Vetor vet1 = new Vetor(1.0, 0.0);
        Ponto ponto = this.apontaPontos;
        while (ponto.proximo != null) {
            Ponto pontoRel;
            ponto = ponto.proximo;
            if (ponto.estado == 2 || !this.posPerto(pontoRel = ponto.pontoRel())) continue;
            switch (borda) {
                case 1: {
                    vet1 = this.vetBorda(1);
                    Reta retaBordaA = this.retaBorda(2);
                    Reta retaBordaB = this.retaBorda(3);
                    if (!retaBordaA.dentroLimites(pontoRel) && !retaBordaB.dentroLimites(pontoRel)) break;
                    distA = retaBordaA.distanciaPosSinal(pontoRel);
                    distB = -retaBordaB.distanciaPosSinal(pontoRel);
                    Vetor vet2 = this.vetBorda(2);
                    vet2 = vet2.vetorNormal(Math.abs(distA));
                    double ang = Calculos.anguloVetores(vet1, vet2);
                    distA = Calculos.divisao(distA, Math.cos(ang));
                    break;
                }
                case 2: {
                    vet1 = this.vetBorda(2);
                    Reta retaBordaA = this.retaBorda(1);
                    Reta retaBordaB = this.retaBorda(3);
                    if (!retaBordaA.dentroLimites(pontoRel) && !retaBordaB.dentroLimites(pontoRel)) break;
                    distA = retaBordaA.distanciaPosSinal(pontoRel);
                    distB = retaBordaB.distanciaPosSinal(pontoRel);
                    Vetor vet2 = this.vetBorda(1);
                    vet2 = vet2.vetorNormal(Math.abs(distA));
                    double ang = Calculos.anguloVetores(vet1, vet2);
                    distA = Calculos.divisao(distA, Math.cos(ang));
                    vet2 = this.vetBorda(3);
                    vet2 = vet2.vetorNormal(Math.abs(distB));
                    ang = Calculos.anguloVetores(vet1, vet2);
                    distB = Calculos.divisao(distB, Math.cos(ang));
                    break;
                }
                case 3: {
                    vet1 = this.vetBorda(3);
                    Reta retaBordaA = this.retaBorda(1);
                    Reta retaBordaB = this.retaBorda(2);
                    if (!retaBordaA.dentroLimites(pontoRel) && !retaBordaB.dentroLimites(pontoRel)) break;
                    distA = retaBordaA.distanciaPosSinal(pontoRel);
                    distB = retaBordaB.distanciaPosSinal(pontoRel);
                    Vetor vet2 = this.vetBorda(2);
                    vet2 = vet2.vetorNormal(Math.abs(distB));
                    double ang = Calculos.anguloVetores(vet1, vet2);
                    distB = Calculos.divisao(distB, Math.cos(ang));
                }
            }
            if (distA * distA <= distB * distB) {
                if (!(distA * distA < dmin * dmin)) continue;
                dmin = distA;
                pontoAj = ponto;
                vetAj = vet1.vetorPar(dmin);
                continue;
            }
            if (!(distB * distB < dmin * dmin)) continue;
            dmin = distB;
            pontoAj = ponto;
            vetAj = vet1.vetorPar(dmin);
        }
        if (vetAj != null) {
            pontoAj.vetAjEsq = vetAj;
        }
        return pontoAj;
    }

    private boolean ajusteComFolha() {
        double dist2;
        double dist1;
        Reta retaBorda;
        Vetor vetReta;
        double dmin = 20.0;
        double angMin = 20.0;
        int borda = 0;
        Reta retaAj = null;
        Reta reta = this.folha.margensVisiveis();
        while (reta.proximo != null) {
            reta = reta.proximo;
            Reta retaRel = new Reta(this.folha.posSemPan(reta.inicio), this.folha.posSemPan(reta.fim), this.folha);
            vetReta = retaRel.vetorDiretor();
            int n = 1;
            while (n <= 3) {
                if (this.retaEstaNaBorda(retaRel, n)) {
                    retaBorda = this.retaBorda(n);
                    Vetor vetBorda = retaBorda.vetorDiretor();
                    dist1 = retaRel.distanciaPos(retaBorda.inicio);
                    dist2 = retaRel.distanciaPos(retaBorda.fim);
                    if (dist1 <= dmin && dist2 <= dmin) {
                        double angRad = Calculos.anguloVetores(vetReta, vetBorda);
                        double angGraus = (angRad = Calculos.ang90rad(angRad)) * 57.29577951308232;
                        if (angGraus * angGraus < angMin * angMin) {
                            angMin = angGraus;
                            retaAj = retaRel;
                            retaAj.angBordaEsq = angRad;
                            borda = n;
                        }
                    }
                }
                ++n;
            }
        }
        if (retaAj != null) {
            retaBorda = this.retaBorda(borda);
            this.rodaEsquadro(retaAj.angBordaEsq, retaBorda.inicio);
            retaBorda = this.retaBorda(borda);
            double dist = retaBorda.distanciaPosSinal(retaAj.inicio);
            vetReta = retaBorda.vetorDiretor();
            Vetor vetAj = vetReta.vetorNormal(dist);
            this.movEsqDir(vetAj);
            if (borda == this.bordaEsc) {
                retaBorda = this.retaBordaEsc();
                if (retaBorda.dentroLimites(retaAj.inicio) && retaBorda.dentroLimites(retaAj.fim)) {
                    dist1 = Calculos.distancia(retaBorda.inicio, retaAj.inicio);
                    if (dist1 <= (dist2 = Calculos.distancia(retaBorda.inicio, retaAj.fim))) {
                        this.ajusteEscPos(borda, retaAj.inicio);
                        this.destEsc(borda, retaAj.inicio);
                    } else {
                        this.ajusteEscPos(borda, retaAj.fim);
                        this.destEsc(borda, retaAj.fim);
                    }
                } else if (retaBorda.dentroLimites(retaAj.inicio)) {
                    this.ajusteEscPos(borda, retaAj.inicio);
                    this.destEsc(borda, retaAj.inicio);
                } else if (retaBorda.dentroLimites(retaAj.fim)) {
                    this.ajusteEscPos(borda, retaAj.fim);
                    this.destEsc(borda, retaAj.fim);
                }
            }
            return true;
        }
        return false;
    }

    private boolean ajusteBordaReta() {
        double dist2;
        double dist1;
        Reta retaBorda;
        Vetor vetReta;
        double dmin = 20.0;
        double angMin = 20.0;
        int borda = 0;
        Reta retaAj = null;
        Reta reta = this.apontaRetas;
        while (reta.proximo != null) {
            reta = reta.proximo;
            Reta retaRel = reta.retaRelativa();
            vetReta = retaRel.vetorDiretor();
            int n = 1;
            while (n <= 3) {
                if (this.retaEstaNaBorda(retaRel, n)) {
                    retaBorda = this.retaBorda(n);
                    Vetor vetBorda = retaBorda.vetorDiretor();
                    dist1 = retaRel.distanciaPos(retaBorda.inicio);
                    dist2 = retaRel.distanciaPos(retaBorda.fim);
                    if (dist1 <= dmin && dist2 <= dmin) {
                        double angRad = Calculos.anguloVetores(vetReta, vetBorda);
                        double angGraus = (angRad = Calculos.ang90rad(angRad)) * 57.29577951308232;
                        if (angGraus * angGraus < angMin * angMin) {
                            angMin = angGraus;
                            retaAj = retaRel;
                            retaAj.angBordaEsq = angRad;
                            borda = n;
                        }
                    }
                }
                ++n;
            }
        }
        if (retaAj != null) {
            retaBorda = this.retaBorda(borda);
            this.rodaEsquadro(retaAj.angBordaEsq, retaBorda.inicio);
            retaBorda = this.retaBorda(borda);
            double dist = retaBorda.distanciaPosSinal(retaAj.inicio);
            vetReta = retaBorda.vetorDiretor();
            Vetor vetAj = vetReta.vetorNormal(dist);
            this.movEsqDir(vetAj);
            if (borda == this.bordaEsc) {
                retaBorda = this.retaBordaEsc();
                if (retaBorda.dentroLimites(retaAj.inicio) && retaBorda.dentroLimites(retaAj.fim)) {
                    dist1 = Calculos.distancia(retaBorda.inicio, retaAj.inicio);
                    if (dist1 <= (dist2 = Calculos.distancia(retaBorda.inicio, retaAj.fim))) {
                        this.ajusteEscPos(borda, retaAj.inicio);
                        this.destEsc(borda, retaAj.inicio);
                    } else {
                        this.ajusteEscPos(borda, retaAj.fim);
                        this.destEsc(borda, retaAj.fim);
                    }
                } else if (retaBorda.dentroLimites(retaAj.inicio)) {
                    this.ajusteEscPos(borda, retaAj.inicio);
                    this.destEsc(borda, retaAj.inicio);
                } else if (retaBorda.dentroLimites(retaAj.fim)) {
                    this.ajusteEscPos(borda, retaAj.fim);
                    this.destEsc(borda, retaAj.fim);
                }
            }
            return true;
        }
        return false;
    }

    public void ajusteComPonto(Ponto ponto) {
        Vetor vetBorda = this.vetBorda(ponto.bordaEsq);
        Vetor vetNormal = vetBorda.vetorNormal(ponto.distEsq);
        this.movEsqDir(vetNormal);
    }

    public void ajusteEscPos(int borda, Posicao pos) {
        if (borda == this.bordaEsc) {
            this.movEsqDir(this.vetAjEsc(pos).invert());
        }
    }

    public void ajusteComPontos(Ponto pontoVinc, Ponto pontoDest) {
        Vetor vetBorda = this.vetBorda(pontoDest.bordaEsq);
        Vetor vetDir = new Vetor(pontoVinc, pontoDest);
        double ang = Calculos.anguloVetores(vetBorda, vetDir);
        ang = Calculos.ang90rad(ang);
        this.rodaEsquadro(-ang, pontoVinc);
    }

    public int intercepta(Posicao pos) {
        int borda = 0;
        double dmin = 6.0;
        int n = 1;
        while (n <= 3) {
            Reta retaBorda = this.retaBorda(n);
            double dist = retaBorda.distanciaPosSinal(pos);
            if (dist * dist < dmin * dmin && retaBorda.dentroLimites(pos)) {
                dmin = dist;
                borda = n;
            }
            ++n;
        }
        this.distLapis = dmin;
        return borda;
    }

    private double comprimento(double altura, double angulo) {
        return altura * Math.tan(angulo * (Math.PI / 180));
    }

    public boolean posicaoDentro(double x, double y) {
        double[] X = new double[3];
        double[] Y = new double[3];
        this.triangInt(X, Y);
        return Calculos.dentroTriang(this.vertX, this.vertY, x, y) && !Calculos.dentroTriang(X, Y, x, y);
    }

    @Override
    public boolean posicaoDentro(Posicao clique) {
        return this.posicaoDentro(clique.x, clique.y);
    }

    private double distanciaPontoBorda(Posicao ponto, int borda) {
        Posicao pos1 = new Posicao(this.vertX[--borda], this.vertY[borda]);
        Posicao pos2 = new Posicao(this.vertX[(borda + 1) % 3], this.vertY[(borda + 1) % 3]);
        return Calculos.distanciaPontoReta(ponto, pos2, pos1);
    }

    private boolean retaEstaNaBorda(Reta reta, int borda) {
        Reta retaBorda = this.retaBorda(borda);
        if (retaBorda.dentroLimites(reta.inicio)) {
            return true;
        }
        if (retaBorda.dentroLimites(reta.fim)) {
            return true;
        }
        if (reta.dentroLimites(retaBorda.inicio)) {
            return true;
        }
        return reta.dentroLimites(retaBorda.fim);
    }

    public Reta retaBorda(int borda) {
        int n = borda - 1;
        return new Reta(this.vertX[n], this.vertY[n], this.vertX[(n + 1) % 3], this.vertY[(n + 1) % 3], this.folha);
    }

    public Reta retaBordaInv(int borda) {
        int n = borda - 1;
        return new Reta(this.vertX[(n + 1) % 3], this.vertY[(n + 1) % 3], this.vertX[n], this.vertY[n], this.folha);
    }

    public Reta retaBordaEsc() {
        int n = this.bordaEsc - 1;
        return new Reta(this.vertX[(n + 1) % 3], this.vertY[(n + 1) % 3], this.vertX[n], this.vertY[n], this.folha);
    }

    public Vetor vetBorda(int borda) {
        int n = borda - 1;
        return new Vetor(this.vertX[n], this.vertY[n], this.vertX[(n + 1) % 3], this.vertY[(n + 1) % 3]);
    }

    public int borda(int vert, int vert2) {
        int v1 = Math.min(vert, vert2);
        int v2 = Math.max(vert, vert2);
        int borda = 2 * v2 - v1 - 1;
        return borda;
    }

    public Posicao posVert(int vert) {
        return new Posicao(this.vertX[vert % 3], this.vertY[vert % 3]);
    }

    private Vetor vetVert(int vert) {
        Vetor vet2;
        Vetor vet1;
        if (vert != 0) {
            vet1 = this.vetBorda(vert).invert();
            vet2 = this.vetBorda(vert + 1);
        } else {
            vet1 = this.vetBorda(3).invert();
            vet2 = this.vetBorda(1);
        }
        double ang = Calculos.anguloVetores(vet1, vet2);
        Vetor vet = vet1.gira(-ang / 2.0);
        vet = vet.invert();
        return vet;
    }

    private Vetor vetVert1(int vert) {
        Vetor vet = vert == 0 ? this.vetBorda(3) : this.vetBorda(vert);
        return vet;
    }

    private Vetor vetVert2(int vert) {
        Vetor vet = vert == 0 ? this.vetBorda(1).invert() : this.vetBorda(vert + 1).invert();
        return vet;
    }

    private void triangInt(double[] X, double[] Y) {
        double c = Calculos.valInt(this.altInterna);
        double d = this.compInterno;
        double x = this.distInterna;
        Posicao pExt0 = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pExt1 = new Posicao(this.vertX[1], this.vertY[1]);
        Posicao pExt2 = new Posicao(this.vertX[2], this.vertY[2]);
        Vetor vet1 = new Vetor(pExt0, pExt1);
        Vetor vet2 = new Vetor(pExt0, pExt2);
        Posicao pInt0 = pExt0.soma(vet1.vetorPar(x)).soma(vet2.vetorPar(x));
        X[0] = pInt0.x;
        Y[0] = pInt0.y;
        Posicao pInt1 = pExt0.soma(vet1.vetorPar(c + x)).soma(vet2.vetorPar(x));
        X[1] = pInt1.x;
        Y[1] = pInt1.y;
        Posicao pInt2 = pExt0.soma(vet1.vetorPar(x)).soma(vet2.vetorPar(d + x));
        X[2] = pInt2.x;
        Y[2] = pInt2.y;
    }

    @Override
    public boolean destaca(Posicao posCursor) {
        boolean estAnt = this.possuiFoco;
        this.possuiFoco = this.posicaoDentro(posCursor);
        if (this.possuiFoco != estAnt) {
            this.sistema.repaint();
        }
        return this.possuiFoco;
    }

    @Override
    public void desenha(Graphics g) {
        int[] X = new int[3];
        int[] Y = new int[3];
        int[] Xtrap = new int[4];
        int[] Ytrap = new int[4];
        double[] Xd = new double[3];
        double[] Yd = new double[3];
        Posicao pExt0 = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pExt1 = new Posicao(this.vertX[1], this.vertY[1]);
        Posicao pExt2 = new Posicao(this.vertX[2], this.vertY[2]);
        X[0] = pExt0.intX();
        Y[0] = pExt0.intY();
        X[1] = pExt1.intX();
        Y[1] = pExt1.intY();
        X[2] = pExt2.intX();
        Y[2] = pExt2.intY();
        Polygon triangExt = this.folha.poligono(X, Y, 3);
        this.triangInt(Xd, Yd);
        Posicao pInt0 = new Posicao(Xd[0], Yd[0]);
        Posicao pInt1 = new Posicao(Xd[1], Yd[1]);
        Posicao pInt2 = new Posicao(Xd[2], Yd[2]);
        X[0] = pInt0.intX();
        Y[0] = pInt0.intY();
        X[1] = pInt1.intX();
        Y[1] = pInt1.intY();
        X[2] = pInt2.intX();
        Y[2] = pInt2.intY();
        Polygon triangInt = this.folha.poligono(X, Y, 3);
        Xtrap[0] = pExt0.intX();
        Ytrap[0] = pExt0.intY();
        Xtrap[1] = pExt1.intX();
        Ytrap[1] = pExt1.intY();
        Xtrap[2] = pInt1.intX();
        Ytrap[2] = pInt1.intY();
        Xtrap[3] = pInt0.intX();
        Ytrap[3] = pInt0.intY();
        Polygon trap1 = this.folha.poligono(Xtrap, Ytrap, 4);
        Xtrap[0] = pExt1.intX();
        Ytrap[0] = pExt1.intY();
        Xtrap[1] = pExt2.intX();
        Ytrap[1] = pExt2.intY();
        Xtrap[2] = pInt2.intX();
        Ytrap[2] = pInt2.intY();
        Xtrap[3] = pInt1.intX();
        Ytrap[3] = pInt1.intY();
        Polygon trap2 = this.folha.poligono(Xtrap, Ytrap, 4);
        Xtrap[0] = pExt0.intX();
        Ytrap[0] = pExt0.intY();
        Xtrap[1] = pExt2.intX();
        Ytrap[1] = pExt2.intY();
        Xtrap[2] = pInt2.intX();
        Ytrap[2] = pInt2.intY();
        Xtrap[3] = pInt0.intX();
        Ytrap[3] = pInt0.intY();
        Polygon trap3 = this.folha.poligono(Xtrap, Ytrap, 4);
        Color cor = g.getColor();
        if (this.possuiFoco) {
            g.setColor(Cor.esqCorpoDest);
        } else {
            g.setColor(Cor.esqCorpo);
        }
        g.fillPolygon(trap1);
        g.fillPolygon(trap2);
        g.fillPolygon(trap3);
        g.setColor(Cor.esqContorno);
        g.drawPolygon(triangExt);
        g.drawPolygon(triangInt);
        g.setColor(cor);
        this.desenhaEscala(g, this.subUnidDest);
    }

    private void desenhaEscala(Graphics g, int dest) {
        g.setFont(this.fonte);
        Vetor vetBorda = this.vetBorda(this.bordaEsc);
        double dist = this.sistema.unidade * this.folha.zoom() / 10.0;
        double fundoEsc = this.comprimento / dist;
        double tg = this.tipoGraus == 45.0 ? 1.0 : Math.sqrt(3.0) / 3.0;
        double tam = 2.0;
        Vetor vetN1 = vetBorda.vetorNormal(-2.0 * tam);
        Vetor vetN2 = vetBorda.vetorNormal(-3.0 * tam);
        Vetor vetN3 = vetBorda.vetorNormal(-4.0 * tam);
        Vetor vetN4 = vetBorda.vetorNormal(-5.0 * tam);
        double lim1 = this.comprimento - 2.0 * tam / tg;
        double lim2 = this.comprimento - 3.0 * tam / tg;
        double lim3 = this.comprimento - 4.0 * tam / tg;
        double lim4 = this.comprimento - 9.0 * tam / tg;
        if (dist + 1.0E-6 >= 2.0) {
            int j = Calculos.valInt(fundoEsc);
            Vetor vetPar = vetBorda.vetorPar(-dist);
            Posicao pos1 = this.folha.posPan(this.posVert(0));
            Posicao pos3 = pos1.soma(vetN4);
            Color cor = g.getColor();
            double dtotal = 0.0;
            int i = 1;
            while (i <= j) {
                Posicao pos2;
                if (i == dest) {
                    g.setColor(Cor.esqEscalaDest);
                } else {
                    g.setColor(Cor.esqEscala);
                }
                dtotal = (double)i * dist;
                pos1 = pos1.soma(vetPar);
                if (i % 10 == 0) {
                    if (dtotal < lim3) {
                        pos2 = pos1.soma(vetN3);
                        g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                    }
                    if (dtotal < lim4) {
                        pos3 = pos1.soma(vetN4);
                        this.desLegenda(g, pos3, String.valueOf(i / 10));
                    }
                } else if (i % 5 == 0) {
                    if (dtotal < lim2) {
                        pos2 = pos1.soma(vetN2);
                        g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                    }
                } else if (dtotal < lim1) {
                    pos2 = pos1.soma(vetN1);
                    g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                }
                ++i;
            }
            g.setColor(cor);
        } else if (5.0 * dist + 1.0E-6 >= 2.0) {
            int j = Calculos.valInt(fundoEsc / 5.0);
            Vetor vetPar = vetBorda.vetorPar(-(dist *= 5.0));
            Posicao pos1 = this.folha.posPan(this.posVert(0));
            Posicao pos3 = pos1.soma(vetN4);
            Color cor = g.getColor();
            double dtotal = 0.0;
            int i = 1;
            while (i <= j) {
                Posicao pos2;
                if (i == dest) {
                    g.setColor(Cor.esqEscalaDest);
                } else {
                    g.setColor(Cor.esqEscala);
                }
                dtotal = (double)i * dist;
                pos1 = pos1.soma(vetPar);
                if (i % 2 == 0) {
                    if (dist >= 5.0) {
                        if (dtotal < lim4) {
                            pos3 = pos1.soma(vetN3);
                            this.desLegenda(g, pos3, String.valueOf(i / 2));
                        }
                    } else if (i % 10 == 0 && dtotal < lim4) {
                        pos3 = pos1.soma(vetN3);
                        this.desLegenda(g, pos3, String.valueOf(i / 2));
                    }
                    if (dtotal < lim2) {
                        pos2 = pos1.soma(vetN2);
                        g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                    }
                } else if (dtotal < lim1) {
                    pos2 = pos1.soma(vetN1);
                    g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                }
                ++i;
            }
            g.setColor(cor);
        } else if (10.0 * dist + 1.0E-6 >= 2.0) {
            int j = Calculos.valInt(fundoEsc / 10.0);
            Vetor vetPar = vetBorda.vetorPar(-(dist *= 10.0));
            Posicao pos1 = this.folha.posPan(this.posVert(0));
            Posicao pos2 = pos1.soma(vetN3);
            Color cor = g.getColor();
            double dtotal = 0.0;
            int i = 1;
            while (i <= j) {
                if (i == dest) {
                    g.setColor(Cor.esqEscalaDest);
                } else {
                    g.setColor(Cor.esqEscala);
                }
                dtotal = (double)i * dist;
                pos1 = pos1.soma(vetPar);
                if (i % 5 == 0) {
                    if (dtotal < lim2) {
                        pos2 = pos1.soma(vetN2);
                        g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                    }
                    if (dtotal < lim4) {
                        Posicao pos3 = pos1.soma(vetN3);
                        this.desLegenda(g, pos3, String.valueOf(i));
                    }
                } else if (dtotal < lim1) {
                    pos2 = pos1.soma(vetN1);
                    g.drawLine(pos1.intX(), pos1.intY(), pos2.intX(), pos2.intY());
                }
                ++i;
            }
            g.setColor(cor);
        }
    }

    private void desLegenda(Graphics g, Posicao pos, String val) {
        g.drawString(val, pos.intX(), pos.intY());
    }

    public int subUnid(Posicao pos) {
        double dSubUnids = this.sistema.unidade * this.folha.zoom() / 10.0;
        if (dSubUnids + 1.0E-6 < 2.0) {
            if (5.0 * dSubUnids + 1.0E-6 >= 2.0) {
                dSubUnids *= 5.0;
            } else if (10.0 * dSubUnids + 1.0E-6 >= 2.0) {
                dSubUnids *= 10.0;
            }
        }
        Posicao inicio = this.posVert(0);
        double distIni = Calculos.distancia(inicio, pos);
        double distIniSU = distIni / dSubUnids;
        int subUnid = Calculos.valInt(distIniSU);
        return subUnid;
    }

    public Vetor vetAjEsc(Posicao pos) {
        double dSubUnids = this.sistema.unidade * this.folha.zoom() / 10.0;
        if (dSubUnids + 1.0E-6 < 2.0) {
            if (5.0 * dSubUnids + 1.0E-6 >= 2.0) {
                dSubUnids *= 5.0;
            } else if (10.0 * dSubUnids + 1.0E-6 >= 2.0) {
                dSubUnids *= 10.0;
            }
        }
        Posicao inicio = this.posVert(0);
        double distIni = Calculos.distancia(inicio, pos);
        double distIniSU = distIni / dSubUnids;
        int nSubUnids = Calculos.valInt(distIniSU);
        double delta = (double)nSubUnids - distIniSU;
        double norma = delta * dSubUnids;
        Vetor vetBorda = this.vetBorda(this.bordaEsc).invert();
        Vetor vetAj = vetBorda.vetorPar(norma);
        return vetAj;
    }

    private boolean ajusteEscala() {
        Reta retaBordaMov;
        Reta retaBorda;
        if (esqBorda == this) {
            int borda1 = bordaContato;
            int borda2 = bordaContato2;
            if (this.outroEsq.bordaEsc != borda2) {
                return false;
            }
            retaBorda = this.outroEsq.retaBordaEsc();
            retaBordaMov = borda1 == 3 ? this.retaBordaInv(borda1) : this.retaBorda(borda1);
        } else {
            int borda1 = bordaContato;
            int borda2 = bordaContato2;
            if (this.outroEsq.bordaEsc != borda1) {
                return false;
            }
            retaBorda = this.outroEsq.retaBordaEsc();
            retaBordaMov = borda2 == 3 ? this.retaBordaInv(borda2) : this.retaBorda(borda2);
        }
        if (retaBorda.dentroLimites(retaBordaMov.inicio)) {
            Vetor vetAj = this.outroEsq.vetAjEsc(retaBordaMov.inicio);
            this.movEsqDir(vetAj);
            return true;
        }
        if (retaBorda.dentroLimites(retaBordaMov.fim)) {
            Vetor vetAj = this.outroEsq.vetAjEsc(retaBordaMov.fim);
            this.movEsqDir(vetAj);
            return true;
        }
        return false;
    }

    private int subUnidDest() {
        Reta retaBordaMov;
        Reta retaBorda;
        if (esqBorda == this) {
            int borda1 = bordaContato;
            int borda2 = bordaContato2;
            if (this.outroEsq.bordaEsc != borda2) {
                return -1;
            }
            retaBorda = this.outroEsq.retaBordaEsc();
            retaBordaMov = borda1 == 3 ? this.retaBordaInv(borda1) : this.retaBorda(borda1);
        } else {
            int borda1 = bordaContato;
            int borda2 = bordaContato2;
            if (this.outroEsq.bordaEsc != borda1) {
                return -1;
            }
            retaBorda = this.outroEsq.retaBordaEsc();
            retaBordaMov = borda2 == 3 ? this.retaBordaInv(borda2) : this.retaBorda(borda2);
        }
        if (retaBorda.dentroLimites(retaBordaMov.inicio)) {
            return this.outroEsq.subUnid(retaBordaMov.inicio);
        }
        if (retaBorda.dentroLimites(retaBordaMov.fim)) {
            return this.outroEsq.subUnid(retaBordaMov.fim);
        }
        return -1;
    }

    public void destEsc(int borda, Posicao pos) {
        if (this.bordaEsc == borda) {
            this.subUnidDest = this.subUnid(pos);
        }
    }

    public void liberaEscala() {
        this.subUnidDest = -1;
    }
}

