/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Evento;
import control.EventoOperacao;
import control.EventoSelecao;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import model.Arco;
import model.Constantes;
import model.Cor;
import model.Esquadro;
import model.Folha;
import model.Instrumento;
import model.Ponto;
import model.Posicao;
import model.Reta;
import model.Vetor;
import view.Tela;

public class Compasso
extends Instrumento
implements Constantes {
    private double[] vertX = new double[3];
    private double[] vertY = new double[3];
    private int regiao;
    private int tamanho;
    private int largura;
    private double raio;
    private boolean novoArco;
    double av = 0.0;
    double ai = 0.0;
    double ap = 0.0;
    double an = 0.0;
    Esquadro esquadro;
    Ponto apontaPontos;
    Ponto pontoDest;
    Posicao cliqueAnt;
    Posicao marca;
    Arco apontaArcos;
    Arco arcoAtual;
    Folha folha;

    public Compasso(Posicao posicao, int tamanho, Tela sistema) {
        this.tamanho = Calculos.valInt(1.0 * (double)tamanho);
        this.largura = Calculos.valInt(0.06 * (double)tamanho);
        this.vertX[0] = posicao.x;
        this.vertY[0] = posicao.y;
        this.vertX[2] = posicao.x + (double)(tamanho / 2);
        this.vertY[2] = posicao.y;
        this.marca = new Posicao(0.0, 0.0);
        this.cliqueAnt = new Posicao(0.0, 0.0);
        this.novoArco = true;
        this.proximo = null;
        this.sistema = sistema;
        this.apontaPontos = sistema.listaPontos;
        this.arcoAtual = this.apontaArcos = sistema.listaArcos;
        this.folha = sistema.folha;
        this.pontoDest = null;
        this.esquadro = null;
        this.regiao = -1;
        this.constroiCompasso();
    }

    @Override
    public boolean posicaoDentro(Posicao clique) {
        this.regiao = this.regiaoAtiva(clique);
        return this.regiao != -1;
    }

    @Override
    public void seleciona(EventoSelecao evento) {
        this.cliqueAnt.defPosicao(evento.coordenadas());
    }

    @Override
    public void opera(EventoOperacao evento) {
        Ponto ponto = null;
        double anguloPonta = 0.0;
        Posicao cliqueAtual = new Posicao(evento.coordenadas());
        switch (this.regiao) {
            case 0: {
                this.esquadro = null;
                this.novoArco = true;
                if (this.pontoDest != null) {
                    this.pontoDest.estado = 0;
                    this.pontoDest = null;
                }
                this.moveCompasso(cliqueAtual.x - this.cliqueAnt.x, cliqueAtual.y - this.cliqueAnt.y);
                ponto = this.pontoNaPontaSeca();
                if (ponto != null) {
                    ponto.areaComp = 0;
                } else {
                    ponto = this.pontoNaPontaGraf();
                    if (ponto != null) {
                        ponto.areaComp = 1;
                    }
                }
                this.sistema.repaint();
                break;
            }
            case 2: {
                this.novoArco = true;
                this.abertura(cliqueAtual);
                ponto = this.pontoNaPontaGraf();
                if (ponto != null) {
                    ponto.areaComp = 1;
                }
                if (this.esquadro != null) {
                    this.destEscEsqGraf(this.esquadro, this.esquadro.bordaCompasso);
                }
                this.sistema.repaint();
                break;
            }
            case 1: {
                if (!this.folha.posicaoDentro(this.folha.posPan(this.vertX[2], this.vertY[2]))) break;
                anguloPonta = Calculos.anguloVetores(1.0, 0.0, this.vertX[2] - this.vertX[0], this.vertY[2] - this.vertY[0]);
                anguloPonta *= 57.29577951308232;
                if (this.esquadro != null) {
                    this.esquadro.distCompasso = -1.0;
                }
                if (this.novoArco) {
                    this.novoArco = false;
                    this.ai = Calculos.anguloVetores360(1.0, 0.0, this.vertX[2] - this.vertX[0], this.vertY[2] - this.vertY[0]);
                    this.av = 0.0;
                    this.ap = 0.0;
                    this.an = 0.0;
                    Posicao pseca = this.folha.posSemZoom(this.vertX[0], this.vertY[0]);
                    Posicao pgraf = this.folha.posSemZoom(this.vertX[2], this.vertY[2]);
                    double raio = Calculos.distancia(pseca, pgraf);
                    Arco arco = new Arco(pseca, raio, anguloPonta, 0.0, this.folha);
                    arco.proximo = this.apontaArcos.proximo;
                    this.apontaArcos.proximo = arco;
                    this.arcoAtual = arco;
                }
                double angulo = Calculos.anguloVetores(this.cliqueAnt.x - this.vertX[0], this.cliqueAnt.y - this.vertY[0], cliqueAtual.x - this.vertX[0], cliqueAtual.y - this.vertY[0]);
                this.giraCompasso(-angulo);
                if (this.av < 360.0) {
                    if (angulo >= 0.0) {
                        if (this.an > 0.0 && this.an < this.ap) {
                            this.an -= angulo * 180.0 / Math.PI;
                        } else {
                            this.ap += angulo * 180.0 / Math.PI;
                            if (this.an < 0.0) {
                                this.ap -= this.an;
                                this.an = 0.0;
                            }
                            if (this.ap > this.an) {
                                this.an = 0.0;
                                this.av = this.ap;
                            }
                        }
                    } else if (this.ap > 0.0 && this.ap < this.an) {
                        this.ap += angulo * 180.0 / Math.PI;
                    } else {
                        this.an -= angulo * 180.0 / Math.PI;
                        if (this.ap < 0.0) {
                            this.an -= this.ap;
                            this.ap = 0.0;
                        }
                        if (this.an > this.ap) {
                            this.ai = this.ai + this.av - this.an;
                            this.av = this.an;
                            this.ap = 0.0;
                        }
                    }
                } else {
                    this.av = 360.0;
                }
                this.arcoAtual.defAnguloInicial(this.ai);
                this.arcoAtual.defAnguloVarredura(this.av);
                this.sistema.repaint();
                break;
            }
            case 3: {
                this.novoArco = true;
                double angulo = Calculos.anguloVetores(this.cliqueAnt.x - this.vertX[0], this.cliqueAnt.y - this.vertY[0], cliqueAtual.x - this.vertX[0], cliqueAtual.y - this.vertY[0]);
                this.giraCompasso(-angulo);
                ponto = this.pontoNaPontaGraf();
                if (ponto != null) {
                    ponto.areaComp = 1;
                }
                this.sistema.repaint();
            }
        }
        if (this.pontoDest == null) {
            if (ponto != null) {
                this.pontoDest = ponto;
                ponto.estado = 1;
                this.sistema.repaint();
            }
        } else if (ponto != null) {
            if (ponto != this.pontoDest) {
                this.pontoDest.estado = 0;
                this.pontoDest = ponto;
                ponto.estado = 1;
                this.sistema.repaint();
            }
        } else {
            this.pontoDest.estado = 0;
            this.pontoDest = null;
            this.sistema.repaint();
        }
        this.cliqueAnt.defPosicao(cliqueAtual);
    }

    @Override
    public void libera(Evento evento) {
        Posicao[] intersecao = new Posicao[]{new Posicao(0.0, 0.0), new Posicao(0.0, 0.0)};
        switch (this.regiao) {
            case 0: {
                this.esquadro = this.esqAjuste();
                if (this.esquadro == null) break;
                this.ajustePontaSecaEsq(this.esquadro);
                this.sistema.repaint();
                break;
            }
            case 2: 
            case 3: {
                if (this.esquadro == null) break;
                this.ajustePontaGrafEsq(this.esquadro);
                this.sistema.repaint();
                break;
            }
            case 1: {
                Ponto ponto;
                int i;
                int n;
                Arco arco = this.apontaArcos;
                while (arco.proximo != null) {
                    arco = arco.proximo;
                    if (arco == this.arcoAtual) continue;
                    n = Calculos.intersecaoArcos(this.arcoAtual, arco, intersecao);
                    i = 1;
                    while (i <= n) {
                        ponto = this.sistema.listaPontos.proximo;
                        while (ponto != null && !ponto.igual(intersecao[i - 1])) {
                            ponto = ponto.proximo;
                        }
                        if (ponto == null) {
                            ponto = new Ponto(intersecao[i - 1], this.folha);
                            ponto.proximo = this.sistema.listaPontos.proximo;
                            this.sistema.listaPontos.proximo = ponto;
                            this.sistema.repaint();
                        }
                        ++i;
                    }
                }
                Reta reta = this.sistema.listaRetas;
                while (reta.proximo != null) {
                    reta = reta.proximo;
                    n = Calculos.intersecaoRetaArco(reta, this.arcoAtual, intersecao);
                    i = 1;
                    while (i <= n) {
                        ponto = this.sistema.listaPontos.proximo;
                        while (ponto != null && !ponto.igual(intersecao[i - 1])) {
                            ponto = ponto.proximo;
                        }
                        if (ponto == null) {
                            ponto = new Ponto(intersecao[i - 1], this.folha);
                            ponto.proximo = this.sistema.listaPontos.proximo;
                            this.sistema.listaPontos.proximo = ponto;
                            this.sistema.repaint();
                        }
                        ++i;
                    }
                }
                break;
            }
        }
        if (this.pontoDest != null) {
            if (this.pontoDest.areaComp == 0) {
                this.ajustaPontaSeca(this.pontoDest.pontoRel());
            } else if (this.pontoDest.areaComp == 1) {
                this.ajustaPontaGraf(this.pontoDest.pontoRel());
            }
            this.pontoDest.estado = 2;
            this.sistema.repaint();
        }
        this.regiao = 0;
    }

    public void defNovoArco() {
        this.novoArco = true;
    }

    private Arco arcoEditavel() {
        Posicao pSeca = this.folha.posSemZoom(this.vertX[0], this.vertY[0]);
        Posicao pGraf = this.folha.posSemZoom(this.vertX[2], this.vertY[2]);
        double dist = Calculos.distancia(pSeca, pGraf);
        Arco arcoRet = null;
        Arco arco = this.apontaArcos;
        while (arco.proximo != null) {
            arco = arco.proximo;
            if (!Calculos.distIgual(arco.raio, dist) || !arco.centro.igual(pSeca) || !arco.interceptaPosicao(pGraf)) continue;
            arcoRet = arco;
            break;
        }
        return arcoRet;
    }

    private void ajustaPontaSeca(Posicao pos) {
        this.moveCompasso(pos.x - this.vertX[0], pos.y - this.vertY[0]);
    }

    private void ajustaPontaGraf(Posicao pos) {
        this.vertX[2] = pos.x;
        this.vertY[2] = pos.y;
        this.constroiCompasso();
    }

    private void destEscEsqGraf(Esquadro esq, int borda) {
        if (borda == esq.bordaEsc && esq.distCompasso == 0.0) {
            Posicao pontaGraf = new Posicao(this.vertX[2], this.vertY[2]);
            Reta retaBorda = esq.retaBorda(esq.bordaCompasso);
            if (retaBorda.dentroLimites(pontaGraf)) {
                esq.destEsc(borda, pontaGraf);
            }
        }
    }

    private void ajustePontaSecaEsq(Esquadro esq) {
        Posicao pontaSeca = new Posicao(this.vertX[0], this.vertY[0]);
        Vetor vetBorda = esq.vetBorda(esq.bordaCompasso);
        Vetor vetNormal = vetBorda.vetorNormal(-esq.distCompasso);
        this.moveCompasso(vetNormal);
        if (esq.bordaCompasso == esq.bordaEsc) {
            this.moveCompasso(esq.vetAjEsc(pontaSeca));
            this.esquadro.destEsc(this.esquadro.bordaCompasso, pontaSeca);
        }
    }

    private void ajustePontaGrafEsq(Esquadro esq) {
        double dist;
        double distTol = 6.0;
        Posicao pontaGraf = new Posicao(this.vertX[2], this.vertY[2]);
        Reta retaBorda = esq.retaBorda(esq.bordaCompasso);
        if (retaBorda.dentroLimites(pontaGraf) && (dist = retaBorda.distanciaPosSinal(pontaGraf)) * dist <= distTol * distTol) {
            Vetor vetBorda = esq.vetBorda(esq.bordaCompasso);
            Vetor vetNormal = vetBorda.vetorNormal(-dist);
            pontaGraf = pontaGraf.soma(vetNormal);
            if (esq.bordaCompasso == esq.bordaEsc) {
                pontaGraf = pontaGraf.soma(esq.vetAjEsc(pontaGraf));
                this.esquadro.destEsc(this.esquadro.bordaCompasso, pontaGraf);
            }
            this.vertX[2] = pontaGraf.x;
            this.vertY[2] = pontaGraf.y;
            this.constroiCompasso();
            esq.distCompasso = 0.0;
        }
    }

    private Esquadro esqAjuste() {
        double dist;
        Reta retaBorda;
        int i;
        Posicao pontaSeca = new Posicao(this.vertX[0], this.vertY[0]);
        double dmin = 6.0;
        Esquadro esq = null;
        Esquadro esq1 = this.sistema.esquadro45;
        Esquadro esq2 = this.sistema.esquadro60;
        if (esq1.posPerto(pontaSeca)) {
            i = 1;
            while (i <= 3) {
                retaBorda = esq1.retaBorda(i);
                if (retaBorda.dentroLimites(pontaSeca) && (dist = retaBorda.distanciaPosSinal(pontaSeca)) * dist < dmin * dmin) {
                    dmin = dist;
                    esq1.distCompasso = dist;
                    esq1.bordaCompasso = i;
                    esq = esq1;
                }
                ++i;
            }
        }
        if (esq2.posPerto(pontaSeca)) {
            i = 1;
            while (i <= 3) {
                retaBorda = esq2.retaBorda(i);
                if (retaBorda.dentroLimites(pontaSeca) && (dist = retaBorda.distanciaPosSinal(pontaSeca)) * dist < dmin * dmin) {
                    dmin = dist;
                    esq2.distCompasso = dist;
                    esq2.bordaCompasso = i;
                    esq = esq2;
                }
                ++i;
            }
        }
        return esq;
    }

    private Ponto pontoNaPontaSeca() {
        Ponto pontoRet = null;
        double dmin = 4.0;
        Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
        Ponto ponto = this.apontaPontos;
        while (ponto.proximo != null) {
            ponto = ponto.proximo;
            Ponto pontoRel = ponto.pontoRel();
            double dist = Calculos.distancia(pontoRel, pSeca);
            if (!(dist < dmin)) continue;
            dmin = dist;
            pontoRet = ponto;
        }
        return pontoRet;
    }

    private Ponto pontoNaPontaGraf() {
        Ponto pontoRet = null;
        double dmin = 4.0;
        Posicao pGraf = new Posicao(this.vertX[2], this.vertY[2]);
        Ponto ponto = this.apontaPontos;
        while (ponto.proximo != null) {
            ponto = ponto.proximo;
            Ponto pontoRel = ponto.pontoRel();
            double dist = Calculos.distancia(pontoRel, pGraf);
            if (!(dist < dmin)) continue;
            dmin = dist;
            pontoRet = ponto;
        }
        return pontoRet;
    }

    private void moveCompasso(double dx, double dy) {
        int n = 0;
        while (n <= 2) {
            this.vertX[n] = this.vertX[n] + dx;
            this.vertY[n] = this.vertY[n] + dy;
            ++n;
        }
    }

    public void moveCompasso(Vetor mov) {
        Posicao pos = new Posicao(0.0, 0.0);
        int n = 0;
        while (n <= 2) {
            pos.defPosicao(this.vertX[n], this.vertY[n]);
            pos = pos.soma(mov);
            this.vertX[n] = pos.x;
            this.vertY[n] = pos.y;
            ++n;
        }
    }

    private void giraCompasso(double angulo) {
        double s = Math.sin(angulo);
        double c = Math.cos(angulo);
        int n = 1;
        while (n <= 2) {
            double x = this.vertX[n] - this.vertX[0];
            double y = this.vertY[n] - this.vertY[0];
            double xtemp = x * c - y * s;
            double ytemp = x * s + y * c;
            x = xtemp;
            y = ytemp;
            this.vertX[n] = x + this.vertX[0];
            this.vertY[n] = y + this.vertY[0];
            ++n;
        }
    }

    private int regiaoAtiva(Posicao pos) {
        double[] dist = new double[4];
        Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pTopo = new Posicao(this.vertX[1], this.vertY[1]);
        Posicao pGraf = new Posicao(this.vertX[2], this.vertY[2]);
        Vetor vet = new Vetor(pTopo, pSeca);
        dist[0] = this.proximidade(pTopo, pos, vet, this.largura);
        vet = new Vetor(pGraf, pSeca);
        if (vet.norma() < 2.0) {
            vet = new Vetor(pGraf, pTopo);
            vet = vet.vetorNormal(1.0);
        }
        vet = vet.vetorNormal(4.5 * (double)this.largura);
        Vetor vet2 = vet.vetorPar(-1.5 * (double)this.largura);
        Vetor vet3 = vet.vetorNormal(1.4 * (double)this.largura);
        Posicao origem = pTopo.soma(vet2).soma(vet3);
        double distancia = this.proximidade(origem, pos, vet, 2.8 * (double)this.largura);
        if (distancia != -1.0) {
            dist[0] = dist[0] == -1.0 ? distancia : Math.min(dist[0], distancia);
        }
        vet = new Vetor(pGraf, pTopo);
        vet = vet.vetorPar(2 * this.largura);
        dist[1] = this.proximidade(pGraf, pos, vet, this.largura);
        origem = pGraf.soma(vet);
        vet = new Vetor(pGraf, pTopo);
        vet2 = vet.vetorPar(vet.norma() - (double)(2 * this.largura));
        dist[2] = this.proximidade(origem, pos, vet2, this.largura);
        vet = new Vetor(pGraf, pSeca);
        if (vet.norma() < 2.0) {
            vet = new Vetor(pGraf, pTopo);
            vet = vet.vetorNormal(1.0);
        }
        vet = vet.vetorNormal(3.0 * (double)this.largura);
        vet2 = vet.vetorPar(-4.5 * (double)this.largura);
        vet3 = vet.vetorNormal(0.5 * (double)this.largura);
        origem = pTopo.soma(vet2).soma(vet3);
        dist[3] = this.proximidade(origem, pos, vet, 1.0 * (double)this.largura);
        int regiao = dist[0] == -1.0 ? Calculos.indValMin(dist, 4) : 0;
        return regiao;
    }

    private double proximidade(Posicao origem, Posicao pos, Vetor vet, double tol) {
        Vetor vet2 = new Vetor(origem, pos);
        double proj = vet2.normaProj(vet);
        if (proj > vet.norma() || proj < 0.0) {
            return -1.0;
        }
        double dist = vet.distPos(origem, pos);
        if (dist < 0.0 || Math.abs(dist) > tol) {
            return -1.0;
        }
        return dist;
    }

    private void constroiCompasso() {
        Vetor base = new Vetor(this.vertX[0], this.vertY[0], this.vertX[2], this.vertY[2]);
        this.constroiCompasso(base);
    }

    private void constroiCompasso(Vetor base) {
        Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
        double h = this.altTriIso(base, this.tamanho);
        Posicao pTopo = pSeca.soma(base.vetorPar(0.5 * base.norma())).soma(base.vetorNormal(h));
        this.vertX[1] = pTopo.x;
        this.vertY[1] = pTopo.y;
    }

    public void calcRaio() {
        Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pGraf = new Posicao(this.vertX[2], this.vertY[2]);
        Vetor base = new Vetor(pSeca, pGraf);
        this.raio = base.norma();
    }

    public void abertura(double zoom, double fatorAbert) {
        if (zoom >= 0.1 && zoom <= 8.0) {
            Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
            Posicao pGraf = new Posicao(this.vertX[2], this.vertY[2]);
            Vetor base = new Vetor(pSeca, pGraf);
            base = base.vetorPar(this.raio * fatorAbert);
            pGraf = pSeca.soma(base);
            this.vertX[2] = pGraf.x;
            this.vertY[2] = pGraf.y;
            this.constroiCompasso(base);
        }
    }

    private void abertura(Posicao pos) {
        Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pGraf = new Posicao(this.vertX[2], this.vertY[2]);
        Posicao origem = new Posicao(this.cliqueAnt);
        Vetor mov = new Vetor(origem, pos);
        Vetor base = new Vetor(this.vertX[0], this.vertY[0], this.vertX[2], this.vertY[2]);
        Vetor proj = mov.proj(base);
        Vetor base2 = new Vetor(pSeca, pGraf = pGraf.soma(proj));
        if (base2.norma() == 0.0) {
            double x = this.vertX[0];
            double y = this.vertY[0];
            this.vertX[0] = this.vertX[2];
            this.vertY[0] = this.vertY[2];
            this.vertX[2] = x;
            this.vertY[2] = y;
        } else {
            double h = this.altTriIso(base2, this.tamanho);
            Posicao pTopo = pSeca.soma(base2.vetorPar(0.5 * base2.norma())).soma(base2.vetorNormal(h));
            this.vertX[1] = pTopo.x;
            this.vertY[1] = pTopo.y;
            this.vertX[2] = pGraf.x;
            this.vertY[2] = pGraf.y;
        }
    }

    private double altTriIso(Vetor base, int lado) {
        double x = (double)(4 * lado * lado) - base.prodEscalar(base);
        double h = x < 0.0 ? (double)(2 * this.largura) : 0.5 * Calculos.raiz(x);
        return h;
    }

    @Override
    public boolean destaca(Posicao posCursor) {
        int regAnt = this.regiao;
        this.regiao = this.regiaoAtiva(posCursor);
        if (this.regiao != regAnt) {
            this.sistema.repaint();
        }
        return this.regiao != -1;
    }

    @Override
    public void desenha(Graphics g) {
        int[] X = new int[6];
        int[] Y = new int[6];
        int a = this.largura;
        int c = Calculos.valInt(0.5 * (double)a);
        Posicao pSeca = new Posicao(this.vertX[0], this.vertY[0]);
        Posicao pTopo = new Posicao(this.vertX[1], this.vertY[1]);
        Posicao pGraf = new Posicao(this.vertX[2], this.vertY[2]);
        Vetor vet1 = new Vetor(pSeca, pTopo);
        Vetor vet2 = vet1.vetorPar(1.0 * (double)a);
        Vetor vet3 = vet1.vetorNormal(0.2 * (double)a);
        Posicao pos = new Posicao(pSeca);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pSeca.soma(vet2);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pSeca.soma(vet2).soma(vet3);
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pSeca.soma(vet3);
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon seca = this.folha.poligono(X, Y, 4);
        vet3 = vet1.vetorNormal(1.0 * (double)a);
        pos = pSeca.soma(vet2);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pSeca.soma(vet2).soma(vet3);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pTopo.soma(vet3);
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = new Posicao(pTopo);
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon aste1 = this.folha.poligono(X, Y, 4);
        vet1 = new Vetor(pGraf, pTopo);
        vet2 = vet1.vetorPar(2.0 * (double)a);
        vet3 = vet1.vetorNormal(-0.52 * (double)a);
        Vetor vet4 = vet1.vetorPar(0.6 * (double)a);
        pos = new Posicao(pGraf);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pGraf.soma(vet2);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pGraf.soma(vet2).soma(vet3);
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pGraf.soma(vet4).soma(vet3);
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon graf = this.folha.poligono(X, Y, 4);
        vet3 = vet1.vetorNormal(-1.0 * (double)a);
        pos = pGraf.soma(vet2);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pGraf.soma(vet2).soma(vet3);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pTopo.soma(vet3);
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = new Posicao(pTopo);
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon aste2 = this.folha.poligono(X, Y, 4);
        vet1 = new Vetor(pSeca, pGraf);
        if (vet1.norma() < 2.0) {
            vet1 = new Vetor(pTopo, pSeca);
            vet2 = new Vetor(pTopo, pGraf);
            double ang = Calculos.anguloVetores(vet1, vet2);
            vet1 = vet1.gira(ang / 2.0);
            vet1 = vet1.vetorPar(-1.0);
        } else {
            vet1 = vet1.vetorNormal(1.0);
        }
        vet2 = vet1.vetorPar(4.5 * (double)a);
        vet3 = vet1.vetorNormal(0.5 * (double)a);
        pos = pTopo.soma(vet3);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pTopo.soma(vet2).soma(vet3);
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pTopo.soma(vet2).soma(vet3.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pTopo.soma(vet3.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        Polygon topo = this.folha.poligono(X, Y, 4);
        vet2 = vet1.vetorPar(1.5 * (double)a);
        vet3 = vet1.vetorNormal(1.4 * (double)a);
        vet4 = vet1.vetorPar(-0.5 * (double)a);
        Vetor vet5 = vet1.vetorPar(-3.0 * (double)a);
        Vetor vet6 = vet1.vetorNormal(0.8 * (double)a);
        pos = pTopo.soma(vet2).soma(vet3);
        X[0] = pos.intX();
        Y[0] = pos.intY();
        pos = pTopo.soma(vet2).soma(vet3.invert());
        X[1] = pos.intX();
        Y[1] = pos.intY();
        pos = pTopo.soma(vet4).soma(vet3.invert());
        X[2] = pos.intX();
        Y[2] = pos.intY();
        pos = pTopo.soma(vet5).soma(vet6.invert());
        X[3] = pos.intX();
        Y[3] = pos.intY();
        pos = pTopo.soma(vet5).soma(vet6);
        X[4] = pos.intX();
        Y[4] = pos.intY();
        pos = pTopo.soma(vet4).soma(vet3);
        X[5] = pos.intX();
        Y[5] = pos.intY();
        Polygon retang = this.folha.poligono(X, Y, 6);
        vet1 = new Vetor(pSeca, pGraf);
        if (vet1.norma() < 2.0) {
            vet1 = new Vetor(pTopo, pSeca);
            vet1 = vet1.vetorNormal(1.0);
        }
        vet2 = vet1.vetorPar(0.5 * (double)a);
        vet3 = new Vetor(-0.5 * (double)c, -0.5 * (double)c);
        Posicao posPino1 = pTopo.soma(vet2.invert()).soma(vet3);
        posPino1 = this.folha.posPan(posPino1);
        Posicao posPino2 = pTopo.soma(vet2).soma(vet3);
        posPino2 = this.folha.posPan(posPino2);
        Color cor = g.getColor();
        if (this.regiao == 1) {
            g.setColor(Cor.compGrafDest);
        } else {
            g.setColor(Cor.compGraf);
        }
        g.fillPolygon(graf);
        g.setColor(Cor.compAste);
        g.fillPolygon(seca);
        if (this.regiao == 0) {
            g.setColor(Cor.compAsteDest);
        } else {
            g.setColor(Cor.compAste);
        }
        g.fillPolygon(aste1);
        if (this.regiao == 2) {
            g.setColor(Cor.compAsteDest);
        } else {
            g.setColor(Cor.compAste);
        }
        g.fillPolygon(aste2);
        if (this.regiao == 3) {
            g.setColor(Cor.compTopoDest);
        } else {
            g.setColor(Cor.compTopo);
        }
        g.fillPolygon(topo);
        g.setColor(Cor.compContorno);
        g.drawPolygon(graf);
        g.drawPolygon(seca);
        g.drawPolygon(aste1);
        g.drawPolygon(aste2);
        g.drawPolygon(topo);
        if (this.regiao == 0) {
            g.setColor(Cor.compManoplaDest);
        } else {
            g.setColor(Cor.compManopla);
        }
        g.fillPolygon(retang);
        g.setColor(Cor.compParafuso);
        g.fillOval(posPino1.intX(), posPino1.intY(), c, c);
        g.fillOval(posPino2.intX(), posPino2.intY(), c, c);
        g.setColor(Cor.compContorno);
        g.drawPolygon(retang);
        g.setColor(cor);
    }
}

