/*
 * Decompiled with CFR 0.152.
 */
package control;

import model.Arco;
import model.Constantes;
import model.Posicao;
import model.Reta;
import model.Vetor;

public class Calculos
implements Constantes {
    public static boolean distIgual(double dist1, double dist2) {
        return dist1 - dist2 >= -1.0E-6 && dist1 - dist2 <= 1.0E-6;
    }

    public static int valInt(double num) {
        return (int)Math.round(num);
    }

    public static double raiz(double num) {
        if (num <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(num);
    }

    public static double divisao(double num, double den) {
        if (den >= -1.0E-6 && den <= 1.0E-6) {
            return 0.0;
        }
        return num / den;
    }

    public static double aCos(double num) {
        if (num > 1.0) {
            return 0.0;
        }
        return Math.acos(num);
    }

    public static double aCosDeg(double num) {
        return Calculos.aCos(num) * 57.29577951308232;
    }

    public static int indValMin(double[] vetor, int n) {
        double min = 1.0E9;
        int j = -1;
        int i = 0;
        while (i < n) {
            if (vetor[i] != -1.0 && vetor[i] < min) {
                min = vetor[i];
                j = i;
            }
            ++i;
        }
        return j;
    }

    public static double distancia(double c, double d, double a, double b) {
        return Calculos.raiz((c - a) * (c - a) + (d - b) * (d - b));
    }

    public static double distancia(Posicao posicao1, Posicao posicao2) {
        return Calculos.distancia(posicao1.x, posicao1.y, posicao2.x, posicao2.y);
    }

    public static boolean dentroTriang(double[] vertX, double[] vertY, double x, double y) {
        if ((x - vertX[1]) * (vertY[2] - vertY[1]) - (y - vertY[1]) * (vertX[2] - vertX[1]) > 0.0) {
            return false;
        }
        if ((vertX[2] - vertX[0]) * (y - vertY[0]) - (vertY[2] - vertY[0]) * (x - vertX[0]) > 0.0) {
            return false;
        }
        return !((x - vertX[0]) * (vertY[1] - vertY[0]) - (y - vertY[0]) * (vertX[1] - vertX[0]) > 0.0);
    }

    public static double distanciaPontoReta(double x, double y, double x1, double y1, double x2, double y2) {
        return Math.abs(Calculos.distanciaPontoRetaSinal(x, y, x1, y1, x2, y2));
    }

    public static double distanciaPontoRetaSinal(double x, double y, double x1, double y1, double x2, double y2) {
        double a = x1 - x2;
        double b = y1 - y2;
        double u = x - x2;
        double v = y - y2;
        return (a * v - b * u) / Calculos.raiz(a * a + b * b);
    }

    public static double distanciaPontoReta(Posicao ponto, Posicao reta2, Posicao reta1) {
        return Calculos.distanciaPontoReta(ponto.x, ponto.y, reta2.x, reta2.y, reta1.x, reta1.y);
    }

    public static double distanciaPontoRetaSinal(Posicao ponto, Posicao reta2, Posicao reta1) {
        return Calculos.distanciaPontoRetaSinal(ponto.x, ponto.y, reta2.x, reta2.y, reta1.x, reta1.y);
    }

    public static double anguloVetores(Vetor vet, Vetor vet2) {
        double angulo = Calculos.aCos(Calculos.divisao(vet.prodEscalar(vet2), vet.norma() * vet2.norma()));
        if (vet.x * vet2.y - vet.y * vet2.x > 0.0) {
            angulo = -angulo;
        }
        return angulo;
    }

    public static double anguloVetores(double a, double b, double m, double n) {
        return Calculos.anguloVetores(new Vetor(a, b), new Vetor(m, n));
    }

    public static double ang90(double angGraus) {
        double ang = angGraus;
        if (ang > 90.0) {
            ang -= 180.0;
        } else if (ang < -90.0) {
            ang += 180.0;
        }
        return ang;
    }

    public static double ang90rad(double angRad) {
        double ang = angRad;
        double pi = Math.PI;
        if (ang > pi / 2.0) {
            ang -= pi;
        } else if (ang < -(pi / 2.0)) {
            ang += pi;
        }
        return ang;
    }

    public static double ang90radSinal(double angRad) {
        double ang = angRad;
        double pi = Math.PI;
        if (ang > pi / 2.0) {
            ang = pi - ang;
        } else if (ang < -(pi / 2.0)) {
            ang = -pi - ang;
        }
        return ang;
    }

    public static double anguloVetores360(Vetor vet, Vetor vet2) {
        double angulo = Calculos.aCos(Calculos.divisao(vet.prodEscalar(vet2), vet.norma() * vet2.norma()));
        angulo *= 57.29577951308232;
        if (vet.x * vet2.y - vet.y * vet2.x > 0.0) {
            angulo = 360.0 - angulo;
        }
        return angulo;
    }

    public static double anguloVetores360(double a, double b, double m, double n) {
        return Calculos.anguloVetores360(new Vetor(a, b), new Vetor(m, n));
    }

    public static double anguloRetas(double a, double b, double m, double n) {
        return Calculos.aCos(Calculos.divisao(Math.abs(a * m + b * n), Calculos.raiz((a * a + b * b) * (m * m + n * n))));
    }

    public static double normaProjecao(Posicao vetor, Posicao vetorDirecao) {
        if (vetorDirecao.x == 0.0 && vetorDirecao.y == 0.0) {
            return 0.0;
        }
        double x = vetor.x;
        double y = vetor.y;
        double a = vetorDirecao.x;
        double b = vetorDirecao.y;
        return Calculos.divisao(Math.abs(a * x + b * y), Calculos.raiz(a * a + b * b));
    }

    public static boolean prodVetSaindo(Vetor vet1, Vetor vet2) {
        double a = vet1.x;
        double y = vet2.y;
        double b = vet1.y;
        double x = vet2.x;
        double z = a * y - b * x;
        return z < 0.0;
    }

    public static Posicao intersecaoRetas(Reta reta1, Reta reta2) {
        if ((Calculos.ladoEsquerdo(reta2, reta1.inicio) && !Calculos.ladoEsquerdo(reta2, reta1.fim) || Calculos.ladoEsquerdo(reta2, reta1.fim) && !Calculos.ladoEsquerdo(reta2, reta1.inicio)) && (Calculos.ladoEsquerdo(reta1, reta2.inicio) && !Calculos.ladoEsquerdo(reta1, reta2.fim) || Calculos.ladoEsquerdo(reta1, reta2.fim) && !Calculos.ladoEsquerdo(reta1, reta2.inicio))) {
            Posicao intersecao;
            if (Calculos.distIgual(reta1.inicio.x - reta1.fim.x, 0.0)) {
                double k = reta1.inicio.x;
                double a2 = reta2.coeficienteAngular();
                double b2 = reta2.coeficienteLinear();
                intersecao = new Posicao(0.0, 0.0);
                intersecao.x = k;
                intersecao.y = a2 * k + b2;
            } else if (Calculos.distIgual(reta2.inicio.x - reta2.fim.x, 0.0)) {
                double k = reta2.inicio.x;
                double a1 = reta1.coeficienteAngular();
                double b1 = reta1.coeficienteLinear();
                intersecao = new Posicao(0.0, 0.0);
                intersecao.x = k;
                intersecao.y = a1 * k + b1;
            } else {
                double a1 = reta1.coeficienteAngular();
                double b1 = reta1.coeficienteLinear();
                double a2 = reta2.coeficienteAngular();
                double b2 = reta2.coeficienteLinear();
                intersecao = new Posicao(0.0, 0.0);
                intersecao.x = Calculos.divisao(b2 - b1, a1 - a2);
                intersecao.y = Calculos.divisao(a1 * b2 - b1 * a2, a1 - a2);
            }
            return intersecao;
        }
        return null;
    }

    public static int intersecaoRetaArco(Reta reta, Arco arco, Posicao[] intersecao) {
        int i = 0;
        Posicao pos1 = null;
        Posicao pos2 = null;
        double d = reta.distanciaPosSinal(arco.centro);
        Vetor vet1 = reta.vetorDiretor();
        Vetor vet2 = vet1.vetorNormal(-d);
        d = Math.abs(d);
        if (Calculos.distIgual(arco.raio(), d)) {
            pos1 = arco.centro.soma(vet2);
        } else if (d < arco.raio + 1.0E-6) {
            double h = Calculos.raiz(arco.raio * arco.raio - d * d);
            Vetor vet = vet1.vetorPar(h);
            Posicao pos = arco.centro.soma(vet2);
            pos1 = pos.soma(vet);
            pos2 = pos.soma(vet.invert());
        }
        if (pos1 != null && reta.dentroLimites(pos1) && arco.interceptaPosicao(pos1)) {
            intersecao[i].defPosicao(pos1);
            ++i;
        }
        if (pos2 != null && reta.dentroLimites(pos2) && arco.interceptaPosicao(pos2) && !pos1.igual(pos2)) {
            intersecao[i].defPosicao(pos2);
            ++i;
        }
        return i;
    }

    public static int intersecaoArcos(Arco arco1, Arco arco2, Posicao[] intersec) {
        int i = 0;
        Posicao P0 = new Posicao(arco1.centro);
        Posicao P1 = new Posicao(arco2.centro);
        Posicao P2 = new Posicao(0.0, 0.0);
        Posicao P3 = new Posicao(0.0, 0.0);
        Posicao P4 = new Posicao(0.0, 0.0);
        double r0 = arco1.raio;
        double r1 = arco2.raio;
        double d = Calculos.distancia(P0, P1);
        if (d <= 1.0E-6 || d > r0 + r1 + 1.0E-6 || d < Math.abs(r0 - r1) - 1.0E-6) {
            return 0;
        }
        double a = (r0 * r0 - r1 * r1 + d * d) / (2.0 * d);
        if (r0 * r0 - a * a < 0.0) {
            return 0;
        }
        double h = Math.sqrt(r0 * r0 - a * a);
        P2.x = P0.x + a * (P1.x - P0.x) / d;
        P2.y = P0.y + a * (P1.y - P0.y) / d;
        P3.x = P2.x + h * (P1.y - P0.y) / d;
        P3.y = P2.y - h * (P1.x - P0.x) / d;
        if (arco1.interceptaPosicao(P3) && arco2.interceptaPosicao(P3)) {
            intersec[i].defPosicao(P3);
            ++i;
        }
        P4.x = P2.x - h * (P1.y - P0.y) / d;
        P4.y = P2.y + h * (P1.x - P0.x) / d;
        if (arco1.interceptaPosicao(P4) && arco2.interceptaPosicao(P4)) {
            intersec[i].defPosicao(P4);
            ++i;
        }
        if (i == 2 && d == r0 + r1) {
            return 1;
        }
        return i;
    }

    public static boolean ladoEsquerdo(Reta reta, Posicao posicao) {
        double a = posicao.x - reta.inicio.x;
        double n = reta.fim.y - reta.inicio.y;
        double b = posicao.y - reta.inicio.y;
        double m = reta.fim.x - reta.inicio.x;
        return a * n - b * m < -1.0E-6;
    }

    public static String joinStr(String[] str) {
        if (str.length < 1) {
            throw new IllegalArgumentException();
        }
        String joined = "";
        int i = 0;
        while (i < str.length) {
            joined = str[i] == null ? String.valueOf(joined) + "EMPTY LINE !\n" : (str[i].endsWith("\n") ? String.valueOf(joined) + str[i] : String.valueOf(joined) + str[i] + "\n");
            ++i;
        }
        return joined;
    }
}

