/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.IfElse;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;
import usp.ime.line.ivprog.view.utils.GripArea;
import usp.ime.line.ivprog.view.utils.IconButtonUI;
import usp.ime.line.ivprog.view.utils.RoundedJPanel;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public abstract class CodeBaseUI
extends RoundedJPanel
implements IDomainObjectUI {
    private String parentModelID;
    private String thisModelID;
    private String scopeModelID;
    private JPanel contentPanel;
    private JPanel gripArea;
    private JPanel trashCanPanel;
    private JPanel panel;

    public CodeBaseUI(String string) {
        System.out.println("./usp/ime/line/ivprog/view/domaingui/workspace/codecomponents/CodeBaseUI.java: CodeBaseUI(" + string + ")");
        this.thisModelID = string;
        this.setLayout(new BorderLayout());
        this.setArcs(new Dimension(15, 15));
        this.initGripArea();
        this.initCompositePanel();
        this.initTrashCan();
        this.addMouseListener(Services.getML());
        this.addMouseMotionListener(Services.getML());
    }

    private void initTrashCan() {
        this.trashCanPanel = new JPanel(new BorderLayout());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CODE_TRASHCAN;");
                if (Services.getModelMapping().get(CodeBaseUI.this.parentModelID) instanceof IfElse) {
                    IfElse ifElse = (IfElse)Services.getModelMapping().get(CodeBaseUI.this.parentModelID);
                    String string = ifElse.getChildContext(CodeBaseUI.this.thisModelID);
                    Services.getController().removeChild(CodeBaseUI.this.parentModelID, CodeBaseUI.this.thisModelID, string);
                } else {
                    Services.getController().removeChild(CodeBaseUI.this.parentModelID, CodeBaseUI.this.thisModelID, "");
                }
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(CodeBaseUI.class.getResource("/usp/ime/line/resources/icons/trash16x16.png")));
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("removeComponent"));
        JButton jButton = new JButton(abstractAction);
        jButton.setUI(new IconButtonUI());
        this.trashCanPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.trashCanPanel.setOpaque(false);
        this.trashCanPanel.add((Component)jButton, "North");
        this.add((Component)this.trashCanPanel, "East");
    }

    private void initCompositePanel() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.contentPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.add((Component)this.contentPanel, "Center");
    }

    private void initGripArea() {
        GripArea gripArea = new GripArea(this.thisModelID);
        this.gripArea = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(2);
        this.gripArea.setLayout(borderLayout);
        this.gripArea.add((Component)gripArea, "Center");
        this.gripArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.gripArea.add((Component)gripArea, "Center");
        this.gripArea.setOpaque(false);
        this.add((Component)this.gripArea, "West");
    }

    @Override
    public String getModelID() {
        return this.thisModelID;
    }

    @Override
    public String getModelParent() {
        return this.parentModelID;
    }

    @Override
    public String getModelScope() {
        return this.scopeModelID;
    }

    @Override
    public void setModelID(String string) {
        this.thisModelID = string;
    }

    @Override
    public void setModelParent(String string) {
        this.parentModelID = string;
    }

    @Override
    public void setModelScope(String string) {
        this.scopeModelID = string;
    }

    protected void addContentPanel(JPanel jPanel) {
        this.contentPanel.add(jPanel);
    }
}

