/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.gui;

import ilm.framework.SystemFactory;
import ilm.framework.assignment.IAssignment;
import ilm.framework.config.SystemConfig;
import ilm.framework.modules.AssignmentModule;
import ilm.framework.modules.IlmModule;
import java.util.Collection;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.utils.IconButtonUI;

public abstract class BaseGUI
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    protected SystemConfig _config;
    protected SystemFactory _factory;
    protected Vector _domainGUIList;
    protected Vector _authoringGUIList;
    protected IAssignment _assignments;
    protected int _activeAssignment;

    public void setComponents(SystemConfig systemConfig, IAssignment iAssignment, SystemFactory systemFactory) {
        this._config = systemConfig;
        this._config.addObserver(this);
        this._factory = systemFactory;
        this._domainGUIList = new Vector();
        this._authoringGUIList = new Vector();
        this._assignments = iAssignment;
        this._activeAssignment = 0;
    }

    public void initGUI(boolean bl) {
        this.initAssignments();
        this.initToolbar(this._assignments.getIlmModuleList().values(), bl);
    }

    protected abstract void initAssignments();

    protected abstract void initToolbar(Collection var1, boolean var2);

    public void startDesktop() {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(this);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(800, 600);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    protected void updateAssignmentIndex(int n) {
        this._activeAssignment = n;
        for (IlmModule ilmModule : this._assignments.getIlmModuleList().values()) {
            AssignmentModule assignmentModule;
            ilmModule.setAssignmentIndex(n);
            if (!(ilmModule instanceof AssignmentModule) || (assignmentModule = (AssignmentModule)ilmModule).getObserverType() == 1) continue;
            assignmentModule.update(this._assignments.getCurrentState(n), null);
        }
        Services.setCurrentState(this._assignments.getCurrentState(n));
    }

    protected abstract void setAuthoringButton();

    protected abstract void setNewAssignmentButton();

    protected abstract void setCloseAssignmentButton();

    protected abstract void setOpenAssignmentButton();

    protected abstract void setSaveAssignmentButton();

    protected abstract void startAuthoring();

    protected abstract void addNewAssignment();

    protected abstract void closeAssignment(int var1);

    protected abstract void openAssignmentFile(String var1);

    protected abstract void saveAssignmentFile(String var1);

    protected JButton makeButton(String string, String string2, String string3, String string4) {
        JButton jButton = new JButton();
        jButton.setActionCommand(string2);
        jButton.setToolTipText(string3);
        try {
            jButton.setIcon(new ImageIcon(BaseGUI.class.getResource("/usp/ime/line/resources/" + string + ".png"), string4));
        }
        catch (Exception exception) {
            System.err.println("Error: image './usp/ime/line/resources/" + string + ".png' is missing: ilm/framework/gui/BaseGUI.java");
        }
        jButton.setUI(new IconButtonUI());
        return jButton;
    }
}

