/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.utils;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicButtonUI;

public class IconButtonUI
extends BasicButtonUI {
    private Icon baseIcon;
    private Icon darkerIcon;
    private Icon brighterIcon;
    private Icon originalIcon;
    private double scalingValue = -1.0;

    public IconButtonUI() {
    }

    public IconButtonUI(double d) {
        this.scalingValue = d;
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setBorderPainted(false);
        abstractButton.setRolloverEnabled(true);
        abstractButton.setOpaque(false);
        abstractButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        abstractButton.addMouseListener(new HandCursor());
        this.prepareIcons(abstractButton);
    }

    @Override
    public void installUI(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.originalIcon = abstractButton.getIcon();
        super.installUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        abstractButton.setIcon(this.originalIcon);
        super.uninstallUI(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            abstractButton.setIcon(this.darkerIcon);
        } else if (buttonModel.isRollover()) {
            abstractButton.setIcon(this.brighterIcon);
        } else {
            abstractButton.setIcon(this.baseIcon);
        }
        super.paint(graphics, jComponent);
    }

    private void prepareIcons(AbstractButton abstractButton) {
        this.baseIcon = abstractButton.getIcon();
        Image image = this.getImage(this.baseIcon);
        if (this.scalingValue > 0.0) {
            image = this.getScaledImage(image, (int)((double)this.baseIcon.getIconWidth() * this.scalingValue), (int)((double)this.baseIcon.getIconHeight() * this.scalingValue));
            this.baseIcon = this.getIcon(image);
        }
        Image image2 = this.changeBrightness(image, true, 30);
        Image image3 = this.changeBrightness(image, false, 20);
        this.brighterIcon = this.getIcon(image2);
        this.darkerIcon = this.getIcon(image3);
    }

    private Image getImage(Icon icon) {
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                return ((ImageIcon)icon).getImage();
            }
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics graphics = bufferedImage.getGraphics();
            icon.paintIcon(new JLabel(), graphics, 0, 0);
            graphics.dispose();
            return bufferedImage;
        }
        return null;
    }

    private Icon getIcon(Image image) {
        return new IconUIResource(new ImageIcon(image));
    }

    private Image getScaledImage(Image image, int n, int n2) {
        AreaAveragingScaleFilter areaAveragingScaleFilter = new AreaAveragingScaleFilter(n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), areaAveragingScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private Image changeBrightness(Image image, final boolean bl, final int n) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            @Override
            public int filterRGB(int n4, int n2, int n3) {
                return n3 & 0xFF000000 | this.filter(n3 >> 16) << 16 | this.filter(n3 >> 8) << 8 | this.filter(n3);
            }

            private int filter(int n2) {
                n2 &= 0xFF;
                n2 = bl ? 255 - (255 - n2) * (100 - n) / 100 : n2 * (100 - n) / 100;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 255) {
                    n2 = 255;
                }
                return n2;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    static class HandCursor
    extends MouseAdapter {
        HandCursor() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

