/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.utils;

import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.DataObject;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.IfElse;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.domaingui.workspace.IVPContainer;
import usp.ime.line.ivprog.view.utils.GripArea;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class IVPMouseListener
extends MouseAdapter {
    private String currentProtocol = "drag&drop";
    public static final String INTERACTION_PROTOCOL_DND = "drag&drop";
    public static final String INTERACTION_PROTOCOL_CNP = "catch&paste";
    private boolean isHolding = false;
    private String holdingComponent = "";
    private JComponent lastEnteredComponent = null;
    private int lastYOnLastEnteredComponent = 0;

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.currentProtocol.equals(INTERACTION_PROTOCOL_CNP)) {
            if (!this.isHolding) {
                this.getComponent(mouseEvent.getSource());
            } else if (mouseEvent.getSource() instanceof IVPContainer) {
                this.dropComponent((IVPContainer)mouseEvent.getSource(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.currentProtocol.equals(INTERACTION_PROTOCOL_DND) && mouseEvent.getSource() instanceof IVPContainer) {
            this.lastEnteredComponent = (JComponent)mouseEvent.getComponent();
            this.lastYOnLastEnteredComponent = mouseEvent.getY();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentProtocol.equals(INTERACTION_PROTOCOL_DND) && this.lastEnteredComponent instanceof IVPContainer && this.isHolding) {
            this.dropComponent((IVPContainer)this.lastEnteredComponent, this.lastYOnLastEnteredComponent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.currentProtocol.equals(INTERACTION_PROTOCOL_DND) && !this.isHolding) {
            this.getComponent(mouseEvent.getSource());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public String getProtocol() {
        return this.currentProtocol;
    }

    public void setProtocol(String string) {
        this.currentProtocol = string;
    }

    private void getComponent(Object object) {
        if (object instanceof GripArea) {
            this.isHolding = true;
            this.holdingComponent = ((GripArea)object).getModelID();
            Services.getController().changeCursor(DragSource.DefaultMoveDrop);
        }
    }

    private void dropComponent(IVPContainer iVPContainer, int n) {
        String string = ((DataObject)Services.getModelMapping().get(this.holdingComponent)).getParentID();
        String string2 = iVPContainer.getCodeComposite();
        DataObject dataObject = (DataObject)Services.getModelMapping().get(string);
        String string3 = dataObject instanceof IfElse ? ((IfElse)dataObject).getChildContext(this.holdingComponent) : "";
        String string4 = "".equals(iVPContainer.getContext()) ? "" : iVPContainer.getContext();
        JComponent jComponent = (JComponent)Services.getViewMapping().get(this.holdingComponent);
        if (jComponent.isAncestorOf(iVPContainer)) {
            Services.getController().printError(ResourceBundleIVP.getString("Error.dropCodeInsideItSelf"));
        } else {
            Services.getController().moveChild(this.holdingComponent, string, iVPContainer.getCodeComposite(), string3, string4, iVPContainer.getDropIndex(n, jComponent));
        }
        this.holdingComponent = "";
        this.isHolding = false;
        this.lastEnteredComponent = null;
        this.lastYOnLastEnteredComponent = 0;
        Services.getController().changeCursor(0);
    }
}

