/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import usp.ime.line.ivprog.listeners.ICodeListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.While;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.workspace.IVPContainer;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.BooleanOperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.CodeBaseUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionFieldUI;
import usp.ime.line.ivprog.view.utils.IconButtonUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class WhileUI
extends CodeBaseUI
implements ICodeListener {
    private JPanel contentPanel;
    private JPanel header;
    private IVPContainer container;
    private ExpressionFieldUI expressionField;
    private JLabel codeBlockName;
    private JButton expandBtnUP;
    private JButton expandBtnDOWN;
    private Icon up;
    private Icon down;
    private String context;
    private BooleanOperationUI booleanOperationUI;

    public WhileUI(String string) {
        super(string);
        this.setModelID(string);
        this.initContentPanel();
        this.initExpandButtonIcon();
        this.initHeader();
        this.initExpressionHolder();
        this.initContainer();
        this.addContentPanel(this.contentPanel);
        this.setBackground(FlatUIColors.MAIN_BG);
        Services.getController().addComponentListener(this, string);
    }

    private void initContainer() {
        this.container = new IVPContainer(true, this.getModelID(), "");
        this.container.setContainerBackground(FlatUIColors.MAIN_BG);
        this.container.setVisible(false);
        this.contentPanel.add((Component)this.container, "Center");
    }

    private void initExpandButtonIcon() {
        this.up = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/expand_up.png"));
        this.down = new ImageIcon(this.getClass().getResource("/usp/ime/line/resources/icons/expand_down.png"));
    }

    private void initContentPanel() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(false);
    }

    private void initHeader() {
        this.header = new JPanel(new FlowLayout(0));
        this.header.setOpaque(false);
        this.contentPanel.add((Component)this.header, "North");
        this.initExpandBtnUP();
        this.initExpandBtnDOWN();
        this.initCodeBlockLabel();
        this.initExpression();
    }

    private void initExpressionHolder() {
    }

    private void initExpression() {
        String string = ((While)Services.getModelMapping().get(this.getModelID())).getCondition();
        this.booleanOperationUI = (BooleanOperationUI)Services.getRenderer().paint(string);
        this.expressionField = new ExpressionFieldUI(this.getModelID(), this.getModelScope());
        this.expressionField.setHolderContent(this.booleanOperationUI);
        this.expressionField.setComparison(true);
        this.expressionField.setBlocked(false);
        this.header.add(this.expressionField);
    }

    private void initExpandBtnUP() {
        this.expandBtnUP = new JButton();
        this.expandBtnUP.setIcon(this.up);
        this.expandBtnUP.setUI(new IconButtonUI());
        this.expandBtnUP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_EXPAND_CODE;");
                WhileUI.this.expandedActions();
            }
        });
        this.expandBtnUP.setVisible(false);
        this.header.add(this.expandBtnUP);
    }

    private void initExpandBtnDOWN() {
        this.expandBtnDOWN = new JButton();
        this.expandBtnDOWN.setIcon(this.down);
        this.expandBtnDOWN.setUI(new IconButtonUI());
        this.expandBtnDOWN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CONTRACT_CODE;");
                WhileUI.this.notExpandedAction();
            }
        });
        this.header.add(this.expandBtnDOWN);
    }

    protected void notExpandedAction() {
        this.container.setVisible(true);
        this.expandBtnUP.setVisible(true);
        this.expandBtnDOWN.setVisible(false);
        this.revalidate();
        this.repaint();
    }

    protected void expandedActions() {
        this.container.setVisible(false);
        this.expandBtnUP.setVisible(false);
        this.expandBtnDOWN.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    private void initCodeBlockLabel() {
        this.codeBlockName = new JLabel(ResourceBundleIVP.getString("WhileUI.text"));
        this.header.add(this.codeBlockName);
    }

    @Override
    public void setContext(String string) {
        this.context = string;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void addChild(String string, String string2) {
        this.container.addChild(string);
    }

    @Override
    public void childRemoved(String string, String string2) {
        this.container.childRemoved(string);
    }

    @Override
    public void restoreChild(String string, int n, String string2) {
        this.container.restoreChild(string, n);
    }

    @Override
    public void moveChild(String string, String string2, int n) {
        this.container.moveChild(string, n);
    }

    @Override
    public boolean isContentSet() {
        boolean bl = true;
        if (!this.expressionField.isContentSet()) {
            bl = false;
        }
        if (!this.container.isContentSet() && bl) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void lockDownCode() {
        this.expressionField.setEdition(false);
        this.container.lockCodeDown();
    }
}

