/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import usp.ime.line.ivprog.listeners.IOperationListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.VariableReference;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionFieldUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionHolderUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;

public abstract class OperationUI
extends JPanel
implements IDomainObjectUI,
IOperationListener {
    private JLabel leftPar;
    protected ExpressionHolderUI expressionBaseUI_1;
    protected JLabel expSign;
    protected ExpressionHolderUI expressionBaseUI_2;
    private JLabel rightPar;
    protected String currentModelID;
    protected String parentModelID;
    protected String scopeModelID;
    protected String context;
    private JPanel expPanel;
    private boolean drawBorder = false;
    private boolean isEditing = false;
    protected JPopupMenu operationSignMenu;
    protected short expressionType;

    public OperationUI(String string, String string2, String string3) {
        this.currentModelID = string3;
        this.scopeModelID = string2;
        this.parentModelID = string;
        this.context = "";
        this.setOpaque(false);
        this.initLayout();
        this.initComponents();
        this.initOperationSignMenu();
        this.initSignal();
        Services.getController().getProgram().addOperationListener(this);
    }

    public abstract void initOperationSignMenu();

    public abstract void initSignal();

    protected void initComponents() {
        this.initLeftParenthesis();
        this.initExpressionHolder1();
        this.initExpressionSign();
        this.initExpressionHolder2();
        this.initRightParenthesis();
    }

    private void initRightParenthesis() {
        this.rightPar = new JLabel(")");
        this.add(this.rightPar);
    }

    private void initExpressionHolder2() {
        this.expressionBaseUI_2 = new ExpressionHolderUI(this.currentModelID, this.scopeModelID);
        this.expressionBaseUI_2.setOperationContext("right");
        if (this.isEditing) {
            this.expressionBaseUI_2.enableEdition();
        } else {
            this.expressionBaseUI_2.disableEdition();
        }
        this.add(this.expressionBaseUI_2);
    }

    private void initExpressionSign() {
        this.expPanel = new JPanel();
        this.expPanel.setLayout(new FlowLayout(0));
        this.expPanel.addMouseListener(new OperationMouseListener(this.expPanel));
        this.add(this.expPanel);
        this.expSign = new JLabel();
        this.expSign.setForeground(FlatUIColors.CHANGEABLE_ITEMS_COLOR);
        this.expSign.setFont(new Font("Tahoma", 1, 12));
        this.expPanel.add(this.expSign);
    }

    private void initExpressionHolder1() {
        this.expressionBaseUI_1 = new ExpressionHolderUI(this.currentModelID, this.scopeModelID);
        this.expressionBaseUI_1.setOperationContext("left");
        if (this.isEditing) {
            this.expressionBaseUI_1.enableEdition();
        } else {
            this.expressionBaseUI_1.disableEdition();
        }
        this.add(this.expressionBaseUI_1);
    }

    private void initLeftParenthesis() {
        this.leftPar = new JLabel("(");
        this.add(this.leftPar);
    }

    protected void initLayout() {
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setHgap(3);
        flowLayout.setVgap(0);
        flowLayout.setAlignment(0);
    }

    public ExpressionHolderUI getExpressionBaseUI_1() {
        return this.expressionBaseUI_1;
    }

    public void setExpressionBaseUI_1(JComponent jComponent) {
        this.expressionBaseUI_1.setExpression(jComponent);
        this.revalidate();
        this.repaint();
    }

    public ExpressionHolderUI getExpressionBaseUI_2() {
        return this.expressionBaseUI_2;
    }

    public void setExpressionBaseUI_2(JComponent jComponent) {
        this.expressionBaseUI_2.setExpression(jComponent);
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getModelID() {
        return this.currentModelID;
    }

    @Override
    public String getModelParent() {
        return this.parentModelID;
    }

    @Override
    public String getModelScope() {
        return this.scopeModelID;
    }

    @Override
    public void setModelID(String string) {
        this.currentModelID = string;
        this.initSignal();
    }

    @Override
    public void setModelParent(String string) {
        this.parentModelID = string;
    }

    @Override
    public void setModelScope(String string) {
        this.scopeModelID = string;
    }

    @Override
    public void setContext(String string) {
        this.context = string;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public void enableEdition() {
        this.isEditing = true;
        this.expressionBaseUI_1.enableEdition();
        this.expressionBaseUI_2.enableEdition();
    }

    public void warningStateOn() {
        if (Services.getViewMapping().get(this.parentModelID) instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)Services.getViewMapping().get(this.parentModelID)).warningStateOn();
        } else if (Services.getViewMapping().get(this.parentModelID) instanceof OperationUI) {
            ((OperationUI)Services.getViewMapping().get(this.parentModelID)).warningStateOn();
        } else if (this.getParent() instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)this.getParent()).warningStateOn();
        } else if (this.getParent() instanceof ExpressionFieldUI) {
            ((ExpressionFieldUI)this.getParent()).setEdition(true);
        } else {
            this.enableEdition();
        }
    }

    public void disableEdition() {
        this.isEditing = false;
        this.expressionBaseUI_1.disableEdition();
        this.expressionBaseUI_2.disableEdition();
    }

    public short getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(short s) {
        this.expressionType = s;
        this.expressionBaseUI_1.setHoldingType(s);
        this.expressionBaseUI_2.setHoldingType(s);
    }

    public boolean isBothContentSet() {
        String string = "";
        String string2 = "";
        if (Services.getModelMapping().get(this.expressionBaseUI_1.getCurrentModelID()) instanceof VariableReference) {
            string = ((VariableReference)Services.getModelMapping().get(this.expressionBaseUI_1.getCurrentModelID())).getReferencedVariable();
        }
        if (Services.getModelMapping().get(this.expressionBaseUI_2.getCurrentModelID()) instanceof VariableReference) {
            string2 = ((VariableReference)Services.getModelMapping().get(this.expressionBaseUI_2.getCurrentModelID())).getReferencedVariable();
        }
        return !"".equals(string) || !"".equals(string2);
    }

    class OperationMouseListener
    implements MouseListener {
        private JPanel panel;

        public OperationMouseListener(JPanel jPanel) {
            this.panel = jPanel;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (OperationUI.this.isEditing) {
                OperationUI.this.operationSignMenu.show(this.panel, 0, this.panel.getHeight());
                OperationUI.this.operationSignMenu.requestFocus();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (OperationUI.this.isEditing) {
                this.panel.setBackground(FlatUIColors.HOVER_COLOR);
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (OperationUI.this.isEditing) {
                this.panel.setBackground(FlatUIColors.CODE_BG);
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

