/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import usp.ime.line.ivprog.listeners.IExpressionListener;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.variables.IVPVariablePanel;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.CodeBaseUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ConstantUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionFieldUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.OperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.VariableSelectorUI;
import usp.ime.line.ivprog.view.utils.IconButtonUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class ExpressionHolderUI
extends JPanel
implements IExpressionListener {
    public static final Color borderColor = new Color(230, 126, 34);
    public static final Color hoverColor = FlatUIColors.HOVER_COLOR;
    private boolean drawBorder = true;
    private boolean isComparisonEnabled = false;
    private boolean isEditing = true;
    private boolean isContentSet = false;
    private boolean isComparison = false;
    private JPopupMenu contentMenuWithValue;
    private JPopupMenu contentMenuWithoutValue;
    private JPopupMenu numberMenu;
    private JPopupMenu stringMenu;
    private JPopupMenu booleanMenu;
    private JPopupMenu comparisonMenu;
    private JLabel selectLabel;
    private String parentModelID;
    private String scopeModelID;
    private String currentModelID;
    private String operationContext;
    private JButton operationsBtn;
    private boolean hideOperationsBtn;
    private JComponent expression;
    private short holdingType = (short)-1;
    private boolean isForHeader = false;
    private String forContext = "";
    private boolean warningState = false;

    public ExpressionHolderUI(String string, String string2) {
        this.init(string, string2);
        this.initialization();
        this.initComponents();
    }

    private void init(String string, String string2) {
        this.parentModelID = string;
        this.scopeModelID = string2;
        this.currentModelID = "";
        this.setOperationContext("");
        Services.getController().getProgram().addExpressionListener(this);
    }

    private void initialization() {
        this.setBackground(FlatUIColors.MAIN_BG);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(3);
        flowLayout.setVgap(0);
        this.setLayout(flowLayout);
        this.addMouseListener(new ExpressionMouseListener(this));
    }

    private void initComponents() {
        this.initLabel();
        this.initChooseContentMenu();
        this.initChangeContentBtn();
        this.initOperationsMenu();
    }

    private void initOperationsMenu() {
        this.numberMenu = new JPopupMenu();
        this.stringMenu = new JPopupMenu();
        this.booleanMenu = new JPopupMenu();
        this.comparisonMenu = new JPopupMenu();
        this.addBooleanOperators(this.booleanMenu);
        this.addArithmeticOperations(this.numberMenu);
        this.addStringOperations(this.stringMenu);
        this.addComparison(this.comparisonMenu);
        this.addCleanContentForCondition(this.comparisonMenu);
        this.addCleanContent(this.booleanMenu);
        this.addCleanContent(this.numberMenu);
        this.addCleanContent(this.stringMenu);
    }

    private void addStringOperations(JPopupMenu jPopupMenu) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)17, (short)-1, ExpressionHolderUI.this.operationContext);
                Tracking.track("event=CLICK;where=BTN_CODE_OPERATION_CONCAT;");
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.stringConcat.tip"));
        abstractAction.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.stringConcat.text"));
        jPopupMenu.add(abstractAction);
        jPopupMenu.addSeparator();
    }

    private void addCleanContentForCondition(JPopupMenu jPopupMenu) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().deleteExpression(string, ExpressionHolderUI.this.parentModelID, ExpressionHolderUI.this.operationContext, true, true);
                Tracking.track("event=CLICK;where=BTN_CODE_CLEAN;");
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.cleanContent.tip"));
        abstractAction.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.cleanContent.text"));
        jPopupMenu.add(abstractAction);
    }

    private void addBooleanOperators(JPopupMenu jPopupMenu) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)5, (short)-1, ExpressionHolderUI.this.operationContext);
                Tracking.track("event=CLICK;where=BTN_EXPRESSION_OPERATION_AND;");
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.AND.tip"));
        abstractAction.putValue("Name", ResourceBundleIVP.getString("BooleanOperationUI.AND.text"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)6, (short)-1, ExpressionHolderUI.this.operationContext);
                Tracking.track("event=CLICK;where=BTN_EXPRESSION_OPERATION_OR;");
            }
        };
        abstractAction2.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.OR.tip"));
        abstractAction2.putValue("Name", ResourceBundleIVP.getString("BooleanOperationUI.OR.text"));
        jPopupMenu.add(abstractAction);
        jPopupMenu.add(abstractAction2);
        jPopupMenu.addSeparator();
    }

    private void addCleanContent(JPopupMenu jPopupMenu) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CLEAN;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().deleteExpression(string, ExpressionHolderUI.this.parentModelID, ExpressionHolderUI.this.forContext, true, false);
                } else {
                    Services.getController().deleteExpression(string, ExpressionHolderUI.this.parentModelID, ExpressionHolderUI.this.operationContext, true, false);
                }
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.cleanContent.tip"));
        abstractAction.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.cleanContent.text"));
        jPopupMenu.add(abstractAction);
    }

    private void addArithmeticOperations(JPopupMenu jPopupMenu) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEADDITION;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)1, (short)-1, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)1, (short)-1, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.createAddition.tip"));
        abstractAction.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.createAddition.text"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATESUBTRACTION;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)2, (short)-1, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)2, (short)-1, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction2.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.createSubtraction.tip"));
        abstractAction2.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.createSubtraction.text"));
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEMULTIPLICATION;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)4, (short)-1, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)4, (short)-1, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction3.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.createMultiplication.tip"));
        abstractAction3.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.createMultiplication.text"));
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEDIVISION;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)3, (short)-1, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)3, (short)-1, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction4.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.createDivision.tip"));
        abstractAction4.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.createDivision.text"));
        AbstractAction abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEINTDIV;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)18, (short)-1, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)18, (short)-1, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction5.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.createIntDiv.tip"));
        abstractAction5.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.createIntDiv.text"));
        jPopupMenu.add(abstractAction);
        jPopupMenu.add(abstractAction2);
        jPopupMenu.add(abstractAction4);
        jPopupMenu.add(abstractAction3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(abstractAction5);
        jPopupMenu.addSeparator();
    }

    private void addComparison(JPopupMenu jPopupMenu) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATELEQ;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)7, (short)-1, ExpressionHolderUI.this.operationContext);
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.LEQ.tip"));
        abstractAction.putValue("Name", "\u2264");
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATELES;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)8, (short)-1, ExpressionHolderUI.this.operationContext);
            }
        };
        abstractAction2.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.LES.tip"));
        abstractAction2.putValue("Name", "<");
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEEQU;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)9, (short)-1, ExpressionHolderUI.this.operationContext);
            }
        };
        abstractAction3.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.EQU.tip"));
        abstractAction3.putValue("Name", "=");
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATENEQ;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)10, (short)-1, ExpressionHolderUI.this.operationContext);
            }
        };
        abstractAction4.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.NEQ.tip"));
        abstractAction4.putValue("Name", "\u2260");
        AbstractAction abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEGEQ;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)11, (short)-1, ExpressionHolderUI.this.operationContext);
            }
        };
        abstractAction5.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.GEQ.tip"));
        abstractAction5.putValue("Name", "\u2265");
        AbstractAction abstractAction6 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CREATEGRE;");
                String string = ((IDomainObjectUI)((Object)ExpressionHolderUI.this.expression)).getModelID();
                Services.getController().createExpression(string, ExpressionHolderUI.this.parentModelID, (short)12, (short)-1, ExpressionHolderUI.this.operationContext);
            }
        };
        abstractAction6.putValue("ShortDescription", ResourceBundleIVP.getString("BooleanOperationUI.GRE.tip"));
        abstractAction6.putValue("Name", ">");
        jPopupMenu.add(abstractAction);
        jPopupMenu.add(abstractAction2);
        jPopupMenu.add(abstractAction3);
        jPopupMenu.add(abstractAction4);
        jPopupMenu.add(abstractAction5);
        jPopupMenu.add(abstractAction6);
        jPopupMenu.addSeparator();
    }

    private void initChooseContentMenu() {
        this.contentMenuWithValue = new JPopupMenu();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_VARIABLEHASBEENCHOSEN;");
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression("", ExpressionHolderUI.this.parentModelID, (short)0, ExpressionHolderUI.this.holdingType, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression("", ExpressionHolderUI.this.parentModelID, (short)0, ExpressionHolderUI.this.holdingType, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.variableHasBeenChosen.tip"));
        abstractAction.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.variableHasBeenChosen.text"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_VALUEHASBEENCHOSEN;");
                if (ExpressionHolderUI.this.isForHeader) {
                    Services.getController().createExpression("", ExpressionHolderUI.this.parentModelID, ExpressionHolderUI.this.holdingType, (short)-1, ExpressionHolderUI.this.forContext);
                } else {
                    Services.getController().createExpression("", ExpressionHolderUI.this.parentModelID, ExpressionHolderUI.this.holdingType, (short)-1, ExpressionHolderUI.this.operationContext);
                }
            }
        };
        abstractAction2.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.valueHasBeensChosen.tip"));
        abstractAction2.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.valueHasBeensChosen.text"));
        this.contentMenuWithValue.add(abstractAction);
        this.contentMenuWithValue.add(abstractAction2);
        this.contentMenuWithoutValue = new JPopupMenu();
        abstractAction2.putValue("ShortDescription", ResourceBundleIVP.getString("ExpressionHolderUI.action.valueHasBeensChosen.tip"));
        abstractAction2.putValue("Name", ResourceBundleIVP.getString("ExpressionHolderUI.action.valueHasBeensChosen.text"));
        this.contentMenuWithoutValue.add(abstractAction);
    }

    private void initChangeContentBtn() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_OPEN_OPERATIONMENU;");
                if (!ExpressionHolderUI.this.isComparison) {
                    if (ExpressionHolderUI.this.isComparisonEnabled) {
                        ExpressionHolderUI.this.comparisonMenu.show(ExpressionHolderUI.this.operationsBtn, ExpressionHolderUI.this.operationsBtn.getWidth(), ExpressionHolderUI.this.operationsBtn.getHeight());
                    } else if (ExpressionHolderUI.this.holdingType == 14 || ExpressionHolderUI.this.holdingType == 13) {
                        ExpressionHolderUI.this.numberMenu.show(ExpressionHolderUI.this.operationsBtn, ExpressionHolderUI.this.operationsBtn.getWidth(), ExpressionHolderUI.this.operationsBtn.getHeight());
                    } else if (ExpressionHolderUI.this.holdingType == 15) {
                        ExpressionHolderUI.this.stringMenu.show(ExpressionHolderUI.this.operationsBtn, ExpressionHolderUI.this.operationsBtn.getWidth(), ExpressionHolderUI.this.operationsBtn.getHeight());
                    } else if (ExpressionHolderUI.this.holdingType == 16) {
                        ExpressionHolderUI.this.booleanMenu.show(ExpressionHolderUI.this.operationsBtn, ExpressionHolderUI.this.operationsBtn.getWidth(), ExpressionHolderUI.this.operationsBtn.getHeight());
                    }
                } else {
                    ExpressionHolderUI.this.booleanMenu.show(ExpressionHolderUI.this.operationsBtn, ExpressionHolderUI.this.operationsBtn.getWidth(), ExpressionHolderUI.this.operationsBtn.getHeight());
                }
            }
        };
        abstractAction.putValue("SmallIcon", new ImageIcon(IVPVariablePanel.class.getResource("/usp/ime/line/resources/icons/operations.png")));
        this.operationsBtn = new JButton(abstractAction);
        this.operationsBtn.setUI(new IconButtonUI());
        this.operationsBtn.setVisible(false);
        this.add(this.operationsBtn);
    }

    private void initLabel() {
        this.selectLabel = new JLabel(ResourceBundleIVP.getString("ExpressionHolderUI.selectLabel.text"));
        this.selectLabel.setForeground(FlatUIColors.CHANGEABLE_ITEMS_COLOR);
        this.add(this.selectLabel);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.drawBorder) {
            int n;
            FlowLayout flowLayout = (FlowLayout)this.getLayout();
            flowLayout.setVgap(3);
            flowLayout.setHgap(3);
            this.revalidate();
            graphics.setColor(borderColor);
            Rectangle rectangle = this.getBounds();
            for (n = 0; n < rectangle.width; n += 6) {
                graphics.drawLine(n, 0, n + 3, 0);
                graphics.drawLine(n + 3, rectangle.height - 1, n + 6, rectangle.height - 1);
            }
            for (n = 0; n < rectangle.height; n += 6) {
                graphics.drawLine(0, n, 0, n + 3);
                graphics.drawLine(rectangle.width - 1, n + 3, rectangle.width - 1, n + 6);
            }
        } else {
            FlowLayout flowLayout = (FlowLayout)this.getLayout();
            flowLayout.setVgap(0);
            flowLayout.setHgap(0);
        }
    }

    @Override
    public void expressionCreated(String string, String string2, String string3) {
        if (this.isForHeader) {
            this.expressionCreatedFor(string, string2, string3);
        } else {
            this.expressionCreatedNormal(string, string2, string3);
        }
    }

    private void expressionCreatedNormal(String string, String string2, String string3) {
        if (string.equals(this.parentModelID) && this.operationContext.equals(string3)) {
            JComponent jComponent = this.expression;
            if (this.expression != null) {
                this.remove(this.expression);
            }
            this.currentModelID = string2;
            this.expression = Services.getRenderer().paint(string2);
            this.populatedExpressionHolder();
            this.add((Component)this.expression, 0);
            if (this.expression instanceof VariableSelectorUI) {
                if (this.isEditing) {
                    ((VariableSelectorUI)this.expression).editStateOn();
                } else {
                    ((VariableSelectorUI)this.expression).editStateOff("");
                }
                if (this.holdingType != -1) {
                    ((VariableSelectorUI)this.expression).setReferencedType(this.holdingType);
                }
            } else if (this.expression instanceof ConstantUI) {
                if (this.isEditing) {
                    ((ConstantUI)this.expression).editStateOn();
                } else {
                    ((ConstantUI)this.expression).editStateOff("");
                }
            } else {
                if (this.holdingType == -1) {
                    this.correctHoldingType(jComponent);
                }
                ((OperationUI)this.expression).setExpressionType(this.holdingType);
                if (!this.isComparison && jComponent != null && !"".equals(jComponent)) {
                    ((OperationUI)this.expression).setExpressionBaseUI_1(jComponent);
                }
                if (this.isEditing) {
                    ((OperationUI)this.expression).enableEdition();
                } else {
                    ((OperationUI)this.expression).disableEdition();
                }
                if (jComponent != null && !"".equals(jComponent)) {
                    ((IDomainObjectUI)((Object)jComponent)).setModelParent(this.currentModelID);
                }
            }
            if (Services.getViewMapping().get(this.parentModelID) instanceof CodeBaseUI) {
                if (jComponent != null && !"".equals(jComponent)) {
                    Services.getController().updateParent(this.parentModelID, ((IDomainObjectUI)((Object)jComponent)).getModelID(), string2, this.operationContext);
                } else {
                    Services.getController().updateParent(this.parentModelID, "", string2, this.operationContext);
                }
            }
            this.isContentSet = true;
            this.drawBorder = false;
            if (this.warningState) {
                this.setBorder(null);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void expressionCreatedFor(String string, String string2, String string3) {
        if (string.equals(this.parentModelID) && this.forContext.equals(string3)) {
            JComponent jComponent = this.expression;
            if (this.expression != null) {
                this.remove(this.expression);
            }
            this.currentModelID = string2;
            this.expression = Services.getRenderer().paint(string2);
            this.populatedExpressionHolder();
            this.add((Component)this.expression, 0);
            if (this.expression instanceof VariableSelectorUI) {
                if (this.isEditing) {
                    ((VariableSelectorUI)this.expression).editStateOn();
                } else {
                    ((VariableSelectorUI)this.expression).editStateOff("");
                }
                if (this.holdingType != -1) {
                    ((VariableSelectorUI)this.expression).setReferencedType(this.holdingType);
                }
            } else if (this.expression instanceof ConstantUI) {
                if (this.isEditing) {
                    ((ConstantUI)this.expression).editStateOn();
                } else {
                    ((ConstantUI)this.expression).editStateOff("");
                }
            } else {
                if (this.holdingType == -1) {
                    this.correctHoldingType(jComponent);
                }
                ((OperationUI)this.expression).setExpressionType(this.holdingType);
                if (!this.isComparison && jComponent != null) {
                    ((OperationUI)this.expression).setExpressionBaseUI_1(jComponent);
                }
                if (this.isEditing) {
                    ((OperationUI)this.expression).enableEdition();
                } else {
                    ((OperationUI)this.expression).disableEdition();
                }
                if (jComponent != null && !"".equals(jComponent)) {
                    ((IDomainObjectUI)((Object)jComponent)).setModelParent(this.currentModelID);
                }
            }
            if (Services.getViewMapping().get(this.parentModelID) instanceof CodeBaseUI) {
                if (jComponent != null && !"".equals(jComponent)) {
                    Services.getController().updateParent(this.parentModelID, ((IDomainObjectUI)((Object)jComponent)).getModelID(), string2, this.forContext);
                } else {
                    Services.getController().updateParent(this.parentModelID, "", string2, this.forContext);
                }
            }
            this.isContentSet = true;
            this.drawBorder = false;
            if (this.warningState) {
                this.setBorder(null);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void correctHoldingType(JComponent jComponent) {
        if (jComponent instanceof VariableSelectorUI) {
            this.holdingType = ((VariableSelectorUI)jComponent).referenceType();
        } else if (jComponent instanceof OperationUI) {
            this.holdingType = ((OperationUI)jComponent).getExpressionType();
        }
    }

    @Override
    public void expressionDeleted(String string, String string2, boolean bl) {
        if (this.isForHeader) {
            this.expressionDeletedFor(string, string2, bl);
        } else {
            this.expressionDeletedNormal(string, string2, bl);
        }
    }

    private void expressionDeletedFor(String string, String string2, boolean bl) {
        if (this.expression != null && this.currentModelID.equals(string) && this.forContext.equals(string2)) {
            this.remove(this.expression);
            this.isContentSet = false;
            if (!bl) {
                if (this.expression instanceof OperationUI) {
                    JComponent jComponent = ((OperationUI)this.expression).getExpressionBaseUI_1().getExpression();
                    this.currentModelID = ((IDomainObjectUI)((Object)jComponent)).getModelID();
                    this.setExpression(jComponent);
                } else {
                    this.emptyExpressionHolder();
                    this.currentModelID = "";
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void expressionDeletedNormal(String string, String string2, boolean bl) {
        if (this.expression != null && this.currentModelID.equals(string) && this.operationContext.equals(string2)) {
            this.remove(this.expression);
            this.isContentSet = false;
            if (!bl) {
                if (this.expression instanceof OperationUI) {
                    JComponent jComponent = ((OperationUI)this.expression).getExpressionBaseUI_1().getExpression();
                    this.currentModelID = ((IDomainObjectUI)((Object)jComponent)).getModelID();
                    this.setExpression(jComponent);
                } else {
                    this.emptyExpressionHolder();
                    this.currentModelID = "";
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void expressionRestoredFromCleaning(String string, String string2, String string3) {
        if (this.isForHeader) {
            this.expressionRestoredFromCleaningFor(string, string2, string3);
        } else {
            this.expressionRestoredFromCleaningNormal(string, string2, string3);
        }
    }

    private void expressionRestoredFromCleaningFor(String string, String string2, String string3) {
        Object var4_4 = null;
        if (string.equals(this.parentModelID) && this.forContext.equals(string3)) {
            Services.getController().updateParent(this.parentModelID, this.currentModelID, string2, this.forContext);
            JComponent jComponent = (JComponent)Services.getViewMapping().get(string2);
            this.setExpression(jComponent);
            this.isContentSet = true;
            this.drawBorder = false;
        }
        this.revalidate();
        this.repaint();
    }

    private void expressionRestoredFromCleaningNormal(String string, String string2, String string3) {
        Object var4_4 = null;
        if (string.equals(this.parentModelID) && this.operationContext.equals(string3)) {
            Services.getController().updateParent(this.parentModelID, this.currentModelID, string2, this.operationContext);
            JComponent jComponent = (JComponent)Services.getViewMapping().get(string2);
            this.setExpression(jComponent);
            this.isContentSet = true;
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void expressionRestored(String string, String string2, String string3) {
        if (this.isForHeader) {
            this.expressionRestoredFor(string, string2, string3);
        } else {
            this.expressionRestoredNormal(string, string2, string3);
        }
    }

    private void expressionRestoredFor(String string, String string2, String string3) {
        Object var4_4 = null;
        if (string.equals(this.parentModelID) && this.forContext.equals(string3)) {
            JComponent jComponent = (JComponent)Services.getViewMapping().get(string2);
            Services.getController().updateParent(this.parentModelID, this.currentModelID, string2, this.forContext);
            if (jComponent instanceof OperationUI) {
                ((OperationUI)jComponent).setExpressionBaseUI_1(this.expression);
            } else if (jComponent instanceof ConstantUI) {
                if (((ConstantUI)jComponent).isEditState()) {
                    this.editStateOn();
                } else {
                    this.editStateOff();
                }
            } else if (((VariableSelectorUI)jComponent).isEditState()) {
                this.editStateOn();
            } else {
                this.editStateOff();
            }
            this.setExpression(jComponent);
            this.isContentSet = true;
        }
        this.revalidate();
        this.repaint();
    }

    private void expressionRestoredNormal(String string, String string2, String string3) {
        Object var4_4 = null;
        if (string.equals(this.parentModelID) && this.operationContext.equals(string3)) {
            JComponent jComponent = (JComponent)Services.getViewMapping().get(string2);
            Services.getController().updateParent(this.parentModelID, this.currentModelID, string2, this.operationContext);
            if (jComponent instanceof OperationUI) {
                ((OperationUI)jComponent).setExpressionBaseUI_1(this.expression);
            } else if (jComponent instanceof ConstantUI) {
                if (((ConstantUI)jComponent).isEditState()) {
                    this.editStateOn();
                } else {
                    this.editStateOff();
                }
            } else if (((VariableSelectorUI)jComponent).isEditState()) {
                this.editStateOn();
            } else {
                this.editStateOff();
            }
            this.setExpression(jComponent);
            this.isContentSet = true;
        }
        this.revalidate();
        this.repaint();
    }

    private void emptyExpressionHolder() {
        this.selectLabel.setVisible(true);
        this.setOpaque(true);
        this.drawBorder = true;
        this.editStateOff();
    }

    private void populatedExpressionHolder() {
        this.selectLabel.setVisible(false);
        this.setOpaque(false);
        this.drawBorder = false;
    }

    public JComponent getExpression() {
        return this.expression;
    }

    public void setExpression(JComponent jComponent) {
        this.currentModelID = ((IDomainObjectUI)((Object)jComponent)).getModelID();
        if (this.expression != null) {
            this.remove(this.expression);
        }
        this.expression = jComponent;
        this.populatedExpressionHolder();
        if (this.isEditing) {
            this.enableEdition();
        } else {
            this.disableEdition();
        }
        this.add((Component)this.expression, 0);
        this.isContentSet = true;
        this.revalidate();
        this.repaint();
    }

    public String getCurrentModelID() {
        return this.currentModelID;
    }

    public void setCurrentModelID(String string) {
        this.currentModelID = string;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public void setOperationContext(String string) {
        this.operationContext = string;
    }

    public void editStateOff() {
        if (!this.hideOperationsBtn) {
            this.operationsBtn.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    public void editStateOn() {
        if (!this.hideOperationsBtn) {
            this.operationsBtn.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }

    public void enableComparison() {
        this.isComparisonEnabled = true;
    }

    public void disableComparison() {
        this.isComparisonEnabled = false;
    }

    public void enableEdition() {
        this.isEditing = true;
        if (this.expression != null) {
            if (this.expression instanceof VariableSelectorUI) {
                ((VariableSelectorUI)this.expression).editStateOn();
            } else if (this.expression instanceof OperationUI) {
                ((OperationUI)this.expression).enableEdition();
                this.editStateOn();
            } else if (this.expression instanceof ConstantUI) {
                ((ConstantUI)this.expression).editStateOn();
            }
        }
    }

    public void disableEdition() {
        this.isEditing = false;
        if (this.expression != null) {
            if (this.expression instanceof VariableSelectorUI) {
                String string = ((VariableSelectorUI)this.expression).getVarListSelectedItem();
                ((VariableSelectorUI)this.expression).editStateOff(string);
            } else if (this.expression instanceof OperationUI) {
                ((OperationUI)this.expression).disableEdition();
                this.editStateOff();
            } else if (this.expression instanceof ConstantUI) {
                ((ConstantUI)this.expression).editStateOff("");
            }
        }
    }

    public boolean isComparison() {
        return this.isComparison;
    }

    public void setComparison(boolean bl) {
        this.isComparison = bl;
    }

    public void warningStateOn() {
        this.warningState = true;
        if (Services.getViewMapping().get(this.parentModelID) instanceof OperationUI) {
            ((OperationUI)Services.getViewMapping().get(this.parentModelID)).warningStateOn();
        } else if (this.getParent() instanceof ExpressionFieldUI) {
            ((ExpressionFieldUI)this.getParent()).setEdition(true);
        } else if (this.getParent() instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)this.getParent()).warningStateOn();
        }
        if (!this.isContentSet) {
            this.setBorder(BorderFactory.createLineBorder(Color.red));
        }
        this.revalidate();
        this.repaint();
    }

    public void warningStateOFF() {
        this.warningState = false;
        this.setBorder(null);
        this.revalidate();
        this.repaint();
    }

    public short getHoldingType() {
        return this.holdingType;
    }

    public void setHoldingType(short s) {
        this.holdingType = s;
    }

    public boolean isCSet() {
        boolean bl = true;
        if (this.isContentSet) {
            if (!((IDomainObjectUI)((Object)this.expression)).isContentSet()) {
                bl = false;
            }
        } else {
            bl = false;
            this.warningStateOn();
        }
        return bl;
    }

    public boolean isContentSet() {
        return this.isContentSet;
    }

    public void setContentSet(boolean bl) {
        this.isContentSet = bl;
    }

    public void setHideMenu(boolean bl) {
        this.operationsBtn.setVisible(!bl);
        this.hideOperationsBtn = bl;
    }

    public boolean isForHeader() {
        return this.isForHeader;
    }

    public void setForHeader(boolean bl) {
        this.isForHeader = bl;
    }

    public String getForContext() {
        return this.forContext;
    }

    public void setForContext(String string) {
        this.forContext = string;
    }

    private class ExpressionMouseListener
    implements MouseListener {
        private JPanel container;

        public ExpressionMouseListener(JPanel jPanel) {
            this.container = jPanel;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (ExpressionHolderUI.this.isEditing && !ExpressionHolderUI.this.isContentSet) {
                ExpressionHolderUI.this.setBackground(hoverColor);
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (ExpressionHolderUI.this.isEditing && !ExpressionHolderUI.this.isContentSet) {
                ExpressionHolderUI.this.setBackground(FlatUIColors.MAIN_BG);
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ExpressionHolderUI.this.isEditing && !ExpressionHolderUI.this.isContentSet) {
                if (ExpressionHolderUI.this.holdingType != -1) {
                    ExpressionHolderUI.this.contentMenuWithValue.show(this.container, 0, this.container.getHeight());
                    ExpressionHolderUI.this.contentMenuWithValue.requestFocus();
                } else {
                    ExpressionHolderUI.this.contentMenuWithoutValue.show(this.container, 0, this.container.getHeight());
                    ExpressionHolderUI.this.contentMenuWithoutValue.requestFocus();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

