/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import usp.ime.line.ivprog.listeners.IValueListener;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.editinplace.EditInPlace;
import usp.ime.line.ivprog.view.domaingui.editinplace.ReadTextField;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class AskUserFrameDouble
extends JDialog
implements IValueListener {
    private JPanel contentPane;
    private ReadTextField value;
    private JPanel content;
    private JPanel buttons;
    private JButton btnOk;
    private JButton btnCancel;
    private JPanel header;
    private JLabel plsInsertLabel;
    private JLabel propertyLabel;
    private JLabel variableNameLabel;
    private double finalValue = 1.0;
    private boolean interrupt = false;

    public AskUserFrameDouble() {
        super((Frame)new JFrame(), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Tracking.track("event=CLICK;where=BTN_CLOSE_ASKUSERINTEGER;");
                AskUserFrameDouble.this.interrupt = true;
                AskUserFrameDouble.this.setVisible(false);
                Services.getController().printError(ResourceBundleIVP.getString("Error.executionInterruptedByUser"));
            }
        });
        this.initLayout();
        this.initContent();
        this.initEditInPlace();
        this.initButtonsPanel();
        this.initButtons();
        this.initHeader();
        this.initLabels();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initLabels() {
        this.plsInsertLabel = new JLabel(ResourceBundleIVP.getString("AskUser.double.messageLabel"));
        this.header.add(this.plsInsertLabel);
        this.propertyLabel = new JLabel(ResourceBundleIVP.getString("AskUser.double.propertyLabel"));
        this.header.add(this.propertyLabel);
        this.variableNameLabel = new JLabel();
        this.variableNameLabel.setForeground(FlatUIColors.CHANGEABLE_ITEMS_COLOR);
        this.header.add(this.variableNameLabel);
    }

    private void initHeader() {
        this.header = new JPanel();
        this.header.setBackground(FlatUIColors.MAIN_BG);
        this.contentPane.add((Component)this.header, "North");
    }

    private void initButtons() {
        this.btnOk = new JButton(ResourceBundleIVP.getString("AskUser.OKBtn.text"));
        this.btnOk.setToolTipText(ResourceBundleIVP.getString("AskUser.OKBtn.tip"));
        this.buttons.add(this.btnOk);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_OK_ASKUSERDOUBLE;");
                AskUserFrameDouble.this.interrupt = false;
                AskUserFrameDouble.this.setVisible(false);
            }
        });
        this.btnCancel = new JButton(ResourceBundleIVP.getString("AskUser.cancelBtn.text"));
        this.btnCancel.setToolTipText(ResourceBundleIVP.getString("AskUser.cancelBtn.tip"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CANCEL_ASKUSERDOUBLE;");
                AskUserFrameDouble.this.interrupt = true;
                AskUserFrameDouble.this.setVisible(false);
                Services.getController().printError(ResourceBundleIVP.getString("Error.executionInterruptedByUser"));
            }
        });
        this.buttons.add(this.btnCancel);
    }

    private void initButtonsPanel() {
        this.buttons = new JPanel();
        this.buttons.setBackground(FlatUIColors.MAIN_BG);
        this.contentPane.add((Component)this.buttons, "South");
    }

    private void initEditInPlace() {
        this.value = new ReadTextField();
        this.value.setCurrentPattern(EditInPlace.PATTERN_VARIABLE_VALUE_DOUBLE);
        this.value.setValue("" + this.finalValue + "");
        this.value.setValueListener(this);
        this.content.add(this.value);
    }

    private void initContent() {
        this.content = new JPanel();
        this.content.setBackground(FlatUIColors.MAIN_BG);
        this.contentPane.add((Component)this.content, "Center");
    }

    private void initLayout() {
        this.setDefaultCloseOperation(0);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
    }

    public double getFinalValue() {
        double d = this.finalValue;
        this.finalValue = 1.0;
        return d;
    }

    public void setFinalValue(double d) {
        this.finalValue = d;
    }

    public void showAskUser(String string) {
        String string2 = string + ": ";
        this.variableNameLabel.setText(string2);
        this.variableNameLabel.repaint();
        this.pack();
        this.value.setValue(this.finalValue + "");
        this.setVisible(true);
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean bl) {
        this.interrupt = bl;
    }

    @Override
    public void valueChanged(String string) {
        this.finalValue = Double.parseDouble(string);
        this.value.setValue(string);
    }
}

