/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.editinplace;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import usp.ime.line.ivprog.listeners.IValueListener;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;

public class EditInPlace
extends JPanel
implements KeyListener {
    private JLabel nameLabel;
    private JPanel nameContainer;
    private JTextField nameField;
    private IValueListener valueListener;
    public static int PATTERN_VARIABLE_NAME = 0;
    public static int PATTERN_VARIABLE_VALUE_DOUBLE = 1;
    public static int PATTERN_VARIABLE_VALUE_INTEGER = 2;
    public static int PATTERN_VARIABLE_VALUE_STRING = 3;
    private int currentPattern = 0;
    private String[] patternsTyping = new String[]{"^[a-zA-Z_][a-zA-Z0-9_]*$", "^[-]?[0-9]*.[0-9]*$", "^[-]?[0-9]*$", ".*"};
    private String[] patterns = new String[]{"^[a-zA-Z_][a-zA-Z0-9_]*$", "^[-]?[0-9]*.[0-9]*$", "^[-]?[0-9]*$", ".*"};
    private Color bgColor = FlatUIColors.MAIN_BG;
    public static final Color hoverColor = FlatUIColors.HOVER_COLOR;
    public boolean isUpdate = false;

    public EditInPlace(Color color) {
        this.bgColor = color;
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.initNameContainer();
        this.initNameLabel();
        this.initNameField();
    }

    public EditInPlace() {
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.initNameContainer();
        this.initNameLabel();
        this.initNameField();
    }

    private void initNameContainer() {
        this.nameContainer = new JPanel();
        this.nameContainer.setBackground(this.bgColor);
        this.add(this.nameContainer);
    }

    private void initNameLabel() {
        this.nameLabel = new JLabel("");
        this.nameLabel.addMouseListener(new VariableMouseListener());
        this.nameContainer.add(this.nameLabel);
    }

    private void hasFocusLost() {
        this.nameContainer.setVisible(true);
        this.nameField.setVisible(false);
        if (this.valueListener != null) {
            this.valueListener.valueChanged(this.nameField.getText());
        }
        this.nameField.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initNameField() {
        this.nameField = new JTextField(5);
        this.nameField.addKeyListener(this);
        this.nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!EditInPlace.this.isUpdate) {
                    String string = EditInPlace.this.nameField.getText();
                    if (string.matches(EditInPlace.this.patterns[EditInPlace.this.currentPattern])) {
                        EditInPlace.this.hasFocusLost();
                    } else {
                        EditInPlace.this.nameField.setBorder(BorderFactory.createLineBorder(Color.red));
                    }
                }
                EditInPlace.this.isUpdate = false;
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.nameField.setVisible(false);
        this.initInputMap();
        this.add(this.nameField);
    }

    private void initInputMap() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=FOCUSLOST;where=EDIT_DONE_EDITINPLACE;");
                EditInPlace.this.isUpdate = true;
                EditInPlace.this.nameField.setFocusable(false);
                EditInPlace.this.nameField.setFocusable(true);
            }
        };
        this.nameField.getInputMap().put(KeyStroke.getKeyStroke('\n'), abstractAction);
        this.nameField.getInputMap().put(KeyStroke.getKeyStroke('\u001b'), abstractAction);
        this.nameField.getInputMap().put(KeyStroke.getKeyStroke('\t'), abstractAction);
    }

    public void setValueListener(IValueListener iValueListener) {
        this.valueListener = iValueListener;
    }

    public void setValue(String string) {
        this.nameField.setText(string);
        this.nameLabel.setText(string);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c;
        if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            this.hasFocusLost();
            return;
        }
        String string = this.nameField.getText();
        string = this.nameField.getSelectionStart() == 0 ? keyEvent.getKeyChar() + string : (this.nameField.getSelectionStart() == string.length() ? string + keyEvent.getKeyChar() : string.substring(0, this.nameField.getSelectionStart()) + keyEvent.getKeyChar() + string.substring(this.nameField.getSelectionEnd()));
        if (!string.matches(this.patternsTyping[this.currentPattern]) && (c = keyEvent.getKeyChar()) != '\b' && c != '\u007f') {
            this.getToolkit().beep();
            keyEvent.consume();
        }
    }

    public boolean isValidValue(KeyEvent keyEvent) {
        return false;
    }

    public int getCurrentPattern() {
        return this.currentPattern;
    }

    public void setCurrentPattern(int n) {
        this.currentPattern = n;
    }

    public void resetTextField() {
        this.nameField.setText(this.nameLabel.getText());
    }

    private class VariableMouseListener
    implements MouseListener {
        private VariableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            EditInPlace.this.nameContainer.setBackground(hoverColor);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            EditInPlace.this.nameContainer.setBackground(EditInPlace.this.bgColor);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource().equals(EditInPlace.this.nameLabel)) {
                EditInPlace.this.nameField.setVisible(true);
                EditInPlace.this.nameContainer.setVisible(false);
                EditInPlace.this.nameField.requestFocus();
            }
        }
    }
}

