/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.FlatUIColors;

public class IVPConsole
extends JPanel {
    private JTextPane textPane;
    private JScrollPane scrollPane;
    private StyledDocument doc;
    private String[] styles;
    private final StyleContext cont = StyleContext.getDefaultStyleContext();
    private final AttributeSet attrRed = this.cont.addAttribute(this.cont.getEmptySet(), StyleConstants.Foreground, Color.RED);
    private final AttributeSet attrRegular = this.cont.addAttribute(this.cont.getEmptySet(), StyleConstants.Foreground, Color.WHITE);
    private final AttributeSet attrYellow = this.cont.addAttribute(this.cont.getEmptySet(), StyleConstants.Foreground, Color.YELLOW);

    public IVPConsole() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(FlatUIColors.CONSOLE_COLOR);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setOpaque(false);
        this.scrollPane.setBorder(null);
        this.add(this.scrollPane);
        this.textPane = new JTextPane();
        this.doc = this.textPane.getStyledDocument();
        this.textPane.setFont(new Font("Consolas", 1, 12));
        this.textPane.setOpaque(true);
        this.textPane.setBackground(FlatUIColors.CONSOLE_COLOR);
        this.textPane.setEditable(false);
        this.scrollPane.setViewportView(this.textPane);
        Services.getController().setConsole(this);
    }

    public void println(Object object) {
        this.print(String.valueOf(object) + "\n");
        this.repaint();
    }

    public void print(Object object) {
        try {
            this.doc.insertString(this.doc.getLength(), String.valueOf(object), this.attrRegular);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void printError(Object object) {
        try {
            this.doc.insertString(this.doc.getLength(), ">(!)< ", this.attrYellow);
            this.doc.insertString(this.doc.getLength(), String.valueOf(object) + "\n", this.attrYellow);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void clean() {
        this.textPane.setText("");
    }
}

