/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view;

import javax.swing.JComponent;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.AttributionLine;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Constant;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.DataObject;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Expression;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.For;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Function;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.IfElse;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Operation;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Print;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.ReadData;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Reference;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Variable;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.VariableReference;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.While;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.view.domaingui.variables.IVPVariableBasic;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ArithmeticOperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.AttributionLineUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.BooleanOperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ConstantUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ForUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.FunctionBodyUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IfElseUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.OperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.PrintUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ReadUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.StringOperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.VariableSelectorUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.WhileUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class IVPRenderer {
    public JComponent paint(Object object) {
        DataObject dataObject = (DataObject)Services.getModelMapping().get((String)object);
        if (dataObject instanceof Function) {
            return this.renderFunction((Function)dataObject);
        }
        if (dataObject instanceof Variable) {
            return this.renderVariable((Variable)dataObject);
        }
        if (dataObject instanceof While) {
            return this.renderWhile((While)dataObject);
        }
        if (dataObject instanceof IfElse) {
            return this.renderIfElse((IfElse)dataObject);
        }
        if (dataObject instanceof Print) {
            return this.renderWrite((Print)dataObject);
        }
        if (dataObject instanceof AttributionLine) {
            return this.renderAttributionLine((AttributionLine)dataObject);
        }
        if (dataObject instanceof Expression) {
            return this.renderExpresion((Expression)dataObject);
        }
        if (dataObject instanceof Reference) {
            return this.renderReference((Reference)dataObject);
        }
        if (dataObject instanceof ReadData) {
            return this.renderRead((ReadData)dataObject);
        }
        if (dataObject instanceof For) {
            return this.renderFor((For)dataObject);
        }
        return null;
    }

    private JComponent renderReference(Reference reference) {
        return null;
    }

    private JComponent renderExpresion(Expression expression) {
        if (expression instanceof VariableReference) {
            VariableSelectorUI variableSelectorUI = new VariableSelectorUI(expression.getParentID());
            variableSelectorUI.setModelID(expression.getUniqueID());
            variableSelectorUI.setScopeID(expression.getScopeID());
            Services.getViewMapping().put(expression.getUniqueID(), variableSelectorUI);
            return variableSelectorUI;
        }
        if (expression instanceof Constant) {
            ConstantUI constantUI = new ConstantUI(expression.getUniqueID());
            constantUI.setExpressionType(expression.getExpressionType());
            constantUI.setModelScope(expression.getScopeID());
            Services.getViewMapping().put(expression.getUniqueID(), constantUI);
            return constantUI;
        }
        OperationUI operationUI = expression.getExpressionType() >= 5 && expression.getExpressionType() != 17 && expression.getExpressionType() != 18 ? new BooleanOperationUI(expression.getParentID(), expression.getScopeID(), expression.getUniqueID()) : (expression.getExpressionType() == 17 ? new StringOperationUI(expression.getParentID(), expression.getScopeID(), expression.getUniqueID()) : new ArithmeticOperationUI(expression.getParentID(), expression.getScopeID(), expression.getUniqueID()));
        if (((Operation)expression).getExpressionA() != null && !"".equals(((Operation)expression).getExpressionA())) {
            operationUI.setExpressionBaseUI_1((JComponent)Services.getViewMapping().get(((Operation)expression).getExpressionA()));
        }
        operationUI.setModelScope(expression.getScopeID());
        Services.getViewMapping().put(expression.getUniqueID(), operationUI);
        return operationUI;
    }

    private JComponent renderAttributionLine(AttributionLine attributionLine) {
        AttributionLineUI attributionLineUI = new AttributionLineUI(attributionLine.getUniqueID(), attributionLine.getScopeID(), attributionLine.getParentID());
        attributionLineUI.setModelParent(attributionLine.getParentID());
        attributionLineUI.setModelScope(attributionLine.getScopeID());
        attributionLineUI.setLeftVarModelID(attributionLine.getLeftVariableID());
        Services.getViewMapping().put(attributionLine.getUniqueID(), attributionLineUI);
        return attributionLineUI;
    }

    private JComponent renderWhile(While while_) {
        WhileUI whileUI = new WhileUI(while_.getUniqueID());
        whileUI.setModelParent(while_.getParentID());
        whileUI.setModelScope(while_.getScopeID());
        Services.getViewMapping().put(while_.getUniqueID(), whileUI);
        return whileUI;
    }

    private JComponent renderFor(For for_) {
        ForUI forUI = new ForUI(for_.getUniqueID());
        forUI.setModelParent(for_.getParentID());
        forUI.setModelScope(for_.getScopeID());
        Services.getViewMapping().put(for_.getUniqueID(), forUI);
        return forUI;
    }

    private JComponent renderIfElse(IfElse ifElse) {
        IfElseUI ifElseUI = new IfElseUI(ifElse.getUniqueID());
        ifElseUI.setModelParent(ifElse.getParentID());
        ifElseUI.setModelScope(ifElse.getScopeID());
        Services.getViewMapping().put(ifElse.getUniqueID(), ifElseUI);
        return ifElseUI;
    }

    public FunctionBodyUI renderFunction(Function function) {
        FunctionBodyUI functionBodyUI = function.getFunctionName().equals(ResourceBundleIVP.getString("mainFunctionName")) ? new FunctionBodyUI(function.getUniqueID(), true) : new FunctionBodyUI(function.getUniqueID(), false);
        functionBodyUI.setName(function.getFunctionName());
        functionBodyUI.setType(function.getReturnType());
        Services.getViewMapping().put(function.getUniqueID(), functionBodyUI);
        return functionBodyUI;
    }

    private JComponent renderWrite(Print print) {
        PrintUI printUI = new PrintUI(print.getUniqueID(), print.getParentID(), print.getScopeID());
        Services.getViewMapping().put(print.getUniqueID(), printUI);
        return printUI;
    }

    private JComponent renderRead(ReadData readData) {
        ReadUI readUI = new ReadUI(readData.getUniqueID(), readData.getParentID(), readData.getScopeID());
        Services.getViewMapping().put(readData.getUniqueID(), readUI);
        return readUI;
    }

    private JComponent renderVariable(Variable variable) {
        IVPVariableBasic iVPVariableBasic = new IVPVariableBasic(variable.getUniqueID(), variable.getScopeID());
        iVPVariableBasic.setVariableName(variable.getVariableName());
        Services.getViewMapping().put(variable.getUniqueID(), iVPVariableBasic);
        return iVPVariableBasic;
    }
}

