/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.model.components.datafactory.dataobjetcs;

import ilm.framework.assignment.model.DomainObject;
import java.awt.Point;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Collection;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Variable;
import usp.ime.line.ivprog.model.utils.Services;

public class IVPMatrix
extends Collection {
    private Point dimension = null;
    private String[][] elements = null;
    private int nLines = -1;
    private int nColumns = -1;
    public static final String STRING_CLASS = "matrix";

    public IVPMatrix(String string, String string2) {
        super(string, string2);
    }

    public void setMatrixDimension(Point point) {
        this.nLines = new Double(point.getX()).intValue();
        this.nColumns = new Double(point.getY()).intValue();
        this.elements = new String[this.nLines][this.nColumns];
    }

    public void addToIndexes(Point point, String string) {
        int n = new Double(point.getX()).intValue();
        int n2 = new Double(point.getY()).intValue();
        this.elements[n][n2] = string;
    }

    public String getElementFromIndex(Point point) {
        int n = new Double(point.getX()).intValue();
        int n2 = new Double(point.getY()).intValue();
        return this.elements[n][n2];
    }

    public String removeElementFromIndex(int n, int n2) {
        String string = this.elements[n2][n];
        this.elements[n2][n] = "";
        return string;
    }

    @Override
    public String toXML() {
        String string = "<dataobject class=\"ivpmatrix\"><id>" + this.getUniqueID() + "</id>" + "<collectionname>" + this.getCollectionName() + "</collectionname>" + "<collectiontype>" + this.getCollectionType() + "</collectiontype>" + "<numberoflines>" + this.nLines + "</numberoflines><numberofcolumns>" + this.nColumns + "</numberofcolumns><elements>";
        for (int i = 0; i < this.nLines; ++i) {
            for (int j = 0; j < this.nColumns; ++j) {
                Variable variable = (Variable)Services.getModelMapping().get(this.elements[i][j]);
                string = string + "<A" + i + "" + j + ">" + variable.toXML() + "</A" + i + "" + j + ">";
            }
        }
        string = string + "</elements></dataobject>";
        return string;
    }

    @Override
    public String toJavaString() {
        return null;
    }

    public Point getDimension() {
        return this.dimension;
    }

    public void setDimension(Point point) {
        this.dimension = point;
    }

    @Override
    public boolean equals(DomainObject domainObject) {
        return false;
    }
}

