/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.assignment;

import ilm.framework.assignment.Assignment;
import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.domain.DomainConverter;
import ilm.framework.modules.AssignmentModule;
import java.util.HashMap;
import java.util.Vector;

final class AssignmentParser {
    AssignmentParser() {
    }

    public Assignment convertStringToAssignment(DomainConverter domainConverter, String string) {
        String string2 = this.getProposition(string);
        AssignmentState assignmentState = this.getState(domainConverter, string, "initial");
        AssignmentState assignmentState2 = this.getState(domainConverter, string, "current");
        AssignmentState assignmentState3 = this.getState(domainConverter, string, "expected");
        HashMap hashMap = this.convertStringToMap(string, "config");
        HashMap hashMap2 = this.convertStringToMap(string, "metadata");
        Assignment assignment = new Assignment(string2, assignmentState, assignmentState2, assignmentState3);
        if (string.contains("<test>")) {
            assignment.setTestCase(string.substring(string.indexOf("<test>"), string.length()));
        } else {
            assignment.setTestCase("");
        }
        assignment.setConfig(hashMap);
        assignment.setMetadata(hashMap2);
        return assignment;
    }

    public String getProposition(String string) {
        int n = string.indexOf("<proposition>");
        int n2 = string.indexOf("</proposition>");
        return string.substring(n + 2 + "proposition".length(), n2);
    }

    public AssignmentState getState(DomainConverter domainConverter, String string, String string2) {
        int n;
        AssignmentState assignmentState = new AssignmentState();
        int n2 = string.indexOf("<" + string2 + ">") + 2 + string2.length();
        if (n2 == -1 | (n = string.indexOf("</" + string2 + ">")) == -1) {
            return assignmentState;
        }
        String string3 = string.substring(n2, n);
        Vector vector = domainConverter.convertStringToObject(string3);
        assignmentState.setList(vector);
        return assignmentState;
    }

    public HashMap convertStringToMap(String string, String string2) {
        int n = string2.length();
        int n2 = string.indexOf("<" + string2 + ">");
        int n3 = string.indexOf("</" + string2 + ">");
        String string3 = string.substring(n2, n3 + 3 + n);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n4 = 0;
        n3 = n;
        do {
            n2 = string3.indexOf("<", n3 + 1);
            n4 = string3.indexOf(">", n2) - n2;
            n3 = string3.indexOf("</", n2);
            if (n2 == n3) break;
            hashMap.put(string3.substring(n2 + 1, n2 + n4), string3.substring(n2 + n4 + 1, n3));
        } while (n3 < string3.lastIndexOf("</" + string2 + ">") - n4 - 4);
        return hashMap;
    }

    public String convertAssignmentToString(DomainConverter domainConverter, Assignment assignment) {
        String string = "<atividade>";
        string = string + "<proposition>" + assignment.getProposition() + "</" + "proposition" + ">";
        string = string + "<initial>" + domainConverter.convertObjectToString(assignment.getInitialState().getList()) + "</" + "initial" + ">";
        string = assignment.getCurrentState().getList().size() > 0 ? string + "<current>" + domainConverter.convertObjectToString(assignment.getCurrentState().getList()) + "</" + "current" + ">" : string + "<current/>";
        string = assignment.getExpectedAnswer() != null && assignment.getExpectedAnswer().getList().size() > 0 ? string + "<expected>" + domainConverter.convertObjectToString(assignment.getExpectedAnswer().getList()) + "</" + "expected" + ">" : string + "<expected/>";
        string = string + "<config>" + this.convertMapToString(assignment.getConfig()) + "</" + "config" + ">";
        string = string + "<metadata>" + this.convertMapToString(assignment.getMetadata()) + "</" + "metadata" + ">";
        string = string + "</atividade>";
        string = assignment.getTestCase() != null && !"".equals(assignment.getTestCase()) ? string + "<test>" + assignment.getTestCase() + "</test>" : string + "</test>";
        return string;
    }

    public String convertMapToString(HashMap hashMap) {
        String string = "";
        for (String string2 : hashMap.keySet()) {
            string = string + "<" + string2 + ">" + hashMap.get(string2) + "</" + string2 + ">";
        }
        return string;
    }

    public Vector getAssignmentFileList(String string) {
        int n = "files".length();
        int n2 = string.indexOf("<files>");
        int n3 = string.indexOf("</files>");
        String string2 = string.substring(n2, n3 + 3 + n);
        Vector<String> vector = new Vector<String>();
        int n4 = "atividade".length();
        n3 = 0;
        do {
            n2 = string2.indexOf("<atividade>", n3) + 2 + n4;
            n3 = string2.indexOf("</atividade>", n2);
            vector.add(string2.substring(n2, n3));
        } while (n3 < string2.lastIndexOf("</atividade>"));
        return vector;
    }

    public Vector mergeMetadata(Vector vector, HashMap hashMap) {
        String string = "";
        for (String string2 : hashMap.keySet()) {
            string = string + "<" + string2 + ">" + hashMap.get(string2) + "</" + string2 + ">";
        }
        int n = 0;
        String string3 = "";
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.get(i);
            n = string4.indexOf("<metadata>");
            if (n == -1) {
                string = "<metadata>" + string + "</" + "metadata" + ">";
                string3 = string4.substring(0, string4.indexOf("</package>"));
                string3 = string3 + string + "</" + "package" + ">";
                vector2.add(string3);
                continue;
            }
            int n2 = string4.indexOf("</metadata>");
            string3 = string4.substring(0, n2);
            string3 = string3 + string + "</" + "metadata" + ">" + string4.substring(n2 + 3 + "metadata".length());
            vector2.add(string3);
        }
        return vector2;
    }

    public String createMetadataFileContent(Vector vector, String string) {
        String string2 = "<package>";
        if (vector.size() < 1) {
            return null;
        }
        string2 = string2 + "<files>";
        for (int i = 0; i < vector.size(); ++i) {
            Assignment assignment = (Assignment)vector.get(i);
            string2 = string2 + "<atividade>" + assignment.getName() + "</" + "atividade" + ">";
        }
        string2 = string2 + "</files><config>" + string + "</" + "config" + "><" + "metadata" + ">";
        HashMap hashMap = new HashMap();
        for (int i = 0; i < vector.size(); ++i) {
            Assignment assignment = (Assignment)vector.get(i);
            hashMap = this.mergeMap(hashMap, assignment.getMetadata());
        }
        string2 = string2 + this.convertMapToString(hashMap) + "</" + "metadata" + "></" + "package" + ">";
        return string2;
    }

    private HashMap mergeMap(HashMap hashMap, HashMap hashMap2) {
        for (String string : hashMap2.keySet()) {
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, hashMap2.get(string));
        }
        return hashMap;
    }

    public void setAssignmentModulesData(DomainConverter domainConverter, String string, HashMap hashMap, int n) {
        int n2 = string.indexOf("<modules>");
        int n3 = string.indexOf("</modules>");
        if (n2 == -1 || n3 == -1) {
            return;
        }
        String string2 = string.substring(n2 + "modules".length() + 2, n3);
        String string3 = "";
        for (String string4 : hashMap.keySet()) {
            n2 = string2.indexOf("<" + string4);
            n3 = string2.indexOf("</" + string4);
            string3 = n3 != -1 ? string2.substring(n2 + string4.length() + 2, n3) : "";
            if (!(hashMap.get(string4) instanceof AssignmentModule)) continue;
            ((AssignmentModule)hashMap.get(string4)).setContentFromString(domainConverter, n, string3);
        }
    }

    public String getAssignmentModulesData(DomainConverter domainConverter, String string, HashMap hashMap, int n) {
        String string2 = "<modules>";
        for (String string3 : hashMap.keySet()) {
            if (!(hashMap.get(string3) instanceof AssignmentModule)) continue;
            string2 = string2 + ((AssignmentModule)hashMap.get(string3)).getStringContent(domainConverter, n);
        }
        string2 = string2 + "</modules>";
        int n2 = string.lastIndexOf("</atividade>");
        return string.substring(0, n2) + string2 + string.substring(n2);
    }
}

