/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework.assignment;

import ilm.framework.IlmProtocol;
import ilm.framework.assignment.Assignment;
import ilm.framework.assignment.AssignmentParser;
import ilm.framework.assignment.IAssignment;
import ilm.framework.assignment.IAssignmentOperator;
import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.comm.ICommunication;
import ilm.framework.config.SystemConfig;
import ilm.framework.domain.DomainConverter;
import ilm.framework.domain.DomainModel;
import ilm.framework.modules.AssignmentModule;
import ilm.framework.modules.IlmModule;
import ilm.framework.modules.assignment.HistoryModule;
import ilm.framework.modules.assignment.ObjectListModule;
import ilm.framework.modules.assignment.UndoRedoModule;
import ilm.framework.modules.operation.AutomaticCheckingModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipFile;
import usp.ime.line.ivprog.modules.configuration.ConfigurationModule;

public final class AssignmentControl
implements IAssignment,
IAssignmentOperator,
IlmProtocol {
    private SystemConfig _config;
    private DomainModel _model;
    private DomainConverter _converter;
    private ICommunication _comm;
    private Vector _assignmentList;
    private HashMap _moduleList;

    public AssignmentControl(SystemConfig systemConfig, ICommunication iCommunication, DomainModel domainModel, DomainConverter domainConverter) {
        this._config = systemConfig;
        this._comm = iCommunication;
        this._model = domainModel;
        this._converter = domainConverter;
        this.initModuleList();
        this.initAssignments();
    }

    private void initModuleList() {
        this._moduleList = new HashMap();
        AutomaticCheckingModule automaticCheckingModule = new AutomaticCheckingModule(this, this);
        automaticCheckingModule.setModel(this._model);
        this.addModule(automaticCheckingModule);
        this.addModule(new UndoRedoModule());
        this.addModule(new HistoryModule());
        this.addModule(new ObjectListModule());
        if (!this._config.isApplet()) {
            this.addModule(new ConfigurationModule());
        }
        System.out.println("ilm/framework/assignment/AssignmentControl.java: initModuleList(): _config.isApplet=" + this._config.isApplet());
    }

    public void addModule(IlmModule ilmModule) {
        this._moduleList.put(ilmModule.getName(), ilmModule);
    }

    private void initAssignments() {
        int n;
        try {
            n = Integer.parseInt(this._config.getValue("iLM_PARAM_NumberOfAssigments"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this._assignmentList = new Vector();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string = this._config.getValue("iLM_PARAM_AssignmentURL_" + i);
                this.getConfigFromMetadataFile(this.loadMetadataFile(string));
                this._assignmentList.addAll(this.createAssignments(this.loadAssignmentFiles(string)));
            }
        } else {
            this._assignmentList.add(this.createNewAssignment());
        }
    }

    private Vector createAssignments(Vector vector) {
        Vector<Assignment> vector2 = new Vector<Assignment>();
        AssignmentParser assignmentParser = new AssignmentParser();
        int n = this.getNumberOfAssignments();
        for (int i = 0; i < vector.size(); ++i) {
            Assignment assignment = assignmentParser.convertStringToAssignment(this._converter, (String)vector.get(i));
            vector2.add(assignment);
            if (assignment.getExpectedAnswer() == null || assignment.getExpectedAnswer().getList().size() < 1 || !assignment.getInitialState().equals(assignment.getCurrentState())) {
                assignmentParser.setAssignmentModulesData(this._converter, (String)vector.get(i), this._moduleList, i + n);
            } else {
                this.addAssignmentToModules();
            }
            this.setModulesAssignment(assignment);
        }
        return vector2;
    }

    private Assignment createNewAssignment() {
        AssignmentState assignmentState = this._model.getNewAssignmentState();
        Assignment assignment = new Assignment("", assignmentState, assignmentState, null);
        this.addAssignmentToModules();
        this.setModulesAssignment(assignment);
        return assignment;
    }

    private void addAssignmentToModules() {
        for (String string : this._moduleList.keySet()) {
            if (!(this._moduleList.get(string) instanceof AssignmentModule)) continue;
            ((AssignmentModule)this._moduleList.get(string)).addAssignment();
        }
    }

    private void setModulesAssignment(Assignment assignment) {
        for (String string : this._moduleList.keySet()) {
            if (!(this._moduleList.get(string) instanceof AssignmentModule)) continue;
            if (((AssignmentModule)this._moduleList.get(string)).getObserverType() != 1) {
                assignment.getCurrentState().addObserver((AssignmentModule)this._moduleList.get(string));
            }
            if (((AssignmentModule)this._moduleList.get(string)).getObserverType() != 2) {
                ((AssignmentModule)this._moduleList.get(string)).setDomainModel(this._model);
                ((AssignmentModule)this._moduleList.get(string)).setActionObservers(this._moduleList.values());
            }
            ((AssignmentModule)this._moduleList.get(string)).setState(assignment.getCurrentState());
        }
    }

    private String loadMetadataFile(String string) {
        try {
            return this._comm.readMetadataFile(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void getConfigFromMetadataFile(String string) {
        AssignmentParser assignmentParser = new AssignmentParser();
        HashMap hashMap = assignmentParser.convertStringToMap(string, "config");
        for (String string2 : hashMap.keySet()) {
            this._config.setParameter(string2, (String)hashMap.get(string2));
        }
    }

    private Vector loadAssignmentFiles(String string) {
        AssignmentParser assignmentParser = new AssignmentParser();
        String string2 = this.loadMetadataFile(string);
        Vector vector = assignmentParser.getAssignmentFileList(string2);
        HashMap hashMap = assignmentParser.convertStringToMap(string2, "metadata");
        try {
            Vector vector2 = this._comm.readAssignmentFiles(string, vector);
            Vector vector3 = assignmentParser.mergeMetadata(vector2, hashMap);
            return vector3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public ZipFile saveAssignmentPackage(Vector vector, String string) {
        AssignmentParser assignmentParser = new AssignmentParser();
        String string2 = assignmentParser.createMetadataFileContent(vector, this._config.toString());
        Vector vector2 = assignmentParser.getAssignmentFileList(string2);
        Vector<String> vector3 = new Vector<String>();
        String string3 = "";
        for (int i = 0; i < vector.size(); ++i) {
            string3 = assignmentParser.convertAssignmentToString(this._converter, (Assignment)vector.get(i));
            if (((Assignment)vector.get(i)).getExpectedAnswer() == null || ((Assignment)vector.get(i)).getExpectedAnswer().getList().size() < 1 || !((Assignment)vector.get(i)).getInitialState().equals(((Assignment)vector.get(i)).getCurrentState())) {
                string3 = assignmentParser.getAssignmentModulesData(this._converter, string3, this._moduleList, i);
            }
            vector3.add(string3);
        }
        try {
            return this._comm.writeAssignmentPackage(string, string2, null, null, vector2, vector3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public int openAssignmentPackage(String string) {
        int n = this._assignmentList.size();
        Vector vector = this.loadAssignmentFiles(string);
        Vector vector2 = this.createAssignments(vector);
        this._assignmentList.addAll(vector2);
        this.getConfigFromMetadataFile(this.loadMetadataFile(string));
        return n;
    }

    public int openAssignmentPackageFromURL(String string) {
        AssignmentParser assignmentParser = new AssignmentParser();
        HashMap hashMap = assignmentParser.convertStringToMap(string.substring(0, string.lastIndexOf("</package>")), "metadata");
        int n = this._assignmentList.size();
        Vector<String> vector = new Vector<String>();
        vector.add(string.substring(string.lastIndexOf("</package>"), string.length()));
        Vector vector2 = this.createAssignments(vector);
        this._assignmentList.addAll(vector2);
        this.getConfigFromMetadataFile(string.substring(0, string.lastIndexOf("</package>")));
        return n;
    }

    @Override
    public AssignmentState newAssignment() {
        Assignment assignment = this.createNewAssignment();
        this._assignmentList.add(assignment);
        return assignment.getCurrentState();
    }

    @Override
    public void closeAssignment(int n) {
        this._assignmentList.remove(n);
        for (String string : this._moduleList.keySet()) {
            if (!(this._moduleList.get(string) instanceof AssignmentModule)) continue;
            ((AssignmentModule)this._moduleList.get(string)).removeAssignment(n);
        }
    }

    @Override
    public int getNumberOfAssignments() {
        return this._assignmentList.size();
    }

    @Override
    public HashMap getIlmModuleList() {
        return this._moduleList;
    }

    @Override
    public AssignmentState getCurrentState(int n) {
        return ((Assignment)this._assignmentList.get(n)).getCurrentState();
    }

    @Override
    public AssignmentState getInitialState(int n) {
        return ((Assignment)this._assignmentList.get(n)).getInitialState();
    }

    @Override
    public AssignmentState getExpectedAnswer(int n) {
        return ((Assignment)this._assignmentList.get(n)).getExpectedAnswer();
    }

    @Override
    public HashMap getConfig(int n) {
        return ((Assignment)this._assignmentList.get(n)).getConfig();
    }

    @Override
    public HashMap getMetadata(int n) {
        return ((Assignment)this._assignmentList.get(n)).getMetadata();
    }

    @Override
    public String getProposition(int n) {
        return ((Assignment)this._assignmentList.get(n)).getProposition();
    }

    @Override
    public DomainConverter getConverter() {
        return this._converter;
    }

    @Override
    public ICommunication getFileRW() {
        return this._comm;
    }

    public void print() {
        for (int i = 0; i < this._assignmentList.size(); ++i) {
            Object object = (Assignment)this._assignmentList.get(i);
            ((Assignment)object).print();
        }
        for (Object object : this._moduleList.keySet()) {
            ((IlmModule)this._moduleList.get(object)).print();
        }
    }

    @Override
    public float getEvaluation() {
        return ((AutomaticCheckingModule)this._moduleList.get("automatic_checking")).getEvaluation();
    }

    @Override
    public String getAnswer() {
        AssignmentParser assignmentParser = new AssignmentParser();
        String string = assignmentParser.createMetadataFileContent(this._assignmentList, this._config.toString());
        Vector vector = assignmentParser.getAssignmentFileList(string);
        Vector<String> vector2 = new Vector<String>();
        String string2 = "";
        for (int i = 0; i < this._assignmentList.size(); ++i) {
            string2 = assignmentParser.convertAssignmentToString(this._converter, (Assignment)this._assignmentList.get(i));
            if (((Assignment)this._assignmentList.get(i)).getExpectedAnswer() == null || ((Assignment)this._assignmentList.get(i)).getExpectedAnswer().getList().size() < 1 || !((Assignment)this._assignmentList.get(i)).getInitialState().equals(((Assignment)this._assignmentList.get(i)).getCurrentState())) {
                string2 = assignmentParser.getAssignmentModulesData(this._converter, string2, this._moduleList, i);
            }
            vector2.add(string2);
        }
        String string3 = string;
        for (int i = 0; i < vector.size(); ++i) {
            string3 = string3 + vector2.get(i);
        }
        return string3;
    }

    @Override
    public ZipFile getAssignmentPackage() {
        String string = "namehere";
        return this.saveAssignmentPackage(this._assignmentList, string);
    }

    public Vector get_assignmentList() {
        return this._assignmentList;
    }

    public void set_assignmentList(Vector vector) {
        this._assignmentList = vector;
    }
}

