/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import usp.ime.line.ivprog.listeners.IVariableListener;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.DataObject;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Function;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.Variable;
import usp.ime.line.ivprog.model.components.datafactory.dataobjetcs.VariableReference;
import usp.ime.line.ivprog.model.utils.Services;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.FlatUIColors;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.AttributionLineUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.BooleanOperationUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionHolderUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.IDomainObjectUI;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.OperationUI;
import usp.ime.line.ivprog.view.utils.language.ResourceBundleIVP;

public class VariableSelectorUI
extends JPanel
implements IVariableListener,
IDomainObjectUI {
    public static final Color borderColor = new Color(230, 126, 34);
    public static final Color hoverColor = FlatUIColors.HOVER_COLOR;
    private String currentModelID;
    private String parentModelID;
    private String scopeModelID;
    private String referencedID;
    private String context;
    private String lastRemoved = "";
    private JComboBox varList;
    private TreeMap indexMap;
    private JLabel nameLabel;
    private JLabel icon;
    private boolean isUpdate = true;
    private boolean warningState = false;
    private boolean isOnlyOneElement = false;
    private boolean isIsolated = false;
    private boolean drawBorder = true;
    private boolean editState = true;
    private short referencedType = (short)-1;

    public VariableSelectorUI(String string) {
        this.parentModelID = string;
        this.initialization();
        this.initComponents();
        Services.getController().getProgram().addVariableListener(this);
    }

    private void initialization() {
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(3);
        flowLayout.setHgap(3);
        this.setLayout(flowLayout);
        this.addMouseListener(new ExpressionMouseListener(this));
        this.setBackground(FlatUIColors.MAIN_BG);
    }

    private void initComponents() {
        this.initVector();
        this.initLabel();
        this.initConfigMenu();
    }

    private void initVector() {
        this.indexMap = new TreeMap();
    }

    private void initLabel() {
        this.nameLabel = new JLabel(ResourceBundleIVP.getString("variableSelectorInitialLabel"));
        this.nameLabel.setForeground(FlatUIColors.CHANGEABLE_ITEMS_COLOR);
        this.add(this.nameLabel);
    }

    private void initConfigMenu() {
        this.varList = new JComboBox();
        this.varList.setVisible(false);
        this.initValues();
        this.varList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!VariableSelectorUI.this.isUpdate) {
                    Tracking.track("event=CLICK;where=BTN_VARIABLE_SELECTOR;");
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                        String string;
                        if (VariableSelectorUI.this.isIsolated) {
                            VariableSelectorUI.this.editStateOff((String)object);
                        }
                        if (!"".equals(string = VariableSelectorUI.this.getNewVarID())) {
                            Services.getController().updateVariableReference(VariableSelectorUI.this.currentModelID, string);
                        }
                        if (VariableSelectorUI.this.warningState) {
                            VariableSelectorUI.this.turnWaningStateOFF();
                        }
                    }
                }
            }
        });
        this.add(this.varList);
    }

    private String getNewVarID() {
        Function function = (Function)Services.getModelMapping().get(this.scopeModelID);
        Vector vector = function.getLocalVariableMap().toVector();
        String string = (String)this.varList.getSelectedItem();
        for (int i = 0; i < vector.size(); ++i) {
            Variable variable = (Variable)Services.getModelMapping().get(vector.get(i));
            String string2 = this.getVariableViewName(variable);
            if (!string2.equals(string)) continue;
            return variable.getUniqueID();
        }
        return null;
    }

    private String getVariableViewName(Variable variable) {
        String string = variable.getVariableName();
        if (string.contains("#@ivprog@#!")) {
            string = string.substring(string.indexOf("!") + 1);
        }
        return string;
    }

    private void initValues() {
        String string = this.parentModelID;
        if (string.contains("_")) {
            string = this.parentModelID.substring(0, this.parentModelID.indexOf("_"));
        }
        DataObject dataObject = (DataObject)Services.getModelMapping().get(string);
        Function function = (Function)Services.getModelMapping().get(dataObject.getScopeID());
        Vector vector = function.getLocalVariableMap().toVector();
        for (int i = 0; i < vector.size(); ++i) {
            Variable variable = (Variable)Services.getModelMapping().get(vector.get(i));
            String string2 = this.getVariableViewName(variable);
            this.indexMap.put(variable.getUniqueID(), string2);
        }
        this.isUpdate = true;
        this.updateVariableList("", "");
        this.isUpdate = false;
    }

    private void updateValuesFromVariableList() {
        if (!this.isIsolated && this.referencedType != -1 && this.referencedType != 0) {
            Function function = (Function)Services.getModelMapping().get(this.getScopeID());
            Vector vector = function.getLocalVariableMap().toVector();
            this.indexMap = new TreeMap();
            for (int i = 0; i < vector.size(); ++i) {
                Variable variable = (Variable)Services.getModelMapping().get(vector.get(i));
                String string = this.getVariableViewName(variable);
                if (this.referencedType == variable.getVariableType()) {
                    this.indexMap.put(variable.getUniqueID(), string);
                    continue;
                }
                if (this.referencedType != 14 || variable.getVariableType() != 13) continue;
                this.indexMap.put(variable.getUniqueID(), string);
            }
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
        }
    }

    @Override
    public void addedVariable(String string) {
        Variable variable = (Variable)Services.getModelMapping().get(string);
        String string2 = "";
        if (this.isIsolated) {
            string2 = this.getVariableViewName(variable);
            this.indexMap.put(string, string2);
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
        } else if (variable.getVariableType() == this.referencedType) {
            string2 = this.getVariableViewName(variable);
            this.indexMap.put(string, string2);
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
        } else if (this.referencedType == -1 || this.referencedType == 0) {
            string2 = this.getVariableViewName(variable);
            this.indexMap.put(string, string2);
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
        }
    }

    @Override
    public void changeVariable(String string) {
    }

    @Override
    public void removedVariable(String string) {
        String string2 = this.getVariableViewName((Variable)Services.getModelMapping().get(string));
        if (this.indexMap.containsKey(string)) {
            this.indexMap.put(string, null);
            if (this.isIsolated) {
                if (this.nameLabel.isVisible() && this.nameLabel.getText().equals(string2)) {
                    this.lastRemoved = string2;
                    this.turnWaningStateON();
                }
            } else if (string2.equals(this.varList.getSelectedItem())) {
                if (this.isEditState()) {
                    this.lastRemoved = string2;
                    this.turnWaningStateON();
                } else {
                    if (Services.getModelMapping().get(this.parentModelID) instanceof ExpressionHolderUI) {
                        ((ExpressionHolderUI)Services.getModelMapping().get(this.parentModelID)).warningStateOn();
                    }
                    this.lastRemoved = string2;
                    this.turnWaningStateON();
                }
            }
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
        }
    }

    @Override
    public void changeVariableName(String string, String string2, String string3) {
        if (this.indexMap.containsKey(string)) {
            this.isUpdate = true;
            this.indexMap.put(string, string2);
            this.updateVariableList(string2, string3);
            this.isUpdate = false;
            if (this.nameLabel.isVisible() && this.nameLabel.getText().equals(string3)) {
                this.nameLabel.setText(string2);
                this.nameLabel.revalidate();
                this.nameLabel.repaint();
            }
        }
    }

    @Override
    public void updateReference(String string) {
        if (string.equals(this.currentModelID)) {
            String string2 = ((VariableReference)Services.getModelMapping().get(string)).getReferencedName();
            this.isUpdate = true;
            this.varList.setSelectedItem(string2);
            this.isUpdate = false;
            if (this.referencedType == 0 || this.referencedType == -1) {
                this.referencedType = ((Variable)Services.getModelMapping().get(this.getNewVarID())).getVariableType();
                this.updateValuesFromVariableList();
                this.isUpdate = true;
                this.updateVariableList("", "");
                this.isUpdate = false;
            }
            if (this.isIsolated) {
                this.editStateOff(string2);
                if (Services.getViewMapping().get(this.parentModelID) instanceof AttributionLineUI) {
                    if ("".equals(string2) || string2 == null) {
                        ((AttributionLineUI)Services.getViewMapping().get(this.parentModelID)).setLeftVarSet(false);
                        this.drawBorder = true;
                        this.setBackground(FlatUIColors.MAIN_BG);
                    } else {
                        this.drawBorder = false;
                        this.setBackground(FlatUIColors.CODE_BG);
                        ((AttributionLineUI)Services.getViewMapping().get(this.parentModelID)).setLeftVarSet(true);
                        this.referencedType = ((Variable)Services.getModelMapping().get(this.getNewVarID())).getVariableType();
                    }
                }
            } else {
                if (this.nameLabel.isVisible() && !"".equals(string2) && string2 != null) {
                    this.nameLabel.setText(string2);
                    this.nameLabel.revalidate();
                    this.nameLabel.repaint();
                    this.setBackground(FlatUIColors.MAIN_BG);
                } else {
                    this.nameLabel.setText(ResourceBundleIVP.getString("variableSelectorInitialLabel"));
                    this.nameLabel.revalidate();
                    this.nameLabel.repaint();
                    this.setBackground(FlatUIColors.CODE_BG);
                }
                if (Services.getViewMapping().get(this.parentModelID) instanceof OperationUI) {
                    if (this.getNewVarID() != null && !"".equals(this.getNewVarID())) {
                        ((OperationUI)Services.getViewMapping().get(this.parentModelID)).setExpressionType(((Variable)Services.getModelMapping().get(this.getNewVarID())).getVariableType());
                    } else if (Services.getViewMapping().get(this.parentModelID) instanceof BooleanOperationUI && !((BooleanOperationUI)Services.getViewMapping().get(this.parentModelID)).isBothContentSet()) {
                        ((OperationUI)Services.getViewMapping().get(this.parentModelID)).setExpressionType((short)-1);
                        this.referencedType = (short)-1;
                        this.initValues();
                        this.isUpdate = true;
                        this.updateVariableList("", "");
                        this.isUpdate = false;
                    }
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void changeVariableType(String string, short s) {
        Variable variable = (Variable)Services.getModelMapping().get(string);
        if (this.isIsolated) {
            if (this.getVariableViewName(variable).equals(this.nameLabel.getText()) && this.nameLabel.isVisible()) {
                this.referencedType = s;
            }
        } else if (this.indexMap.containsValue(variable.getVariableName())) {
            if (this.getVariableViewName(variable).equals(this.nameLabel.getText()) && this.nameLabel.isVisible() || !this.nameLabel.isVisible() && this.getVariableViewName(variable).equals(this.varList.getSelectedItem())) {
                this.lastRemoved = variable.getVariableName();
                this.updateValuesFromVariableList();
                this.turnWaningStateON();
            } else {
                this.updateValuesFromVariableList();
            }
        } else if (variable.getVariableType() == this.referencedType) {
            this.indexMap.put(variable.getUniqueID(), this.getVariableViewName(variable));
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
            if (this.getVariableViewName(variable).equals(this.lastRemoved)) {
                this.turnWaningStateOFF();
                this.isUpdate = true;
                this.varList.setSelectedItem(this.lastRemoved);
                this.isUpdate = false;
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void variableRestored(String string) {
        String string2 = this.getVariableViewName((Variable)Services.getModelMapping().get(string));
        if (this.indexMap.containsKey(string)) {
            this.indexMap.put(string, string2);
            this.isUpdate = true;
            this.updateVariableList("", "");
            this.isUpdate = false;
            if (this.isIsolated) {
                if (this.nameLabel.isVisible()) {
                    if (this.lastRemoved.equals(string2)) {
                        this.nameLabel.setText(string2);
                        this.turnWaningStateOFF();
                    }
                } else if (this.lastRemoved.equals(string2)) {
                    this.turnWaningStateOFF();
                    this.isUpdate = true;
                    this.varList.setSelectedItem(this.lastRemoved);
                    this.isUpdate = false;
                }
            } else if (this.lastRemoved.equals(string2)) {
                this.turnWaningStateOFF();
                this.isUpdate = true;
                this.varList.setSelectedItem(this.lastRemoved);
                this.isUpdate = false;
            }
            this.lastRemoved = "";
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void changeVariableValue(String string, String string2) {
    }

    public void editStateOn() {
        this.varList.setVisible(true);
        this.nameLabel.setVisible(false);
        this.drawBorder = false;
        if (this.getParent() instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)this.getParent()).editStateOn();
        }
        if (!this.isIsolated) {
            this.editState = true;
        }
        this.revalidate();
        this.repaint();
    }

    public void editStateOff(String string) {
        this.varList.setVisible(false);
        if (string != null && !"".equals(string)) {
            this.nameLabel.setText(string);
        } else {
            this.nameLabel.setText(ResourceBundleIVP.getString("variableSelectorInitialLabel"));
        }
        this.nameLabel.setVisible(true);
        if (this.getParent() instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)this.getParent()).editStateOff();
        }
        if (!this.isIsolated) {
            this.editState = false;
        }
        this.revalidate();
        this.repaint();
    }

    private void turnWaningStateON() {
        this.warningState = true;
        if (Services.getViewMapping().get(this.parentModelID) instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)Services.getViewMapping().get(this.parentModelID)).warningStateOn();
        } else if (Services.getViewMapping().get(this.parentModelID) instanceof OperationUI) {
            ((OperationUI)Services.getViewMapping().get(this.parentModelID)).enableEdition();
        }
        this.editStateOn();
        this.varList.setBorder(BorderFactory.createLineBorder(Color.red));
        this.revalidate();
        this.repaint();
    }

    private void turnWaningStateOFF() {
        this.warningState = false;
        if (Services.getViewMapping().get(this.parentModelID) instanceof ExpressionHolderUI) {
            ((ExpressionHolderUI)Services.getViewMapping().get(this.parentModelID)).warningStateOFF();
        }
        this.varList.setBorder(null);
        this.revalidate();
        this.repaint();
    }

    private void updateVariableList(String string, String string2) {
        String string3;
        int n;
        Object object = this.varList.getSelectedItem();
        this.varList.removeAllItems();
        Object[] objectArray = this.indexMap.keySet().toArray();
        int n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            string3 = (String)this.indexMap.get(objectArray[n]);
            if (string3 == null || string3.equals("")) continue;
            ++n2;
        }
        this.isOnlyOneElement = n2 == 1;
        for (n = 0; n < objectArray.length; ++n) {
            string3 = (String)this.indexMap.get(objectArray[n]);
            if (string3 == null || string3.equals("")) continue;
            this.varList.addItem(string3);
        }
        if (string2.equals(object)) {
            this.varList.setSelectedItem(string);
        } else {
            this.varList.setSelectedItem(object);
        }
    }

    public String getScopeID() {
        return this.scopeModelID;
    }

    public void setScopeID(String string) {
        this.scopeModelID = string;
    }

    public String getCurrentModelID() {
        return this.currentModelID;
    }

    public void setCurrentModelID(String string) {
        this.currentModelID = string;
    }

    @Override
    public String getModelID() {
        return this.currentModelID;
    }

    @Override
    public String getModelParent() {
        return this.parentModelID;
    }

    @Override
    public String getModelScope() {
        return this.scopeModelID;
    }

    @Override
    public void setModelID(String string) {
        this.currentModelID = string;
    }

    @Override
    public void setModelParent(String string) {
        this.parentModelID = string;
    }

    @Override
    public void setModelScope(String string) {
        this.scopeModelID = string;
    }

    @Override
    public void setContext(String string) {
        this.context = string;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public boolean isEditState() {
        return this.editState;
    }

    public void setEditState(boolean bl) {
        this.editState = bl;
    }

    public String getVarListSelectedItem() {
        return (String)this.varList.getSelectedItem();
    }

    public void setIsolationMode(boolean bl) {
        this.isIsolated = bl;
        this.setBackground(FlatUIColors.MAIN_BG);
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public short referenceType() {
        return ((Variable)Services.getModelMapping().get(this.getNewVarID())).getVariableType();
    }

    public short getReferencedType() {
        return this.referencedType;
    }

    public void setReferencedType(short s) {
        this.referencedType = s;
        this.updateValuesFromVariableList();
        this.isUpdate = true;
        this.updateVariableList("", "");
        this.isUpdate = false;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.drawBorder) {
            int n;
            FlowLayout flowLayout = (FlowLayout)this.getLayout();
            flowLayout.setVgap(3);
            flowLayout.setHgap(3);
            this.revalidate();
            graphics.setColor(borderColor);
            Rectangle rectangle = this.getBounds();
            for (n = 0; n < rectangle.width; n += 6) {
                graphics.drawLine(n, 0, n + 3, 0);
                graphics.drawLine(n + 3, rectangle.height - 1, n + 6, rectangle.height - 1);
            }
            for (n = 0; n < rectangle.height; n += 6) {
                graphics.drawLine(0, n, 0, n + 3);
                graphics.drawLine(rectangle.width - 1, n + 3, rectangle.width - 1, n + 6);
            }
        } else {
            FlowLayout flowLayout = (FlowLayout)this.getLayout();
            flowLayout.setVgap(0);
            flowLayout.setHgap(0);
        }
    }

    @Override
    public boolean isContentSet() {
        boolean bl = true;
        if (this.nameLabel.isVisible() && this.nameLabel.getText().equals(ResourceBundleIVP.getString("variableSelectorInitialLabel"))) {
            bl = false;
            this.turnWaningStateON();
        }
        if (!this.nameLabel.isVisible() && ("".equals(this.varList.getSelectedItem()) || this.varList.getSelectedItem() == null) && bl) {
            bl = false;
            this.turnWaningStateON();
        }
        return bl;
    }

    @Override
    public void lockDownCode() {
        this.editStateOff(this.getVarListSelectedItem());
    }

    private class ExpressionMouseListener
    implements MouseListener {
        private JPanel container;
        private int clickCounter = 0;

        public ExpressionMouseListener(JPanel jPanel) {
            this.container = jPanel;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (VariableSelectorUI.this.editState || VariableSelectorUI.this.isIsolated) {
                VariableSelectorUI.this.setBackground(hoverColor);
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (VariableSelectorUI.this.editState || VariableSelectorUI.this.isIsolated) {
                if (VariableSelectorUI.this.drawBorder) {
                    VariableSelectorUI.this.setBackground(FlatUIColors.MAIN_BG);
                } else {
                    VariableSelectorUI.this.setBackground(FlatUIColors.CODE_BG);
                }
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (VariableSelectorUI.this.editState) {
                VariableSelectorUI.this.setBorder(null);
                VariableSelectorUI.this.revalidate();
                VariableSelectorUI.this.repaint();
                VariableSelectorUI.this.editStateOn();
                VariableSelectorUI.this.varList.requestFocus();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

