/*
 * Decompiled with CFR 0.152.
 */
package usp.ime.line.ivprog.view.domaingui.workspace.codecomponents;

import ilm.framework.assignment.model.DomainAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import usp.ime.line.ivprog.model.utils.Tracking;
import usp.ime.line.ivprog.view.domaingui.workspace.codecomponents.ExpressionHolderUI;
import usp.ime.line.ivprog.view.utils.IconButtonUI;

public class ExpressionFieldUI
extends JPanel {
    private JButton btnEdit;
    private ExpressionHolderUI expressionHolderUI;
    private ImageIcon open;
    private ImageIcon closed;
    private JLabel lockerIcon;
    private boolean isEditing = true;
    private boolean isBlocked = false;

    public static void printParents(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            System.out.println(" " + component2.toString());
        }
    }

    public ExpressionFieldUI(String string, String string2) {
        if (DomainAction.getExecutingInSilence()) {
            this.isEditing = false;
            this.isBlocked = true;
        }
        this.initLayout();
        this.initExpressionHolder(string, string2);
        this.initEditionBtn();
    }

    private void initEditionBtn() {
        this.open = new ImageIcon(ExpressionFieldUI.class.getResource("/usp/ime/line/resources/icons/locker_opened.png"));
        this.closed = new ImageIcon(ExpressionFieldUI.class.getResource("/usp/ime/line/resources/icons/locker_closed.png"));
        this.lockerIcon = new JLabel();
        if (this.isEditing) {
            this.lockerIcon.setIcon(this.open);
        } else {
            this.lockerIcon.setIcon(this.closed);
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracking.track("event=CLICK;where=BTN_CODE_EDITIONLOCKER_" + ExpressionFieldUI.this.isBlocked + ";");
                if (!ExpressionFieldUI.this.isBlocked) {
                    if (ExpressionFieldUI.this.isEditing) {
                        ExpressionFieldUI.this.expressionHolderUI.disableEdition();
                        ExpressionFieldUI.this.isEditing = false;
                        ExpressionFieldUI.this.lockerIcon.setIcon(ExpressionFieldUI.this.closed);
                        ExpressionFieldUI.this.lockerIcon.repaint();
                    } else {
                        ExpressionFieldUI.this.expressionHolderUI.enableEdition();
                        ExpressionFieldUI.this.isEditing = true;
                        ExpressionFieldUI.this.lockerIcon.setIcon(ExpressionFieldUI.this.open);
                        ExpressionFieldUI.this.lockerIcon.repaint();
                    }
                }
            }
        };
        this.btnEdit = new JButton(abstractAction);
        this.btnEdit.add(this.lockerIcon);
        this.btnEdit.setIcon(new ImageIcon(ExpressionFieldUI.class.getResource("/usp/ime/line/resources/icons/pog.png")));
        this.btnEdit.setUI(new IconButtonUI());
        this.add(this.btnEdit);
    }

    private void initExpressionHolder(String string, String string2) {
        this.expressionHolderUI = new ExpressionHolderUI(string, string2);
        this.add(this.expressionHolderUI);
    }

    private void initLayout() {
        this.setOpaque(false);
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setAlignment(0);
        flowLayout.setVgap(1);
        flowLayout.setHgap(1);
    }

    public void setHolderContent(JComponent jComponent) {
        this.expressionHolderUI.setExpression(jComponent);
    }

    public void setComparison(boolean bl) {
        this.expressionHolderUI.setComparison(bl);
    }

    public void setEdition(boolean bl) {
        if (bl) {
            this.lockerIcon.setIcon(this.open);
            this.expressionHolderUI.enableEdition();
        } else {
            this.lockerIcon.setIcon(this.closed);
            this.expressionHolderUI.disableEdition();
        }
        this.isEditing = bl;
    }

    public boolean isEdition() {
        return this.isEditing;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean bl) {
        this.isBlocked = bl;
    }

    public void setHoldingType(short s) {
        this.expressionHolderUI.setHoldingType(s);
    }

    public short getHoldingType() {
        return this.expressionHolderUI.getHoldingType();
    }

    public void hideMenu(boolean bl) {
        this.expressionHolderUI.setHideMenu(bl);
    }

    public void setForHeader(boolean bl) {
        this.expressionHolderUI.setForHeader(bl);
    }

    public void setForContext(String string) {
        this.expressionHolderUI.setForContext(string);
    }

    public boolean isContentSet() {
        boolean bl = true;
        if (!this.expressionHolderUI.isCSet()) {
            bl = false;
        }
        return bl;
    }
}

