/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework;

import ilm.framework.IlmProtocol;
import ilm.framework.SystemFactory;
import ilm.framework.assignment.AssignmentControl;
import ilm.framework.comm.CommControl;
import ilm.framework.config.AppletParameterListParser;
import ilm.framework.config.IParameterListParser;
import ilm.framework.config.ParameterListParser;
import ilm.framework.config.SystemConfig;
import ilm.framework.gui.BaseGUI;
import java.io.File;
import java.util.Map;

public final class SystemControl {
    private SystemConfig _config;
    private AssignmentControl _assignmentControl;
    private CommControl _comm;
    private BaseGUI _gui;
    private boolean isApplet = false;

    public SystemConfig getSystemConfig() {
        return this._config;
    }

    private static void listParameters(String[] stringArray) {
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        System.out.println("./ilm/framework/SystemControl.java: listParameters = ");
        for (int i = 0; i < n; ++i) {
            System.out.println(" " + i + ": " + stringArray[i]);
        }
    }

    private static boolean isFile(String string) {
        File file = new File(string);
        return file.exists() && !file.isDirectory();
    }

    private static String isFileParameter(boolean bl, String[] stringArray) {
        int n = 0;
        if (bl) {
            return null;
        }
        if (stringArray != null) {
            n = stringArray.length;
        }
        System.out.println("./ilm/framework/SystemControl.java: isFileParameter(...): ");
        for (int i = 0; i < n; ++i) {
            if (!SystemControl.isFile(stringArray[i])) continue;
            return stringArray[i];
        }
        return null;
    }

    public void initialize(boolean bl, String[] stringArray, SystemFactory systemFactory) {
        IParameterListParser iParameterListParser;
        this.isApplet = bl;
        String string = null;
        if (bl) {
            iParameterListParser = new AppletParameterListParser();
        } else {
            iParameterListParser = new ParameterListParser();
            string = SystemControl.isFileParameter(bl, stringArray);
        }
        Map map = iParameterListParser.Parse(stringArray);
        if (string != null) {
            map.put("file", string);
        }
        this._config = new SystemConfig(bl, map);
        if (!bl) {
            try {
                System.out.println("./ilm/framework/SystemControl.java: initialize: file=" + map.get("file"));
                this._config.getParameters().list(System.out);
            }
            catch (Exception exception) {
                System.err.println("./ilm/framework/SystemControl.java: initialize: error in debug print properties!");
            }
        }
        this.initComponents(systemFactory);
    }

    private void initComponents(SystemFactory systemFactory) {
        this._comm = systemFactory.createCommControl(this._config);
        this._assignmentControl = systemFactory.createAssignmentControl(this._config, this._comm, systemFactory.getDomainModel(this._config), systemFactory.getDomainConverter());
        this._gui = systemFactory.createBaseGUI(this._config, this._assignmentControl, systemFactory);
    }

    public IlmProtocol getProtocol() {
        return this._assignmentControl;
    }

    public CommControl getCommunicationControl() {
        return this._comm;
    }

    public void startDesktopGUI() {
        this._gui.initGUI(false);
        this._gui.startDesktop();
    }

    public BaseGUI getApplicationGUI() {
        return this._gui;
    }

    public BaseGUI getAppletGUI() {
        this._gui.initGUI(true);
        return this._gui;
    }
}

