/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipTreeLoader
implements DirectoryTreeLoader {
    protected ZipInputStream zipIn = null;
    protected String currentDirectory = null;
    protected boolean isLoading = false;
    protected Hashtable pathnamesToByteArrays = null;
    protected Vector directories = null;
    private Object pathnameBeingWaitedOn = null;
    protected static final Object WHOLE_FILE = new Object();
    protected ZipLoaderThread loaderThread = null;
    protected InputStream currentlyOpenStream = null;

    public void open(Object pathname) throws IllegalArgumentException, IOException {
        if (this.zipIn != null) {
            this.close();
        }
        InputStream in = null;
        if (pathname instanceof String) {
            in = new FileInputStream((String)pathname);
        } else if (pathname instanceof File) {
            in = new FileInputStream((File)pathname);
        } else if (pathname instanceof URL) {
            in = ((URL)pathname).openStream();
        } else if (pathname instanceof InputStream) {
            in = (InputStream)pathname;
        } else {
            if (pathname == null) {
                throw new IllegalArgumentException("pathname is null");
            }
            throw new IllegalArgumentException("pathname must be an instance of String, java.io.File, java.net.URL, or java.io.InputStream");
        }
        this.zipIn = new ZipInputStream(new BufferedInputStream(in));
        this.currentDirectory = "";
        this.pathnamesToByteArrays = new Hashtable();
        this.directories = new Vector();
        this.loaderThread = new ZipLoaderThread();
        this.loaderThread.start();
    }

    public void close() throws IOException {
        if (this.zipIn != null) {
            this.closeCurrentFile();
            if (this.isLoading) {
                this.loaderThread.stopEarly();
                this.waitFor(WHOLE_FILE);
            }
            this.zipIn.close();
            this.zipIn = null;
            this.pathnamesToByteArrays = null;
            this.directories = null;
            this.loaderThread = null;
        }
    }

    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        if (pathname == null) {
            pathname = "";
        } else if (pathname.length() > 0) {
            if (pathname.charAt(0) != '/' && pathname.charAt(0) != '\\') {
                pathname = String.valueOf(this.currentDirectory) + pathname;
            }
            if (!(pathname = this.getCanonicalPathname(pathname)).endsWith("/")) {
                pathname = String.valueOf(pathname) + "/";
            }
            if (!pathname.startsWith("/")) {
                pathname = "/" + pathname + "/";
            }
        }
        this.currentDirectory = pathname;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public InputStream readFile(String filename) throws IllegalArgumentException, IOException {
        this.closeCurrentFile();
        String pathname = this.getCanonicalPathname(String.valueOf(this.currentDirectory) + filename);
        this.waitFor(pathname);
        byte[] fileContents = (byte[])this.pathnamesToByteArrays.get(pathname);
        if (fileContents == null) {
            throw new FileNotFoundException("Not Found: " + pathname);
        }
        this.currentlyOpenStream = new ByteArrayInputStream(fileContents);
        return this.currentlyOpenStream;
    }

    public void closeCurrentFile() throws IOException {
        if (this.currentlyOpenStream != null) {
            this.currentlyOpenStream.close();
            this.currentlyOpenStream = null;
        }
    }

    public String[] getFilesInCurrentDirectory() {
        this.waitFor(WHOLE_FILE);
        Vector<String> files = new Vector<String>();
        Enumeration enu = this.pathnamesToByteArrays.keys();
        while (enu.hasMoreElements()) {
            String tail;
            String filename = (String)enu.nextElement();
            int index = filename.indexOf(this.currentDirectory);
            if (index != 0 || (tail = filename.substring(this.currentDirectory.length())).indexOf(47) != -1) continue;
            files.addElement(tail);
        }
        String[] filenames = new String[files.size()];
        int i = 0;
        Enumeration enu2 = files.elements();
        while (enu2.hasMoreElements()) {
            filenames[i++] = (String)enu2.nextElement();
        }
        return filenames;
    }

    public String[] getDirectoriesInCurrentDirectory() {
        this.waitFor(WHOLE_FILE);
        Vector<String> dirs = new Vector<String>();
        Enumeration enu = this.directories.elements();
        while (enu.hasMoreElements()) {
            String tail;
            String dirname = (String)enu.nextElement();
            int index = dirname.indexOf(this.currentDirectory);
            if (index != 0 || (tail = dirname.substring(this.currentDirectory.length())).length() <= 0 || tail.indexOf(47) != tail.lastIndexOf(47)) continue;
            dirs.addElement(tail);
        }
        String[] dirnames = new String[dirs.size()];
        int i = 0;
        Enumeration enu2 = dirs.elements();
        while (enu2.hasMoreElements()) {
            dirnames[i++] = (String)enu2.nextElement();
        }
        return dirnames;
    }

    protected String getCanonicalPathname(String pathname) {
        int index;
        pathname = pathname.replace('\\', '/');
        while ((index = pathname.indexOf("//")) != -1) {
            pathname = String.valueOf(pathname.substring(0, index + 1)) + pathname.substring(index + 2);
        }
        if (pathname.charAt(0) == '/') {
            pathname = pathname.substring(1);
        }
        return pathname;
    }

    protected synchronized void waitFor(Object pathname) {
        if (this.pathnamesToByteArrays.get(pathname) != null) {
            return;
        }
        if (this.directories.indexOf(pathname) != -1) {
            return;
        }
        if (pathname == WHOLE_FILE && !this.isLoading) {
            return;
        }
        this.pathnameBeingWaitedOn = pathname;
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected synchronized void finishedLoading(Object pathname) {
        if (pathname.equals(this.pathnameBeingWaitedOn) || pathname.equals(WHOLE_FILE)) {
            this.notifyAll();
        }
    }

    public boolean isKeepFileSupported() {
        return false;
    }

    public Object getKeepKey(String filename) throws KeepFileNotSupportedException {
        throw new KeepFileNotSupportedException();
    }

    class ZipLoaderThread
    extends Thread {
        private boolean stoppedEarly = false;

        ZipLoaderThread() {
        }

        public void run() {
            this.setPriority(10);
            ZipTreeLoader.this.isLoading = true;
            while (true) {
                try {
                    ZipEntry entry;
                    while (!this.stoppedEarly && (entry = ZipTreeLoader.this.zipIn.getNextEntry()) != null) {
                        String pathname = ZipTreeLoader.this.getCanonicalPathname(entry.getName());
                        if (entry.isDirectory()) {
                            ZipTreeLoader.this.directories.addElement(pathname);
                            ZipTreeLoader.this.finishedLoading(pathname);
                            continue;
                        }
                        int size = 1024;
                        int off = 0;
                        byte[] entryContents = new byte[size];
                        while (ZipTreeLoader.this.zipIn.available() == 1) {
                            int theByte;
                            if (off == size) {
                                byte[] temp = entryContents;
                                entryContents = new byte[size += 1024];
                                System.arraycopy(temp, 0, entryContents, 0, size - 1024);
                            }
                            if ((theByte = ZipTreeLoader.this.zipIn.read()) == -1) break;
                            entryContents[off++] = (byte)theByte;
                        }
                        if (off < size) {
                            byte[] temp = entryContents;
                            entryContents = new byte[off];
                            System.arraycopy(temp, 0, entryContents, 0, off);
                        }
                        ZipTreeLoader.this.zipIn.closeEntry();
                        ZipTreeLoader.this.pathnamesToByteArrays.put(pathname, entryContents);
                        ZipTreeLoader.this.finishedLoading(pathname);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            this.stoppedEarly = false;
            ZipTreeLoader.this.isLoading = false;
            ZipTreeLoader.this.finishedLoading(WHOLE_FILE);
        }

        public void stopEarly() {
            this.stoppedEarly = true;
        }
    }
}

