/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;

public abstract class WorldListener {
    private World m_world;
    private ChildrenListener m_childrenListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent e) {
            WorldListener.this.handleChildrenChanging(e);
        }

        public void childrenChanged(ChildrenEvent e) {
            if (e.getChangeType() == 1) {
                WorldListener.this.hookUp(e.getChild());
            } else if (e.getChangeType() == 3) {
                WorldListener.this.unhookUp(e.getChild());
            }
            WorldListener.this.handleChildrenChanged(e);
        }
    };
    private PropertyListener m_propertyListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent e) {
            WorldListener.this.handlePropertyChanging(e);
        }

        public void propertyChanged(PropertyEvent e) {
            WorldListener.this.handlePropertyChanged(e);
        }
    };
    private ObjectArrayPropertyListener m_objectArrayPropertyListener = new ObjectArrayPropertyListener(){

        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent e) {
            WorldListener.this.handleObjectArrayPropertyChanging(e);
        }

        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent e) {
            WorldListener.this.handleObjectArrayPropertyChanged(e);
        }
    };

    protected abstract void handleChildrenChanging(ChildrenEvent var1);

    protected abstract void handleChildrenChanged(ChildrenEvent var1);

    protected abstract void handlePropertyChanging(PropertyEvent var1);

    protected abstract void handlePropertyChanged(PropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanging(ObjectArrayPropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanged(ObjectArrayPropertyEvent var1);

    protected abstract boolean isPropertyListeningRequired(Property var1);

    protected abstract boolean isObjectArrayPropertyListeningRequired(ObjectArrayProperty var1);

    public World getWorld() {
        return this.m_world;
    }

    public void setWorld(World world) {
        if (this.m_world != world) {
            if (this.m_world != null) {
                this.unhookUp(this.m_world);
            }
            this.m_world = world;
            if (this.m_world != null) {
                this.hookUp(this.m_world);
            }
        }
    }

    private boolean isChildrenListenerHookedUp(Element element) {
        ChildrenListener[] childrenListeners;
        ChildrenListener[] childrenListenerArray = childrenListeners = element.getChildrenListeners();
        int n = 0;
        int n2 = childrenListenerArray.length;
        while (n < n2) {
            ChildrenListener childrenListener = childrenListenerArray[n];
            if (childrenListener == this.m_childrenListener) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isPropertyListenerHookedUp(Property property) {
        PropertyListener[] propertyListeners;
        PropertyListener[] propertyListenerArray = propertyListeners = property.getPropertyListeners();
        int n = 0;
        int n2 = propertyListenerArray.length;
        while (n < n2) {
            PropertyListener propertyListener = propertyListenerArray[n];
            if (propertyListener == this.m_propertyListener) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isObjectArrayPropertyListenerHookedUp(ObjectArrayProperty oap) {
        ObjectArrayPropertyListener[] oapListeners;
        ObjectArrayPropertyListener[] objectArrayPropertyListenerArray = oapListeners = oap.getObjectArrayPropertyListeners();
        int n = 0;
        int n2 = objectArrayPropertyListenerArray.length;
        while (n < n2) {
            ObjectArrayPropertyListener oapListener = objectArrayPropertyListenerArray[n];
            if (oapListener == this.m_objectArrayPropertyListener) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void unhookUp(Element element) {
        Element[] children;
        Property[] properties;
        if (this.isChildrenListenerHookedUp(element)) {
            element.removeChildrenListener(this.m_childrenListener);
        }
        Property[] propertyArray = properties = element.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            ObjectArrayProperty oapI;
            Property propertyI = propertyArray[n];
            if (this.isPropertyListeningRequired(propertyI) && this.isPropertyListenerHookedUp(propertyI)) {
                propertyI.removePropertyListener(this.m_propertyListener);
            }
            if (propertyI instanceof ObjectArrayProperty && this.isObjectArrayPropertyListeningRequired(oapI = (ObjectArrayProperty)propertyI) && this.isObjectArrayPropertyListenerHookedUp(oapI)) {
                oapI.removeObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
            }
            ++n;
        }
        Element[] elementArray = children = element.getChildren();
        n2 = 0;
        int n3 = elementArray.length;
        while (n2 < n3) {
            Element element2 = elementArray[n2];
            this.unhookUp(element2);
            ++n2;
        }
    }

    private void hookUp(Element element) {
        Element[] children;
        Property[] properties;
        if (!this.isChildrenListenerHookedUp(element)) {
            element.addChildrenListener(this.m_childrenListener);
        }
        Property[] propertyArray = properties = element.getProperties();
        int n = 0;
        int n2 = propertyArray.length;
        while (n < n2) {
            ObjectArrayProperty oapI;
            Property propertyI = propertyArray[n];
            if (this.isPropertyListeningRequired(propertyI) && !this.isPropertyListenerHookedUp(propertyI)) {
                propertyI.addPropertyListener(this.m_propertyListener);
            }
            if (propertyI instanceof ObjectArrayProperty && this.isObjectArrayPropertyListeningRequired(oapI = (ObjectArrayProperty)propertyI) && !this.isObjectArrayPropertyListenerHookedUp(oapI)) {
                oapI.addObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
            }
            ++n;
        }
        Element[] elementArray = children = element.getChildren();
        n2 = 0;
        int n3 = elementArray.length;
        while (n2 < n3) {
            Element element2 = elementArray[n2];
            this.hookUp(element2);
            ++n2;
        }
    }
}

