/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.style;

import edu.cmu.cs.stage3.alice.core.Style;
import edu.cmu.cs.stage3.util.Enumerable;

public class TraditionalAnimationStyle
extends Enumerable
implements Style {
    @Deprecated
    public static final TraditionalAnimationStyle LINEAR = new TraditionalAnimationStyle(false, false, false, false);
    @Deprecated
    public static final TraditionalAnimationStyle SLOW_IN = new TraditionalAnimationStyle(true, false, false, false);
    @Deprecated
    public static final TraditionalAnimationStyle SLOW_OUT = new TraditionalAnimationStyle(false, true, false, false);
    @Deprecated
    public static final TraditionalAnimationStyle SLOW_IN_OUT = new TraditionalAnimationStyle(true, true, false, false);
    public static final TraditionalAnimationStyle BEGIN_AND_END_GENTLY = new TraditionalAnimationStyle(true, true, false, false);
    public static final TraditionalAnimationStyle BEGIN_GENTLY_AND_END_ABRUPTLY = new TraditionalAnimationStyle(true, false, false, false);
    public static final TraditionalAnimationStyle BEGIN_ABRUPTLY_AND_END_GENTLY = new TraditionalAnimationStyle(false, true, false, false);
    public static final TraditionalAnimationStyle BEGIN_AND_END_ABRUPTLY = new TraditionalAnimationStyle(false, false, false, false);
    private boolean m_beginGently;
    private boolean m_endGently;

    public TraditionalAnimationStyle(boolean beginGently, boolean endGently, boolean withAnticipation, boolean withOvershoot) {
        this.m_beginGently = beginGently;
        this.m_endGently = endGently;
    }

    private static double gently(double x, double A, double B) {
        double y;
        if (x < A) {
            y = (B - 1.0) / (A * (B * B - A * B + A - 1.0)) * x * x;
        } else if (x > B) {
            double a3 = 1.0 / (B * B - A * B + A - 1.0);
            double b3 = -2.0 * a3;
            double c3 = 1.0 + a3;
            y = a3 * x * x + b3 * x + c3;
        } else {
            double m = 2.0 * (B - 1.0) / (B * B - A * B + A - 1.0);
            double b2 = -m * A / 2.0;
            y = m * x + b2;
        }
        return y;
    }

    public double getPortion(double current, double total) {
        if (total != 0.0) {
            double portion = current / total;
            if (this.m_beginGently) {
                if (this.m_endGently) {
                    return TraditionalAnimationStyle.gently(portion, 0.3, 0.8);
                }
                return TraditionalAnimationStyle.gently(portion, 0.99, 0.999);
            }
            if (this.m_endGently) {
                return TraditionalAnimationStyle.gently(portion, 0.001, 0.01);
            }
            return portion;
        }
        return 1.0;
    }

    public static TraditionalAnimationStyle valueOf(String s) {
        TraditionalAnimationStyle tas = (TraditionalAnimationStyle)Enumerable.valueOf(s, TraditionalAnimationStyle.class);
        if (tas == LINEAR) {
            tas = BEGIN_AND_END_ABRUPTLY;
        } else if (tas == SLOW_IN) {
            tas = BEGIN_GENTLY_AND_END_ABRUPTLY;
        } else if (tas == SLOW_OUT) {
            tas = BEGIN_ABRUPTLY_AND_END_GENTLY;
        } else if (tas == SLOW_IN_OUT) {
            tas = BEGIN_AND_END_GENTLY;
        }
        return tas;
    }
}

