/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.IllegalPropertyValueException;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.core.property.OverridableElementProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.property.ValueProperty;
import edu.cmu.cs.stage3.alice.core.response.Animation;
import edu.cmu.cs.stage3.util.HowMuch;

public class PropertyAnimation
extends Animation {
    public final OverridableElementProperty element = new OverridableElementProperty(this, "element", null);
    public final StringProperty propertyName = new StringProperty(this, "propertyName", null);
    public final ValueProperty value = new ValueProperty(this, "value", null);
    public final ObjectProperty howMuch = new ObjectProperty(this, "howMuch", HowMuch.INSTANCE_AND_PARTS, HowMuch.class);

    private void updateOverrideValueClasses() {
        Element elementValue;
        Class elementOverrideValueClass = null;
        Class valueOverrideValueClass = null;
        String propertyNameValue = this.propertyName.getStringValue();
        if (propertyNameValue != null && (elementValue = this.element.getElementValue()) != null) {
            Class cls;
            Property property = elementValue.getPropertyNamed(propertyNameValue);
            if (property != null) {
                elementOverrideValueClass = property.getDeclaredClass();
                valueOverrideValueClass = property.getValueClass();
            } else if (elementValue instanceof Expression && (cls = ((Expression)elementValue).getValueClass()) != null) {
                elementOverrideValueClass = cls;
                valueOverrideValueClass = Element.getValueClassForPropertyNamed(elementOverrideValueClass, propertyNameValue);
            }
        }
        this.element.setOverrideValueClass(elementOverrideValueClass);
        this.value.setOverrideValueClass(valueOverrideValueClass);
    }

    protected void propertyChanged(Property property, Object value) {
        if (property == this.element) {
            this.updateOverrideValueClasses();
        } else if (property == this.propertyName) {
            this.updateOverrideValueClasses();
        } else {
            super.propertyChanged(property, value);
        }
    }

    public class RuntimePropertyAnimation
    extends Animation.RuntimeAnimation {
        private Property m_property;
        private Object m_valueBegin;
        private Object m_valueEnd;
        private HowMuch m_howMuch;
        private Element m_element;
        private String m_propertyName;

        public RuntimePropertyAnimation() {
            super(PropertyAnimation.this);
        }

        protected Property getProperty() {
            return this.m_property;
        }

        protected void set(Object value) {
            if (this.m_property != null) {
                if (PropertyAnimation.this.howMuch != null) {
                    this.m_property.set(value, this.m_howMuch);
                } else {
                    this.m_property.set(value);
                }
            } else {
                this.m_element.setPropertyNamed(this.m_propertyName, value, this.m_howMuch);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void prologue(double t) {
            super.prologue(t);
            PropertyAnimation.this.updateOverrideValueClasses();
            this.m_element = PropertyAnimation.this.element.getElementValue();
            this.m_propertyName = PropertyAnimation.this.propertyName.getStringValue();
            if (this.m_element == null) throw new IllegalPropertyValueException(PropertyAnimation.this.element, null, "element must not be null.");
            if (this.m_propertyName == null) throw new IllegalPropertyValueException(PropertyAnimation.this.propertyName, null, "propertyName must not be null.");
            this.m_property = this.m_element.getPropertyNamed(this.m_propertyName);
            if (this.m_property == null) throw new IllegalPropertyValueException(PropertyAnimation.this.propertyName, this.m_propertyName, this.m_element + " does not have property named " + this.m_propertyName);
            this.m_valueBegin = this.m_property.getValue();
            this.m_valueEnd = PropertyAnimation.this.value.getValue();
            this.m_howMuch = this.m_property.isAcceptingOfHowMuch() ? (HowMuch)PropertyAnimation.this.howMuch.getValue() : HowMuch.INSTANCE;
        }

        public void update(double t) {
            super.update(t);
            if (this.m_valueBegin != null) {
                // empty if block
            }
        }

        public void epilogue(double t) {
            super.epilogue(t);
            this.set(this.m_valueEnd);
        }
    }
}

