/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.question;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.property.OverridableElementProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import java.lang.reflect.Field;

public class PropertyValue
extends Question {
    private boolean m_ignorePropertyChanges = false;
    public final OverridableElementProperty element = new OverridableElementProperty(this, "element", null);
    public final StringProperty propertyName = new StringProperty(this, "propertyName", null);

    private void updateOverrideValueClass() {
        Element elementValue;
        Class elementOverrideValueClass = null;
        String propertyNameValue = this.propertyName.getStringValue();
        if (propertyNameValue != null && (elementValue = this.element.getElementValue()) != null) {
            Class cls;
            Property property = elementValue.getPropertyNamed(propertyNameValue);
            if (property != null) {
                elementOverrideValueClass = property.getDeclaredClass();
            } else if (elementValue instanceof Expression && (cls = ((Expression)elementValue).getValueClass()) != null) {
                elementOverrideValueClass = cls;
            }
        }
        this.element.setOverrideValueClass(elementOverrideValueClass);
    }

    protected void propertyChanged(Property property, Object value) {
        if (this.m_ignorePropertyChanges) {
            return;
        }
        if (property == this.element) {
            this.updateOverrideValueClass();
        } else if (property == this.propertyName) {
            this.updateOverrideValueClass();
        } else {
            super.propertyChanged(property, value);
        }
    }

    private Property getPropertyValue() {
        if (this.element.getOverrideValueClass() == null) {
            this.updateOverrideValueClass();
        }
        Element elementValue = this.element.getElementValue();
        String propertyNameValue = this.propertyName.getStringValue();
        if (elementValue != null && propertyNameValue != null) {
            return elementValue.getPropertyNamed(propertyNameValue);
        }
        return null;
    }

    public Object getValue() {
        Property property = this.getPropertyValue();
        if (property != null) {
            return property.getValue();
        }
        throw new RuntimeException();
    }

    public Class getValueClass() {
        Class cls;
        Property property = this.getPropertyValue();
        if (property != null) {
            return property.getValueClass();
        }
        String propertyNameValue = this.propertyName.getStringValue();
        if (propertyNameValue != null && Element.class.isAssignableFrom(cls = this.element.getValueClass())) {
            try {
                Field field = cls.getField(propertyNameValue);
                if (field != null) {
                    return Element.getValueClassForPropertyNamed(field.getDeclaringClass(), propertyNameValue);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return Object.class;
    }
}

