/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DictionaryProperty
extends ObjectProperty {
    public DictionaryProperty(Element owner, String name, Dictionary defaultValue) {
        super(owner, name, defaultValue, Dictionary.class);
    }

    public Dictionary getDictionaryValue() {
        return (Dictionary)this.getValue();
    }

    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        Hashtable<Object, Object> dict = new Hashtable<Object, Object>();
        NodeList entryNodeList = node.getElementsByTagName("entry");
        int i = 0;
        while (i < entryNodeList.getLength()) {
            Object value;
            Object key;
            org.w3c.dom.Element entryNode = (org.w3c.dom.Element)entryNodeList.item(i);
            org.w3c.dom.Element keyNode = (org.w3c.dom.Element)entryNode.getElementsByTagName("key").item(0);
            String keyTypeName = keyNode.getAttribute("class");
            try {
                Class<?> keyType = Class.forName(keyTypeName);
                key = keyType == String.class ? this.getNodeText(keyNode) : this.getValueOf(keyType, this.getNodeText(keyNode));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(keyTypeName);
            }
            org.w3c.dom.Element valueNode = (org.w3c.dom.Element)entryNode.getElementsByTagName("value").item(0);
            String valueTypeName = valueNode.getAttribute("class");
            try {
                Class<?> valueType = Class.forName(valueTypeName);
                value = valueType == String.class ? this.getNodeText(valueNode) : this.getValueOf(valueType, this.getNodeText(valueNode));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(valueTypeName);
            }
            ((Dictionary)dict).put(key, value);
            ++i;
        }
        this.set(dict);
    }

    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Dictionary dict = this.getDictionaryValue();
        if (dict != null) {
            Enumeration enu = dict.keys();
            while (enu.hasMoreElements()) {
                Object key = enu.nextElement();
                Object value = dict.get(key);
                org.w3c.dom.Element entryNode = document.createElement("entry");
                org.w3c.dom.Element keyNode = document.createElement("key");
                keyNode.setAttribute("class", key.getClass().getName());
                keyNode.appendChild(this.createNodeForString(document, key.toString()));
                org.w3c.dom.Element valueNode = document.createElement("value");
                valueNode.setAttribute("class", value.getClass().getName());
                valueNode.appendChild(this.createNodeForString(document, value.toString()));
                entryNode.appendChild(keyNode);
                entryNode.appendChild(valueNode);
                node.appendChild(entryNode);
            }
        }
    }

    public Object get(Object key) {
        Dictionary dict = this.getDictionaryValue();
        if (dict != null) {
            return dict.get(key);
        }
        return null;
    }

    public boolean isEmpty() {
        Dictionary dict = this.getDictionaryValue();
        if (dict != null) {
            return dict.isEmpty();
        }
        return true;
    }

    public Object put(Object key, Object value) {
        Dictionary dict = this.getDictionaryValue();
        Hashtable<Object, Object> newDict = new Hashtable<Object, Object>();
        if (dict != null) {
            Enumeration enu = dict.keys();
            while (enu.hasMoreElements()) {
                Object k = enu.nextElement();
                Object v = dict.get(k);
                ((Dictionary)newDict).put(k, v);
            }
        }
        Object o = ((Dictionary)newDict).put(key, value);
        this.set(newDict);
        return o;
    }

    public Object remove(Object key) {
        Dictionary dict = this.getDictionaryValue();
        Hashtable newDict = new Hashtable();
        Object value = null;
        if (dict != null) {
            Enumeration enu = dict.keys();
            while (enu.hasMoreElements()) {
                Object k = enu.nextElement();
                Object v = dict.get(k);
                if (k.equals(key)) {
                    value = v;
                    continue;
                }
                ((Dictionary)newDict).put(k, v);
            }
        }
        if (value != null) {
            this.set(newDict);
        }
        return value;
    }
}

