/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyClickBehavior
extends TriggerBehavior
implements KeyListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{KeyIsPressedBehavior.class};
    public final IntegerProperty keyCode = new IntegerProperty(this, "keyCode", null);
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    private RenderTarget[] m_renderTargets = null;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureAnyNecessaryDetails() {
        if (this.details.size() == 1) {
            Variable code = new Variable();
            code.name.set("code");
            code.setParent(this);
            code.valueClass.set(Integer.class);
            this.details.add(code);
        }
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable keyChar = new Variable();
        keyChar.name.set("keyChar");
        keyChar.setParent(this);
        keyChar.valueClass.set(Character.class);
        this.details.add(keyChar);
        Variable code = new Variable();
        code.name.set("code");
        code.setParent(this);
        code.valueClass.set(Integer.class);
        this.details.add(code);
    }

    private void updateDetails(KeyEvent keyEvent) {
        int i = 0;
        while (i < this.details.size()) {
            Variable detail = (Variable)this.details.get(i);
            if (detail.name.getStringValue().equals("keyChar")) {
                detail.value.set(new Character(keyEvent.getKeyChar()));
            } else if (detail.name.getStringValue().equals("code")) {
                detail.value.set(new Integer(keyEvent.getKeyCode()));
            }
            ++i;
        }
    }

    private boolean checkKeyCode(KeyEvent keyEvent) {
        int requiredValue;
        int actualValue = keyEvent.getKeyCode();
        return actualValue == (requiredValue = this.keyCode.intValue(actualValue));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.updateDetails(keyEvent);
        if (this.checkKeyCode(keyEvent)) {
            this.trigger((double)keyEvent.getWhen() * 0.001);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void started(World world, double time) {
        super.started(world, time);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.addKeyListener(this);
            ++n;
        }
    }

    protected void stopped(World world, double time) {
        super.stopped(world, time);
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.removeKeyListener(this);
            ++n;
        }
        this.m_renderTargets = null;
    }
}

