/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class Behavior
extends Element {
    public final BooleanProperty isEnabled = new BooleanProperty(this, "isEnabled", Boolean.TRUE);
    public final ElementArrayProperty details = new ElementArrayProperty((Element)this, "details", null, Expression[].class);
    private double m_prevT;
    private boolean m_isActive = false;
    private RuntimeStack m_stack = new RuntimeStack();
    private Hashtable m_detailNameMap = new Hashtable();
    private Hashtable m_forkMap = new Hashtable();

    public void openFork(Object key, int n) {
        Fork fork = new Fork(n);
        this.m_forkMap.put(key, fork);
        this.m_stack.push(fork);
    }

    public void setForkIndex(Object key, int i) {
        Fork fork = (Fork)this.m_forkMap.get(key);
        fork.setIndex(i);
    }

    public void closeFork(Object key) {
        if (this.m_isActive) {
            this.m_stack.pop();
            this.m_forkMap.remove(key);
        }
    }

    public Stack getCurrentStack() {
        return this.m_stack.getCurrentStack();
    }

    public void manufactureAnyNecessaryDetails() {
    }

    protected void enabled() {
    }

    protected void disabled() {
    }

    protected void propertyChanged(Property property, Object value) {
        if (property == this.isEnabled) {
            if (this.m_isActive) {
                if (value == Boolean.TRUE) {
                    this.enabled();
                } else {
                    this.disabled();
                }
            }
        } else {
            super.propertyChanged(property, value);
        }
    }

    public void manufactureDetails() {
    }

    public void preSchedule(double t) {
    }

    public void postSchedule(double t) {
    }

    protected abstract void internalSchedule(double var1, double var3);

    public abstract void stopAllRuntimeResponses(double var1);

    public void schedule(double time) {
        double dt;
        if (this.isEnabled.booleanValue() && (dt = time - this.m_prevT) > 0.0) {
            this.internalSchedule(time, dt);
            this.m_prevT = time;
        }
    }

    private Variable createRuntimeVariable(Variable other) {
        Variable v = new Variable();
        v.name.set(other.name.getStringValue());
        Class cls = other.getValueClass();
        v.valueClass.set(cls);
        Object value = other.getValue();
        v.value.set(value);
        return v;
    }

    public Variable stackLookup(Variable variable) {
        Variable returnValue = this.m_stack.top().lookup(variable);
        return returnValue;
    }

    public Variable stackLookup(String name) {
        return this.m_stack.top().lookup(name);
    }

    public Expression detailLookup(String name) {
        return (Expression)this.m_detailNameMap.get(name);
    }

    public void pushEach(Variable variable, Variable runtimeVariable) {
        Context context = new Context();
        context.m_isCeiling = false;
        context.m_variableMap.put(variable, runtimeVariable);
        context.m_nameMap.put(variable.name.getStringValue(), runtimeVariable);
        this.m_stack.push(context);
    }

    public void pushStack(Variable[] actualRequired, Variable[] actualKeyword, Variable[] formalRequired, Variable[] formalKeyword, Variable[] localVariables, boolean isCeiling) {
        Context context = new Context();
        context.m_isCeiling = isCeiling;
        Variable[] variableArray = formalRequired;
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable formal = variableArray[n];
            String nameValue = formal.name.getStringValue();
            int j = 0;
            while (j < actualRequired.length) {
                Variable actual = actualRequired[j];
                if (nameValue.equals(actual.name.getStringValue())) {
                    Variable runtime = this.createRuntimeVariable(actual);
                    context.m_nameMap.put(nameValue, runtime);
                    context.m_variableMap.put(formal, runtime);
                    break;
                }
                if (j == actualRequired.length - 1) {
                    throw new RuntimeException("missing required parameter: " + nameValue);
                }
                ++j;
            }
            ++n;
        }
        variableArray = localVariables;
        n = 0;
        n2 = variableArray.length;
        while (n < n2) {
            Variable localVariable = variableArray[n];
            Variable runtime = this.createRuntimeVariable(localVariable);
            context.m_nameMap.put(localVariable.name.getStringValue(), runtime);
            context.m_variableMap.put(localVariable, runtime);
            ++n;
        }
        this.m_stack.push(context);
    }

    public void popStack() {
        if (this.m_isActive) {
            this.m_stack.top();
            this.m_stack.pop();
        }
    }

    protected void internalFindAccessibleExpressions(Class cls, Vector v) {
        int i = 0;
        while (i < this.details.size()) {
            this.internalAddExpressionIfAssignableTo((Expression)this.details.get(i), cls, v);
            ++i;
        }
        super.internalFindAccessibleExpressions(cls, v);
    }

    protected void started(World world, double time) {
        super.started(world, time);
        this.m_prevT = time;
        this.m_stack.clear();
        this.m_detailNameMap.clear();
        this.m_forkMap.clear();
        int i = 0;
        while (i < this.details.size()) {
            Expression detail = (Expression)this.details.get(i);
            this.m_detailNameMap.put(detail.name.getStringValue(), detail);
            ++i;
        }
        this.m_isActive = true;
    }

    protected void stopped(World world, double time) {
        super.stopped(world, time);
        this.m_isActive = false;
        this.stopAllRuntimeResponses(time);
        this.m_stack.clear();
        this.m_detailNameMap.clear();
        this.m_forkMap.clear();
    }

    private class RuntimeStack {
        private Item m_front;

        private RuntimeStack() {
            this.m_front = new Single();
        }

        public void clear() {
            this.m_front.setNext(null);
        }

        public void push(Item item) {
            Item t = this.top();
            t.setNext(item);
            item.setPrev(t);
        }

        public void pop() {
            Item t = this.top();
            t.getPrev().setNext(null);
            t.setPrev(null);
        }

        public Item top() {
            Item prev = this.m_front;
            Item curr;
            while ((curr = prev.getNext()) != null) {
                prev = curr;
            }
            return prev;
        }

        public Stack getCurrentStack() {
            Item curr;
            Stack<Item> stack = new Stack<Item>();
            Item prev = this.m_front;
            while ((curr = prev.getNext()) != null) {
                prev = curr;
                stack.push(prev);
            }
            return stack;
        }
    }

    private abstract class Item {
        private Item m_prev;

        private Item() {
        }

        public Item getPrev() {
            return this.m_prev;
        }

        protected void setPrev(Item prev) {
            this.m_prev = prev;
        }

        public abstract Item getNext();

        public abstract void setNext(Item var1);

        public Variable lookup(Variable variable) {
            if (this.m_prev == null) {
                return variable;
            }
            return this.m_prev.lookup(variable);
        }

        public Variable lookup(String name) {
            if (this.m_prev == null) {
                return null;
            }
            return this.m_prev.lookup(name);
        }
    }

    private class Fork
    extends Item {
        private Item[] m_nexts;
        private int m_index;

        public Fork(int n) {
            this.m_nexts = new Item[n];
            this.m_index = -1;
        }

        public Item getNext() {
            if (this.m_index < 0 || this.m_index >= this.m_nexts.length) {
                throw new ArrayIndexOutOfBoundsException(String.valueOf(this.m_index) + " not in range [0," + this.m_nexts.length + ")");
            }
            return this.m_nexts[this.m_index];
        }

        public void setNext(Item item) {
            this.m_nexts[this.m_index] = item;
        }

        public void setIndex(int index) {
            this.m_index = index;
        }
    }

    private class Single
    extends Item {
        private Item m_next;

        private Single() {
        }

        public Item getNext() {
            return this.m_next;
        }

        public void setNext(Item next) {
            this.m_next = next;
        }

        /* synthetic */ Single(Single single, Single single2) {
            this();
        }
    }

    private class Context
    extends Single {
        private Dictionary m_variableMap;
        private Dictionary m_nameMap;
        private boolean m_isCeiling;

        private Context() {
            super(null, null);
            this.m_variableMap = new Hashtable();
            this.m_nameMap = new Hashtable();
            this.m_isCeiling = true;
        }

        public Variable lookup(Variable variable) {
            Variable runtimeVariable = (Variable)this.m_variableMap.get(variable);
            if (runtimeVariable != null) {
                return runtimeVariable;
            }
            if (this.m_isCeiling) {
                return variable;
            }
            return this.getPrev().lookup(variable);
        }

        public Variable lookup(String name) {
            Variable runtimeVariable = (Variable)this.m_nameMap.get(name);
            if (runtimeVariable != null) {
                return runtimeVariable;
            }
            if (this.m_isCeiling) {
                return null;
            }
            return this.getPrev().lookup(name);
        }
    }
}

