/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class VariablesViewController
extends GroupingPanel
implements GUIElement,
Releasable {
    protected ObjectArrayProperty variables;
    protected RefreshListener refreshListener = new RefreshListener();
    protected boolean sleeping = false;

    public VariablesViewController() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(null);
    }

    public void set(ObjectArrayProperty variables) {
        this.clean();
        this.variables = variables;
        if (!this.sleeping) {
            this.startListening();
        }
        this.refreshGUI();
    }

    public void goToSleep() {
        if (!this.sleeping) {
            this.stopListening();
            this.sleeping = true;
        }
    }

    public void wakeUp() {
        if (this.sleeping) {
            this.startListening();
            this.sleeping = false;
        }
    }

    public void die() {
        this.clean();
    }

    public void clean() {
        this.stopListening();
        this.removeAll();
        this.variables = null;
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void refreshGUI() {
        Object[] vars;
        this.removeAll();
        Object[] objectArray = vars = this.variables.getArrayValue();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object var = objectArray[n];
            Variable variable = (Variable)var;
            if (variable != null) {
                JComponent gui = null;
                SetPropertyImmediatelyFactory setImmediatelyFactory = new SetPropertyImmediatelyFactory(variable.value);
                gui = GUIFactory.getPropertyViewController(variable.value, true, true, false, setImmediatelyFactory);
                this.add(gui);
            }
            ++n;
        }
    }

    protected void startListening() {
        if (this.variables != null) {
            Object[] vars;
            this.variables.addObjectArrayPropertyListener(this.refreshListener);
            Object[] objectArray = vars = this.variables.getArrayValue();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object var = objectArray[n];
                if (var != null) {
                    ((Variable)var).name.addPropertyListener(this.refreshListener);
                }
                ++n;
            }
        }
    }

    protected void stopListening() {
        if (this.variables != null) {
            Object[] vars;
            this.variables.removeObjectArrayPropertyListener(this.refreshListener);
            Object[] objectArray = vars = this.variables.getArrayValue();
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object var = objectArray[n];
                if (var != null) {
                    ((Variable)var).name.removePropertyListener(this.refreshListener);
                }
                ++n;
            }
        }
    }

    class RefreshListener
    implements ObjectArrayPropertyListener,
    PropertyListener {
        RefreshListener() {
        }

        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
        }

        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
            Variable variable;
            if (ev.getChangeType() == 1) {
                Variable variable2 = (Variable)ev.getItem();
                if (variable2 != null) {
                    variable2.name.addPropertyListener(this);
                }
            } else if (ev.getChangeType() == 3 && (variable = (Variable)ev.getItem()) != null) {
                variable.name.removePropertyListener(this);
            }
            VariablesViewController.this.refreshGUI();
        }

        public void propertyChanging(PropertyEvent ev) {
        }

        public void propertyChanged(PropertyEvent ev) {
            VariablesViewController.this.refreshGUI();
        }
    }
}

