/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.TextFieldEditablePropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Comment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class StringPropertyViewController
extends TextFieldEditablePropertyViewController {
    protected JLabel stringLabel = new JLabel();
    protected boolean emptyStringWritesNull;
    private Dimension minSize = new Dimension(20, 16);

    public StringPropertyViewController() {
        this.stringLabel.setMinimumSize(this.minSize);
        this.textField.setColumns(20);
    }

    public void set(Property property, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        this.set(property, allowExpressions, omitPropertyName, true, factory);
    }

    public void set(Property property, boolean includeDefaults, boolean allowExpressions, boolean omitPropertyName, boolean emptyStringWritesNull, PopupItemFactory factory) {
        super.set(property, includeDefaults, allowExpressions, true, omitPropertyName, factory);
        if (edu.cmu.cs.stage3.alice.core.response.Comment.class.isAssignableFrom(property.getOwner().getClass()) || Comment.class.isAssignableFrom(property.getOwner().getClass())) {
            this.stringLabel.setForeground(AuthoringToolResources.getColor("commentForeground"));
            int fontSize = 12;
            this.stringLabel.setFont(new Font("Helvetica", 1, (int)((double)(13 * fontSize) / 12.0)));
        } else {
            this.stringLabel.setForeground(UIManager.getColor("Label.foreground"));
            this.stringLabel.setFont(UIManager.getFont("Label.font"));
        }
        this.refreshGUI();
    }

    public void set(Property property, boolean allowExpressions, boolean omitPropertyName, boolean emptyStringWritesNull, PopupItemFactory factory) {
        this.set(property, false, allowExpressions, omitPropertyName, emptyStringWritesNull, factory);
    }

    protected void setValueFromString(String valueString) {
        if (valueString.trim().equals("") && this.emptyStringWritesNull) {
            valueString = null;
        }
        ((Runnable)this.factory.createItem(valueString)).run();
    }

    protected Component getNativeComponent() {
        return this.stringLabel;
    }

    protected Class getNativeClass() {
        return String.class;
    }

    protected void updateNativeComponent() {
        this.stringLabel.setText(this.property.get().toString());
    }

    protected void refreshGUI() {
        if (this.property.getValue() != null && this.property.getValue().toString().trim().equals("")) {
            this.stringLabel.setPreferredSize(this.minSize);
        } else {
            this.stringLabel.setPreferredSize(null);
        }
        if (this.isAncestorOf(this.textField)) {
            this.remove(this.textField);
        }
        super.refreshGUI();
    }
}

