/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ElementPrototypeDnDPanel
extends DnDGroupingPanel
implements GUIElement,
Releasable {
    protected static TilePool tilePool = new TilePool();
    protected ElementPrototype elementPrototype;
    protected JPanel subPanel = new GroupingPanel();
    protected String elementName;
    protected GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);

    public ElementPrototypeDnDPanel() {
        this.subPanel.setLayout(new GridBagLayout());
        this.subPanel.setOpaque(false);
        this.subPanel.setBorder(null);
        this.add((Component)this.subPanel, "Center");
        this.addDragSourceComponent(this.subPanel);
    }

    public void set(ElementPrototype elementPrototype) {
        this.elementPrototype = elementPrototype;
        this.setTransferable(TransferableFactory.createTransferable(elementPrototype));
        if (CallToUserDefinedResponse.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("userDefinedResponse"));
        } else if (Response.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("response"));
        } else if (CallToUserDefinedQuestion.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("userDefinedQuestion"));
        } else if (Question.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("question"));
        } else if (edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("userDefinedQuestionComponent"));
        } else {
            this.setBackground(AuthoringToolResources.getColor("elementPrototypeDnDPanel"));
        }
        this.elementName = AuthoringToolResources.getReprForValue(elementPrototype.getElementClass());
        this.refreshGUI();
    }

    public void goToSleep() {
    }

    public void wakeUp() {
    }

    public void clean() {
        this.elementPrototype = null;
        this.setTransferable(null);
        this.refreshGUI();
    }

    public void die() {
        this.clean();
        this.subPanel.removeAll();
        this.removeAll();
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    /*
     * Unable to fully structure code
     */
    public void refreshGUI() {
        block7: {
            var5_2 = components = this.subPanel.getComponents();
            var3_3 = 0;
            var4_5 = var5_2.length;
            while (var3_3 < var4_5) {
                component2 = var5_2[var3_3];
                if (component2 instanceof Tile) {
                    this.removeDragSourceComponent(component2);
                    ElementPrototypeDnDPanel.tilePool.releaseTile(((Tile)component2).getText(), (Tile)component2);
                }
                ++var3_3;
            }
            this.subPanel.removeAll();
            if (this.elementPrototype == null) break block7;
            propertyValues = this.elementPrototype.getKnownPropertyValues();
            keys = new Vector<String>();
            propertyMap = new HashMap<String, Object>();
            var8_8 = propertyValues;
            var6_9 = 0;
            var7_11 = var8_8.length;
            while (var6_9 < var7_11) {
                propertyValue = var8_8[var6_9];
                keys.add(propertyValue.getString());
                propertyMap.put(propertyValue.getString(), propertyValue.getObject());
                ++var6_9;
            }
            this.constraints.gridx = 0;
            format = AuthoringToolResources.getFormat(this.elementPrototype.getElementClass());
            tokenizer = new FormatTokenizer(format);
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("<<<") && token.endsWith(">>>")) {
                    propertyName = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                    if (keys.contains(propertyName)) {
                        this.addTile(AuthoringToolResources.getReprForValue(propertyMap.get(propertyName), false), true);
                        ++this.constraints.gridx;
                        keys.remove(propertyName);
                        continue;
                    }
                    AuthoringTool.showErrorDialog("no value available for " + token, null);
                    this.addTile(token, true);
                    ++this.constraints.gridx;
                    continue;
                }
                if (token.startsWith("<<") && token.endsWith(">>")) continue;
                if (!token.startsWith("<") || !token.endsWith(">")) ** GOTO lbl51
                token = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                this.addTile(token, true);
                ++this.constraints.gridx;
                continue;
lbl-1000:
                // 1 sources

                {
                    token = new StringBuffer(token).replace(token.indexOf("&lt;"), token.indexOf("&lt;") + 4, "<").toString();
lbl51:
                    // 2 sources

                    ** while (token.indexOf((String)"&lt;") > -1)
                }
lbl52:
                // 1 sources

                this.addTile(token, false);
                ++this.constraints.gridx;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void addTile(String text, boolean opaque) {
        Tile tile = tilePool.getTile(text);
        tile.setOpaque(opaque);
        tile.setBorderEnabled(opaque);
        this.subPanel.add((Component)tile, this.constraints);
        this.addDragSourceComponent(tile);
    }

    public static class Tile
    extends GroupingPanel {
        protected String text;

        public Tile(String text) {
            this.text = text;
            this.setLayout(new BorderLayout());
            this.setBackground(AuthoringToolResources.getColor("prototypeParameter"));
            JLabel tileLabel = new JLabel(text);
            tileLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)tileLabel, "Center");
        }

        public String getText() {
            return this.text;
        }

        public void setBorderEnabled(boolean enabled) {
            if (enabled) {
                this.setBorder(this.border);
            } else {
                this.setBorder(null);
            }
        }

        public void release() {
        }
    }

    static class TilePool {
        protected HashMap tileListMap = new HashMap();

        TilePool() {
        }

        public Tile getTile(String text) {
            LinkedList tileList = (LinkedList)this.tileListMap.get(text);
            if (tileList != null && !tileList.isEmpty()) {
                return (Tile)tileList.removeFirst();
            }
            Tile tilePanel = new Tile(text);
            return tilePanel;
        }

        public void releaseTile(String text, Tile tile) {
            LinkedList<Tile> tileList = (LinkedList<Tile>)this.tileListMap.get(text);
            if (tileList == null) {
                tileList = new LinkedList<Tile>();
                this.tileListMap.put(text, tileList);
            }
            tileList.addFirst(tile);
        }
    }
}

