/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;

public class WatcherPanel
extends JPanel {
    protected List variablesToWatch = new ArrayList();
    protected List propertiesToWatch = new ArrayList();
    protected Element root;

    public WatcherPanel() {
        this.setBackground(Color.white);
        this.setLayout(new GridBagLayout());
        this.addContainerListener(GUIElementContainerListener.getStaticListener());
    }

    public boolean isThereSomethingToWatch() {
        return this.variablesToWatch.size() + this.propertiesToWatch.size() > 0;
    }

    public void clear() {
        this.removeAllVariablesBeingWatched();
        this.removeAllPropertiesBeingWatched();
    }

    public void addVariableToWatch(Variable variable) {
        this.variablesToWatch.add(variable);
        this.refreshGUI();
    }

    public void removeVariableBeingWatched(Variable variable) {
        this.variablesToWatch.remove(variable);
        this.refreshGUI();
    }

    public void removeAllVariablesBeingWatched() {
        this.variablesToWatch.clear();
        this.refreshGUI();
    }

    public boolean isVariableBeingWatched(Variable variable) {
        return this.variablesToWatch.contains(variable);
    }

    public void addPropertyToWatch(Property property) {
        this.propertiesToWatch.add(property);
        this.refreshGUI();
    }

    public void removePropertyBeingWatched(Property property) {
        this.propertiesToWatch.remove(property);
        this.refreshGUI();
    }

    public void removeAllPropertiesBeingWatched() {
        this.propertiesToWatch.clear();
        this.refreshGUI();
    }

    public boolean isPropertyBeingWatched(Property property) {
        return this.propertiesToWatch.contains(property);
    }

    protected void refreshGUI() {
        JPanel gui;
        SetPropertyImmediatelyFactory factory;
        this.removeAll();
        int count = 0;
        for (Variable variable : this.variablesToWatch) {
            gui = GUIFactory.getVariableGUI(variable, true, factory = new SetPropertyImmediatelyFactory(variable.value));
            if (gui != null) {
                this.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                continue;
            }
            AuthoringTool.showErrorDialog("Unable to create gui for variable: " + variable, null);
        }
        this.add(Box.createVerticalStrut(8), new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        for (Property property : this.propertiesToWatch) {
            gui = GUIFactory.getPropertyGUI(property, true, false, factory = new SetPropertyImmediatelyFactory(property));
            if (gui != null) {
                this.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                continue;
            }
            AuthoringTool.showErrorDialog("Unable to create gui for property: " + property, null);
        }
        Component glue = Box.createGlue();
        this.add(glue, new GridBagConstraints(0, count++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.revalidate();
        this.repaint();
    }
}

