/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ObjectArrayPropertyItemTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyItem;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TrashComponent
extends JPanel
implements DropTargetListener {
    protected ImageIcon trashOpenIcon = AuthoringToolResources.getIconForValue("trashOpen");
    protected ImageIcon trashClosedIcon = AuthoringToolResources.getIconForValue("trashClosed");
    protected JLabel trashLabel = new JLabel(this.trashClosedIcon);
    protected AuthoringTool authoringTool;
    protected boolean paintDropPotential = false;
    protected DropPotentialFeedbackListener dropPotentialFeedbackListener = new DropPotentialFeedbackListener();
    protected boolean beingDroppedOn = false;

    public TrashComponent(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.trashLabel, "Center");
        this.setDropTarget(new DropTarget(this, this));
        this.trashLabel.setDropTarget(new DropTarget(this.trashLabel, this));
        DnDManager.addListener(this.dropPotentialFeedbackListener);
        this.setToolTipText("<html><font face=arial size=-1>Trash<p><p>Drag and drop tiles here to delete them.</font></html>");
        this.addMouseListener(new CustomMouseAdapter(){

            public void singleClickResponse(MouseEvent ev) {
                DialogManager.showMessageDialog(TrashComponent.this.getToolTipText());
            }
        });
    }

    public Dimension getMaximumSize() {
        return this.trashLabel.getMaximumSize();
    }

    public void paintComponent(Graphics g) {
        if (this.paintDropPotential) {
            Dimension size = this.getSize();
            if (this.beingDroppedOn) {
                g.setColor(AuthoringToolResources.getColor("dndHighlight2"));
            } else {
                g.setColor(AuthoringToolResources.getColor("dndHighlight"));
            }
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            g.drawRect(1, 1, size.width - 3, size.height - 3);
        }
        super.paintComponent(g);
    }

    protected boolean checkTransferable(Transferable transferable) {
        return AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(transferable, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
    }

    protected boolean checkDrag(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.elementReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(dtde, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
            dtde.acceptDrag(2);
            this.trashLabel.setIcon(this.trashOpenIcon);
            return true;
        }
        dtde.rejectDrag();
        return false;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.checkDrag(dtde)) {
            this.beingDroppedOn = true;
            this.repaint();
        }
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.beingDroppedOn) {
            this.beingDroppedOn = false;
            this.repaint();
        }
        this.trashLabel.setIcon(this.trashClosedIcon);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.checkDrag(dtde)) {
            this.beingDroppedOn = false;
            this.repaint();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.elementReferenceFlavor)) {
                dtde.acceptDrop(2);
                Transferable transferable = dtde.getTransferable();
                Element element = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(element, this.authoringTool);
                deleteRunnable.run();
                dtde.dropComplete(true);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                dtde.acceptDrop(2);
                Transferable transferable = dtde.getTransferable();
                CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
                ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(callToUserDefinedResponsePrototype.getActualResponse(), this.authoringTool);
                deleteRunnable.run();
                dtde.dropComplete(true);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                dtde.acceptDrop(2);
                Transferable transferable = dtde.getTransferable();
                CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
                ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(callToUserDefinedQuestionPrototype.getActualQuestion(), this.authoringTool);
                deleteRunnable.run();
                dtde.dropComplete(true);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
                dtde.acceptDrop(2);
                Transferable transferable = dtde.getTransferable();
                ObjectArrayPropertyItem item = (ObjectArrayPropertyItem)transferable.getTransferData(ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor);
                item.objectArrayProperty.remove(item.getIndex());
                dtde.dropComplete(true);
            } else {
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
        }
        catch (UnsupportedFlavorException e) {
            AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
            dtde.dropComplete(false);
        }
        catch (IOException e) {
            AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
            dtde.dropComplete(false);
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Drop didn't work.", t);
            dtde.dropComplete(false);
        }
        this.trashLabel.setIcon(this.trashClosedIcon);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.checkDrag(dtde);
    }

    protected class DropPotentialFeedbackListener
    implements DnDManagerListener {
        protected DropPotentialFeedbackListener() {
        }

        private void doCheck() {
            Transferable transferable = DnDManager.getCurrentTransferable();
            boolean transferableHasPotential = TrashComponent.this.checkTransferable(transferable);
            if (TrashComponent.this.paintDropPotential != transferableHasPotential) {
                TrashComponent.this.paintDropPotential = transferableHasPotential;
                TrashComponent.this.repaint();
            }
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        public void dragStarted() {
            this.doCheck();
        }

        public void dragEnter(DragSourceDragEvent dsde) {
            this.doCheck();
        }

        public void dragExit(DragSourceEvent dse) {
            this.doCheck();
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.doCheck();
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            TrashComponent.this.paintDropPotential = false;
            TrashComponent.this.repaint();
        }
    }
}

