/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExpandablePanel
extends JPanel {
    protected static HashSet collapsedSet = new HashSet();
    protected JPanel topPanel = new JPanel();
    protected JPanel mainPanel = new JPanel();
    protected JToggleButton expandButton = new JToggleButton();
    protected JLabel titleLabel = new JLabel();
    protected ImageIcon plusIcon;
    protected ImageIcon minusIcon;
    protected ImageIcon squareIcon;
    protected ExpandButtonListener expandButtonListener = new ExpandButtonListener();

    public ExpandablePanel() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.setOpaque(false);
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.expandButton, "West");
        this.topPanel.add((Component)this.titleLabel, "Center");
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.topPanel.setOpaque(false);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.mainPanel.setOpaque(false);
        this.plusIcon = AuthoringToolResources.getIconForValue("plus");
        this.minusIcon = AuthoringToolResources.getIconForValue("minus");
        this.squareIcon = AuthoringToolResources.getIconForValue("square");
        this.expandButton.setBorder(null);
        this.expandButton.setOpaque(false);
        this.expandButton.setIcon(this.plusIcon);
        this.expandButton.setSelectedIcon(this.minusIcon);
        this.expandButton.setPressedIcon(this.squareIcon);
        this.expandButton.setSelected(true);
        this.expandButton.setFocusPainted(false);
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.addChangeListener(this.expandButtonListener);
        this.titleLabel.setOpaque(false);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
        if (collapsedSet.contains(title)) {
            this.expandButton.setSelected(false);
        }
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setContent(JComponent component) {
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)component, "Center");
    }

    public void setExpanded(boolean b) {
        if (b) {
            if (!this.isAncestorOf(this.mainPanel)) {
                this.add((Component)this.mainPanel, "Center");
                collapsedSet.remove(this.titleLabel.getText());
                if (!this.expandButton.isSelected()) {
                    this.expandButton.setSelected(true);
                }
            }
        } else if (this.isAncestorOf(this.mainPanel)) {
            this.remove(this.mainPanel);
            collapsedSet.add(this.titleLabel.getText());
            if (this.expandButton.isSelected()) {
                this.expandButton.setSelected(false);
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected class ExpandButtonListener
    implements ChangeListener {
        protected ExpandButtonListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            ExpandablePanel.this.setExpanded(ExpandablePanel.this.expandButton.isSelected());
        }
    }
}

