/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.MainCompositeQuestionPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.awt.DynamicFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class MainCompositeElementPanel
extends CompositeElementPanel
implements ObjectArrayPropertyListener {
    protected Color backgroundColor = AuthoringToolResources.getColor("userDefinedResponseEditor");
    protected JPanel parameterPanel;
    protected JPanel variablePanel;
    protected JPanel mainParameterPanel;
    protected JPanel mainVariablePanel;
    protected JButton newParameterButton;
    protected JButton newVariableButton;
    protected JScrollPane scrollPane;
    protected DropTargetHandler parameterDropHandler;
    protected DropTargetHandler variableDropHandler;
    protected JLabel methodNameLabel;
    protected JLabel noParametersLabel;
    protected JLabel noVariablesLabel;
    private ObjectArrayProperty requiredParameters;
    private ObjectArrayProperty keywordParameters;
    private ObjectArrayProperty localVariables;
    private int lineLocation = -1;
    private int lineHeight = 24;
    private int verticalLineLocation = 5;
    private boolean paintParameter = false;
    private boolean paintVariable = false;

    public MainCompositeElementPanel() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setDragEnabled(false);
        this.setBorder(null);
        this.elementMouseListener = null;
    }

    public void set(Element element, AuthoringTool authoringTool) {
        super.set(element, authoringTool);
    }

    protected void setDropTargets() {
    }

    protected void variableInit() {
        super.variableInit();
        this.setVariableObjects(this.m_element);
    }

    protected void startListening() {
        super.startListening();
        if (this.keywordParameters != null) {
            this.keywordParameters.addObjectArrayPropertyListener(this);
        }
        if (this.requiredParameters != null) {
            this.requiredParameters.addObjectArrayPropertyListener(this);
        }
        if (this.localVariables != null) {
            this.localVariables.addObjectArrayPropertyListener(this);
        }
    }

    protected void stopListening() {
        super.stopListening();
        if (this.keywordParameters != null) {
            this.keywordParameters.removeObjectArrayPropertyListener(this);
        }
        if (this.requiredParameters != null) {
            this.requiredParameters.removeObjectArrayPropertyListener(this);
        }
        if (this.localVariables != null) {
            this.localVariables.removeObjectArrayPropertyListener(this);
        }
    }

    protected void removeAllListening() {
        super.removeAllListening();
        this.variablePanel.setDropTarget(null);
        this.parameterPanel.setDropTarget(null);
        this.parameterDropHandler = null;
        this.variableDropHandler = null;
    }

    protected boolean isValidName(String name, ObjectArrayProperty group) {
        int i = 0;
        while (i < group.size()) {
            if (name == ((Element)group.get((int)i)).name.getStringValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent e) {
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent e) {
        if (this.parameterPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainCompositeElementPanel.this.buildParameterPanel();
                }
            });
        }
        if (this.variablePanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainCompositeElementPanel.this.buildVariablePanel();
                }
            });
        }
    }

    protected String getHeaderHTML() {
        String htmlToReturn = "<b>" + this.methodNameLabel.getText() + "</b>&nbsp;(&nbsp;";
        int i = 0;
        while (i < this.requiredParameters.size()) {
            Class iconClass = ((Variable)this.requiredParameters.get((int)i)).valueClass.getClassValue();
            boolean isList = false;
            if (Collection.class.isAssignableFrom(iconClass)) {
                iconClass = (Class)((Collection)((Variable)this.requiredParameters.get((int)i)).getValue()).valueClass.get();
                isList = true;
            }
            String htmlName = AuthoringToolResources.getHTMLName(iconClass.getName());
            if (isList) {
                htmlName = String.valueOf(htmlName) + AuthoringToolResources.getHTMLName("edu.cmu.cs.stage3.alice.core.Collection");
            }
            htmlToReturn = String.valueOf(htmlToReturn) + htmlName + " <b>" + ((Element)this.requiredParameters.get((int)i)).name.getStringValue() + "</b>";
            if (i + 1 != this.requiredParameters.size()) {
                htmlToReturn = String.valueOf(htmlToReturn) + ", ";
            }
            ++i;
        }
        htmlToReturn = CompositeElementEditor.IS_JAVA ? String.valueOf(htmlToReturn) + ") <b>{</b>\n<br>&nbsp;&nbsp;&nbsp;&nbsp;" : String.valueOf(htmlToReturn) + ")\n<br>&nbsp;&nbsp;&nbsp;&nbsp;";
        htmlToReturn = String.valueOf(htmlToReturn) + GUIFactory.getHTMLStringForComponent(this.mainVariablePanel);
        return htmlToReturn;
    }

    private void setVariableObjects(Element element) {
        if (element instanceof UserDefinedResponse) {
            UserDefinedResponse r = (UserDefinedResponse)element;
            this.keywordParameters = r.keywordFormalParameters;
            this.requiredParameters = r.requiredFormalParameters;
            this.localVariables = r.localVariables;
        } else if (element instanceof UserDefinedQuestion) {
            UserDefinedQuestion r = (UserDefinedQuestion)element;
            this.keywordParameters = r.keywordFormalParameters;
            this.requiredParameters = r.requiredFormalParameters;
            this.localVariables = r.localVariables;
        }
        if (this.keywordParameters != null && this.requiredParameters != null && this.localVariables != null) {
            this.keywordParameters.addObjectArrayPropertyListener(this);
            this.requiredParameters.addObjectArrayPropertyListener(this);
            this.localVariables.addObjectArrayPropertyListener(this);
            this.parameterDropHandler.setProperty(this.requiredParameters);
            this.variableDropHandler.setProperty(this.localVariables);
        }
    }

    protected int buildVariablePanel(String seperator, JPanel toCreate, ObjectArrayProperty group, JButton button, DropTargetHandler dropHandler, int count) {
        int itemCount = 0;
        if (group != null == group.size() > 0) {
            int i = 0;
            while (i < group.size()) {
                if (group.get(i) instanceof Variable) {
                    Variable currentVariable = (Variable)group.get(i);
                    SetPropertyImmediatelyFactory variablePIF = new SetPropertyImmediatelyFactory(currentVariable.value);
                    GroupingPanel variableGUI = null;
                    variableGUI = toCreate != this.parameterPanel ? GUIFactory.getVariableGUI(currentVariable, true, variablePIF) : GUIFactory.getVariableDnDPanel(currentVariable);
                    ++itemCount;
                    variableGUI.setDropTarget(new DropTarget(variableGUI, dropHandler));
                    if (variableGUI instanceof Container) {
                        GroupingPanel variableContainer = variableGUI;
                        int j = 0;
                        while (j < variableContainer.getComponentCount()) {
                            variableContainer.getComponent(j).setDropTarget(new DropTarget(variableContainer.getComponent(j), dropHandler));
                            if (variableContainer.getComponent(j) instanceof Container) {
                                Container secondaryContainer = (Container)variableContainer.getComponent(j);
                                int k = 0;
                                while (k < secondaryContainer.getComponentCount()) {
                                    secondaryContainer.getComponent(k).setDropTarget(new DropTarget(secondaryContainer.getComponent(k), dropHandler));
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    if (itemCount != group.size()) {
                        JPanel holder = new JPanel();
                        holder.setBorder(null);
                        holder.setLayout(new FlowLayout(0, 0, 0));
                        holder.setBackground(toCreate.getBackground());
                        holder.setDropTarget(new DropTarget(holder, dropHandler));
                        JLabel comma = new JLabel(" " + seperator);
                        comma.setDropTarget(new DropTarget(comma, dropHandler));
                        holder.add(variableGUI);
                        holder.add(comma);
                        toCreate.add(holder);
                        holder.setDropTarget(new DropTarget(holder, dropHandler));
                    } else {
                        toCreate.add(variableGUI);
                    }
                }
                ++i;
            }
        } else {
            JLabel nonePanel = this.noParametersLabel;
            if (group == this.localVariables) {
                nonePanel = this.noVariablesLabel;
            }
            nonePanel.setDropTarget(new DropTarget(nonePanel, dropHandler));
            toCreate.add(nonePanel);
        }
        return itemCount;
    }

    protected int buildJavaVariablePanel(String seperator, JPanel toCreate, ObjectArrayProperty group, JButton button, DropTargetHandler dropHandler, int count) {
        int itemCount = 0;
        if (group != null) {
            int i = 0;
            while (i < group.size()) {
                if (group.get(i) instanceof Variable) {
                    JPanel holder;
                    String typeName;
                    Variable currentVariable = (Variable)group.get(i);
                    SetPropertyImmediatelyFactory variablePIF = new SetPropertyImmediatelyFactory(currentVariable.value);
                    String className = currentVariable.getValueClass().getName();
                    boolean isList = false;
                    if (Collection.class.isAssignableFrom(currentVariable.getValueClass())) {
                        className = ((Class)((Collection)currentVariable.getValue()).valueClass.get()).getName();
                        isList = true;
                    }
                    if ((typeName = AuthoringToolResources.getHTMLName(className)) == null) {
                        typeName = currentVariable.getValueClass().getName();
                        typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                    }
                    if (isList) {
                        typeName = String.valueOf(typeName) + "[]";
                    }
                    JLabel typeLabel = new JLabel(String.valueOf(typeName) + " ");
                    GroupingPanel variableGUI = null;
                    variableGUI = toCreate != this.parameterPanel ? GUIFactory.getVariableGUI(currentVariable, true, variablePIF) : GUIFactory.getVariableDnDPanel(currentVariable);
                    ++itemCount;
                    variableGUI.setDropTarget(new DropTarget(variableGUI, dropHandler));
                    if (variableGUI instanceof Container) {
                        GroupingPanel variableContainer = variableGUI;
                        int j = 0;
                        while (j < variableContainer.getComponentCount()) {
                            variableContainer.getComponent(j).setDropTarget(new DropTarget(variableContainer.getComponent(j), dropHandler));
                            if (variableContainer.getComponent(j) instanceof Container) {
                                Container secondaryContainer = (Container)variableContainer.getComponent(j);
                                int k = 0;
                                while (k < secondaryContainer.getComponentCount()) {
                                    secondaryContainer.getComponent(k).setDropTarget(new DropTarget(secondaryContainer.getComponent(k), dropHandler));
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    if (itemCount != group.size()) {
                        holder = new JPanel();
                        holder.setBorder(null);
                        holder.setLayout(new FlowLayout(0, 0, 0));
                        holder.setBackground(toCreate.getBackground());
                        holder.setDropTarget(new DropTarget(holder, dropHandler));
                        JLabel comma = new JLabel(" " + seperator + " ");
                        comma.setDropTarget(new DropTarget(comma, dropHandler));
                        typeLabel.setDropTarget(new DropTarget(typeLabel, dropHandler));
                        holder.add(typeLabel);
                        holder.add(variableGUI);
                        holder.add(comma);
                        toCreate.add(holder);
                    } else {
                        holder = new JPanel();
                        holder.setBorder(null);
                        holder.setLayout(new FlowLayout(0, 0, 0));
                        holder.setBackground(toCreate.getBackground());
                        holder.setDropTarget(new DropTarget(holder, dropHandler));
                        typeLabel.setDropTarget(new DropTarget(typeLabel, dropHandler));
                        holder.add(typeLabel);
                        holder.add(variableGUI);
                        toCreate.add(holder);
                    }
                }
                ++i;
            }
        }
        return itemCount;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.parameterPanel != null) {
            this.parameterPanel.setBackground(color);
        }
        if (this.variablePanel != null) {
            this.variablePanel.setBackground(color);
        }
        if (this.mainVariablePanel != null) {
            this.mainVariablePanel.setBackground(color);
        }
        if (this.mainParameterPanel != null) {
            this.mainParameterPanel.setBackground(color);
        }
        if (this.componentElementPanel != null) {
            this.componentElementPanel.setBackground(color);
        }
    }

    protected void buildParameterPanel() {
        this.parameterPanel.removeAll();
        String functionName = this.m_element.name.getStringValue();
        if (CompositeElementEditor.IS_JAVA) {
            functionName = functionName.replace(' ', '_');
            String typeName = "void";
            if (this instanceof MainCompositeQuestionPanel) {
                UserDefinedQuestion currentQuestion = (UserDefinedQuestion)this.m_element;
                String className = currentQuestion.getValueClass().getName();
                boolean isList = false;
                if (Collection.class.isAssignableFrom(currentQuestion.getValueClass())) {
                    className = ((Class)((Collection)currentQuestion.getValue()).valueClass.get()).getName();
                    isList = true;
                }
                if ((typeName = AuthoringToolResources.getHTMLName(className)) == null) {
                    typeName = currentQuestion.getValueClass().getName();
                    typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                }
                if (isList) {
                    typeName = String.valueOf(typeName) + "[]";
                }
            }
            this.methodNameLabel.setText("public " + typeName + " " + functionName);
            this.parameterPanel.add(this.methodNameLabel);
            this.parameterPanel.add(new JLabel("("));
            this.buildJavaVariablePanel(",", this.parameterPanel, this.requiredParameters, this.newParameterButton, this.parameterDropHandler, 3);
            JLabel brace = new JLabel("{");
            brace.setDropTarget(new DropTarget(brace, this.parameterDropHandler));
            JLabel paren = new JLabel(")");
            paren.setDropTarget(new DropTarget(paren, this.parameterDropHandler));
            this.parameterPanel.add(paren);
            this.parameterPanel.add(brace);
        } else {
            this.methodNameLabel.setText(this.m_element.getTrimmedKey());
            this.parameterPanel.add(this.methodNameLabel);
            this.buildVariablePanel(",", this.parameterPanel, this.requiredParameters, this.newParameterButton, this.parameterDropHandler, 3);
        }
        this.newParameterButton.setDropTarget(new DropTarget(this.newParameterButton, this.parameterDropHandler));
        this.parameterPanel.validate();
        this.parameterPanel.repaint();
    }

    protected void buildVariablePanel() {
        this.variablePanel.removeAll();
        if (CompositeElementEditor.IS_JAVA) {
            int count = this.buildJavaVariablePanel(";", this.variablePanel, this.localVariables, this.newVariableButton, this.variableDropHandler, 1);
            if (count > 0) {
                JLabel semi = new JLabel(";");
                semi.setDropTarget(new DropTarget(semi, this.parameterDropHandler));
                this.variablePanel.add(semi);
            }
        } else {
            this.buildVariablePanel(",", this.variablePanel, this.localVariables, this.newVariableButton, this.variableDropHandler, 1);
        }
        this.newVariableButton.setDropTarget(new DropTarget(this.newVariableButton, this.variableDropHandler));
        this.variablePanel.revalidate();
        this.variablePanel.repaint();
    }

    private Component getAnchor(Component current) {
        if (current == null || current instanceof JTabbedPane) {
            return current;
        }
        return this.getAnchor(current.getParent());
    }

    protected void generateGUI() {
        int buttonWidth = 140;
        int buttonHeight = 26;
        Component anchor = this.getAnchor(this);
        int fontSize = 12;
        if (this.newParameterButton == null) {
            this.newParameterButton = new JButton("new parameter");
            this.newParameterButton.setBackground(new Color(240, 240, 255));
            this.newParameterButton.setMargin(new Insets(2, 2, 2, 2));
            if (fontSize == 12) {
                this.newParameterButton.setMinimumSize(new Dimension(buttonWidth, buttonHeight));
                this.newParameterButton.setPreferredSize(new Dimension(buttonWidth, buttonHeight));
                this.newParameterButton.setMaximumSize(new Dimension(buttonWidth, buttonHeight));
            }
            this.newParameterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Variable variable = MainCompositeElementPanel.this.authoringTool.showNewVariableDialog("Create New Parameter", MainCompositeElementPanel.this.requiredParameters.getOwner(), false, false);
                    if (variable != null && MainCompositeElementPanel.this.requiredParameters != null) {
                        MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().startCompound();
                        try {
                            MainCompositeElementPanel.this.requiredParameters.getOwner().addChild(variable);
                            MainCompositeElementPanel.this.requiredParameters.add(variable);
                        }
                        finally {
                            MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().stopCompound();
                        }
                    }
                }
            });
            this.newParameterButton.setDropTarget(new DropTarget(this.newParameterButton, this.parameterDropHandler));
            this.newParameterButton.setToolTipText("<html><body><p>Open the New Parameter Dialogue Box</p><p>Parameters allow you to send information</p><p>to a method when you run it. You may choose</p><p>among several types of information to send</p><p>(like numbers, objects, and Booleans).</p></body></html>");
        }
        if (this.newVariableButton == null) {
            this.newVariableButton = new JButton("new local variable");
            this.newVariableButton.setBackground(new Color(240, 240, 255));
            this.newVariableButton.setMargin(new Insets(2, 2, 2, 2));
            if (fontSize == 12) {
                this.newVariableButton.setMinimumSize(new Dimension(buttonWidth, buttonHeight));
                this.newVariableButton.setPreferredSize(new Dimension(buttonWidth, buttonHeight));
                this.newVariableButton.setMaximumSize(new Dimension(buttonWidth, buttonHeight));
            }
            this.newVariableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Variable variable = MainCompositeElementPanel.this.authoringTool.showNewVariableDialog("Create New Local Variable", MainCompositeElementPanel.this.localVariables.getOwner(), false, true);
                    if (variable != null && MainCompositeElementPanel.this.localVariables != null) {
                        MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().startCompound();
                        try {
                            MainCompositeElementPanel.this.localVariables.getOwner().addChild(variable);
                            MainCompositeElementPanel.this.localVariables.add(variable);
                        }
                        finally {
                            MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().stopCompound();
                        }
                    }
                }
            });
            this.newVariableButton.setDropTarget(new DropTarget(this.newVariableButton, this.variableDropHandler));
            this.newVariableButton.setToolTipText("<html><body><p>Open the New Variable Dialogue Box</p><p>Variables allow you to store information</p><p>in a method when it runs. You may choose</p><p>among several types of information (like</p><p>numbers, objects, and Booleans).</p></body></html>");
        }
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(20, 30){

                public void printComponent(Graphics g) {
                }
            };
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setOpaque(false);
            this.scrollPane.setBorder(null);
        }
        if (this.parameterDropHandler == null) {
            this.parameterDropHandler = new DropTargetHandler(this.requiredParameters);
        }
        if (this.parameterPanel == null) {
            this.parameterPanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (MainCompositeElementPanel.this.lineLocation > -1 && MainCompositeElementPanel.this.paintParameter) {
                        this.getBounds();
                        g.setColor(Color.black);
                        g.fillRect(MainCompositeElementPanel.this.lineLocation, MainCompositeElementPanel.this.verticalLineLocation, 2, MainCompositeElementPanel.this.lineHeight);
                    }
                }
            };
            this.parameterPanel.setBackground(this.backgroundColor);
            this.parameterPanel.setBorder(null);
            this.parameterPanel.setLayout(new DynamicFlowLayout(0, anchor, JTabbedPane.class, 152));
            this.parameterPanel.setDropTarget(new DropTarget(this.parameterPanel, this.parameterDropHandler));
            this.parameterDropHandler.setPanel(this.parameterPanel);
        }
        if (this.variableDropHandler == null) {
            this.variableDropHandler = new DropTargetHandler(this.localVariables);
        }
        if (this.variablePanel == null) {
            this.variablePanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (MainCompositeElementPanel.this.lineLocation > -1 && MainCompositeElementPanel.this.paintVariable) {
                        this.getBounds();
                        g.setColor(Color.black);
                        g.fillRect(MainCompositeElementPanel.this.lineLocation, MainCompositeElementPanel.this.verticalLineLocation, 2, MainCompositeElementPanel.this.lineHeight);
                    }
                }
            };
            this.variablePanel.setBackground(this.backgroundColor);
            this.variablePanel.setBorder(null);
            this.variablePanel.setLayout(new DynamicFlowLayout(0, anchor, JTabbedPane.class, 152));
            this.variablePanel.setDropTarget(new DropTarget(this.variablePanel, this.variableDropHandler));
            this.variableDropHandler.setPanel(this.variablePanel);
        }
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setOpaque(false);
            this.headerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            this.headerPanel.setLayout(new GridBagLayout());
        }
        this.methodNameLabel = new JLabel();
        Font nameFont = new Font("Helvetica", 1, (int)((double)(14 * fontSize) / 12.0));
        this.methodNameLabel.setFont(nameFont);
        this.methodNameLabel.setDropTarget(new DropTarget(this.methodNameLabel, this.parameterDropHandler));
        this.noParametersLabel = new JLabel("No parameters");
        this.noParametersLabel.setDropTarget(new DropTarget(this.noParametersLabel, this.parameterDropHandler));
        Font noFont = new Font("Helvetica", 2, (int)((double)(12 * fontSize) / 12.0));
        this.noParametersLabel.setFont(noFont);
        this.noVariablesLabel = new JLabel("No variables");
        this.noVariablesLabel.setDropTarget(new DropTarget(this.noVariablesLabel, this.variableDropHandler));
        this.noVariablesLabel.setFont(noFont);
        this.mainParameterPanel = new JPanel();
        this.mainParameterPanel.setBackground(this.backgroundColor);
        this.mainParameterPanel.setOpaque(true);
        this.mainParameterPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
        this.mainParameterPanel.setLayout(new GridBagLayout());
        this.mainParameterPanel.add((Component)this.parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainParameterPanel.add((Component)this.newParameterButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.mainVariablePanel = new JPanel();
        this.mainVariablePanel.setOpaque(true);
        this.mainVariablePanel.setBackground(this.backgroundColor);
        this.mainVariablePanel.setBorder(null);
        this.mainVariablePanel.setLayout(new GridBagLayout());
        this.mainVariablePanel.add((Component)this.variablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainVariablePanel.add((Component)this.newVariableButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    protected void updateGUI() {
        this.removeAll();
        this.buildParameterPanel();
        this.buildVariablePanel();
        this.headerPanel.add((Component)this.mainParameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headerPanel.add((Component)this.mainVariablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPane.setViewportView(this.componentElementPanel);
        this.scrollPane.getViewport().setOpaque(false);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.headerPanel, "North");
        if (CompositeElementEditor.IS_JAVA) {
            this.closeBrace.setText(" }");
            this.add((Component)this.closeBrace, "South");
        }
        this.setBackground(this.getCustomBackgroundColor());
        this.repaint();
        this.revalidate();
    }

    protected boolean isInGroup(Object toCheck, ObjectArrayProperty group) {
        if (toCheck instanceof Element) {
            return group.contains(toCheck);
        }
        return false;
    }

    public void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isInGroup(propertyEvent.getProperty().getOwner(), this.requiredParameters)) {
            this.buildParameterPanel();
        } else if (this.isInGroup(propertyEvent.getProperty().getOwner(), this.localVariables)) {
            this.buildVariablePanel();
        } else if (propertyEvent.getProperty() == this.m_element.name) {
            this.buildParameterPanel();
        }
        this.repaint();
        this.revalidate();
    }

    private Variable isPromotable(Transferable transferring) {
        if (transferring != null && AuthoringToolResources.safeIsDataFlavorSupported(transferring, ElementReferenceTransferable.variableReferenceFlavor)) {
            try {
                Variable toCheck = (Variable)transferring.getTransferData(ElementReferenceTransferable.variableReferenceFlavor);
                if (this.localVariables.contains(toCheck) || this.requiredParameters.contains(toCheck)) {
                    return toCheck;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Component getWorkSpace() {
        return this.scrollPane;
    }

    public Component getParameterPanel() {
        return this.parameterPanel;
    }

    public Component getVariablePanel() {
        return this.variablePanel;
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private ObjectArrayProperty m_group;
        private JPanel containingPanel;
        private int variablePosition;
        boolean isParameter = false;

        public DropTargetHandler(ObjectArrayProperty group) {
            this.m_group = group;
            if (group == MainCompositeElementPanel.this.requiredParameters) {
                this.isParameter = true;
            }
        }

        public void setProperty(ObjectArrayProperty group) {
            this.m_group = group;
            this.isParameter = group == MainCompositeElementPanel.this.requiredParameters;
        }

        public void setPanel(JPanel panel) {
            this.containingPanel = panel;
        }

        protected int getStartIndex() {
            int start = 0;
            int i = 0;
            while (i < this.containingPanel.getComponentCount()) {
                Component c = this.containingPanel.getComponent(i);
                if (c == MainCompositeElementPanel.this.methodNameLabel || c == MainCompositeElementPanel.this.noParametersLabel || c == MainCompositeElementPanel.this.noVariablesLabel) {
                    ++start;
                } else {
                    return start;
                }
                ++i;
            }
            return start;
        }

        private void turnNoPanelOn() {
            if (this.isParameter) {
                if (!MainCompositeElementPanel.this.noParametersLabel.isOpaque()) {
                    MainCompositeElementPanel.this.noParametersLabel.setBackground(Color.white);
                    MainCompositeElementPanel.this.noParametersLabel.setOpaque(true);
                    MainCompositeElementPanel.this.noParametersLabel.repaint();
                }
            } else if (!MainCompositeElementPanel.this.noVariablesLabel.isOpaque()) {
                MainCompositeElementPanel.this.noVariablesLabel.setBackground(Color.white);
                MainCompositeElementPanel.this.noVariablesLabel.setOpaque(true);
                MainCompositeElementPanel.this.noVariablesLabel.repaint();
            }
        }

        private void turnNoPanelOff() {
            if (this.isParameter) {
                if (MainCompositeElementPanel.this.noParametersLabel.isOpaque()) {
                    MainCompositeElementPanel.this.noParametersLabel.setBackground(Color.white);
                    MainCompositeElementPanel.this.noParametersLabel.setOpaque(false);
                    MainCompositeElementPanel.this.noParametersLabel.repaint();
                }
            } else if (MainCompositeElementPanel.this.noVariablesLabel.isOpaque()) {
                MainCompositeElementPanel.this.noVariablesLabel.setBackground(Color.white);
                MainCompositeElementPanel.this.noVariablesLabel.setOpaque(false);
                MainCompositeElementPanel.this.noVariablesLabel.repaint();
            }
        }

        protected void calculateLineLocation(int mouseX, int mouseY) {
            int numSpots = this.m_group.size() + 1;
            int[] spots = new int[numSpots];
            int[] centers = new int[numSpots];
            int startIndex = this.getStartIndex();
            if (this.m_group.size() == 0) {
                this.variablePosition = 0;
                MainCompositeElementPanel.this.verticalLineLocation = -1;
                MainCompositeElementPanel.this.lineLocation = -1;
                this.turnNoPanelOn();
            } else {
                this.turnNoPanelOff();
                JComponent firstComponent = (JComponent)this.containingPanel.getComponent(startIndex);
                spots[0] = firstComponent.getBounds().x - firstComponent.getInsets().left - 4;
                centers[0] = 5 + MainCompositeElementPanel.this.lineHeight / 2;
                int currentIndex = 1;
                int i = 0;
                while (i < numSpots - 1) {
                    JComponent c = (JComponent)this.containingPanel.getComponent(startIndex);
                    Insets insets = c.getInsets();
                    spots[currentIndex] = c.getBounds().x + c.getBounds().width + insets.left;
                    centers[currentIndex] = c.getBounds().y + MainCompositeElementPanel.this.lineHeight / 2;
                    ++currentIndex;
                    ++startIndex;
                    ++i;
                }
                int closestSpot = -2;
                int minDist = Integer.MAX_VALUE;
                int i2 = 0;
                while (i2 < numSpots) {
                    int d = Math.abs(mouseX - spots[i2]) + Math.abs(mouseY - centers[i2]);
                    if (d < minDist) {
                        minDist = d;
                        closestSpot = i2;
                    }
                    ++i2;
                }
                this.variablePosition = closestSpot;
                MainCompositeElementPanel.this.verticalLineLocation = centers[closestSpot] - MainCompositeElementPanel.this.lineHeight / 2;
                MainCompositeElementPanel.this.lineLocation = spots[closestSpot];
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.variableReferenceFlavor)) {
                dtde.acceptDrag(2);
            } else {
                this.turnNoPanelOff();
                MainCompositeElementPanel.this.lineLocation = -1;
                MainCompositeElementPanel.this.paintParameter = false;
                MainCompositeElementPanel.this.paintVariable = false;
                dtde.rejectDrag();
                this.containingPanel.repaint();
            }
        }

        public void dragExit(DropTargetEvent dte) {
            MainCompositeElementPanel.this.lineLocation = -1;
            MainCompositeElementPanel.this.paintParameter = false;
            MainCompositeElementPanel.this.paintVariable = false;
            this.turnNoPanelOff();
            this.containingPanel.repaint();
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (MainCompositeElementPanel.this.isPromotable(DnDManager.getCurrentTransferable()) != null) {
                dtde.acceptDrag(2);
                Point p = SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this.containingPanel);
                int lineTemp = MainCompositeElementPanel.this.lineLocation;
                this.calculateLineLocation(p.x, p.y);
                if (lineTemp != MainCompositeElementPanel.this.lineLocation) {
                    if (this.isParameter) {
                        MainCompositeElementPanel.this.paintParameter = true;
                        MainCompositeElementPanel.this.paintVariable = false;
                    } else {
                        MainCompositeElementPanel.this.paintParameter = false;
                        MainCompositeElementPanel.this.paintVariable = true;
                    }
                    this.containingPanel.repaint();
                }
            } else {
                MainCompositeElementPanel.this.lineLocation = -1;
                MainCompositeElementPanel.this.paintParameter = false;
                MainCompositeElementPanel.this.paintVariable = false;
                this.turnNoPanelOff();
                dtde.rejectDrag();
                this.containingPanel.repaint();
            }
        }

        protected ObjectArrayProperty getGroup(Variable toRemove) {
            Element parent;
            ElementArrayProperty containingArray = null;
            if (toRemove.getParent() instanceof UserDefinedResponse) {
                parent = (UserDefinedResponse)toRemove.getParent();
                if (parent.keywordFormalParameters.contains(toRemove)) {
                    containingArray = parent.keywordFormalParameters;
                } else if (parent.localVariables.contains(toRemove)) {
                    containingArray = parent.localVariables;
                } else if (parent.requiredFormalParameters.contains(toRemove)) {
                    containingArray = parent.requiredFormalParameters;
                } else if (parent.requiredFormalParameters.contains(toRemove)) {
                    containingArray = parent.requiredFormalParameters;
                }
            }
            if (toRemove.getParent() instanceof UserDefinedQuestion) {
                parent = (UserDefinedQuestion)toRemove.getParent();
                if (((UserDefinedQuestion)parent).keywordFormalParameters.contains(toRemove)) {
                    containingArray = ((UserDefinedQuestion)parent).keywordFormalParameters;
                } else if (((UserDefinedQuestion)parent).localVariables.contains(toRemove)) {
                    containingArray = ((UserDefinedQuestion)parent).localVariables;
                } else if (((UserDefinedQuestion)parent).requiredFormalParameters.contains(toRemove)) {
                    containingArray = ((UserDefinedQuestion)parent).requiredFormalParameters;
                } else if (((UserDefinedQuestion)parent).requiredFormalParameters.contains(toRemove)) {
                    containingArray = ((UserDefinedQuestion)parent).requiredFormalParameters;
                }
            }
            return containingArray;
        }

        public void drop(DropTargetDropEvent dtde) {
            Variable toAdd = MainCompositeElementPanel.this.isPromotable(DnDManager.getCurrentTransferable());
            MainCompositeElementPanel.this.paintParameter = false;
            MainCompositeElementPanel.this.paintVariable = false;
            boolean successful = true;
            if (toAdd != null) {
                dtde.acceptDrop(2);
                Point p = SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this.containingPanel);
                this.calculateLineLocation(p.x, p.y);
                ObjectArrayProperty containingArray = this.getGroup(toAdd);
                if (this.variablePosition > this.m_group.size()) {
                    this.variablePosition = this.m_group.size();
                }
                if (containingArray == this.m_group) {
                    int to = this.variablePosition;
                    int from = containingArray.indexOf(toAdd);
                    if (from < to) {
                        --to;
                    }
                    containingArray.shift(from, to);
                } else if (containingArray != null) {
                    containingArray.remove(toAdd);
                    this.m_group.add(this.variablePosition, toAdd);
                }
                this.turnNoPanelOff();
                MainCompositeElementPanel.this.lineLocation = -1;
            } else {
                this.turnNoPanelOff();
                MainCompositeElementPanel.this.lineLocation = -1;
                dtde.rejectDrop();
                successful = false;
            }
            dtde.dropComplete(successful);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (MainCompositeElementPanel.this.isPromotable(DnDManager.getCurrentTransferable()) != null) {
                dtde.acceptDrag(2);
            } else {
                dtde.rejectDrag();
            }
        }
    }
}

