/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.MainCompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.TempColorPicker;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.question.userdefined.IfElse;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.IfElseInOrder;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class CompositeElementEditor
extends GroupingPanel
implements Editor,
PropertyListener {
    public final String editorName = "Composite Editor";
    protected Element elementBeingEdited;
    protected MainCompositeElementPanel compositeElementPanel;
    protected JPanel mainElementContainer;
    protected JPanel buttonPanel;
    protected Color mainColor = Color.white;
    protected AuthoringTool authoringTool;
    public static boolean IS_JAVA = false;

    public CompositeElementEditor() {
        this.guiInit();
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 1) > 0) {
                    TempColorPicker tempColorPicker = new TempColorPicker(CompositeElementEditor.this);
                    DialogManager.showMessageDialog(tempColorPicker);
                }
            }

            public void mousePressed(MouseEvent mouseevent) {
            }

            public void mouseEntered(MouseEvent mouseevent) {
            }

            public void mouseExited(MouseEvent mouseevent) {
            }

            public void mouseReleased(MouseEvent mouseevent) {
            }
        });
    }

    public MainCompositeElementPanel getMainPanel() {
        return this.compositeElementPanel;
    }

    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        if (this.compositeElementPanel != null) {
            this.compositeElementPanel.setBackground(backgroundColor);
        }
    }

    public JComponent getJComponent() {
        return this;
    }

    public Object getObject() {
        return this.elementBeingEdited;
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    protected abstract MainCompositeElementPanel createElementTree(Element var1);

    protected abstract void initPrototypes();

    protected abstract void addPrototypes(Container var1);

    protected abstract Color getEditorColor();

    protected void guiInit() {
        this.setBorder(null);
        this.removeAll();
        this.buttonPanel = new JPanel();
        Color buttonPanelColor = Color.white;
        this.buttonPanel.setOpaque(true);
        this.buttonPanel.setBackground(buttonPanelColor);
        this.buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.buttonPanel.setMinimumSize(new Dimension(0, 0));
        this.buttonPanel.setLayout(new FlowLayout(0){

            public Dimension preferredLayoutSize(Container target) {
                Insets insets = target.getParent().getInsets();
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                int maxwidth = target.getParent().getWidth() - (insets.left + insets.right + hgap * 2);
                int nmembers = target.getComponentCount();
                int x = 0;
                int y = insets.top + vgap;
                int rowh = 0;
                target.getComponentOrientation().isLeftToRight();
                int i = 0;
                while (i < nmembers) {
                    Component m = target.getComponent(i);
                    if (m.isVisible()) {
                        Dimension d = m.getPreferredSize();
                        m.setSize(d.width, d.height);
                        if (x == 0 || x + d.width <= maxwidth) {
                            if (x > 0) {
                                x += hgap;
                            }
                            x += d.width;
                            rowh = Math.max(rowh, d.height);
                        } else {
                            x = d.width;
                            y += vgap + rowh;
                            rowh = d.height;
                        }
                    }
                    ++i;
                }
                return new Dimension(target.getParent().getWidth() - (insets.left + insets.right), y + rowh + vgap);
            }

            public Dimension minimumLayoutSize(Container target) {
                return this.preferredLayoutSize(target);
            }
        });
        this.initPrototypes();
        this.addPrototypes(this.buttonPanel);
        new JScrollPane(this.buttonPanel, 20, 30);
        this.mainElementContainer = new JPanel();
        this.mainElementContainer.setLayout(new BorderLayout());
        this.mainElementContainer.setMinimumSize(new Dimension(0, 0));
        this.mainElementContainer.setBorder(null);
        this.mainElementContainer.setOpaque(false);
        this.mainElementContainer.setBackground(this.getEditorColor());
        this.setLayout(new BorderLayout());
        this.setBackground(this.getEditorColor());
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.mainElementContainer, "Center");
        this.updateGui();
    }

    public void updateGui() {
        this.mainElementContainer.removeAll();
        if (this.elementBeingEdited != null && this.authoringTool != null) {
            this.clearAllListening();
            this.compositeElementPanel = this.createElementTree(this.elementBeingEdited);
            if (this.compositeElementPanel != null) {
                this.mainElementContainer.add((Component)this.compositeElementPanel, "Center");
                this.setBackground(this.compositeElementPanel.getBackground());
            }
        } else {
            JLabel emptyLabel = new JLabel("Not an editable element");
            emptyLabel.setFont(emptyLabel.getFont().deriveFont(2));
            JPanel emptyPanel = new JPanel();
            emptyPanel.setLayout(new GridBagLayout());
            emptyPanel.setBackground(this.getBackground());
            emptyPanel.add((Component)emptyLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.mainElementContainer.add((Component)emptyPanel, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    public static int getDepthCount(ObjectArrayProperty children) {
        int maxDepth = 0;
        int i = 0;
        while (i < children.size()) {
            int depth;
            if (children.get(i) instanceof CompositeResponse) {
                CompositeResponse currentResponse = (CompositeResponse)children.get(i);
                depth = CompositeElementEditor.getDepthCount(currentResponse.componentResponses);
                if (depth > maxDepth) {
                    maxDepth = depth;
                }
                if (currentResponse instanceof IfElseInOrder) {
                    IfElseInOrder ifResponse = (IfElseInOrder)currentResponse;
                    depth = CompositeElementEditor.getDepthCount(ifResponse.elseComponentResponses);
                    if (depth > maxDepth) {
                        maxDepth = depth;
                    }
                }
            } else if (children.get(i) instanceof Composite) {
                Composite currentQuestion = (Composite)children.get(i);
                depth = CompositeElementEditor.getDepthCount(currentQuestion.components);
                if (depth > maxDepth) {
                    maxDepth = depth;
                }
                if (currentQuestion instanceof IfElse) {
                    IfElse ifQuestion = (IfElse)currentQuestion;
                    depth = CompositeElementEditor.getDepthCount(ifQuestion.elseComponents);
                    if (depth > maxDepth) {
                        maxDepth = depth;
                    }
                }
            }
            ++i;
        }
        return 1 + maxDepth;
    }

    public void propertyChanging(PropertyEvent propertyevent) {
    }

    public void propertyChanged(PropertyEvent propertyevent) {
    }

    protected void clearAllListening() {
        if (this.compositeElementPanel != null) {
            this.compositeElementPanel.clean();
        }
    }

    public void stateChanging(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void stateChanged(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.updateGui();
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldStarted(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent authoringtoolstatechangedevent) {
    }
}

