/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.util.ElementUsageGraph;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.util.IndexedTriangleArrayCounter;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.criterion.InstanceOfCriterion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class WorldInfoContentPane
extends ContentPane {
    protected World world;
    protected ElementUsageGraph responseUsageGraph;
    Border border1;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton doneButton = new JButton();
    Border border2;
    JScrollPane mainScrollPane = new JScrollPane();
    JPanel mainPanel = new JPanel();
    JLabel responseUsageLabel = new JLabel();
    Component component1;
    JPanel responseUsagePanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel userDefinedResponseCountLabel = new JLabel();
    JLabel userDefinedQuestionCountLabel = new JLabel();

    public WorldInfoContentPane() {
        this.jbInit();
        this.guiInit();
    }

    public String getTitle() {
        return "Statistics";
    }

    private void guiInit() {
        this.setSize(500, 600);
        this.responseUsageGraph = new ElementUsageGraph();
        this.responseUsageGraph.setElementCriterion(new InstanceOfCriterion(Response.class));
        this.responseUsagePanel.add((Component)this.responseUsageGraph, "Center");
    }

    public void setWorld(World world) {
        this.world = world;
        this.responseUsageGraph.setRoot(world);
        this.refresh();
    }

    private void refresh() {
        if (this.world != null) {
            IndexedTriangleArrayCounter itaCounter = new IndexedTriangleArrayCounter();
            this.world.visit(itaCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            this.userDefinedResponseCountLabel.setText("Number of user-defined methods: " + this.world.getDescendants(UserDefinedResponse.class).length);
            this.userDefinedQuestionCountLabel.setText("Number of user-defined functions: " + this.world.getDescendants(UserDefinedQuestion.class).length);
            this.responseUsageGraph.refresh();
        }
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.border2 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.component1 = Box.createGlue();
        this.setBackground(new Color(232, 230, 255));
        this.setLayout(this.borderLayout1);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(this.gridBagLayout1);
        this.doneButton.setText("Done");
        this.mainPanel.setBorder(this.border2);
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.responseUsageLabel.setText("Animation usage:");
        this.responseUsagePanel.setOpaque(false);
        this.responseUsagePanel.setLayout(this.borderLayout2);
        this.userDefinedResponseCountLabel.setText("Number of user-defined animations:");
        this.mainScrollPane.getViewport().setBackground(new Color(232, 230, 255));
        this.mainScrollPane.setOpaque(false);
        this.userDefinedQuestionCountLabel.setText("Number of user-defined questions:");
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.doneButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.mainScrollPane, "Center");
        this.mainScrollPane.getViewport().add((Component)this.mainPanel, null);
        this.mainPanel.add((Component)this.userDefinedResponseCountLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.responseUsageLabel, new GridBagConstraints(0, 11, 2, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.responseUsagePanel, new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.mainPanel.add(this.component1, new GridBagConstraints(0, 13, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.userDefinedQuestionCountLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
    }

    public void addOKActionListener(ActionListener l) {
        this.doneButton.addActionListener(l);
    }

    public void removeOKActionListener(ActionListener l) {
        this.doneButton.removeActionListener(l);
    }
}

