/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyReferenceListCellRenderer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.HowMuch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeleteContentPane
extends ContentPane
implements PropertyListener,
ChildrenListener {
    public static final int LESS_DETAIL_MODE = 0;
    public static final int MORE_DETAIL_MODE = 1;
    protected int mode = -1;
    protected static AuthoringTool authoringTool;
    protected ImagePanel errorIconPanel = new ImagePanel();
    protected ElementPopupUtilities.DeleteRunnable deleteRunnable;
    protected Element danglingElementToClear;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JButton okayButton = new JButton();
    JButton removeReferenceButton = new JButton();
    JButton removeAllReferenceButton = new JButton();
    JPanel iconPanel = new JPanel();
    JPanel messagePanel = new JPanel();
    JPanel referencesPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JScrollPane referencesScrollPane = new JScrollPane();
    JTextArea messageArea = new JTextArea();
    Border border1;
    Border border2;
    JButton cancelButton = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JList referencesList = new JList();

    public static void showDeleteDialog(ElementPopupUtilities.DeleteRunnable deleteRunnable, AuthoringTool authoringTool) {
        DeleteContentPane dcp = new DeleteContentPane(authoringTool);
        dcp.setDeleteRunnable(deleteRunnable);
        dcp.refresh();
        if (DialogManager.showDialog(dcp) == 0) {
            deleteRunnable.run();
        }
    }

    public DeleteContentPane(AuthoringTool authoringTool) {
        DeleteContentPane.authoringTool = authoringTool;
        this.jbInit();
        URL errorImageResources = JAlice.class.getResource("images/error.gif");
        this.errorIconPanel.setImage(Toolkit.getDefaultToolkit().createImage(errorImageResources));
        this.iconPanel.add((Component)this.errorIconPanel, "Center");
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setOpaque(false);
        this.referencesList.setCellRenderer(new PropertyReferenceListCellRenderer());
        this.referencesList.addListSelectionListener(new ReferencesSelectionListener());
        this.setPreferredSize(new Dimension(600, 300));
    }

    public String getTitle() {
        return "Alice - Can't Delete";
    }

    public void addOKActionListener(ActionListener l) {
        this.okayButton.addActionListener(l);
    }

    public void removeOKActionListener(ActionListener l) {
        this.okayButton.removeActionListener(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    public void postDialogShow(JDialog dialog) {
        this.stopListening();
        super.postDialogShow(dialog);
    }

    public void setDeleteRunnable(ElementPopupUtilities.DeleteRunnable deleteRunnable) {
        this.deleteRunnable = deleteRunnable;
    }

    public void startListening() {
        ListModel list = this.referencesList.getModel();
        int i = 0;
        while (i < list.getSize()) {
            if (list.getElementAt(i) instanceof PropertyReference) {
                PropertyReference reference = (PropertyReference)list.getElementAt(i);
                Element source = reference.getProperty().getOwner();
                this.listenUpToRootElement(source);
                if (source instanceof PropertyValue) {
                    Property[] properties;
                    Property[] propertyArray = properties = source.getParent().getProperties();
                    int n = 0;
                    int n2 = propertyArray.length;
                    while (n < n2) {
                        Property propertie = propertyArray[n];
                        if (propertie.get() == source) {
                            propertie.addPropertyListener(this);
                        }
                        ++n;
                    }
                } else if (reference instanceof ObjectArrayPropertyReference) {
                    ObjectArrayPropertyReference oAPR = (ObjectArrayPropertyReference)reference;
                    PropertyReference[] references = oAPR.getReference().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                    if (references != null && references.length > 0) {
                        reference.getProperty().addPropertyListener(this);
                    }
                } else {
                    reference.getProperty().addPropertyListener(this);
                }
            }
            ++i;
        }
    }

    public void stopListening() {
        ListModel list = this.referencesList.getModel();
        int i = 0;
        while (i < list.getSize()) {
            if (list.getElementAt(i) instanceof PropertyReference) {
                PropertyReference reference = (PropertyReference)list.getElementAt(i);
                Element source = reference.getProperty().getOwner();
                this.stopListeningUpToRootElement(source);
                if (source instanceof PropertyValue) {
                    if (source.getParent() != null) {
                        Property[] properties;
                        Property[] propertyArray = properties = source.getParent().getProperties();
                        int n = 0;
                        int n2 = propertyArray.length;
                        while (n < n2) {
                            Property propertie = propertyArray[n];
                            if (propertie.get() == source) {
                                propertie.removePropertyListener(this);
                            }
                            ++n;
                        }
                    }
                } else if (reference instanceof ObjectArrayPropertyReference) {
                    PropertyReference[] references = reference.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                    if (references != null && references.length > 0) {
                        reference.getProperty().removePropertyListener(this);
                    }
                } else {
                    reference.getProperty().removePropertyListener(this);
                }
            }
            ++i;
        }
    }

    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    public void propertyChanged(PropertyEvent propertyEvent) {
        this.refresh();
    }

    public void childrenChanging(ChildrenEvent childrenEvent) {
        this.danglingElementToClear = childrenEvent.getParent();
    }

    public void childrenChanged(ChildrenEvent childrenEvent) {
        this.stopListeningUpToRootElement(this.danglingElementToClear);
        this.refresh();
    }

    protected void listenUpToRootElement(Element current) {
        if (current != null) {
            Property[] properties;
            ChildrenListener[] childrenListeners;
            boolean alreadyChildrenListening = false;
            ChildrenListener[] childrenListenerArray = childrenListeners = current.getChildrenListeners();
            int n = 0;
            int n2 = childrenListenerArray.length;
            while (n < n2) {
                ChildrenListener childrenListener = childrenListenerArray[n];
                if (childrenListener == this) {
                    alreadyChildrenListening = true;
                }
                ++n;
            }
            if (!alreadyChildrenListening) {
                current.addChildrenListener(this);
            }
            Property[] propertyArray = properties = current.getProperties();
            n2 = 0;
            int n3 = propertyArray.length;
            while (n2 < n3) {
                Property propertie = propertyArray[n2];
                PropertyListener[] propListeners = propertie.getPropertyListeners();
                boolean alreadyPropListening = false;
                PropertyListener[] propertyListenerArray = propListeners;
                int n4 = 0;
                int n5 = propertyListenerArray.length;
                while (n4 < n5) {
                    PropertyListener propListener = propertyListenerArray[n4];
                    if (propListener == this) {
                        alreadyPropListening = true;
                    }
                    ++n4;
                }
                if (!alreadyPropListening) {
                    propertie.addPropertyListener(this);
                }
                ++n2;
            }
            this.listenUpToRootElement(current.getParent());
        }
    }

    protected void stopListeningUpToRootElement(Element current) {
        if (current != null) {
            Property[] properties;
            ChildrenListener[] childrenListeners;
            boolean alreadyChildrenListening = false;
            ChildrenListener[] childrenListenerArray = childrenListeners = current.getChildrenListeners();
            int n = 0;
            int n2 = childrenListenerArray.length;
            while (n < n2) {
                ChildrenListener childrenListener = childrenListenerArray[n];
                if (childrenListener == this) {
                    alreadyChildrenListening = true;
                }
                ++n;
            }
            if (alreadyChildrenListening) {
                current.removeChildrenListener(this);
            }
            Property[] propertyArray = properties = current.getProperties();
            n2 = 0;
            int n3 = propertyArray.length;
            while (n2 < n3) {
                Property propertie = propertyArray[n2];
                PropertyListener[] propListeners = propertie.getPropertyListeners();
                boolean alreadyPropListening = false;
                PropertyListener[] propertyListenerArray = propListeners;
                int n4 = 0;
                int n5 = propertyListenerArray.length;
                while (n4 < n5) {
                    PropertyListener propListener = propertyListenerArray[n4];
                    if (propListener == this) {
                        alreadyPropListening = true;
                    }
                    ++n4;
                }
                if (alreadyPropListening) {
                    propertie.removePropertyListener(this);
                }
                ++n2;
            }
            this.stopListeningUpToRootElement(current.getParent());
        }
    }

    public void refresh() {
        if (this.deleteRunnable != null) {
            Element element = this.deleteRunnable.getElement();
            String elementRepr = AuthoringToolResources.getReprForValue(element);
            PropertyReference[] references = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            if (references.length > 0) {
                AuthoringToolResources.garbageCollectIfPossible(references);
                references = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            this.stopListening();
            this.referencesList.setListData(references);
            this.startListening();
            if (references.length > 0) {
                this.okayButton.setEnabled(false);
                this.removeReferenceButton.setEnabled(true);
                this.removeAllReferenceButton.setEnabled(true);
                this.messageArea.setText(String.valueOf(elementRepr) + " cannot be deleted because other parts of the World contain references to it. You will need to remove these references in order to delete " + elementRepr + ".\n\n" + "Select each reference below, and either remove the reference manually, or click the Remove Reference button to have the reference removed by the system.");
                this.referencesList.setSelectedIndex(0);
            } else {
                this.okayButton.setEnabled(true);
                this.removeReferenceButton.setEnabled(false);
                this.removeAllReferenceButton.setEnabled(false);
                this.messageArea.setText("All references have now been deleted.  Click Okay to delete " + elementRepr + ".");
                this.setDialogTitle("Alice - Can Delete");
            }
        }
    }

    void removeReferenceButton_actionPerformed(ActionEvent e) {
        PropertyReference reference = (PropertyReference)this.referencesList.getSelectedValue();
        if (reference != null) {
            Element source = reference.getProperty().getOwner();
            Element sourceParent = source.getParent();
            if (source instanceof CallToUserDefinedResponse || source instanceof CallToUserDefinedQuestion || source instanceof PropertyValue) {
                if (sourceParent instanceof CompositeResponse) {
                    source.removeFromParent();
                } else {
                    Property[] properties;
                    Property[] propertyArray = properties = sourceParent.getProperties();
                    int n = 0;
                    int n2 = propertyArray.length;
                    while (n < n2) {
                        Property propertie = propertyArray[n];
                        if (propertie.get() == source) {
                            propertie.removePropertyListener(this);
                            propertie.set(AuthoringToolResources.getDefaultValueForClass(propertie.getValueClass()));
                        }
                        ++n;
                    }
                }
            } else if (reference instanceof ObjectArrayPropertyReference) {
                ObjectArrayPropertyReference oAPR = (ObjectArrayPropertyReference)reference;
                oAPR.getObjectArrayProperty().set(oAPR.getIndex(), (Object)null);
                PropertyReference[] references = oAPR.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                if (references == null || references.length < 1) {
                    reference.getProperty().removePropertyListener(this);
                }
            } else {
                reference.getProperty().removePropertyListener(this);
                reference.getProperty().set(AuthoringToolResources.getDefaultValueForClass(reference.getProperty().getValueClass()));
            }
            this.refresh();
        }
    }

    void removeAllReferenceButton_actionPerformed(ActionEvent e) {
        this.stopListening();
        int i = 0;
        while (i < this.referencesList.getModel().getSize()) {
            PropertyReference reference = (PropertyReference)this.referencesList.getModel().getElementAt(i);
            if (reference != null) {
                Element source = reference.getProperty().getOwner();
                Element sourceParent = source.getParent();
                if (source instanceof CallToUserDefinedResponse || source instanceof CallToUserDefinedQuestion || source instanceof PropertyValue) {
                    if (sourceParent instanceof CompositeResponse) {
                        source.removeFromParent();
                    } else {
                        Property[] properties;
                        Property[] propertyArray = properties = sourceParent.getProperties();
                        int n = 0;
                        int n2 = propertyArray.length;
                        while (n < n2) {
                            Property propertie = propertyArray[n];
                            if (propertie.get() == source) {
                                propertie.removePropertyListener(this);
                                propertie.set(AuthoringToolResources.getDefaultValueForClass(propertie.getValueClass()));
                            }
                            ++n;
                        }
                    }
                } else if (reference instanceof ObjectArrayPropertyReference) {
                    ObjectArrayPropertyReference oAPR = (ObjectArrayPropertyReference)reference;
                    oAPR.getObjectArrayProperty().set(oAPR.getIndex(), (Object)null);
                    PropertyReference[] otherReferences = oAPR.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                    if (otherReferences == null || otherReferences.length < 1) {
                        reference.getProperty().removePropertyListener(this);
                    }
                } else {
                    reference.getProperty().removePropertyListener(this);
                    reference.getProperty().set(AuthoringToolResources.getDefaultValueForClass(reference.getProperty().getValueClass()));
                }
            }
            ++i;
        }
        this.refresh();
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.setLayout(this.borderLayout1);
        this.okayButton.setText("OK");
        this.removeReferenceButton.setText("Remove Reference");
        this.removeReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteContentPane.this.removeReferenceButton_actionPerformed(e);
            }
        });
        this.removeAllReferenceButton.setText("Remove All References");
        this.removeAllReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteContentPane.this.removeAllReferenceButton_actionPerformed(e);
            }
        });
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.iconPanel.setLayout(this.borderLayout2);
        this.messagePanel.setLayout(this.borderLayout3);
        this.referencesPanel.setLayout(this.borderLayout4);
        this.messageArea.setText("Message goes here.");
        this.mainPanel.setBorder(this.border1);
        this.buttonPanel.setBorder(this.border2);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.cancelButton.setText("Cancel");
        this.referencesList.setSelectionMode(0);
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.buttonPanel.add((Component)this.okayButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 8, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 8, 0), 0, 0));
        this.buttonPanel.add((Component)this.removeReferenceButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0));
        this.buttonPanel.add((Component)this.removeAllReferenceButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0));
        this.mainPanel.add((Component)this.iconPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.mainPanel.add((Component)this.messagePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.messagePanel.add((Component)this.messageArea, "Center");
        this.mainPanel.add((Component)this.referencesPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesPanel.add((Component)this.referencesScrollPane, "Center");
        this.referencesScrollPane.getViewport().add((Component)this.referencesList, null);
    }

    class ReferencesSelectionListener
    implements ListSelectionListener {
        ReferencesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent ev) {
        }
    }
}

