/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.UndoRedoListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.ChildChangeUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CompoundUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import java.util.HashSet;
import java.util.Iterator;

public class MainUndoRedoStack
extends DefaultUndoRedoStack
implements PropertyListener,
ObjectArrayPropertyListener,
ChildrenListener,
AuthoringToolStateListener {
    protected AuthoringTool authoringTool;
    private boolean isListening = true;
    private boolean inCompound = false;
    private CompoundUndoableRedoable compoundItem;
    private int unmodifiedIndex = -1;
    protected HashSet listeners = new HashSet();
    protected Object preChangeValue;

    public MainUndoRedoStack(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public void addUndoRedoListener(UndoRedoListener listener) {
        this.listeners.add(listener);
    }

    public int getUnmodifiedIndex() {
        return this.unmodifiedIndex;
    }

    protected synchronized void fireChange() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UndoRedoListener)iter.next()).onChange();
        }
    }

    public synchronized void setUnmodified() {
        this.unmodifiedIndex = this.getCurrentUndoableRedoableIndex();
        this.fireChange();
    }

    public synchronized void setIsListening(boolean isListening) {
        this.isListening = isListening;
    }

    public synchronized boolean getIsListening() {
        return this.isListening;
    }

    public synchronized void startCompound() {
        if (!this.inCompound) {
            this.compoundItem = new CompoundUndoableRedoable();
            this.compoundItem.setContext(this.authoringTool.getContext());
            this.push(this.compoundItem);
            this.inCompound = true;
        }
    }

    public synchronized void stopCompound() {
        this.inCompound = false;
    }

    public synchronized UndoableRedoable undo() {
        this.stopCompound();
        boolean temp = this.isListening;
        this.isListening = false;
        UndoableRedoable ur = super.undo();
        this.loadContext(ur.getContext());
        this.isListening = temp;
        this.fireChange();
        return ur;
    }

    public synchronized UndoableRedoable redo() {
        this.stopCompound();
        boolean temp = this.isListening;
        this.isListening = false;
        int currentIndex = this.getCurrentUndoableRedoableIndex();
        if (currentIndex < this.size() - 1) {
            this.loadContext(((UndoableRedoable)this.get(currentIndex + 1)).getContext());
        }
        UndoableRedoable ur = super.redo();
        this.isListening = temp;
        this.fireChange();
        return ur;
    }

    protected synchronized void loadContext(Object context) {
        this.authoringTool.setContext(context);
    }

    public synchronized void push(UndoableRedoable ur) {
        if (ur instanceof ContextAssignableUndoableRedoable) {
            ((ContextAssignableUndoableRedoable)ur).setContext(this.authoringTool.getContext());
        }
        if (this.inCompound) {
            this.compoundItem.addItem(ur);
        } else {
            super.push(ur);
        }
        this.fireChange();
    }

    public synchronized UndoableRedoable pop() {
        this.stopCompound();
        UndoableRedoable ur = super.pop();
        this.fireChange();
        return ur;
    }

    public synchronized void clear() {
        super.clear();
        this.setUnmodified();
        this.fireChange();
    }

    public synchronized UndoableRedoable removeUndoable(int index) {
        UndoableRedoable ur = super.removeUndoable(index);
        this.fireChange();
        return ur;
    }

    public synchronized void propertyChanging(PropertyEvent propertyEvent) {
        if (this.isListening) {
            this.preChangeValue = propertyEvent.getProperty().get();
        }
    }

    public synchronized void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isListening) {
            if (propertyEvent.getProperty() instanceof ObjectArrayProperty) {
                return;
            }
            if (this.authoringTool.getOneShotScheduler().isPropertyAffected(propertyEvent.getProperty())) {
                return;
            }
            this.push(new PropertyUndoableRedoable(propertyEvent.getProperty(), this.preChangeValue, propertyEvent.getProperty().get()));
        }
    }

    public synchronized void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
    }

    public synchronized void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
        if (this.isListening) {
            if (this.authoringTool.getOneShotScheduler().isPropertyAffected(ev.getObjectArrayProperty())) {
                return;
            }
            this.push(new ObjectArrayPropertyUndoableRedoable(ev.getObjectArrayProperty(), ev.getChangeType(), ev.getOldIndex(), ev.getNewIndex(), ev.getItem()));
        }
    }

    public synchronized void childrenChanging(ChildrenEvent childrenEvent) {
    }

    public synchronized void childrenChanged(ChildrenEvent childrenEvent) {
        int changeType;
        if (this.isListening) {
            this.push(new ChildChangeUndoableRedoable(childrenEvent));
        }
        if ((changeType = childrenEvent.getChangeType()) == 1) {
            this.listenTo(childrenEvent.getChild());
        } else if (changeType == 3) {
            this.stopListeningTo(childrenEvent.getChild());
        }
    }

    public synchronized void listenTo(Element element) {
        if (element != null) {
            Element[] elements;
            Element[] elementArray = elements = element.getDescendants();
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                ChildrenListener[] childrenListeners;
                Property[] properties;
                Element element2 = elementArray[n];
                Property[] propertyArray = properties = element2.getProperties();
                int n3 = 0;
                int n4 = propertyArray.length;
                while (n3 < n4) {
                    Property propertie = propertyArray[n3];
                    propertie.addPropertyListener(this);
                    if (propertie instanceof ObjectArrayProperty) {
                        ((ObjectArrayProperty)propertie).addObjectArrayPropertyListener(this);
                    }
                    ++n3;
                }
                boolean alreadyChildrenListening = false;
                ChildrenListener[] childrenListenerArray = childrenListeners = element2.getChildrenListeners();
                int n5 = 0;
                int n6 = childrenListenerArray.length;
                while (n5 < n6) {
                    ChildrenListener childrenListener = childrenListenerArray[n5];
                    if (childrenListener == this) {
                        alreadyChildrenListening = true;
                    }
                    ++n5;
                }
                if (!alreadyChildrenListening) {
                    element2.addChildrenListener(this);
                }
                ++n;
            }
        }
    }

    public synchronized void stopListeningTo(Element element) {
        if (element != null) {
            Element[] elements;
            Element[] elementArray = elements = element.getDescendants();
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                Property[] properties;
                Element element2 = elementArray[n];
                Property[] propertyArray = properties = element2.getProperties();
                int n3 = 0;
                int n4 = propertyArray.length;
                while (n3 < n4) {
                    Property propertie = propertyArray[n3];
                    propertie.removePropertyListener(this);
                    if (propertie instanceof ObjectArrayProperty) {
                        ((ObjectArrayProperty)propertie).removeObjectArrayPropertyListener(this);
                    }
                    ++n3;
                }
                element2.removeChildrenListener(this);
                ++n;
            }
        }
    }

    public void stateChanged(AuthoringToolStateChangedEvent ev) {
        if (ev.getCurrentState() == 3) {
            this.stopListeningTo(ev.getWorld());
        } else {
            this.listenTo(ev.getWorld());
        }
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
        this.stopListeningTo(ev.getWorld());
    }

    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.listenTo(ev.getWorld());
    }

    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }
}

